/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class ArrayList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8683452581122892189L;
    private static final int DEFAULT_CAPACITY = 10;
    private static final Object[] EMPTY_ELEMENTDATA = new Object[0];
    private static final Object[] DEFAULTCAPACITY_EMPTY_ELEMENTDATA = new Object[0];
    transient Object[] elementData;
    private int size;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public ArrayList(int initialCapacity) {
        if (initialCapacity > 0) {
            this.elementData = new Object[initialCapacity];
        } else if (initialCapacity == 0) {
            this.elementData = EMPTY_ELEMENTDATA;
        } else {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
    }

    public ArrayList() {
        this.elementData = DEFAULTCAPACITY_EMPTY_ELEMENTDATA;
    }

    public ArrayList(Collection<? extends E> c) {
        this.elementData = c.toArray();
        this.size = this.elementData.length;
        if (this.size != 0) {
            if (this.elementData.getClass() != Object[].class) {
                this.elementData = Arrays.copyOf(this.elementData, this.size, Object[].class);
            }
        } else {
            this.elementData = EMPTY_ELEMENTDATA;
        }
    }

    public void trimToSize() {
        ++this.modCount;
        if (this.size < this.elementData.length) {
            this.elementData = this.size == 0 ? EMPTY_ELEMENTDATA : Arrays.copyOf(this.elementData, this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.elementData.length && (this.elementData != DEFAULTCAPACITY_EMPTY_ELEMENTDATA || minCapacity > 10)) {
            ++this.modCount;
            this.grow(minCapacity);
        }
    }

    private Object[] grow(int minCapacity) {
        this.elementData = Arrays.copyOf(this.elementData, this.newCapacity(minCapacity));
        return this.elementData;
    }

    private Object[] grow() {
        return this.grow(this.size + 1);
    }

    private int newCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minCapacity <= 0) {
            if (this.elementData == DEFAULTCAPACITY_EMPTY_ELEMENTDATA) {
                return Math.max(10, minCapacity);
            }
            if (minCapacity < 0) {
                throw new OutOfMemoryError();
            }
            return minCapacity;
        }
        return newCapacity - 0x7FFFFFF7 <= 0 ? newCapacity : ArrayList.hugeCapacity(minCapacity);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!o.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!o.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            ArrayList v = (ArrayList)super.clone();
            v.elementData = Arrays.copyOf(this.elementData, this.size);
            v.modCount = 0;
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.elementData, this.size);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            return Arrays.copyOf(this.elementData, this.size, a.getClass());
        }
        System.arraycopy(this.elementData, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    E elementData(int index) {
        return (E)this.elementData[index];
    }

    static <E> E elementAt(Object[] es, int index) {
        return (E)es[index];
    }

    @Override
    public E get(int index) {
        Objects.checkIndex(index, this.size);
        return this.elementData(index);
    }

    @Override
    public E set(int index, E element) {
        Objects.checkIndex(index, this.size);
        E oldValue = this.elementData(index);
        this.elementData[index] = element;
        return oldValue;
    }

    private void add(E e, Object[] elementData, int s) {
        if (s == elementData.length) {
            elementData = this.grow();
        }
        elementData[s] = e;
        this.size = s + 1;
    }

    @Override
    public boolean add(E e) {
        ++this.modCount;
        this.add(e, this.elementData, this.size);
        return true;
    }

    @Override
    public void add(int index, E element) {
        this.rangeCheckForAdd(index);
        ++this.modCount;
        int s = this.size;
        Object[] elementData = this.elementData;
        if (s == this.elementData.length) {
            elementData = this.grow();
        }
        System.arraycopy(elementData, index, elementData, index + 1, s - index);
        elementData[index] = element;
        this.size = s + 1;
    }

    @Override
    public E remove(int index) {
        Objects.checkIndex(index, this.size);
        ++this.modCount;
        E oldValue = this.elementData(index);
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = null;
        return oldValue;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            for (int index = 0; index < this.size; ++index) {
                if (this.elementData[index] != null) continue;
                this.fastRemove(index);
                return true;
            }
        } else {
            for (int index = 0; index < this.size; ++index) {
                if (!o.equals(this.elementData[index])) continue;
                this.fastRemove(index);
                return true;
            }
        }
        return false;
    }

    private void fastRemove(int index) {
        ++this.modCount;
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = null;
    }

    @Override
    public void clear() {
        ++this.modCount;
        Object[] es = this.elementData;
        int to = this.size;
        this.size = 0;
        for (int i = 0; i < to; ++i) {
            es[i] = null;
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Object[] a = c.toArray();
        ++this.modCount;
        int numNew = a.length;
        if (numNew == 0) {
            return false;
        }
        Object[] elementData = this.elementData;
        int s = this.size;
        if (numNew > this.elementData.length - s) {
            elementData = this.grow(s + numNew);
        }
        System.arraycopy(a, 0, elementData, s, numNew);
        this.size = s + numNew;
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        int numMoved;
        this.rangeCheckForAdd(index);
        Object[] a = c.toArray();
        ++this.modCount;
        int numNew = a.length;
        if (numNew == 0) {
            return false;
        }
        Object[] elementData = this.elementData;
        int s = this.size;
        if (numNew > this.elementData.length - s) {
            elementData = this.grow(s + numNew);
        }
        if ((numMoved = s - index) > 0) {
            System.arraycopy(elementData, index, elementData, index + numNew, numMoved);
        }
        System.arraycopy(a, 0, elementData, index, numNew);
        this.size = s + numNew;
        return true;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException(ArrayList.outOfBoundsMsg(fromIndex, toIndex));
        }
        ++this.modCount;
        this.shiftTailOverGap(this.elementData, fromIndex, toIndex);
    }

    private void shiftTailOverGap(Object[] es, int lo, int hi) {
        System.arraycopy(es, hi, es, lo, this.size - hi);
        int to = this.size;
        for (int i = this.size -= hi - lo; i < to; ++i) {
            es[i] = null;
        }
    }

    private void rangeCheckForAdd(int index) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size;
    }

    private static String outOfBoundsMsg(int fromIndex, int toIndex) {
        return "From Index: " + fromIndex + " > To Index: " + toIndex;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.batchRemove(c, false, 0, this.size);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.batchRemove(c, true, 0, this.size);
    }

    boolean batchRemove(Collection<?> c, boolean complement, int from, int end) {
        int r;
        Objects.requireNonNull(c);
        Object[] es = this.elementData;
        for (r = from; r < end && c.contains(es[r]) == complement; ++r) {
        }
        boolean modified = r < end;
        if (modified) {
            int w = r++;
            try {
                while (r < end) {
                    Object e = es[r];
                    if (c.contains(e) == complement) {
                        es[w++] = e;
                    }
                    ++r;
                }
            }
            catch (Throwable ex) {
                System.arraycopy(es, r, es, w, end - r);
                w += end - r;
                throw ex;
            }
            finally {
                this.modCount += end - w;
                this.shiftTailOverGap(es, w, end);
            }
        }
        return modified;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int expectedModCount = this.modCount;
        s.defaultWriteObject();
        s.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            s.writeObject(this.elementData[i]);
        }
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        s.readInt();
        if (this.size > 0) {
            Object[] elements = new Object[this.size];
            for (int i = 0; i < this.size; ++i) {
                elements[i] = s.readObject();
            }
            this.elementData = elements;
        } else if (this.size == 0) {
            this.elementData = EMPTY_ELEMENTDATA;
        } else {
            throw new InvalidObjectException("Invalid size: " + this.size);
        }
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        this.rangeCheckForAdd(index);
        return new ListItr(index);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListItr(0);
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        ArrayList.subListRangeCheck(fromIndex, toIndex, this.size);
        return new SubList(this, fromIndex, toIndex);
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        int expectedModCount = this.modCount;
        Object[] es = this.elementData;
        int size = this.size;
        for (int i = 0; this.modCount == expectedModCount && i < size; ++i) {
            action.accept(ArrayList.elementAt(es, i));
        }
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Spliterator<E> spliterator() {
        return new ArrayListSpliterator(0, -1, 0);
    }

    private static long[] nBits(int n) {
        return new long[(n - 1 >> 6) + 1];
    }

    private static void setBit(long[] bits, int i) {
        int n = i >> 6;
        bits[n] = bits[n] | 1L << i;
    }

    private static boolean isClear(long[] bits, int i) {
        return (bits[i >> 6] & 1L << i) == 0L;
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        return this.removeIf(filter, 0, this.size);
    }

    boolean removeIf(Predicate<? super E> filter, int i, int end) {
        Objects.requireNonNull(filter);
        int expectedModCount = this.modCount;
        Object[] es = this.elementData;
        while (i < end && !filter.test(ArrayList.elementAt(es, i))) {
            ++i;
        }
        if (i < end) {
            int beg = i;
            long[] deathRow = ArrayList.nBits(end - beg);
            deathRow[0] = 1L;
            for (i = beg + 1; i < end; ++i) {
                if (!filter.test(ArrayList.elementAt(es, i))) continue;
                ArrayList.setBit(deathRow, i - beg);
            }
            if (this.modCount != expectedModCount) {
                throw new ConcurrentModificationException();
            }
            ++expectedModCount;
            ++this.modCount;
            int w = beg;
            for (i = beg; i < end; ++i) {
                if (!ArrayList.isClear(deathRow, i - beg)) continue;
                es[w++] = es[i];
            }
            this.shiftTailOverGap(es, w, end);
            return true;
        }
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
        return false;
    }

    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        Objects.requireNonNull(operator);
        int expectedModCount = this.modCount;
        Object[] es = this.elementData;
        int size = this.size;
        for (int i = 0; this.modCount == expectedModCount && i < size; ++i) {
            es[i] = operator.apply(ArrayList.elementAt(es, i));
        }
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
        ++this.modCount;
    }

    @Override
    public void sort(Comparator<? super E> c) {
        int expectedModCount = this.modCount;
        Arrays.sort(this.elementData, 0, this.size, c);
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
        ++this.modCount;
    }

    void checkInvariants() {
    }

    final class ArrayListSpliterator
    implements Spliterator<E> {
        private int index;
        private int fence;
        private int expectedModCount;

        ArrayListSpliterator(int origin, int fence, int expectedModCount) {
            this.index = origin;
            this.fence = fence;
            this.expectedModCount = expectedModCount;
        }

        private int getFence() {
            int hi = this.fence;
            if (hi < 0) {
                this.expectedModCount = ArrayList.this.modCount;
                hi = this.fence = ArrayList.this.size;
            }
            return hi;
        }

        public ArrayListSpliterator trySplit() {
            ArrayListSpliterator arrayListSpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid) {
                arrayListSpliterator = null;
            } else {
                this.index = mid;
                ArrayListSpliterator arrayListSpliterator2 = new ArrayListSpliterator(lo, this.index, this.expectedModCount);
                arrayListSpliterator = arrayListSpliterator2;
            }
            return arrayListSpliterator;
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int i = this.index;
            int hi = this.getFence();
            if (i < hi) {
                this.index = i + 1;
                Object e = ArrayList.this.elementData[i];
                action.accept(e);
                if (ArrayList.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] a = ArrayList.this.elementData;
            if (ArrayList.this.elementData != null) {
                int i;
                int mc;
                int hi = this.fence;
                if (hi < 0) {
                    mc = ArrayList.this.modCount;
                    hi = ArrayList.this.size;
                } else {
                    mc = this.expectedModCount;
                }
                if (i >= 0 && (this.index = hi) <= a.length) {
                    for (i = this.index; i < hi; ++i) {
                        Object e = a[i];
                        action.accept(e);
                    }
                    if (ArrayList.this.modCount == mc) {
                        return;
                    }
                }
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public long estimateSize() {
            return this.getFence() - this.index;
        }

        @Override
        public int characteristics() {
            return 16464;
        }
    }

    private static class SubList<E>
    extends AbstractList<E>
    implements RandomAccess {
        private final ArrayList<E> root;
        private final SubList<E> parent;
        private final int offset;
        private int size;

        public SubList(ArrayList<E> root, int fromIndex, int toIndex) {
            this.root = root;
            this.parent = null;
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
            this.modCount = root.modCount;
        }

        private SubList(SubList<E> parent, int fromIndex, int toIndex) {
            this.root = parent.root;
            this.parent = parent;
            this.offset = parent.offset + fromIndex;
            this.size = toIndex - fromIndex;
            this.modCount = this.root.modCount;
        }

        @Override
        public E set(int index, E element) {
            Objects.checkIndex(index, this.size);
            this.checkForComodification();
            E oldValue = this.root.elementData(this.offset + index);
            this.root.elementData[this.offset + index] = element;
            return oldValue;
        }

        @Override
        public E get(int index) {
            Objects.checkIndex(index, this.size);
            this.checkForComodification();
            return this.root.elementData(this.offset + index);
        }

        @Override
        public int size() {
            this.checkForComodification();
            return this.size;
        }

        @Override
        public void add(int index, E element) {
            this.rangeCheckForAdd(index);
            this.checkForComodification();
            this.root.add(this.offset + index, element);
            this.updateSizeAndModCount(1);
        }

        @Override
        public E remove(int index) {
            Objects.checkIndex(index, this.size);
            this.checkForComodification();
            E result = this.root.remove(this.offset + index);
            this.updateSizeAndModCount(-1);
            return result;
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            this.checkForComodification();
            this.root.removeRange(this.offset + fromIndex, this.offset + toIndex);
            this.updateSizeAndModCount(fromIndex - toIndex);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            return this.addAll(this.size, c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            this.rangeCheckForAdd(index);
            int cSize = c.size();
            if (cSize == 0) {
                return false;
            }
            this.checkForComodification();
            this.root.addAll(this.offset + index, c);
            this.updateSizeAndModCount(cSize);
            return true;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.batchRemove(c, false);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.batchRemove(c, true);
        }

        private boolean batchRemove(Collection<?> c, boolean complement) {
            this.checkForComodification();
            int oldSize = ((ArrayList)this.root).size;
            boolean modified = this.root.batchRemove(c, complement, this.offset, this.offset + this.size);
            if (modified) {
                this.updateSizeAndModCount(((ArrayList)this.root).size - oldSize);
            }
            return modified;
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            this.checkForComodification();
            int oldSize = ((ArrayList)this.root).size;
            boolean modified = this.root.removeIf(filter, this.offset, this.offset + this.size);
            if (modified) {
                this.updateSizeAndModCount(((ArrayList)this.root).size - oldSize);
            }
            return modified;
        }

        @Override
        public Iterator<E> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(final int index) {
            this.checkForComodification();
            this.rangeCheckForAdd(index);
            return new ListIterator<E>(){
                int cursor;
                int lastRet;
                int expectedModCount;
                {
                    this.cursor = index;
                    this.lastRet = -1;
                    this.expectedModCount = ((SubList)this).root.modCount;
                }

                @Override
                public boolean hasNext() {
                    return this.cursor != size;
                }

                @Override
                public E next() {
                    this.checkForComodification();
                    int i = this.cursor;
                    if (i >= size) {
                        throw new NoSuchElementException();
                    }
                    Object[] elementData = ((SubList)this).root.elementData;
                    if (offset + i >= elementData.length) {
                        throw new ConcurrentModificationException();
                    }
                    this.cursor = i + 1;
                    this.lastRet = i;
                    return elementData[offset + this.lastRet];
                }

                @Override
                public boolean hasPrevious() {
                    return this.cursor != 0;
                }

                @Override
                public E previous() {
                    this.checkForComodification();
                    int i = this.cursor - 1;
                    if (i < 0) {
                        throw new NoSuchElementException();
                    }
                    Object[] elementData = ((SubList)this).root.elementData;
                    if (offset + i >= elementData.length) {
                        throw new ConcurrentModificationException();
                    }
                    this.cursor = i;
                    this.lastRet = i;
                    return elementData[offset + this.lastRet];
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    int i;
                    Objects.requireNonNull(action);
                    int size = size;
                    if (i < size) {
                        Object[] es = ((SubList)this).root.elementData;
                        if (offset + i >= es.length) {
                            throw new ConcurrentModificationException();
                        }
                        for (i = this.cursor; i < size && modCount == this.expectedModCount; ++i) {
                            action.accept(ArrayList.elementAt(es, offset + i));
                        }
                        this.cursor = i;
                        this.lastRet = i - 1;
                        this.checkForComodification();
                    }
                }

                @Override
                public int nextIndex() {
                    return this.cursor;
                }

                @Override
                public int previousIndex() {
                    return this.cursor - 1;
                }

                @Override
                public void remove() {
                    if (this.lastRet < 0) {
                        throw new IllegalStateException();
                    }
                    this.checkForComodification();
                    try {
                        this.remove(this.lastRet);
                        this.cursor = this.lastRet;
                        this.lastRet = -1;
                        this.expectedModCount = ((SubList)this).root.modCount;
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                public void set(E e) {
                    if (this.lastRet < 0) {
                        throw new IllegalStateException();
                    }
                    this.checkForComodification();
                    try {
                        root.set(offset + this.lastRet, e);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                public void add(E e) {
                    this.checkForComodification();
                    try {
                        int i = this.cursor;
                        this.add(i, e);
                        this.cursor = i + 1;
                        this.lastRet = -1;
                        this.expectedModCount = ((SubList)this).root.modCount;
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new ConcurrentModificationException();
                    }
                }

                final void checkForComodification() {
                    if (((SubList)this).root.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                }
            };
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            SubList.subListRangeCheck(fromIndex, toIndex, this.size);
            return new SubList<E>(this, fromIndex, toIndex);
        }

        private void rangeCheckForAdd(int index) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
            }
        }

        private String outOfBoundsMsg(int index) {
            return "Index: " + index + ", Size: " + this.size;
        }

        private void checkForComodification() {
            if (this.root.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        private void updateSizeAndModCount(int sizeChange) {
            SubList<E> slist = this;
            do {
                slist.size += sizeChange;
                slist.modCount = this.root.modCount;
            } while ((slist = slist.parent) != null);
        }

        @Override
        public Spliterator<E> spliterator() {
            this.checkForComodification();
            return new Spliterator<E>(){
                private int index;
                private int fence;
                private int expectedModCount;
                {
                    this.index = offset;
                    this.fence = -1;
                }

                private int getFence() {
                    int hi = this.fence;
                    if (hi < 0) {
                        this.expectedModCount = modCount;
                        hi = this.fence = offset + size;
                    }
                    return hi;
                }

                public ArrayListSpliterator trySplit() {
                    ArrayListSpliterator arrayListSpliterator;
                    int lo = this.index;
                    int hi = this.getFence();
                    int mid = lo + hi >>> 1;
                    if (lo >= mid) {
                        arrayListSpliterator = null;
                    } else {
                        ArrayList arrayList = root;
                        Objects.requireNonNull(arrayList);
                        this.index = mid;
                        ArrayListSpliterator arrayListSpliterator2 = arrayList.new ArrayListSpliterator(lo, this.index, this.expectedModCount);
                        arrayListSpliterator = arrayListSpliterator2;
                    }
                    return arrayListSpliterator;
                }

                @Override
                public boolean tryAdvance(Consumer<? super E> action) {
                    Objects.requireNonNull(action);
                    int hi = this.getFence();
                    int i = this.index;
                    if (i < hi) {
                        this.index = i + 1;
                        Object e = ((SubList)this).root.elementData[i];
                        action.accept(e);
                        if (((SubList)this).root.modCount != this.expectedModCount) {
                            throw new ConcurrentModificationException();
                        }
                        return true;
                    }
                    return false;
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    Objects.requireNonNull(action);
                    ArrayList lst = root;
                    Object[] a = lst.elementData;
                    if (lst.elementData != null) {
                        int i;
                        int mc;
                        int hi = this.fence;
                        if (hi < 0) {
                            mc = modCount;
                            hi = offset + size;
                        } else {
                            mc = this.expectedModCount;
                        }
                        if (i >= 0 && (this.index = hi) <= a.length) {
                            for (i = this.index; i < hi; ++i) {
                                Object e = a[i];
                                action.accept(e);
                            }
                            if (lst.modCount == mc) {
                                return;
                            }
                        }
                    }
                    throw new ConcurrentModificationException();
                }

                @Override
                public long estimateSize() {
                    return this.getFence() - this.index;
                }

                @Override
                public int characteristics() {
                    return 16464;
                }
            };
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            int i = this.cursor - 1;
            if (i < 0) {
                throw new NoSuchElementException();
            }
            Object[] elementData = ArrayList.this.elementData;
            if (i >= elementData.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = i;
            this.lastRet = i;
            return elementData[this.lastRet];
        }

        @Override
        public void set(E e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ArrayList.this.set(this.lastRet, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            try {
                int i = this.cursor;
                ArrayList.this.add(i, e);
                this.cursor = i + 1;
                this.lastRet = -1;
                this.expectedModCount = ArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator<E> {
        int cursor;
        int lastRet = -1;
        int expectedModCount;

        Itr() {
            this.expectedModCount = ArrayList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ArrayList.this.size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            int i = this.cursor;
            if (i >= ArrayList.this.size) {
                throw new NoSuchElementException();
            }
            Object[] elementData = ArrayList.this.elementData;
            if (i >= elementData.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = i + 1;
            this.lastRet = i;
            return elementData[this.lastRet];
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ArrayList.this.remove(this.lastRet);
                this.cursor = this.lastRet;
                this.lastRet = -1;
                this.expectedModCount = ArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            int i;
            Objects.requireNonNull(action);
            int size = ArrayList.this.size;
            if (i < size) {
                Object[] es = ArrayList.this.elementData;
                if (i >= es.length) {
                    throw new ConcurrentModificationException();
                }
                for (i = this.cursor; i < size && ArrayList.this.modCount == this.expectedModCount; ++i) {
                    action.accept(ArrayList.elementAt(es, i));
                }
                this.cursor = i;
                this.lastRet = i - 1;
                this.checkForComodification();
            }
        }

        final void checkForComodification() {
            if (ArrayList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

