/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class ArrayDeque<E>
extends AbstractCollection<E>
implements Deque<E>,
Cloneable,
Serializable {
    transient Object[] elements;
    transient int head;
    transient int tail;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final long serialVersionUID = 2340985798034038923L;

    private void grow(int needed) {
        int newCapacity;
        int jump;
        int oldCapacity = this.elements.length;
        int n = jump = oldCapacity < 64 ? oldCapacity + 2 : oldCapacity >> 1;
        if (jump < needed || (newCapacity = oldCapacity + jump) - 0x7FFFFFF7 > 0) {
            newCapacity = this.newCapacity(needed, jump);
        }
        this.elements = Arrays.copyOf(this.elements, newCapacity);
        Object[] es = this.elements;
        if (this.tail < this.head || this.tail == this.head && es[this.head] != null) {
            int newSpace = newCapacity - oldCapacity;
            System.arraycopy(es, this.head, es, this.head + newSpace, oldCapacity - this.head);
            int to = this.head += newSpace;
            for (int i = this.head; i < to; ++i) {
                es[i] = null;
            }
        }
    }

    private int newCapacity(int needed, int jump) {
        int oldCapacity = this.elements.length;
        int minCapacity = oldCapacity + needed;
        if (minCapacity - 0x7FFFFFF7 > 0) {
            if (minCapacity < 0) {
                throw new IllegalStateException("Sorry, deque too big");
            }
            return Integer.MAX_VALUE;
        }
        if (needed > jump) {
            return minCapacity;
        }
        return oldCapacity + jump - 0x7FFFFFF7 < 0 ? oldCapacity + jump : 0x7FFFFFF7;
    }

    public ArrayDeque() {
        this.elements = new Object[16];
    }

    public ArrayDeque(int numElements) {
        this.elements = new Object[numElements < 1 ? 1 : (numElements == Integer.MAX_VALUE ? Integer.MAX_VALUE : numElements + 1)];
    }

    public ArrayDeque(Collection<? extends E> c) {
        this(c.size());
        this.addAll(c);
    }

    static final int inc(int i, int modulus) {
        if (++i >= modulus) {
            i = 0;
        }
        return i;
    }

    static final int dec(int i, int modulus) {
        if (--i < 0) {
            i = modulus - 1;
        }
        return i;
    }

    static final int add(int i, int distance, int modulus) {
        if ((i += distance) - modulus >= 0) {
            i -= modulus;
        }
        return i;
    }

    static final int sub(int i, int j, int modulus) {
        if ((i -= j) < 0) {
            i += modulus;
        }
        return i;
    }

    static final <E> E elementAt(Object[] es, int i) {
        return (E)es[i];
    }

    static final <E> E nonNullElementAt(Object[] es, int i) {
        Object e = es[i];
        if (e == null) {
            throw new ConcurrentModificationException();
        }
        return (E)e;
    }

    @Override
    public void addFirst(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        Object[] es = this.elements;
        this.head = ArrayDeque.dec(this.head, es.length);
        es[this.head] = e;
        if (this.head == this.tail) {
            this.grow(1);
        }
    }

    @Override
    public void addLast(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        Object[] es = this.elements;
        es[this.tail] = e;
        this.tail = ArrayDeque.inc(this.tail, es.length);
        if (this.head == this.tail) {
            this.grow(1);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        int s = this.size();
        int needed = s + c.size() + 1 - this.elements.length;
        if (needed > 0) {
            this.grow(needed);
        }
        c.forEach(this::addLast);
        return this.size() > s;
    }

    @Override
    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public E removeFirst() {
        E e = this.pollFirst();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E removeLast() {
        E e = this.pollLast();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E pollFirst() {
        Object[] es = this.elements;
        int h = this.head;
        E e = ArrayDeque.elementAt(this.elements, h);
        if (e != null) {
            es[h] = null;
            this.head = ArrayDeque.inc(h, es.length);
        }
        return e;
    }

    @Override
    public E pollLast() {
        Object[] es = this.elements;
        int t = ArrayDeque.dec(this.tail, es.length);
        E e = ArrayDeque.elementAt(this.elements, t);
        if (e != null) {
            this.tail = t;
            es[this.tail] = null;
        }
        return e;
    }

    @Override
    public E getFirst() {
        E e = ArrayDeque.elementAt(this.elements, this.head);
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E getLast() {
        Object[] es = this.elements;
        E e = ArrayDeque.elementAt(es, ArrayDeque.dec(this.tail, es.length));
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E peekFirst() {
        return ArrayDeque.elementAt(this.elements, this.head);
    }

    @Override
    public E peekLast() {
        Object[] es = this.elements;
        return ArrayDeque.elementAt(this.elements, ArrayDeque.dec(this.tail, es.length));
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        if (o != null) {
            int to;
            Object[] es = this.elements;
            int i = this.head;
            int end = this.tail;
            int n = to = i <= end ? end : es.length;
            while (true) {
                if (i < to) {
                    if (o.equals(es[i])) {
                        this.delete(i);
                        return true;
                    }
                    ++i;
                    continue;
                }
                if (to == end) break;
                i = 0;
                to = end;
            }
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        if (o != null) {
            Object[] es = this.elements;
            int i = this.tail;
            int end = this.head;
            int to = i >= end ? end : 0;
            while (true) {
                --i;
                while (i > to - 1) {
                    if (o.equals(es[i])) {
                        this.delete(i);
                        return true;
                    }
                    --i;
                }
                if (to == end) break;
                i = es.length;
                to = end;
            }
        }
        return false;
    }

    @Override
    public boolean add(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    boolean delete(int i) {
        int t;
        int back;
        int h = this.head;
        Object[] es = this.elements;
        int capacity = es.length;
        int front = ArrayDeque.sub(i, h, capacity);
        if (front < (back = ArrayDeque.sub(t = this.tail, i, capacity) - 1)) {
            if (h <= i) {
                System.arraycopy(es, h, es, h + 1, front);
            } else {
                System.arraycopy(es, 0, es, 1, i);
                es[0] = es[capacity - 1];
                System.arraycopy(es, h, es, h + 1, front - (i + 1));
            }
            es[h] = null;
            this.head = ArrayDeque.inc(h, capacity);
            return false;
        }
        this.tail = ArrayDeque.dec(t, capacity);
        if (i <= this.tail) {
            System.arraycopy(es, i + 1, es, i, back);
        } else {
            System.arraycopy(es, i + 1, es, i, capacity - (i + 1));
            es[capacity - 1] = es[0];
            System.arraycopy(es, 1, es, 0, t - 1);
        }
        es[this.tail] = null;
        return true;
    }

    @Override
    public int size() {
        return ArrayDeque.sub(this.tail, this.head, this.elements.length);
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    @Override
    public Iterator<E> iterator() {
        return new DeqIterator();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingIterator();
    }

    @Override
    public Spliterator<E> spliterator() {
        return new DeqSpliterator();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        int to;
        Objects.requireNonNull(action);
        Object[] es = this.elements;
        int i = this.head;
        int end = this.tail;
        int n = to = i <= end ? end : es.length;
        while (true) {
            if (i < to) {
                action.accept(ArrayDeque.elementAt(es, i));
                ++i;
                continue;
            }
            if (to == end) {
                if (end == this.tail) break;
                throw new ConcurrentModificationException();
            }
            i = 0;
            to = end;
        }
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        Objects.requireNonNull(filter);
        return this.bulkRemove(filter);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.bulkRemove(e -> c.contains(e));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.bulkRemove(e -> !c.contains(e));
    }

    private boolean bulkRemove(Predicate<? super E> filter) {
        int to;
        Object[] es = this.elements;
        int i = this.head;
        int end = this.tail;
        int n = to = i <= end ? end : es.length;
        while (true) {
            if (i < to) {
                if (filter.test(ArrayDeque.elementAt(es, i))) {
                    return this.bulkRemoveModified(filter, i);
                }
                ++i;
                continue;
            }
            if (to == end) {
                if (end == this.tail) break;
                throw new ConcurrentModificationException();
            }
            i = 0;
            to = end;
        }
        return false;
    }

    private static long[] nBits(int n) {
        return new long[(n - 1 >> 6) + 1];
    }

    private static void setBit(long[] bits, int i) {
        int n = i >> 6;
        bits[n] = bits[n] | 1L << i;
    }

    private static boolean isClear(long[] bits, int i) {
        return (bits[i >> 6] & 1L << i) == 0L;
    }

    private boolean bulkRemoveModified(Predicate<? super E> filter, int beg) {
        Object[] es = this.elements;
        int capacity = es.length;
        int end = this.tail;
        long[] deathRow = ArrayDeque.nBits(ArrayDeque.sub(end, beg, capacity));
        deathRow[0] = 1L;
        int i = beg + 1;
        int to = i <= end ? end : es.length;
        int k = beg;
        while (true) {
            if (i < to) {
                if (filter.test(ArrayDeque.elementAt(es, i))) {
                    ArrayDeque.setBit(deathRow, i - k);
                }
                ++i;
                continue;
            }
            if (to == end) break;
            i = 0;
            to = end;
            k -= capacity;
        }
        int w = beg;
        int i2 = beg + 1;
        int to2 = i2 <= end ? end : es.length;
        int k2 = beg;
        while (true) {
            if (i2 < to2) {
                if (ArrayDeque.isClear(deathRow, i2 - k2)) {
                    es[w++] = es[i2];
                }
                ++i2;
                continue;
            }
            if (to2 == end) break;
            to2 = end;
            k2 -= capacity;
            for (i2 = 0; i2 < to2 && w < capacity; ++i2) {
                if (!ArrayDeque.isClear(deathRow, i2 - k2)) continue;
                es[w++] = es[i2];
            }
            if (i2 >= to2) {
                if (w != capacity) break;
                w = 0;
                break;
            }
            w = 0;
        }
        if (end != this.tail) {
            throw new ConcurrentModificationException();
        }
        this.tail = w;
        ArrayDeque.circularClear(es, this.tail, end);
        return true;
    }

    @Override
    public boolean contains(Object o) {
        if (o != null) {
            int to;
            Object[] es = this.elements;
            int i = this.head;
            int end = this.tail;
            int n = to = i <= end ? end : es.length;
            while (true) {
                if (i < to) {
                    if (o.equals(es[i])) {
                        return true;
                    }
                    ++i;
                    continue;
                }
                if (to == end) break;
                i = 0;
                to = end;
            }
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return this.removeFirstOccurrence(o);
    }

    @Override
    public void clear() {
        ArrayDeque.circularClear(this.elements, this.head, this.tail);
        this.tail = 0;
        this.head = 0;
    }

    private static void circularClear(Object[] es, int i, int end) {
        int to;
        int n = to = i <= end ? end : es.length;
        while (true) {
            if (i < to) {
                es[i] = null;
                ++i;
                continue;
            }
            if (to == end) break;
            i = 0;
            to = end;
        }
    }

    @Override
    public Object[] toArray() {
        return this.toArray(Object[].class);
    }

    private <T> T[] toArray(Class<T[]> klazz) {
        T[] a;
        int tail;
        Object[] es = this.elements;
        int head = this.head;
        int end = tail + (head <= (tail = this.tail) ? 0 : es.length);
        if (end >= 0) {
            a = Arrays.copyOfRange(es, head, end, klazz);
        } else {
            a = Arrays.copyOfRange(es, 0, end - head, klazz);
            System.arraycopy(es, head, a, 0, es.length - head);
        }
        if (end != tail) {
            System.arraycopy(es, 0, a, es.length - head, tail);
        }
        return a;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (size > a.length) {
            return this.toArray(a.getClass());
        }
        Object[] es = this.elements;
        int i = this.head;
        int j = 0;
        int len = Math.min(size, es.length - i);
        while (true) {
            System.arraycopy(es, i, a, j, len);
            if ((j += len) == size) break;
            i = 0;
            len = this.tail;
        }
        if (size < a.length) {
            a[size] = null;
        }
        return a;
    }

    public ArrayDeque<E> clone() {
        try {
            ArrayDeque result = (ArrayDeque)super.clone();
            result.elements = Arrays.copyOf(this.elements, this.elements.length);
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int to;
        s.defaultWriteObject();
        s.writeInt(this.size());
        Object[] es = this.elements;
        int i = this.head;
        int end = this.tail;
        int n = to = i <= end ? end : es.length;
        while (true) {
            if (i < to) {
                s.writeObject(es[i]);
                ++i;
                continue;
            }
            if (to == end) break;
            i = 0;
            to = end;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.elements = new Object[size + 1];
        this.tail = size;
        for (int i = 0; i < size; ++i) {
            this.elements[i] = s.readObject();
        }
    }

    void checkInvariants() {
        try {
            int n = this.elements.length;
        }
        catch (Throwable t) {
            System.err.printf("head=%d tail=%d capacity=%d%n", this.head, this.tail, this.elements.length);
            System.err.printf("elements=%s%n", Arrays.toString(this.elements));
            throw t;
        }
    }

    final class DeqSpliterator
    implements Spliterator<E> {
        private int fence;
        private int cursor;

        DeqSpliterator() {
            this.fence = -1;
        }

        DeqSpliterator(int origin, int fence) {
            this.cursor = origin;
            this.fence = fence;
        }

        private int getFence() {
            int t = this.fence;
            if (t < 0) {
                t = this.fence = ArrayDeque.this.tail;
                this.cursor = ArrayDeque.this.head;
            }
            return t;
        }

        public DeqSpliterator trySplit() {
            DeqSpliterator deqSpliterator;
            Object[] es = ArrayDeque.this.elements;
            int i = this.cursor;
            int n = ArrayDeque.sub(this.getFence(), i, es.length) >> 1;
            if (n <= 0) {
                deqSpliterator = null;
            } else {
                this.cursor = ArrayDeque.add(i, n, es.length);
                DeqSpliterator deqSpliterator2 = new DeqSpliterator(i, this.cursor);
                deqSpliterator = deqSpliterator2;
            }
            return deqSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int end = this.getFence();
            int cursor = this.cursor;
            Object[] es = ArrayDeque.this.elements;
            if (cursor != end) {
                int to;
                this.cursor = end;
                if (es[cursor] == null || es[ArrayDeque.dec(end, es.length)] == null) {
                    throw new ConcurrentModificationException();
                }
                int i = cursor;
                int n = to = i <= end ? end : es.length;
                while (true) {
                    if (i < to) {
                        action.accept(ArrayDeque.elementAt(es, i));
                        ++i;
                        continue;
                    }
                    if (to == end) break;
                    i = 0;
                    to = end;
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            int i;
            Objects.requireNonNull(action);
            Object[] es = ArrayDeque.this.elements;
            if (this.fence < 0) {
                this.fence = ArrayDeque.this.tail;
                this.cursor = ArrayDeque.this.head;
            }
            if ((i = this.cursor) == this.fence) {
                return false;
            }
            Object e = ArrayDeque.nonNullElementAt(es, i);
            this.cursor = ArrayDeque.inc(i, es.length);
            action.accept(e);
            return true;
        }

        @Override
        public long estimateSize() {
            return ArrayDeque.sub(this.getFence(), this.cursor, ArrayDeque.this.elements.length);
        }

        @Override
        public int characteristics() {
            return 16720;
        }
    }

    private class DescendingIterator
    extends DeqIterator {
        DescendingIterator() {
            this.cursor = ArrayDeque.dec(ArrayDeque.this.tail, ArrayDeque.this.elements.length);
        }

        @Override
        public final E next() {
            if (this.remaining <= 0) {
                throw new NoSuchElementException();
            }
            Object[] es = ArrayDeque.this.elements;
            Object e = ArrayDeque.nonNullElementAt(es, this.cursor);
            this.lastRet = this.cursor;
            this.cursor = ArrayDeque.dec(this.lastRet, es.length);
            --this.remaining;
            return e;
        }

        @Override
        void postDelete(boolean leftShifted) {
            if (!leftShifted) {
                this.cursor = ArrayDeque.inc(this.cursor, ArrayDeque.this.elements.length);
            }
        }

        @Override
        public final void forEachRemaining(Consumer<? super E> action) {
            int to;
            Objects.requireNonNull(action);
            int r = this.remaining;
            if (r <= 0) {
                return;
            }
            this.remaining = 0;
            Object[] es = ArrayDeque.this.elements;
            if (es[this.cursor] == null || ArrayDeque.sub(this.cursor, ArrayDeque.this.head, es.length) + 1 != r) {
                throw new ConcurrentModificationException();
            }
            int i = this.cursor;
            int end = ArrayDeque.this.head;
            int n = to = i >= end ? end : 0;
            while (true) {
                if (i > to - 1) {
                    action.accept(ArrayDeque.elementAt(es, i));
                    --i;
                    continue;
                }
                if (to == end) {
                    if (end != ArrayDeque.this.head) {
                        throw new ConcurrentModificationException();
                    }
                    break;
                }
                i = es.length - 1;
                to = end;
            }
            this.lastRet = end;
        }
    }

    private class DeqIterator
    implements Iterator<E> {
        int cursor;
        int remaining;
        int lastRet;

        DeqIterator() {
            this.remaining = ArrayDeque.this.size();
            this.lastRet = -1;
            this.cursor = ArrayDeque.this.head;
        }

        @Override
        public final boolean hasNext() {
            return this.remaining > 0;
        }

        @Override
        public E next() {
            if (this.remaining <= 0) {
                throw new NoSuchElementException();
            }
            Object[] es = ArrayDeque.this.elements;
            Object e = ArrayDeque.nonNullElementAt(es, this.cursor);
            this.lastRet = this.cursor;
            this.cursor = ArrayDeque.inc(this.lastRet, es.length);
            --this.remaining;
            return e;
        }

        void postDelete(boolean leftShifted) {
            if (leftShifted) {
                this.cursor = ArrayDeque.dec(this.cursor, ArrayDeque.this.elements.length);
            }
        }

        @Override
        public final void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.postDelete(ArrayDeque.this.delete(this.lastRet));
            this.lastRet = -1;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            int to;
            Objects.requireNonNull(action);
            int r = this.remaining;
            if (r <= 0) {
                return;
            }
            this.remaining = 0;
            Object[] es = ArrayDeque.this.elements;
            if (es[this.cursor] == null || ArrayDeque.sub(ArrayDeque.this.tail, this.cursor, es.length) != r) {
                throw new ConcurrentModificationException();
            }
            int i = this.cursor;
            int end = ArrayDeque.this.tail;
            int n = to = i <= end ? end : es.length;
            while (true) {
                if (i < to) {
                    action.accept(ArrayDeque.elementAt(es, i));
                    ++i;
                    continue;
                }
                if (to == end) {
                    if (end != ArrayDeque.this.tail) {
                        throw new ConcurrentModificationException();
                    }
                    break;
                }
                i = 0;
                to = end;
            }
            this.lastRet = ArrayDeque.dec(end, es.length);
        }
    }
}

