/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapShortBuffer;
import java.nio.ReadOnlyBufferException;

public abstract class ShortBuffer
extends Buffer
implements Comparable<ShortBuffer> {
    final short[] hb;
    final int offset;
    boolean isReadOnly;

    ShortBuffer(int mark, int pos, int lim, int cap, short[] hb, int offset) {
        super(mark, pos, lim, cap);
        this.hb = hb;
        this.offset = offset;
    }

    ShortBuffer(int mark, int pos, int lim, int cap) {
        this(mark, pos, lim, cap, null, 0);
    }

    public static ShortBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw ShortBuffer.createCapacityException(capacity);
        }
        return new HeapShortBuffer(capacity, capacity);
    }

    public static ShortBuffer wrap(short[] array, int offset, int length) {
        try {
            return new HeapShortBuffer(array, offset, length);
        }
        catch (IllegalArgumentException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static ShortBuffer wrap(short[] array) {
        return ShortBuffer.wrap(array, 0, array.length);
    }

    @Override
    public abstract ShortBuffer slice();

    @Override
    public abstract ShortBuffer duplicate();

    public abstract ShortBuffer asReadOnlyBuffer();

    public abstract short get();

    public abstract ShortBuffer put(short var1);

    public abstract short get(int var1);

    public abstract ShortBuffer put(int var1, short var2);

    public ShortBuffer get(short[] dst, int offset, int length) {
        ShortBuffer.checkBounds(offset, length, dst.length);
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            dst[i] = this.get();
        }
        return this;
    }

    public ShortBuffer get(short[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public ShortBuffer put(ShortBuffer src) {
        if (src == this) {
            throw ShortBuffer.createSameBufferException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        int n = src.remaining();
        if (n > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = 0; i < n; ++i) {
            this.put(src.get());
        }
        return this;
    }

    public ShortBuffer put(short[] src, int offset, int length) {
        ShortBuffer.checkBounds(offset, length, src.length);
        if (length > this.remaining()) {
            throw new BufferOverflowException();
        }
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public final ShortBuffer put(short[] src) {
        return this.put(src, 0, src.length);
    }

    @Override
    public final boolean hasArray() {
        return this.hb != null && !this.isReadOnly;
    }

    public final short[] array() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.hb;
    }

    @Override
    public final int arrayOffset() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.offset;
    }

    @Override
    public final ShortBuffer position(int newPosition) {
        super.position(newPosition);
        return this;
    }

    @Override
    public final ShortBuffer limit(int newLimit) {
        super.limit(newLimit);
        return this;
    }

    @Override
    public final ShortBuffer mark() {
        super.mark();
        return this;
    }

    @Override
    public final ShortBuffer reset() {
        super.reset();
        return this;
    }

    @Override
    public final ShortBuffer clear() {
        super.clear();
        return this;
    }

    @Override
    public final ShortBuffer flip() {
        super.flip();
        return this;
    }

    @Override
    public final ShortBuffer rewind() {
        super.rewind();
        return this;
    }

    public abstract ShortBuffer compact();

    @Override
    public abstract boolean isDirect();

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("[pos=");
        sb.append(this.position());
        sb.append(" lim=");
        sb.append(this.limit());
        sb.append(" cap=");
        sb.append(this.capacity());
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int h = 1;
        int p = this.position();
        for (int i = this.limit() - 1; i >= p; --i) {
            h = 31 * h + this.get(i);
        }
        return h;
    }

    public boolean equals(Object ob) {
        if (this == ob) {
            return true;
        }
        if (!(ob instanceof ShortBuffer)) {
            return false;
        }
        ShortBuffer that = (ShortBuffer)ob;
        if (this.remaining() != that.remaining()) {
            return false;
        }
        int p = this.position();
        int i = this.limit() - 1;
        int j = that.limit() - 1;
        while (i >= p) {
            if (!ShortBuffer.equals(this.get(i), that.get(j))) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    private static boolean equals(short x, short y) {
        return x == y;
    }

    @Override
    public int compareTo(ShortBuffer that) {
        int n = this.position() + Math.min(this.remaining(), that.remaining());
        int i = this.position();
        int j = that.position();
        while (i < n) {
            int cmp = ShortBuffer.compare(this.get(i), that.get(j));
            if (cmp != 0) {
                return cmp;
            }
            ++i;
            ++j;
        }
        return this.remaining() - that.remaining();
    }

    private static int compare(short x, short y) {
        return Short.compare(x, y);
    }

    public abstract ByteOrder order();
}

