/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapIntBufferR;
import java.nio.IntBuffer;

class HeapIntBuffer
extends IntBuffer {
    HeapIntBuffer(int cap, int lim) {
        super(-1, 0, lim, cap, new int[cap], 0);
    }

    HeapIntBuffer(int[] buf, int off, int len) {
        super(-1, off, off + len, buf.length, buf, 0);
    }

    protected HeapIntBuffer(int[] buf, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap, buf, off);
    }

    @Override
    public IntBuffer slice() {
        return new HeapIntBuffer(this.hb, -1, 0, this.remaining(), this.remaining(), this.position() + this.offset);
    }

    @Override
    public IntBuffer duplicate() {
        return new HeapIntBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public IntBuffer asReadOnlyBuffer() {
        return new HeapIntBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int i) {
        return i + this.offset;
    }

    @Override
    public int get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    @Override
    public int get(int i) {
        return this.hb[this.ix(this.checkIndex(i))];
    }

    @Override
    public IntBuffer get(int[] dst, int offset, int length) {
        HeapIntBuffer.checkBounds(offset, length, dst.length);
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(this.position()), dst, offset, length);
        this.position(this.position() + length);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public IntBuffer put(int x) {
        this.hb[this.ix((int)this.nextPutIndex())] = x;
        return this;
    }

    @Override
    public IntBuffer put(int i, int x) {
        this.hb[this.ix((int)this.checkIndex((int)i))] = x;
        return this;
    }

    @Override
    public IntBuffer put(int[] src, int offset, int length) {
        HeapIntBuffer.checkBounds(offset, length, src.length);
        if (length > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, offset, this.hb, this.ix(this.position()), length);
        this.position(this.position() + length);
        return this;
    }

    @Override
    public IntBuffer put(IntBuffer src) {
        if (src instanceof HeapIntBuffer) {
            if (src == this) {
                throw HeapIntBuffer.createSameBufferException();
            }
            HeapIntBuffer sb = (HeapIntBuffer)src;
            int n = sb.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            System.arraycopy(sb.hb, sb.ix(sb.position()), this.hb, this.ix(this.position()), n);
            sb.position(sb.position() + n);
            this.position(this.position() + n);
        } else if (src.isDirect()) {
            int n = src.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            src.get(this.hb, this.ix(this.position()), n);
            this.position(this.position() + n);
        } else {
            super.put(src);
        }
        return this;
    }

    @Override
    public IntBuffer compact() {
        System.arraycopy(this.hb, this.ix(this.position()), this.hb, this.ix(0), this.remaining());
        this.position(this.remaining());
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

