/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.HeapCharBufferR;

class HeapCharBuffer
extends CharBuffer {
    HeapCharBuffer(int cap, int lim) {
        super(-1, 0, lim, cap, new char[cap], 0);
    }

    HeapCharBuffer(char[] buf, int off, int len) {
        super(-1, off, off + len, buf.length, buf, 0);
    }

    protected HeapCharBuffer(char[] buf, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap, buf, off);
    }

    @Override
    public CharBuffer slice() {
        return new HeapCharBuffer(this.hb, -1, 0, this.remaining(), this.remaining(), this.position() + this.offset);
    }

    @Override
    public CharBuffer duplicate() {
        return new HeapCharBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public CharBuffer asReadOnlyBuffer() {
        return new HeapCharBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int i) {
        return i + this.offset;
    }

    @Override
    public char get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    @Override
    public char get(int i) {
        return this.hb[this.ix(this.checkIndex(i))];
    }

    @Override
    char getUnchecked(int i) {
        return this.hb[this.ix(i)];
    }

    @Override
    public CharBuffer get(char[] dst, int offset, int length) {
        HeapCharBuffer.checkBounds(offset, length, dst.length);
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(this.position()), dst, offset, length);
        this.position(this.position() + length);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public CharBuffer put(char x) {
        this.hb[this.ix((int)this.nextPutIndex())] = x;
        return this;
    }

    @Override
    public CharBuffer put(int i, char x) {
        this.hb[this.ix((int)this.checkIndex((int)i))] = x;
        return this;
    }

    @Override
    public CharBuffer put(char[] src, int offset, int length) {
        HeapCharBuffer.checkBounds(offset, length, src.length);
        if (length > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, offset, this.hb, this.ix(this.position()), length);
        this.position(this.position() + length);
        return this;
    }

    @Override
    public CharBuffer put(CharBuffer src) {
        if (src instanceof HeapCharBuffer) {
            if (src == this) {
                throw HeapCharBuffer.createSameBufferException();
            }
            HeapCharBuffer sb = (HeapCharBuffer)src;
            int n = sb.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            System.arraycopy(sb.hb, sb.ix(sb.position()), this.hb, this.ix(this.position()), n);
            sb.position(sb.position() + n);
            this.position(this.position() + n);
        } else if (src.isDirect()) {
            int n = src.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            src.get(this.hb, this.ix(this.position()), n);
            this.position(this.position() + n);
        } else {
            super.put(src);
        }
        return this;
    }

    @Override
    public CharBuffer compact() {
        System.arraycopy(this.hb, this.ix(this.position()), this.hb, this.ix(0), this.remaining());
        this.position(this.remaining());
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    String toString(int start, int end) {
        try {
            return new String(this.hb, start + this.offset, end - start);
        }
        catch (StringIndexOutOfBoundsException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public CharBuffer subSequence(int start, int end) {
        if (start < 0 || end > this.length() || start > end) {
            throw new IndexOutOfBoundsException();
        }
        int pos = this.position();
        return new HeapCharBuffer(this.hb, -1, pos + start, pos + end, this.capacity(), this.offset);
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

