/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsCharBufferB;
import java.nio.ByteBufferAsCharBufferL;
import java.nio.ByteBufferAsDoubleBufferB;
import java.nio.ByteBufferAsDoubleBufferL;
import java.nio.ByteBufferAsFloatBufferB;
import java.nio.ByteBufferAsFloatBufferL;
import java.nio.ByteBufferAsIntBufferB;
import java.nio.ByteBufferAsIntBufferL;
import java.nio.ByteBufferAsLongBufferB;
import java.nio.ByteBufferAsLongBufferL;
import java.nio.ByteBufferAsShortBufferB;
import java.nio.ByteBufferAsShortBufferL;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.HeapByteBufferR;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import jdk.internal.misc.Unsafe;

class HeapByteBuffer
extends ByteBuffer {
    private static final Unsafe unsafe = Bits.unsafe();
    private static final long arrayBaseOffset = unsafe.arrayBaseOffset(byte[].class);

    HeapByteBuffer(int cap, int lim) {
        super(-1, 0, lim, cap, new byte[cap], 0);
        this.address = arrayBaseOffset;
    }

    HeapByteBuffer(byte[] buf, int off, int len) {
        super(-1, off, off + len, buf.length, buf, 0);
        this.address = arrayBaseOffset;
    }

    protected HeapByteBuffer(byte[] buf, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap, buf, off);
        this.address = arrayBaseOffset + (long)off;
    }

    @Override
    public ByteBuffer slice() {
        return new HeapByteBuffer(this.hb, -1, 0, this.remaining(), this.remaining(), this.position() + this.offset);
    }

    @Override
    ByteBuffer slice(int pos, int lim) {
        assert (pos >= 0);
        assert (pos <= lim);
        int rem = lim - pos;
        return new HeapByteBuffer(this.hb, -1, 0, rem, rem, pos + this.offset);
    }

    @Override
    public ByteBuffer duplicate() {
        return new HeapByteBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public ByteBuffer asReadOnlyBuffer() {
        return new HeapByteBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int i) {
        return i + this.offset;
    }

    private long byteOffset(long i) {
        return this.address + i;
    }

    @Override
    public byte get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    @Override
    public byte get(int i) {
        return this.hb[this.ix(this.checkIndex(i))];
    }

    @Override
    public ByteBuffer get(byte[] dst, int offset, int length) {
        HeapByteBuffer.checkBounds(offset, length, dst.length);
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(this.position()), dst, offset, length);
        this.position(this.position() + length);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteBuffer put(byte x) {
        this.hb[this.ix((int)this.nextPutIndex())] = x;
        return this;
    }

    @Override
    public ByteBuffer put(int i, byte x) {
        this.hb[this.ix((int)this.checkIndex((int)i))] = x;
        return this;
    }

    @Override
    public ByteBuffer put(byte[] src, int offset, int length) {
        HeapByteBuffer.checkBounds(offset, length, src.length);
        if (length > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, offset, this.hb, this.ix(this.position()), length);
        this.position(this.position() + length);
        return this;
    }

    @Override
    public ByteBuffer put(ByteBuffer src) {
        if (src instanceof HeapByteBuffer) {
            if (src == this) {
                throw HeapByteBuffer.createSameBufferException();
            }
            HeapByteBuffer sb = (HeapByteBuffer)src;
            int n = sb.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            System.arraycopy(sb.hb, sb.ix(sb.position()), this.hb, this.ix(this.position()), n);
            sb.position(sb.position() + n);
            this.position(this.position() + n);
        } else if (src.isDirect()) {
            int n = src.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            src.get(this.hb, this.ix(this.position()), n);
            this.position(this.position() + n);
        } else {
            super.put(src);
        }
        return this;
    }

    @Override
    public ByteBuffer compact() {
        System.arraycopy(this.hb, this.ix(this.position()), this.hb, this.ix(0), this.remaining());
        this.position(this.remaining());
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    byte _get(int i) {
        return this.hb[i];
    }

    @Override
    void _put(int i, byte b) {
        this.hb[i] = b;
    }

    @Override
    public char getChar() {
        return unsafe.getCharUnaligned(this.hb, this.byteOffset(this.nextGetIndex(2)), this.bigEndian);
    }

    @Override
    public char getChar(int i) {
        return unsafe.getCharUnaligned(this.hb, this.byteOffset(this.checkIndex(i, 2)), this.bigEndian);
    }

    @Override
    public ByteBuffer putChar(char x) {
        unsafe.putCharUnaligned(this.hb, this.byteOffset(this.nextPutIndex(2)), x, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putChar(int i, char x) {
        unsafe.putCharUnaligned(this.hb, this.byteOffset(this.checkIndex(i, 2)), x, this.bigEndian);
        return this;
    }

    @Override
    public CharBuffer asCharBuffer() {
        int size = this.remaining() >> 1;
        long addr = this.address + (long)this.position();
        return this.bigEndian ? new ByteBufferAsCharBufferB(this, -1, 0, size, size, addr) : new ByteBufferAsCharBufferL(this, -1, 0, size, size, addr);
    }

    @Override
    public short getShort() {
        return unsafe.getShortUnaligned(this.hb, this.byteOffset(this.nextGetIndex(2)), this.bigEndian);
    }

    @Override
    public short getShort(int i) {
        return unsafe.getShortUnaligned(this.hb, this.byteOffset(this.checkIndex(i, 2)), this.bigEndian);
    }

    @Override
    public ByteBuffer putShort(short x) {
        unsafe.putShortUnaligned(this.hb, this.byteOffset(this.nextPutIndex(2)), x, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putShort(int i, short x) {
        unsafe.putShortUnaligned(this.hb, this.byteOffset(this.checkIndex(i, 2)), x, this.bigEndian);
        return this;
    }

    @Override
    public ShortBuffer asShortBuffer() {
        int size = this.remaining() >> 1;
        long addr = this.address + (long)this.position();
        return this.bigEndian ? new ByteBufferAsShortBufferB(this, -1, 0, size, size, addr) : new ByteBufferAsShortBufferL(this, -1, 0, size, size, addr);
    }

    @Override
    public int getInt() {
        return unsafe.getIntUnaligned(this.hb, this.byteOffset(this.nextGetIndex(4)), this.bigEndian);
    }

    @Override
    public int getInt(int i) {
        return unsafe.getIntUnaligned(this.hb, this.byteOffset(this.checkIndex(i, 4)), this.bigEndian);
    }

    @Override
    public ByteBuffer putInt(int x) {
        unsafe.putIntUnaligned(this.hb, this.byteOffset(this.nextPutIndex(4)), x, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putInt(int i, int x) {
        unsafe.putIntUnaligned(this.hb, this.byteOffset(this.checkIndex(i, 4)), x, this.bigEndian);
        return this;
    }

    @Override
    public IntBuffer asIntBuffer() {
        int size = this.remaining() >> 2;
        long addr = this.address + (long)this.position();
        return this.bigEndian ? new ByteBufferAsIntBufferB(this, -1, 0, size, size, addr) : new ByteBufferAsIntBufferL(this, -1, 0, size, size, addr);
    }

    @Override
    public long getLong() {
        return unsafe.getLongUnaligned(this.hb, this.byteOffset(this.nextGetIndex(8)), this.bigEndian);
    }

    @Override
    public long getLong(int i) {
        return unsafe.getLongUnaligned(this.hb, this.byteOffset(this.checkIndex(i, 8)), this.bigEndian);
    }

    @Override
    public ByteBuffer putLong(long x) {
        unsafe.putLongUnaligned(this.hb, this.byteOffset(this.nextPutIndex(8)), x, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putLong(int i, long x) {
        unsafe.putLongUnaligned(this.hb, this.byteOffset(this.checkIndex(i, 8)), x, this.bigEndian);
        return this;
    }

    @Override
    public LongBuffer asLongBuffer() {
        int size = this.remaining() >> 3;
        long addr = this.address + (long)this.position();
        return this.bigEndian ? new ByteBufferAsLongBufferB(this, -1, 0, size, size, addr) : new ByteBufferAsLongBufferL(this, -1, 0, size, size, addr);
    }

    @Override
    public float getFloat() {
        int x = unsafe.getIntUnaligned(this.hb, this.byteOffset(this.nextGetIndex(4)), this.bigEndian);
        return Float.intBitsToFloat(x);
    }

    @Override
    public float getFloat(int i) {
        int x = unsafe.getIntUnaligned(this.hb, this.byteOffset(this.checkIndex(i, 4)), this.bigEndian);
        return Float.intBitsToFloat(x);
    }

    @Override
    public ByteBuffer putFloat(float x) {
        int y = Float.floatToRawIntBits(x);
        unsafe.putIntUnaligned(this.hb, this.byteOffset(this.nextPutIndex(4)), y, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putFloat(int i, float x) {
        int y = Float.floatToRawIntBits(x);
        unsafe.putIntUnaligned(this.hb, this.byteOffset(this.checkIndex(i, 4)), y, this.bigEndian);
        return this;
    }

    @Override
    public FloatBuffer asFloatBuffer() {
        int size = this.remaining() >> 2;
        long addr = this.address + (long)this.position();
        return this.bigEndian ? new ByteBufferAsFloatBufferB(this, -1, 0, size, size, addr) : new ByteBufferAsFloatBufferL(this, -1, 0, size, size, addr);
    }

    @Override
    public double getDouble() {
        long x = unsafe.getLongUnaligned(this.hb, this.byteOffset(this.nextGetIndex(8)), this.bigEndian);
        return Double.longBitsToDouble(x);
    }

    @Override
    public double getDouble(int i) {
        long x = unsafe.getLongUnaligned(this.hb, this.byteOffset(this.checkIndex(i, 8)), this.bigEndian);
        return Double.longBitsToDouble(x);
    }

    @Override
    public ByteBuffer putDouble(double x) {
        long y = Double.doubleToRawLongBits(x);
        unsafe.putLongUnaligned(this.hb, this.byteOffset(this.nextPutIndex(8)), y, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putDouble(int i, double x) {
        long y = Double.doubleToRawLongBits(x);
        unsafe.putLongUnaligned(this.hb, this.byteOffset(this.checkIndex(i, 8)), y, this.bigEndian);
        return this;
    }

    @Override
    public DoubleBuffer asDoubleBuffer() {
        int size = this.remaining() >> 3;
        long addr = this.address + (long)this.position();
        return this.bigEndian ? new ByteBufferAsDoubleBufferB(this, -1, 0, size, size, addr) : new ByteBufferAsDoubleBufferL(this, -1, 0, size, size, addr);
    }
}

