/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectShortBufferRS;
import java.nio.ShortBuffer;
import jdk.internal.misc.Unsafe;
import jdk.internal.ref.Cleaner;
import sun.nio.ch.DirectBuffer;

class DirectShortBufferS
extends ShortBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe = Bits.unsafe();
    private static final long arrayBaseOffset = unsafe.arrayBaseOffset(short[].class);
    protected static final boolean unaligned = Bits.unaligned();
    private final Object att;

    @Override
    public Object attachment() {
        return this.att;
    }

    @Override
    public Cleaner cleaner() {
        return null;
    }

    DirectShortBufferS(DirectBuffer db, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap);
        this.address = db.address() + (long)off;
        this.att = db;
    }

    @Override
    public ShortBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = pos << 1;
        assert (off >= 0);
        return new DirectShortBufferS(this, -1, 0, rem, rem, off);
    }

    @Override
    public ShortBuffer duplicate() {
        return new DirectShortBufferS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public ShortBuffer asReadOnlyBuffer() {
        return new DirectShortBufferRS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public long address() {
        return this.address;
    }

    private long ix(int i) {
        return this.address + ((long)i << 1);
    }

    @Override
    public short get() {
        return Bits.swap(unsafe.getShort(this.ix(this.nextGetIndex())));
    }

    @Override
    public short get(int i) {
        return Bits.swap(unsafe.getShort(this.ix(this.checkIndex(i))));
    }

    @Override
    public ShortBuffer get(short[] dst, int offset, int length) {
        if ((long)length << 1 > 6L) {
            int rem;
            DirectShortBufferS.checkBounds(offset, length, dst.length);
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (length > rem) {
                throw new BufferUnderflowException();
            }
            long dstOffset = arrayBaseOffset + ((long)offset << 1);
            if (this.order() != ByteOrder.nativeOrder()) {
                unsafe.copySwapMemory(null, this.ix(pos), dst, dstOffset, (long)length << 1, 2L);
            } else {
                unsafe.copyMemory(null, this.ix(pos), dst, dstOffset, (long)length << 1);
            }
            this.position(pos + length);
        } else {
            super.get(dst, offset, length);
        }
        return this;
    }

    @Override
    public ShortBuffer put(short x) {
        unsafe.putShort(this.ix(this.nextPutIndex()), Bits.swap(x));
        return this;
    }

    @Override
    public ShortBuffer put(int i, short x) {
        unsafe.putShort(this.ix(this.checkIndex(i)), Bits.swap(x));
        return this;
    }

    @Override
    public ShortBuffer put(ShortBuffer src) {
        if (src instanceof DirectShortBufferS) {
            int rem;
            if (src == this) {
                throw DirectShortBufferS.createSameBufferException();
            }
            DirectShortBufferS sb = (DirectShortBufferS)src;
            int spos = sb.position();
            int slim = sb.limit();
            assert (spos <= slim);
            int srem = spos <= slim ? slim - spos : 0;
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (srem > rem) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(sb.ix(spos), this.ix(pos), (long)srem << 1);
            sb.position(spos + srem);
            this.position(pos + srem);
        } else if (src.hb != null) {
            int spos = src.position();
            int slim = src.limit();
            assert (spos <= slim);
            int srem = spos <= slim ? slim - spos : 0;
            this.put(src.hb, src.offset + spos, srem);
            src.position(spos + srem);
        } else {
            super.put(src);
        }
        return this;
    }

    @Override
    public ShortBuffer put(short[] src, int offset, int length) {
        if ((long)length << 1 > 6L) {
            int rem;
            DirectShortBufferS.checkBounds(offset, length, src.length);
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (length > rem) {
                throw new BufferOverflowException();
            }
            long srcOffset = arrayBaseOffset + ((long)offset << 1);
            if (this.order() != ByteOrder.nativeOrder()) {
                unsafe.copySwapMemory(src, srcOffset, null, this.ix(pos), (long)length << 1, 2L);
            } else {
                unsafe.copyMemory(src, srcOffset, null, this.ix(pos), (long)length << 1);
            }
            this.position(pos + length);
        } else {
            super.put(src, offset, length);
        }
        return this;
    }

    @Override
    public ShortBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        unsafe.copyMemory(this.ix(pos), this.ix(0), (long)rem << 1);
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

