/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectLongBufferRU;
import java.nio.LongBuffer;
import jdk.internal.misc.Unsafe;
import jdk.internal.ref.Cleaner;
import sun.nio.ch.DirectBuffer;

class DirectLongBufferU
extends LongBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe = Bits.unsafe();
    private static final long arrayBaseOffset = unsafe.arrayBaseOffset(long[].class);
    protected static final boolean unaligned = Bits.unaligned();
    private final Object att;

    @Override
    public Object attachment() {
        return this.att;
    }

    @Override
    public Cleaner cleaner() {
        return null;
    }

    DirectLongBufferU(DirectBuffer db, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap);
        this.address = db.address() + (long)off;
        this.att = db;
    }

    @Override
    public LongBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = pos << 3;
        assert (off >= 0);
        return new DirectLongBufferU(this, -1, 0, rem, rem, off);
    }

    @Override
    public LongBuffer duplicate() {
        return new DirectLongBufferU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public LongBuffer asReadOnlyBuffer() {
        return new DirectLongBufferRU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public long address() {
        return this.address;
    }

    private long ix(int i) {
        return this.address + ((long)i << 3);
    }

    @Override
    public long get() {
        return unsafe.getLong(this.ix(this.nextGetIndex()));
    }

    @Override
    public long get(int i) {
        return unsafe.getLong(this.ix(this.checkIndex(i)));
    }

    @Override
    public LongBuffer get(long[] dst, int offset, int length) {
        if ((long)length << 3 > 6L) {
            int rem;
            DirectLongBufferU.checkBounds(offset, length, dst.length);
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (length > rem) {
                throw new BufferUnderflowException();
            }
            long dstOffset = arrayBaseOffset + ((long)offset << 3);
            if (this.order() != ByteOrder.nativeOrder()) {
                unsafe.copySwapMemory(null, this.ix(pos), dst, dstOffset, (long)length << 3, 8L);
            } else {
                unsafe.copyMemory(null, this.ix(pos), dst, dstOffset, (long)length << 3);
            }
            this.position(pos + length);
        } else {
            super.get(dst, offset, length);
        }
        return this;
    }

    @Override
    public LongBuffer put(long x) {
        unsafe.putLong(this.ix(this.nextPutIndex()), x);
        return this;
    }

    @Override
    public LongBuffer put(int i, long x) {
        unsafe.putLong(this.ix(this.checkIndex(i)), x);
        return this;
    }

    @Override
    public LongBuffer put(LongBuffer src) {
        if (src instanceof DirectLongBufferU) {
            int rem;
            if (src == this) {
                throw DirectLongBufferU.createSameBufferException();
            }
            DirectLongBufferU sb = (DirectLongBufferU)src;
            int spos = sb.position();
            int slim = sb.limit();
            assert (spos <= slim);
            int srem = spos <= slim ? slim - spos : 0;
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (srem > rem) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(sb.ix(spos), this.ix(pos), (long)srem << 3);
            sb.position(spos + srem);
            this.position(pos + srem);
        } else if (src.hb != null) {
            int spos = src.position();
            int slim = src.limit();
            assert (spos <= slim);
            int srem = spos <= slim ? slim - spos : 0;
            this.put(src.hb, src.offset + spos, srem);
            src.position(spos + srem);
        } else {
            super.put(src);
        }
        return this;
    }

    @Override
    public LongBuffer put(long[] src, int offset, int length) {
        if ((long)length << 3 > 6L) {
            int rem;
            DirectLongBufferU.checkBounds(offset, length, src.length);
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (length > rem) {
                throw new BufferOverflowException();
            }
            long srcOffset = arrayBaseOffset + ((long)offset << 3);
            if (this.order() != ByteOrder.nativeOrder()) {
                unsafe.copySwapMemory(src, srcOffset, null, this.ix(pos), (long)length << 3, 8L);
            } else {
                unsafe.copyMemory(src, srcOffset, null, this.ix(pos), (long)length << 3);
            }
            this.position(pos + length);
        } else {
            super.put(src, offset, length);
        }
        return this;
    }

    @Override
    public LongBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        unsafe.copyMemory(this.ix(pos), this.ix(0), (long)rem << 3);
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

