/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.DirectIntBufferU;
import java.nio.IntBuffer;
import java.nio.ReadOnlyBufferException;
import sun.nio.ch.DirectBuffer;

class DirectIntBufferRU
extends DirectIntBufferU
implements DirectBuffer {
    DirectIntBufferRU(DirectBuffer db, int mark, int pos, int lim, int cap, int off) {
        super(db, mark, pos, lim, cap, off);
        this.isReadOnly = true;
    }

    @Override
    public IntBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = pos << 2;
        assert (off >= 0);
        return new DirectIntBufferRU(this, -1, 0, rem, rem, off);
    }

    @Override
    public IntBuffer duplicate() {
        return new DirectIntBufferRU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public IntBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    @Override
    public IntBuffer put(int x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public IntBuffer put(int i, int x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public IntBuffer put(IntBuffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public IntBuffer put(int[] src, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public IntBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

