/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.io.FileDescriptor;
import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsCharBufferB;
import java.nio.ByteBufferAsCharBufferL;
import java.nio.ByteBufferAsDoubleBufferB;
import java.nio.ByteBufferAsDoubleBufferL;
import java.nio.ByteBufferAsFloatBufferB;
import java.nio.ByteBufferAsFloatBufferL;
import java.nio.ByteBufferAsIntBufferB;
import java.nio.ByteBufferAsIntBufferL;
import java.nio.ByteBufferAsLongBufferB;
import java.nio.ByteBufferAsLongBufferL;
import java.nio.ByteBufferAsShortBufferB;
import java.nio.ByteBufferAsShortBufferL;
import java.nio.CharBuffer;
import java.nio.DirectByteBufferR;
import java.nio.DirectCharBufferS;
import java.nio.DirectCharBufferU;
import java.nio.DirectDoubleBufferS;
import java.nio.DirectDoubleBufferU;
import java.nio.DirectFloatBufferS;
import java.nio.DirectFloatBufferU;
import java.nio.DirectIntBufferS;
import java.nio.DirectIntBufferU;
import java.nio.DirectLongBufferS;
import java.nio.DirectLongBufferU;
import java.nio.DirectShortBufferS;
import java.nio.DirectShortBufferU;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import jdk.internal.misc.Unsafe;
import jdk.internal.misc.VM;
import jdk.internal.ref.Cleaner;
import sun.nio.ch.DirectBuffer;

class DirectByteBuffer
extends MappedByteBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe = Bits.unsafe();
    private static final long arrayBaseOffset = unsafe.arrayBaseOffset(byte[].class);
    protected static final boolean unaligned = Bits.unaligned();
    private final Object att;
    private final Cleaner cleaner;

    @Override
    public Object attachment() {
        return this.att;
    }

    @Override
    public Cleaner cleaner() {
        return this.cleaner;
    }

    DirectByteBuffer(int cap) {
        super(-1, 0, cap, cap);
        boolean pa = VM.isDirectMemoryPageAligned();
        int ps = Bits.pageSize();
        long size = Math.max(1L, (long)cap + (long)(pa ? ps : 0));
        Bits.reserveMemory(size, cap);
        long base = 0L;
        try {
            base = unsafe.allocateMemory(size);
        }
        catch (OutOfMemoryError x) {
            Bits.unreserveMemory(size, cap);
            throw x;
        }
        unsafe.setMemory(base, size, (byte)0);
        this.address = pa && base % (long)ps != 0L ? base + (long)ps - (base & (long)(ps - 1)) : base;
        this.cleaner = Cleaner.create(this, new Deallocator(base, size, cap));
        this.att = null;
    }

    DirectByteBuffer(long addr, int cap, Object ob) {
        super(-1, 0, cap, cap);
        this.address = addr;
        this.cleaner = null;
        this.att = ob;
    }

    private DirectByteBuffer(long addr, int cap) {
        super(-1, 0, cap, cap);
        this.address = addr;
        this.cleaner = null;
        this.att = null;
    }

    protected DirectByteBuffer(int cap, long addr, FileDescriptor fd, Runnable unmapper) {
        super(-1, 0, cap, cap, fd);
        this.address = addr;
        this.cleaner = Cleaner.create(this, unmapper);
        this.att = null;
    }

    DirectByteBuffer(DirectBuffer db, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap);
        this.address = db.address() + (long)off;
        this.cleaner = null;
        this.att = db;
    }

    @Override
    public ByteBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = pos << 0;
        assert (off >= 0);
        return new DirectByteBuffer(this, -1, 0, rem, rem, off);
    }

    @Override
    public ByteBuffer slice(int pos, int lim) {
        assert (pos >= 0);
        assert (pos <= lim);
        int rem = lim - pos;
        return new DirectByteBuffer(this, -1, 0, rem, rem, pos);
    }

    @Override
    public ByteBuffer duplicate() {
        return new DirectByteBuffer(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public ByteBuffer asReadOnlyBuffer() {
        return new DirectByteBufferR(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public long address() {
        return this.address;
    }

    private long ix(int i) {
        return this.address + ((long)i << 0);
    }

    @Override
    public byte get() {
        return unsafe.getByte(this.ix(this.nextGetIndex()));
    }

    @Override
    public byte get(int i) {
        return unsafe.getByte(this.ix(this.checkIndex(i)));
    }

    @Override
    public ByteBuffer get(byte[] dst, int offset, int length) {
        if ((long)length << 0 > 6L) {
            int rem;
            DirectByteBuffer.checkBounds(offset, length, dst.length);
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (length > rem) {
                throw new BufferUnderflowException();
            }
            long dstOffset = arrayBaseOffset + ((long)offset << 0);
            unsafe.copyMemory(null, this.ix(pos), dst, dstOffset, (long)length << 0);
            this.position(pos + length);
        } else {
            super.get(dst, offset, length);
        }
        return this;
    }

    @Override
    public ByteBuffer put(byte x) {
        unsafe.putByte(this.ix(this.nextPutIndex()), x);
        return this;
    }

    @Override
    public ByteBuffer put(int i, byte x) {
        unsafe.putByte(this.ix(this.checkIndex(i)), x);
        return this;
    }

    @Override
    public ByteBuffer put(ByteBuffer src) {
        if (src instanceof DirectByteBuffer) {
            int rem;
            if (src == this) {
                throw DirectByteBuffer.createSameBufferException();
            }
            DirectByteBuffer sb = (DirectByteBuffer)src;
            int spos = sb.position();
            int slim = sb.limit();
            assert (spos <= slim);
            int srem = spos <= slim ? slim - spos : 0;
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (srem > rem) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(sb.ix(spos), this.ix(pos), (long)srem << 0);
            sb.position(spos + srem);
            this.position(pos + srem);
        } else if (src.hb != null) {
            int spos = src.position();
            int slim = src.limit();
            assert (spos <= slim);
            int srem = spos <= slim ? slim - spos : 0;
            this.put(src.hb, src.offset + spos, srem);
            src.position(spos + srem);
        } else {
            super.put(src);
        }
        return this;
    }

    @Override
    public ByteBuffer put(byte[] src, int offset, int length) {
        if ((long)length << 0 > 6L) {
            int rem;
            DirectByteBuffer.checkBounds(offset, length, src.length);
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (length > rem) {
                throw new BufferOverflowException();
            }
            long srcOffset = arrayBaseOffset + ((long)offset << 0);
            unsafe.copyMemory(src, srcOffset, null, this.ix(pos), (long)length << 0);
            this.position(pos + length);
        } else {
            super.put(src, offset, length);
        }
        return this;
    }

    @Override
    public ByteBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        unsafe.copyMemory(this.ix(pos), this.ix(0), (long)rem << 0);
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    byte _get(int i) {
        return unsafe.getByte(this.address + (long)i);
    }

    @Override
    void _put(int i, byte b) {
        unsafe.putByte(this.address + (long)i, b);
    }

    private char getChar(long a) {
        char x = unsafe.getCharUnaligned(null, a, this.bigEndian);
        return x;
    }

    @Override
    public char getChar() {
        return this.getChar(this.ix(this.nextGetIndex(2)));
    }

    @Override
    public char getChar(int i) {
        return this.getChar(this.ix(this.checkIndex(i, 2)));
    }

    private ByteBuffer putChar(long a, char x) {
        char y = x;
        unsafe.putCharUnaligned(null, a, y, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putChar(char x) {
        this.putChar(this.ix(this.nextPutIndex(2)), x);
        return this;
    }

    @Override
    public ByteBuffer putChar(int i, char x) {
        this.putChar(this.ix(this.checkIndex(i, 2)), x);
        return this;
    }

    @Override
    public CharBuffer asCharBuffer() {
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 1;
        if (!unaligned && (this.address + (long)off) % 2L != 0L) {
            return this.bigEndian ? new ByteBufferAsCharBufferB(this, -1, 0, size, size, this.address + (long)off) : new ByteBufferAsCharBufferL(this, -1, 0, size, size, this.address + (long)off);
        }
        return this.nativeByteOrder ? new DirectCharBufferU(this, -1, 0, size, size, off) : new DirectCharBufferS(this, -1, 0, size, size, off);
    }

    private short getShort(long a) {
        short x = unsafe.getShortUnaligned(null, a, this.bigEndian);
        return x;
    }

    @Override
    public short getShort() {
        return this.getShort(this.ix(this.nextGetIndex(2)));
    }

    @Override
    public short getShort(int i) {
        return this.getShort(this.ix(this.checkIndex(i, 2)));
    }

    private ByteBuffer putShort(long a, short x) {
        short y = x;
        unsafe.putShortUnaligned(null, a, y, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putShort(short x) {
        this.putShort(this.ix(this.nextPutIndex(2)), x);
        return this;
    }

    @Override
    public ByteBuffer putShort(int i, short x) {
        this.putShort(this.ix(this.checkIndex(i, 2)), x);
        return this;
    }

    @Override
    public ShortBuffer asShortBuffer() {
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 1;
        if (!unaligned && (this.address + (long)off) % 2L != 0L) {
            return this.bigEndian ? new ByteBufferAsShortBufferB(this, -1, 0, size, size, this.address + (long)off) : new ByteBufferAsShortBufferL(this, -1, 0, size, size, this.address + (long)off);
        }
        return this.nativeByteOrder ? new DirectShortBufferU(this, -1, 0, size, size, off) : new DirectShortBufferS(this, -1, 0, size, size, off);
    }

    private int getInt(long a) {
        int x = unsafe.getIntUnaligned(null, a, this.bigEndian);
        return x;
    }

    @Override
    public int getInt() {
        return this.getInt(this.ix(this.nextGetIndex(4)));
    }

    @Override
    public int getInt(int i) {
        return this.getInt(this.ix(this.checkIndex(i, 4)));
    }

    private ByteBuffer putInt(long a, int x) {
        int y = x;
        unsafe.putIntUnaligned(null, a, y, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putInt(int x) {
        this.putInt(this.ix(this.nextPutIndex(4)), x);
        return this;
    }

    @Override
    public ByteBuffer putInt(int i, int x) {
        this.putInt(this.ix(this.checkIndex(i, 4)), x);
        return this;
    }

    @Override
    public IntBuffer asIntBuffer() {
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 2;
        if (!unaligned && (this.address + (long)off) % 4L != 0L) {
            return this.bigEndian ? new ByteBufferAsIntBufferB(this, -1, 0, size, size, this.address + (long)off) : new ByteBufferAsIntBufferL(this, -1, 0, size, size, this.address + (long)off);
        }
        return this.nativeByteOrder ? new DirectIntBufferU(this, -1, 0, size, size, off) : new DirectIntBufferS(this, -1, 0, size, size, off);
    }

    private long getLong(long a) {
        long x = unsafe.getLongUnaligned(null, a, this.bigEndian);
        return x;
    }

    @Override
    public long getLong() {
        return this.getLong(this.ix(this.nextGetIndex(8)));
    }

    @Override
    public long getLong(int i) {
        return this.getLong(this.ix(this.checkIndex(i, 8)));
    }

    private ByteBuffer putLong(long a, long x) {
        long y = x;
        unsafe.putLongUnaligned(null, a, y, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putLong(long x) {
        this.putLong(this.ix(this.nextPutIndex(8)), x);
        return this;
    }

    @Override
    public ByteBuffer putLong(int i, long x) {
        this.putLong(this.ix(this.checkIndex(i, 8)), x);
        return this;
    }

    @Override
    public LongBuffer asLongBuffer() {
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 3;
        if (!unaligned && (this.address + (long)off) % 8L != 0L) {
            return this.bigEndian ? new ByteBufferAsLongBufferB(this, -1, 0, size, size, this.address + (long)off) : new ByteBufferAsLongBufferL(this, -1, 0, size, size, this.address + (long)off);
        }
        return this.nativeByteOrder ? new DirectLongBufferU(this, -1, 0, size, size, off) : new DirectLongBufferS(this, -1, 0, size, size, off);
    }

    private float getFloat(long a) {
        int x = unsafe.getIntUnaligned(null, a, this.bigEndian);
        return Float.intBitsToFloat(x);
    }

    @Override
    public float getFloat() {
        return this.getFloat(this.ix(this.nextGetIndex(4)));
    }

    @Override
    public float getFloat(int i) {
        return this.getFloat(this.ix(this.checkIndex(i, 4)));
    }

    private ByteBuffer putFloat(long a, float x) {
        int y = Float.floatToRawIntBits(x);
        unsafe.putIntUnaligned(null, a, y, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putFloat(float x) {
        this.putFloat(this.ix(this.nextPutIndex(4)), x);
        return this;
    }

    @Override
    public ByteBuffer putFloat(int i, float x) {
        this.putFloat(this.ix(this.checkIndex(i, 4)), x);
        return this;
    }

    @Override
    public FloatBuffer asFloatBuffer() {
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 2;
        if (!unaligned && (this.address + (long)off) % 4L != 0L) {
            return this.bigEndian ? new ByteBufferAsFloatBufferB(this, -1, 0, size, size, this.address + (long)off) : new ByteBufferAsFloatBufferL(this, -1, 0, size, size, this.address + (long)off);
        }
        return this.nativeByteOrder ? new DirectFloatBufferU(this, -1, 0, size, size, off) : new DirectFloatBufferS(this, -1, 0, size, size, off);
    }

    private double getDouble(long a) {
        long x = unsafe.getLongUnaligned(null, a, this.bigEndian);
        return Double.longBitsToDouble(x);
    }

    @Override
    public double getDouble() {
        return this.getDouble(this.ix(this.nextGetIndex(8)));
    }

    @Override
    public double getDouble(int i) {
        return this.getDouble(this.ix(this.checkIndex(i, 8)));
    }

    private ByteBuffer putDouble(long a, double x) {
        long y = Double.doubleToRawLongBits(x);
        unsafe.putLongUnaligned(null, a, y, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putDouble(double x) {
        this.putDouble(this.ix(this.nextPutIndex(8)), x);
        return this;
    }

    @Override
    public ByteBuffer putDouble(int i, double x) {
        this.putDouble(this.ix(this.checkIndex(i, 8)), x);
        return this;
    }

    @Override
    public DoubleBuffer asDoubleBuffer() {
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 3;
        if (!unaligned && (this.address + (long)off) % 8L != 0L) {
            return this.bigEndian ? new ByteBufferAsDoubleBufferB(this, -1, 0, size, size, this.address + (long)off) : new ByteBufferAsDoubleBufferL(this, -1, 0, size, size, this.address + (long)off);
        }
        return this.nativeByteOrder ? new DirectDoubleBufferU(this, -1, 0, size, size, off) : new DirectDoubleBufferS(this, -1, 0, size, size, off);
    }

    private static class Deallocator
    implements Runnable {
        private static Unsafe unsafe = Unsafe.getUnsafe();
        private long address;
        private long size;
        private int capacity;

        private Deallocator(long address, long size, int capacity) {
            assert (address != 0L);
            this.address = address;
            this.size = size;
            this.capacity = capacity;
        }

        @Override
        public void run() {
            if (this.address == 0L) {
                return;
            }
            unsafe.freeMemory(this.address);
            this.address = 0L;
            Bits.unreserveMemory(this.size, this.capacity);
        }
    }
}

