/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsShortBufferRL;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import jdk.internal.misc.Unsafe;

class ByteBufferAsShortBufferL
extends ShortBuffer {
    private static final Unsafe unsafe = Bits.unsafe();
    protected final ByteBuffer bb;

    ByteBufferAsShortBufferL(ByteBuffer bb) {
        super(-1, 0, bb.remaining() >> 1, bb.remaining() >> 1);
        this.bb = bb;
        int cap = this.capacity();
        this.limit(cap);
        int pos = this.position();
        assert (pos <= cap);
        this.address = bb.address;
    }

    ByteBufferAsShortBufferL(ByteBuffer bb, int mark, int pos, int lim, int cap, long addr) {
        super(mark, pos, lim, cap);
        this.bb = bb;
        this.address = addr;
        assert (this.address >= bb.address);
    }

    @Override
    public ShortBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        long addr = this.byteOffset(pos);
        return new ByteBufferAsShortBufferL(this.bb, -1, 0, rem, rem, addr);
    }

    @Override
    public ShortBuffer duplicate() {
        return new ByteBufferAsShortBufferL(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.address);
    }

    @Override
    public ShortBuffer asReadOnlyBuffer() {
        return new ByteBufferAsShortBufferRL(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.address);
    }

    private int ix(int i) {
        int off = (int)(this.address - this.bb.address);
        return (i << 1) + off;
    }

    protected long byteOffset(long i) {
        return (i << 1) + this.address;
    }

    @Override
    public short get() {
        short x = unsafe.getShortUnaligned(this.bb.hb, this.byteOffset(this.nextGetIndex()), false);
        return x;
    }

    @Override
    public short get(int i) {
        short x = unsafe.getShortUnaligned(this.bb.hb, this.byteOffset(this.checkIndex(i)), false);
        return x;
    }

    @Override
    public ShortBuffer put(short x) {
        short y = x;
        unsafe.putShortUnaligned(this.bb.hb, this.byteOffset(this.nextPutIndex()), y, false);
        return this;
    }

    @Override
    public ShortBuffer put(int i, short x) {
        short y = x;
        unsafe.putShortUnaligned(this.bb.hb, this.byteOffset(this.checkIndex(i)), y, false);
        return this;
    }

    @Override
    public ShortBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        ByteBuffer db = this.bb.duplicate();
        db.limit(this.ix(lim));
        db.position(this.ix(0));
        ByteBuffer sb = db.slice();
        sb.position(pos << 1);
        sb.compact();
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.bb.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }
}

