/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsLongBufferRL;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import jdk.internal.misc.Unsafe;

class ByteBufferAsLongBufferL
extends LongBuffer {
    private static final Unsafe unsafe = Bits.unsafe();
    protected final ByteBuffer bb;

    ByteBufferAsLongBufferL(ByteBuffer bb) {
        super(-1, 0, bb.remaining() >> 3, bb.remaining() >> 3);
        this.bb = bb;
        int cap = this.capacity();
        this.limit(cap);
        int pos = this.position();
        assert (pos <= cap);
        this.address = bb.address;
    }

    ByteBufferAsLongBufferL(ByteBuffer bb, int mark, int pos, int lim, int cap, long addr) {
        super(mark, pos, lim, cap);
        this.bb = bb;
        this.address = addr;
        assert (this.address >= bb.address);
    }

    @Override
    public LongBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        long addr = this.byteOffset(pos);
        return new ByteBufferAsLongBufferL(this.bb, -1, 0, rem, rem, addr);
    }

    @Override
    public LongBuffer duplicate() {
        return new ByteBufferAsLongBufferL(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.address);
    }

    @Override
    public LongBuffer asReadOnlyBuffer() {
        return new ByteBufferAsLongBufferRL(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.address);
    }

    private int ix(int i) {
        int off = (int)(this.address - this.bb.address);
        return (i << 3) + off;
    }

    protected long byteOffset(long i) {
        return (i << 3) + this.address;
    }

    @Override
    public long get() {
        long x = unsafe.getLongUnaligned(this.bb.hb, this.byteOffset(this.nextGetIndex()), false);
        return x;
    }

    @Override
    public long get(int i) {
        long x = unsafe.getLongUnaligned(this.bb.hb, this.byteOffset(this.checkIndex(i)), false);
        return x;
    }

    @Override
    public LongBuffer put(long x) {
        long y = x;
        unsafe.putLongUnaligned(this.bb.hb, this.byteOffset(this.nextPutIndex()), y, false);
        return this;
    }

    @Override
    public LongBuffer put(int i, long x) {
        long y = x;
        unsafe.putLongUnaligned(this.bb.hb, this.byteOffset(this.checkIndex(i)), y, false);
        return this;
    }

    @Override
    public LongBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        ByteBuffer db = this.bb.duplicate();
        db.limit(this.ix(lim));
        db.position(this.ix(0));
        ByteBuffer sb = db.slice();
        sb.position(pos << 3);
        sb.compact();
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.bb.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }
}

