/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsIntBufferRB;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import jdk.internal.misc.Unsafe;

class ByteBufferAsIntBufferB
extends IntBuffer {
    private static final Unsafe unsafe = Bits.unsafe();
    protected final ByteBuffer bb;

    ByteBufferAsIntBufferB(ByteBuffer bb) {
        super(-1, 0, bb.remaining() >> 2, bb.remaining() >> 2);
        this.bb = bb;
        int cap = this.capacity();
        this.limit(cap);
        int pos = this.position();
        assert (pos <= cap);
        this.address = bb.address;
    }

    ByteBufferAsIntBufferB(ByteBuffer bb, int mark, int pos, int lim, int cap, long addr) {
        super(mark, pos, lim, cap);
        this.bb = bb;
        this.address = addr;
        assert (this.address >= bb.address);
    }

    @Override
    public IntBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        long addr = this.byteOffset(pos);
        return new ByteBufferAsIntBufferB(this.bb, -1, 0, rem, rem, addr);
    }

    @Override
    public IntBuffer duplicate() {
        return new ByteBufferAsIntBufferB(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.address);
    }

    @Override
    public IntBuffer asReadOnlyBuffer() {
        return new ByteBufferAsIntBufferRB(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.address);
    }

    private int ix(int i) {
        int off = (int)(this.address - this.bb.address);
        return (i << 2) + off;
    }

    protected long byteOffset(long i) {
        return (i << 2) + this.address;
    }

    @Override
    public int get() {
        int x = unsafe.getIntUnaligned(this.bb.hb, this.byteOffset(this.nextGetIndex()), true);
        return x;
    }

    @Override
    public int get(int i) {
        int x = unsafe.getIntUnaligned(this.bb.hb, this.byteOffset(this.checkIndex(i)), true);
        return x;
    }

    @Override
    public IntBuffer put(int x) {
        int y = x;
        unsafe.putIntUnaligned(this.bb.hb, this.byteOffset(this.nextPutIndex()), y, true);
        return this;
    }

    @Override
    public IntBuffer put(int i, int x) {
        int y = x;
        unsafe.putIntUnaligned(this.bb.hb, this.byteOffset(this.checkIndex(i)), y, true);
        return this;
    }

    @Override
    public IntBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        ByteBuffer db = this.bb.duplicate();
        db.limit(this.ix(lim));
        db.position(this.ix(0));
        ByteBuffer sb = db.slice();
        sb.position(pos << 2);
        sb.compact();
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.bb.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }
}

