/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsFloatBufferRL;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import jdk.internal.misc.Unsafe;

class ByteBufferAsFloatBufferL
extends FloatBuffer {
    private static final Unsafe unsafe = Bits.unsafe();
    protected final ByteBuffer bb;

    ByteBufferAsFloatBufferL(ByteBuffer bb) {
        super(-1, 0, bb.remaining() >> 2, bb.remaining() >> 2);
        this.bb = bb;
        int cap = this.capacity();
        this.limit(cap);
        int pos = this.position();
        assert (pos <= cap);
        this.address = bb.address;
    }

    ByteBufferAsFloatBufferL(ByteBuffer bb, int mark, int pos, int lim, int cap, long addr) {
        super(mark, pos, lim, cap);
        this.bb = bb;
        this.address = addr;
        assert (this.address >= bb.address);
    }

    @Override
    public FloatBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        long addr = this.byteOffset(pos);
        return new ByteBufferAsFloatBufferL(this.bb, -1, 0, rem, rem, addr);
    }

    @Override
    public FloatBuffer duplicate() {
        return new ByteBufferAsFloatBufferL(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.address);
    }

    @Override
    public FloatBuffer asReadOnlyBuffer() {
        return new ByteBufferAsFloatBufferRL(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.address);
    }

    private int ix(int i) {
        int off = (int)(this.address - this.bb.address);
        return (i << 2) + off;
    }

    protected long byteOffset(long i) {
        return (i << 2) + this.address;
    }

    @Override
    public float get() {
        int x = unsafe.getIntUnaligned(this.bb.hb, this.byteOffset(this.nextGetIndex()), false);
        return Float.intBitsToFloat(x);
    }

    @Override
    public float get(int i) {
        int x = unsafe.getIntUnaligned(this.bb.hb, this.byteOffset(this.checkIndex(i)), false);
        return Float.intBitsToFloat(x);
    }

    @Override
    public FloatBuffer put(float x) {
        int y = Float.floatToRawIntBits(x);
        unsafe.putIntUnaligned(this.bb.hb, this.byteOffset(this.nextPutIndex()), y, false);
        return this;
    }

    @Override
    public FloatBuffer put(int i, float x) {
        int y = Float.floatToRawIntBits(x);
        unsafe.putIntUnaligned(this.bb.hb, this.byteOffset(this.checkIndex(i)), y, false);
        return this;
    }

    @Override
    public FloatBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        ByteBuffer db = this.bb.duplicate();
        db.limit(this.ix(lim));
        db.position(this.ix(0));
        ByteBuffer sb = db.slice();
        sb.position(pos << 2);
        sb.compact();
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.bb.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }
}

