/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsDoubleBufferRB;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import jdk.internal.misc.Unsafe;

class ByteBufferAsDoubleBufferB
extends DoubleBuffer {
    private static final Unsafe unsafe = Bits.unsafe();
    protected final ByteBuffer bb;

    ByteBufferAsDoubleBufferB(ByteBuffer bb) {
        super(-1, 0, bb.remaining() >> 3, bb.remaining() >> 3);
        this.bb = bb;
        int cap = this.capacity();
        this.limit(cap);
        int pos = this.position();
        assert (pos <= cap);
        this.address = bb.address;
    }

    ByteBufferAsDoubleBufferB(ByteBuffer bb, int mark, int pos, int lim, int cap, long addr) {
        super(mark, pos, lim, cap);
        this.bb = bb;
        this.address = addr;
        assert (this.address >= bb.address);
    }

    @Override
    public DoubleBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        long addr = this.byteOffset(pos);
        return new ByteBufferAsDoubleBufferB(this.bb, -1, 0, rem, rem, addr);
    }

    @Override
    public DoubleBuffer duplicate() {
        return new ByteBufferAsDoubleBufferB(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.address);
    }

    @Override
    public DoubleBuffer asReadOnlyBuffer() {
        return new ByteBufferAsDoubleBufferRB(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.address);
    }

    private int ix(int i) {
        int off = (int)(this.address - this.bb.address);
        return (i << 3) + off;
    }

    protected long byteOffset(long i) {
        return (i << 3) + this.address;
    }

    @Override
    public double get() {
        long x = unsafe.getLongUnaligned(this.bb.hb, this.byteOffset(this.nextGetIndex()), true);
        return Double.longBitsToDouble(x);
    }

    @Override
    public double get(int i) {
        long x = unsafe.getLongUnaligned(this.bb.hb, this.byteOffset(this.checkIndex(i)), true);
        return Double.longBitsToDouble(x);
    }

    @Override
    public DoubleBuffer put(double x) {
        long y = Double.doubleToRawLongBits(x);
        unsafe.putLongUnaligned(this.bb.hb, this.byteOffset(this.nextPutIndex()), y, true);
        return this;
    }

    @Override
    public DoubleBuffer put(int i, double x) {
        long y = Double.doubleToRawLongBits(x);
        unsafe.putLongUnaligned(this.bb.hb, this.byteOffset(this.checkIndex(i)), y, true);
        return this;
    }

    @Override
    public DoubleBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        ByteBuffer db = this.bb.duplicate();
        db.limit(this.ix(lim));
        db.position(this.ix(0));
        ByteBuffer sb = db.slice();
        sb.position(pos << 3);
        sb.compact();
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.bb.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }
}

