/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsCharBufferRL;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import jdk.internal.misc.Unsafe;

class ByteBufferAsCharBufferL
extends CharBuffer {
    private static final Unsafe unsafe = Bits.unsafe();
    protected final ByteBuffer bb;

    ByteBufferAsCharBufferL(ByteBuffer bb) {
        super(-1, 0, bb.remaining() >> 1, bb.remaining() >> 1);
        this.bb = bb;
        int cap = this.capacity();
        this.limit(cap);
        int pos = this.position();
        assert (pos <= cap);
        this.address = bb.address;
    }

    ByteBufferAsCharBufferL(ByteBuffer bb, int mark, int pos, int lim, int cap, long addr) {
        super(mark, pos, lim, cap);
        this.bb = bb;
        this.address = addr;
        assert (this.address >= bb.address);
    }

    @Override
    public CharBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        long addr = this.byteOffset(pos);
        return new ByteBufferAsCharBufferL(this.bb, -1, 0, rem, rem, addr);
    }

    @Override
    public CharBuffer duplicate() {
        return new ByteBufferAsCharBufferL(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.address);
    }

    @Override
    public CharBuffer asReadOnlyBuffer() {
        return new ByteBufferAsCharBufferRL(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.address);
    }

    private int ix(int i) {
        int off = (int)(this.address - this.bb.address);
        return (i << 1) + off;
    }

    protected long byteOffset(long i) {
        return (i << 1) + this.address;
    }

    @Override
    public char get() {
        char x = unsafe.getCharUnaligned(this.bb.hb, this.byteOffset(this.nextGetIndex()), false);
        return x;
    }

    @Override
    public char get(int i) {
        char x = unsafe.getCharUnaligned(this.bb.hb, this.byteOffset(this.checkIndex(i)), false);
        return x;
    }

    @Override
    char getUnchecked(int i) {
        char x = unsafe.getCharUnaligned(this.bb.hb, this.byteOffset(i), false);
        return x;
    }

    @Override
    public CharBuffer put(char x) {
        char y = x;
        unsafe.putCharUnaligned(this.bb.hb, this.byteOffset(this.nextPutIndex()), y, false);
        return this;
    }

    @Override
    public CharBuffer put(int i, char x) {
        char y = x;
        unsafe.putCharUnaligned(this.bb.hb, this.byteOffset(this.checkIndex(i)), y, false);
        return this;
    }

    @Override
    public CharBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        ByteBuffer db = this.bb.duplicate();
        db.limit(this.ix(lim));
        db.position(this.ix(0));
        ByteBuffer sb = db.slice();
        sb.position(pos << 1);
        sb.compact();
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.bb.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String toString(int start, int end) {
        if (end > this.limit() || start > end) {
            throw new IndexOutOfBoundsException();
        }
        try {
            int len = end - start;
            char[] ca = new char[len];
            CharBuffer cb = CharBuffer.wrap(ca);
            CharBuffer db = this.duplicate();
            db.position(start);
            db.limit(end);
            cb.put(db);
            return new String(ca);
        }
        catch (StringIndexOutOfBoundsException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public CharBuffer subSequence(int start, int end) {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        pos = pos <= lim ? pos : lim;
        int len = lim - pos;
        if (start < 0 || end > len || start > end) {
            throw new IndexOutOfBoundsException();
        }
        return new ByteBufferAsCharBufferL(this.bb, -1, pos + start, pos + end, this.capacity(), this.address);
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }
}

