/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DirectByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.HeapByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;

public abstract class ByteBuffer
extends Buffer
implements Comparable<ByteBuffer> {
    final byte[] hb;
    final int offset;
    boolean isReadOnly;
    boolean bigEndian = true;
    boolean nativeByteOrder = Bits.byteOrder() == ByteOrder.BIG_ENDIAN;

    ByteBuffer(int mark, int pos, int lim, int cap, byte[] hb, int offset) {
        super(mark, pos, lim, cap);
        this.hb = hb;
        this.offset = offset;
    }

    ByteBuffer(int mark, int pos, int lim, int cap) {
        this(mark, pos, lim, cap, null, 0);
    }

    public static ByteBuffer allocateDirect(int capacity) {
        return new DirectByteBuffer(capacity);
    }

    public static ByteBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw ByteBuffer.createCapacityException(capacity);
        }
        return new HeapByteBuffer(capacity, capacity);
    }

    public static ByteBuffer wrap(byte[] array, int offset, int length) {
        try {
            return new HeapByteBuffer(array, offset, length);
        }
        catch (IllegalArgumentException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static ByteBuffer wrap(byte[] array) {
        return ByteBuffer.wrap(array, 0, array.length);
    }

    @Override
    public abstract ByteBuffer slice();

    @Override
    public abstract ByteBuffer duplicate();

    public abstract ByteBuffer asReadOnlyBuffer();

    public abstract byte get();

    public abstract ByteBuffer put(byte var1);

    public abstract byte get(int var1);

    public abstract ByteBuffer put(int var1, byte var2);

    public ByteBuffer get(byte[] dst, int offset, int length) {
        ByteBuffer.checkBounds(offset, length, dst.length);
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            dst[i] = this.get();
        }
        return this;
    }

    public ByteBuffer get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public ByteBuffer put(ByteBuffer src) {
        if (src == this) {
            throw ByteBuffer.createSameBufferException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        int n = src.remaining();
        if (n > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = 0; i < n; ++i) {
            this.put(src.get());
        }
        return this;
    }

    public ByteBuffer put(byte[] src, int offset, int length) {
        ByteBuffer.checkBounds(offset, length, src.length);
        if (length > this.remaining()) {
            throw new BufferOverflowException();
        }
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public final ByteBuffer put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    @Override
    public final boolean hasArray() {
        return this.hb != null && !this.isReadOnly;
    }

    public final byte[] array() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.hb;
    }

    @Override
    public final int arrayOffset() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.offset;
    }

    @Override
    public ByteBuffer position(int newPosition) {
        super.position(newPosition);
        return this;
    }

    @Override
    public ByteBuffer limit(int newLimit) {
        super.limit(newLimit);
        return this;
    }

    @Override
    public ByteBuffer mark() {
        super.mark();
        return this;
    }

    @Override
    public ByteBuffer reset() {
        super.reset();
        return this;
    }

    @Override
    public ByteBuffer clear() {
        super.clear();
        return this;
    }

    @Override
    public ByteBuffer flip() {
        super.flip();
        return this;
    }

    @Override
    public ByteBuffer rewind() {
        super.rewind();
        return this;
    }

    public abstract ByteBuffer compact();

    @Override
    public abstract boolean isDirect();

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("[pos=");
        sb.append(this.position());
        sb.append(" lim=");
        sb.append(this.limit());
        sb.append(" cap=");
        sb.append(this.capacity());
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int h = 1;
        int p = this.position();
        for (int i = this.limit() - 1; i >= p; --i) {
            h = 31 * h + this.get(i);
        }
        return h;
    }

    public boolean equals(Object ob) {
        if (this == ob) {
            return true;
        }
        if (!(ob instanceof ByteBuffer)) {
            return false;
        }
        ByteBuffer that = (ByteBuffer)ob;
        if (this.remaining() != that.remaining()) {
            return false;
        }
        int p = this.position();
        int i = this.limit() - 1;
        int j = that.limit() - 1;
        while (i >= p) {
            if (!ByteBuffer.equals(this.get(i), that.get(j))) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    private static boolean equals(byte x, byte y) {
        return x == y;
    }

    @Override
    public int compareTo(ByteBuffer that) {
        int n = this.position() + Math.min(this.remaining(), that.remaining());
        int i = this.position();
        int j = that.position();
        while (i < n) {
            int cmp = ByteBuffer.compare(this.get(i), that.get(j));
            if (cmp != 0) {
                return cmp;
            }
            ++i;
            ++j;
        }
        return this.remaining() - that.remaining();
    }

    private static int compare(byte x, byte y) {
        return Byte.compare(x, y);
    }

    public final ByteOrder order() {
        return this.bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    public final ByteBuffer order(ByteOrder bo) {
        this.bigEndian = bo == ByteOrder.BIG_ENDIAN;
        this.nativeByteOrder = this.bigEndian == (Bits.byteOrder() == ByteOrder.BIG_ENDIAN);
        return this;
    }

    public final int alignmentOffset(int index, int unitSize) {
        if (index < 0) {
            throw new IllegalArgumentException("Index less than zero: " + index);
        }
        if (unitSize < 1 || (unitSize & unitSize - 1) != 0) {
            throw new IllegalArgumentException("Unit size not a power of two: " + unitSize);
        }
        if (unitSize > 8 && !this.isDirect()) {
            throw new UnsupportedOperationException("Unit size unsupported for non-direct buffers: " + unitSize);
        }
        return (int)((this.address + (long)index) % (long)unitSize);
    }

    public final ByteBuffer alignedSlice(int unitSize) {
        int pos = this.position();
        int lim = this.limit();
        int pos_mod = this.alignmentOffset(pos, unitSize);
        int lim_mod = this.alignmentOffset(lim, unitSize);
        int aligned_pos = pos_mod > 0 ? pos + (unitSize - pos_mod) : pos;
        int aligned_lim = lim - lim_mod;
        if (aligned_pos > lim || aligned_lim < pos) {
            aligned_pos = aligned_lim = pos;
        }
        return this.slice(aligned_pos, aligned_lim);
    }

    abstract ByteBuffer slice(int var1, int var2);

    abstract byte _get(int var1);

    abstract void _put(int var1, byte var2);

    public abstract char getChar();

    public abstract ByteBuffer putChar(char var1);

    public abstract char getChar(int var1);

    public abstract ByteBuffer putChar(int var1, char var2);

    public abstract CharBuffer asCharBuffer();

    public abstract short getShort();

    public abstract ByteBuffer putShort(short var1);

    public abstract short getShort(int var1);

    public abstract ByteBuffer putShort(int var1, short var2);

    public abstract ShortBuffer asShortBuffer();

    public abstract int getInt();

    public abstract ByteBuffer putInt(int var1);

    public abstract int getInt(int var1);

    public abstract ByteBuffer putInt(int var1, int var2);

    public abstract IntBuffer asIntBuffer();

    public abstract long getLong();

    public abstract ByteBuffer putLong(long var1);

    public abstract long getLong(int var1);

    public abstract ByteBuffer putLong(int var1, long var2);

    public abstract LongBuffer asLongBuffer();

    public abstract float getFloat();

    public abstract ByteBuffer putFloat(float var1);

    public abstract float getFloat(int var1);

    public abstract ByteBuffer putFloat(int var1, float var2);

    public abstract FloatBuffer asFloatBuffer();

    public abstract double getDouble();

    public abstract ByteBuffer putDouble(double var1);

    public abstract double getDouble(int var1);

    public abstract ByteBuffer putDouble(int var1, double var2);

    public abstract DoubleBuffer asDoubleBuffer();
}

