/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.InvalidMarkException;
import jdk.internal.HotSpotIntrinsicCandidate;

public abstract class Buffer {
    static final int SPLITERATOR_CHARACTERISTICS = 16464;
    private int mark = -1;
    private int position = 0;
    private int limit;
    private int capacity;
    long address;

    Buffer(int mark, int pos, int lim, int cap) {
        if (cap < 0) {
            throw Buffer.createCapacityException(cap);
        }
        this.capacity = cap;
        this.limit(lim);
        this.position(pos);
        if (mark >= 0) {
            if (mark > pos) {
                throw new IllegalArgumentException("mark > position: (" + mark + " > " + pos + ")");
            }
            this.mark = mark;
        }
    }

    static IllegalArgumentException createSameBufferException() {
        return new IllegalArgumentException("The source buffer is this buffer");
    }

    static IllegalArgumentException createCapacityException(int capacity) {
        assert (capacity < 0) : "capacity expected to be negative";
        return new IllegalArgumentException("capacity < 0: (" + capacity + " < 0)");
    }

    public final int capacity() {
        return this.capacity;
    }

    public final int position() {
        return this.position;
    }

    public Buffer position(int newPosition) {
        if (newPosition > this.limit | newPosition < 0) {
            throw this.createPositionException(newPosition);
        }
        this.position = newPosition;
        if (this.mark > this.position) {
            this.mark = -1;
        }
        return this;
    }

    private IllegalArgumentException createPositionException(int newPosition) {
        String msg = null;
        if (newPosition > this.limit) {
            msg = "newPosition > limit: (" + newPosition + " > " + this.limit + ")";
        } else {
            assert (newPosition < 0) : "newPosition expected to be negative";
            msg = "newPosition < 0: (" + newPosition + " < 0)";
        }
        return new IllegalArgumentException(msg);
    }

    public final int limit() {
        return this.limit;
    }

    public Buffer limit(int newLimit) {
        if (newLimit > this.capacity | newLimit < 0) {
            throw this.createLimitException(newLimit);
        }
        this.limit = newLimit;
        if (this.position > this.limit) {
            this.position = this.limit;
        }
        if (this.mark > this.limit) {
            this.mark = -1;
        }
        return this;
    }

    private IllegalArgumentException createLimitException(int newLimit) {
        String msg = null;
        if (newLimit > this.capacity) {
            msg = "newLimit > capacity: (" + newLimit + " > " + this.capacity + ")";
        } else {
            assert (newLimit < 0) : "newLimit expected to be negative";
            msg = "newLimit < 0: (" + newLimit + " < 0)";
        }
        return new IllegalArgumentException(msg);
    }

    public Buffer mark() {
        this.mark = this.position;
        return this;
    }

    public Buffer reset() {
        int m = this.mark;
        if (m < 0) {
            throw new InvalidMarkException();
        }
        this.position = m;
        return this;
    }

    public Buffer clear() {
        this.position = 0;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    public Buffer flip() {
        this.limit = this.position;
        this.position = 0;
        this.mark = -1;
        return this;
    }

    public Buffer rewind() {
        this.position = 0;
        this.mark = -1;
        return this;
    }

    public final int remaining() {
        return this.limit - this.position;
    }

    public final boolean hasRemaining() {
        return this.position < this.limit;
    }

    public abstract boolean isReadOnly();

    public abstract boolean hasArray();

    public abstract Object array();

    public abstract int arrayOffset();

    public abstract boolean isDirect();

    public abstract Buffer slice();

    public abstract Buffer duplicate();

    final int nextGetIndex() {
        if (this.position >= this.limit) {
            throw new BufferUnderflowException();
        }
        return this.position++;
    }

    final int nextGetIndex(int nb) {
        if (this.limit - this.position < nb) {
            throw new BufferUnderflowException();
        }
        int p = this.position;
        this.position += nb;
        return p;
    }

    final int nextPutIndex() {
        if (this.position >= this.limit) {
            throw new BufferOverflowException();
        }
        return this.position++;
    }

    final int nextPutIndex(int nb) {
        if (this.limit - this.position < nb) {
            throw new BufferOverflowException();
        }
        int p = this.position;
        this.position += nb;
        return p;
    }

    @HotSpotIntrinsicCandidate
    final int checkIndex(int i) {
        if (i < 0 || i >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return i;
    }

    final int checkIndex(int i, int nb) {
        if (i < 0 || nb > this.limit - i) {
            throw new IndexOutOfBoundsException();
        }
        return i;
    }

    final int markValue() {
        return this.mark;
    }

    final void truncate() {
        this.mark = -1;
        this.position = 0;
        this.limit = 0;
        this.capacity = 0;
    }

    final void discardMark() {
        this.mark = -1;
    }

    static void checkBounds(int off, int len, int size) {
        if ((off | len | off + len | size - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
    }
}

