/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DirectByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import jdk.internal.misc.JavaLangRefAccess;
import jdk.internal.misc.JavaNioAccess;
import jdk.internal.misc.SharedSecrets;
import jdk.internal.misc.Unsafe;
import jdk.internal.misc.VM;

class Bits {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final ByteOrder byteOrder = unsafe.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    private static int pageSize = -1;
    private static boolean unaligned = unsafe.unalignedAccess();
    private static volatile long maxMemory = VM.maxDirectMemory();
    private static final AtomicLong reservedMemory = new AtomicLong();
    private static final AtomicLong totalCapacity = new AtomicLong();
    private static final AtomicLong count = new AtomicLong();
    private static volatile boolean memoryLimitSet;
    private static final int MAX_SLEEPS = 9;
    static final int JNI_COPY_TO_ARRAY_THRESHOLD = 6;
    static final int JNI_COPY_FROM_ARRAY_THRESHOLD = 6;

    private Bits() {
    }

    static short swap(short x) {
        return Short.reverseBytes(x);
    }

    static char swap(char x) {
        return Character.reverseBytes(x);
    }

    static int swap(int x) {
        return Integer.reverseBytes(x);
    }

    static long swap(long x) {
        return Long.reverseBytes(x);
    }

    static Unsafe unsafe() {
        return unsafe;
    }

    static ByteOrder byteOrder() {
        return byteOrder;
    }

    static int pageSize() {
        if (pageSize == -1) {
            pageSize = Bits.unsafe().pageSize();
        }
        return pageSize;
    }

    static int pageCount(long size) {
        return (int)(size + (long)Bits.pageSize() - 1L) / Bits.pageSize();
    }

    static boolean unaligned() {
        return unaligned;
    }

    static void reserveMemory(long size, int cap) {
        if (!memoryLimitSet && VM.initLevel() >= 1) {
            maxMemory = VM.maxDirectMemory();
            memoryLimitSet = true;
        }
        if (Bits.tryReserveMemory(size, cap)) {
            return;
        }
        JavaLangRefAccess jlra = SharedSecrets.getJavaLangRefAccess();
        boolean interrupted = false;
        try {
            boolean refprocActive;
            do {
                try {
                    refprocActive = jlra.waitForReferenceProcessing();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    refprocActive = true;
                }
                if (!Bits.tryReserveMemory(size, cap)) continue;
                return;
            } while (refprocActive);
            System.gc();
            long sleepTime = 1L;
            int sleeps = 0;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static boolean tryReserveMemory(long size, int cap) {
        long totalCap;
        while ((long)cap <= maxMemory - (totalCap = totalCapacity.get())) {
            if (!totalCapacity.compareAndSet(totalCap, totalCap + (long)cap)) continue;
            reservedMemory.addAndGet(size);
            count.incrementAndGet();
            return true;
        }
        return false;
    }

    static void unreserveMemory(long size, int cap) {
        long cnt = count.decrementAndGet();
        long reservedMem = reservedMemory.addAndGet(-size);
        long totalCap = totalCapacity.addAndGet(-cap);
        assert (cnt >= 0L && reservedMem >= 0L && totalCap >= 0L);
    }

    static {
        SharedSecrets.setJavaNioAccess((JavaNioAccess)new JavaNioAccess(){

            public JavaNioAccess.BufferPool getDirectBufferPool() {
                return new JavaNioAccess.BufferPool(){

                    public String getName() {
                        return "direct";
                    }

                    public long getCount() {
                        return count.get();
                    }

                    public long getTotalCapacity() {
                        return totalCapacity.get();
                    }

                    public long getMemoryUsed() {
                        return reservedMemory.get();
                    }
                };
            }

            public ByteBuffer newDirectByteBuffer(long addr, int cap, Object ob) {
                return new DirectByteBuffer(addr, cap, ob);
            }

            public void truncate(Buffer buf) {
                buf.truncate();
            }
        });
    }
}

