/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Module;
import java.lang.reflect.ProxyGenerator;
import java.lang.reflect.ReflectPermission;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.internal.loader.BootLoader;
import jdk.internal.loader.ClassLoaderValue;
import jdk.internal.misc.Unsafe;
import jdk.internal.misc.VM;
import jdk.internal.module.Modules;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;
import sun.security.action.GetPropertyAction;
import sun.security.util.SecurityConstants;

public class Proxy
implements Serializable {
    private static final long serialVersionUID = -2222568056686623797L;
    private static final Class<?>[] constructorParams = new Class[]{InvocationHandler.class};
    private static final ClassLoaderValue<Constructor<?>> proxyCache = new ClassLoaderValue();
    protected InvocationHandler h;
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final String PROXY_PACKAGE_PREFIX = "com.sun.proxy";

    private Proxy() {
    }

    protected Proxy(InvocationHandler h) {
        Objects.requireNonNull(h);
        this.h = h;
    }

    @Deprecated
    @CallerSensitive
    public static Class<?> getProxyClass(ClassLoader loader, Class<?> ... interfaces) throws IllegalArgumentException {
        Class<?> caller = System.getSecurityManager() == null ? null : Reflection.getCallerClass();
        return Proxy.getProxyConstructor(caller, loader, interfaces).getDeclaringClass();
    }

    private static Constructor<?> getProxyConstructor(Class<?> caller, ClassLoader loader, Class<?> ... interfaces) {
        if (interfaces.length == 1) {
            Class<?> intf = interfaces[0];
            if (caller != null) {
                Proxy.checkProxyAccess(caller, loader, intf);
            }
            return proxyCache.sub(intf).computeIfAbsent(loader, (ld, clv) -> new ProxyBuilder((ClassLoader)ld, (Class)clv.key()).build());
        }
        Class[] intfsArray = (Class[])interfaces.clone();
        if (caller != null) {
            Proxy.checkProxyAccess(caller, loader, intfsArray);
        }
        List<Class> intfs = Arrays.asList(intfsArray);
        return proxyCache.sub(intfs).computeIfAbsent(loader, (ld, clv) -> new ProxyBuilder((ClassLoader)ld, (List)clv.key()).build());
    }

    private static void checkProxyAccess(Class<?> caller, ClassLoader loader, Class<?> ... interfaces) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ClassLoader ccl = caller.getClassLoader();
            if (VM.isSystemDomainLoader(loader) && !VM.isSystemDomainLoader(ccl)) {
                sm.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
            }
            ReflectUtil.checkProxyPackageAccess(ccl, interfaces);
        }
    }

    @CallerSensitive
    public static Object newProxyInstance(ClassLoader loader, Class<?>[] interfaces, InvocationHandler h) {
        Objects.requireNonNull(h);
        Class<?> caller = System.getSecurityManager() == null ? null : Reflection.getCallerClass();
        Constructor<?> cons = Proxy.getProxyConstructor(caller, loader, interfaces);
        return Proxy.newProxyInstance(caller, cons, h);
    }

    private static Object newProxyInstance(Class<?> caller, Constructor<?> cons, InvocationHandler h) {
        try {
            if (caller != null) {
                Proxy.checkNewProxyPermission(caller, cons.getDeclaringClass());
            }
            return cons.newInstance(h);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new InternalError(e.toString(), e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new InternalError(t.toString(), t);
        }
    }

    private static void checkNewProxyPermission(Class<?> caller, Class<?> proxyClass) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && ReflectUtil.isNonPublicProxyClass(proxyClass)) {
            String callerPkg;
            ClassLoader ccl = caller.getClassLoader();
            ClassLoader pcl = proxyClass.getClassLoader();
            int n = proxyClass.getName().lastIndexOf(46);
            String pkg = n == -1 ? "" : proxyClass.getName().substring(0, n);
            n = caller.getName().lastIndexOf(46);
            String string = callerPkg = n == -1 ? "" : caller.getName().substring(0, n);
            if (pcl != ccl || !pkg.equals(callerPkg)) {
                sm.checkPermission(new ReflectPermission("newProxyInPackage." + pkg));
            }
        }
    }

    private static ClassLoader getLoader(Module m) {
        PrivilegedAction<ClassLoader> pa = m::getClassLoader;
        return AccessController.doPrivileged(pa);
    }

    public static boolean isProxyClass(Class<?> cl) {
        return Proxy.class.isAssignableFrom(cl) && ProxyBuilder.isProxyClass(cl);
    }

    @CallerSensitive
    public static InvocationHandler getInvocationHandler(Object proxy) throws IllegalArgumentException {
        if (!Proxy.isProxyClass(proxy.getClass())) {
            throw new IllegalArgumentException("not a proxy instance");
        }
        Proxy p = (Proxy)proxy;
        InvocationHandler ih = p.h;
        if (System.getSecurityManager() != null) {
            Class<?> ihClass = ih.getClass();
            Class<?> caller = Reflection.getCallerClass();
            if (ReflectUtil.needsPackageAccessCheck(caller.getClassLoader(), ihClass.getClassLoader())) {
                ReflectUtil.checkPackageAccess(ihClass);
            }
        }
        return ih;
    }

    private static final class ProxyBuilder {
        private static final Unsafe UNSAFE = Unsafe.getUnsafe();
        private static final String proxyClassNamePrefix = "$Proxy";
        private static final AtomicLong nextUniqueNumber = new AtomicLong();
        private static final ClassLoaderValue<Boolean> reverseProxyCache = new ClassLoaderValue();
        private static final String DEBUG = GetPropertyAction.privilegedGetProperty("jdk.proxy.debug", "");
        private final ClassLoader loader;
        private final List<Class<?>> interfaces;
        private final Module module;
        private static final ClassLoaderValue<Module> dynProxyModules = new ClassLoaderValue();
        private static final AtomicInteger counter = new AtomicInteger();

        private static Class<?> defineProxyClass(Module m, List<Class<?>> interfaces) {
            String proxyPkg = null;
            int accessFlags = 17;
            for (Class<?> intf : interfaces) {
                int flags = intf.getModifiers();
                if (Modifier.isPublic(flags)) continue;
                accessFlags = 16;
                String pkg = intf.getPackageName();
                if (proxyPkg == null) {
                    proxyPkg = pkg;
                    continue;
                }
                if (pkg.equals(proxyPkg)) continue;
                throw new IllegalArgumentException("non-public interfaces from different packages");
            }
            if (proxyPkg == null) {
                proxyPkg = m.isNamed() ? "com.sun.proxy." + m.getName() : Proxy.PROXY_PACKAGE_PREFIX;
            } else if (proxyPkg.isEmpty() && m.isNamed()) {
                throw new IllegalArgumentException("Unnamed package cannot be added to " + m);
            }
            if (m.isNamed()) {
                m.addPackage(proxyPkg);
            }
            long num = nextUniqueNumber.getAndIncrement();
            String proxyName = proxyPkg.isEmpty() ? proxyClassNamePrefix + num : proxyPkg + "." + proxyClassNamePrefix + num;
            ClassLoader loader = Proxy.getLoader(m);
            ProxyBuilder.trace(proxyName, m, loader, interfaces);
            byte[] proxyClassFile = ProxyGenerator.generateProxyClass(proxyName, interfaces.toArray(EMPTY_CLASS_ARRAY), accessFlags);
            try {
                Class<?> pc = UNSAFE.defineClass(proxyName, proxyClassFile, 0, proxyClassFile.length, loader, null);
                reverseProxyCache.sub(pc).putIfAbsent(loader, Boolean.TRUE);
                return pc;
            }
            catch (ClassFormatError e) {
                throw new IllegalArgumentException(e.toString());
            }
        }

        static boolean isProxyClass(Class<?> c) {
            return Objects.equals(reverseProxyCache.sub(c).get(c.getClassLoader()), Boolean.TRUE);
        }

        private static boolean isExportedType(Class<?> c) {
            String pn = c.getPackageName();
            return Modifier.isPublic(c.getModifiers()) && c.getModule().isExported(pn);
        }

        private static boolean isPackagePrivateType(Class<?> c) {
            return !Modifier.isPublic(c.getModifiers());
        }

        private static String toDetails(Class<?> c) {
            String access = "unknown";
            access = ProxyBuilder.isExportedType(c) ? "exported" : (ProxyBuilder.isPackagePrivateType(c) ? "package-private" : "module-private");
            ClassLoader ld = c.getClassLoader();
            return String.format("   %s/%s %s loader %s", c.getModule().getName(), c.getName(), access, ld);
        }

        static void trace(String cn, Module module, ClassLoader loader, List<Class<?>> interfaces) {
            if (ProxyBuilder.isDebug()) {
                System.out.format("PROXY: %s/%s defined by %s%n", module.getName(), cn, loader);
            }
            if (ProxyBuilder.isDebug("debug")) {
                interfaces.stream().forEach(c -> System.out.println(ProxyBuilder.toDetails(c)));
            }
        }

        private static boolean isDebug() {
            return !DEBUG.isEmpty();
        }

        private static boolean isDebug(String flag) {
            return DEBUG.equals(flag);
        }

        ProxyBuilder(ClassLoader loader, List<Class<?>> interfaces) {
            if (!VM.isModuleSystemInited()) {
                throw new InternalError("Proxy is not supported until module system is fully initialized");
            }
            if (interfaces.size() > 65535) {
                throw new IllegalArgumentException("interface limit exceeded: " + interfaces.size());
            }
            Set<Class<?>> refTypes = ProxyBuilder.referencedTypes(loader, interfaces);
            ProxyBuilder.validateProxyInterfaces(loader, interfaces, refTypes);
            this.loader = loader;
            this.interfaces = interfaces;
            this.module = ProxyBuilder.mapToModule(loader, interfaces, refTypes);
            assert (Proxy.getLoader(this.module) == loader);
        }

        ProxyBuilder(ClassLoader loader, Class<?> intf) {
            this(loader, Collections.singletonList(intf));
        }

        Constructor<?> build() {
            Constructor<?> cons;
            Class<?> proxyClass = ProxyBuilder.defineProxyClass(this.module, this.interfaces);
            try {
                cons = proxyClass.getConstructor(constructorParams);
            }
            catch (NoSuchMethodException e) {
                throw new InternalError(e.toString(), e);
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    cons.setAccessible(true);
                    return null;
                }
            });
            return cons;
        }

        private static void validateProxyInterfaces(ClassLoader loader, List<Class<?>> interfaces, Set<Class<?>> refTypes) {
            IdentityHashMap interfaceSet = new IdentityHashMap(interfaces.size());
            for (Class<?> intf : interfaces) {
                ProxyBuilder.ensureVisible(loader, intf);
                if (!intf.isInterface()) {
                    throw new IllegalArgumentException(intf.getName() + " is not an interface");
                }
                if (interfaceSet.put(intf, Boolean.TRUE) == null) continue;
                throw new IllegalArgumentException("repeated interface: " + intf.getName());
            }
            for (Class<?> type : refTypes) {
                ProxyBuilder.ensureVisible(loader, type);
            }
        }

        private static Set<Class<?>> referencedTypes(ClassLoader loader, List<Class<?>> interfaces) {
            return interfaces.stream().flatMap(intf -> Stream.of(intf.getMethods()).filter(m -> !Modifier.isStatic(m.getModifiers())).flatMap(ProxyBuilder::methodRefTypes).map(ProxyBuilder::getElementType).filter(t -> !t.isPrimitive())).collect(Collectors.toSet());
        }

        private static Stream<Class<?>> methodRefTypes(Method m) {
            return Stream.of({m.getReturnType()}, m.getParameterTypes(), m.getExceptionTypes()).flatMap(Stream::of);
        }

        private static Module mapToModule(ClassLoader loader, List<Class<?>> interfaces, Set<Class<?>> refTypes) {
            Module target;
            HashMap modulePrivateTypes = new HashMap();
            HashMap packagePrivateTypes = new HashMap();
            for (Class<?> clazz : interfaces) {
                Module m = clazz.getModule();
                if (Modifier.isPublic(clazz.getModifiers())) {
                    if (m.isExported(clazz.getPackageName())) continue;
                    modulePrivateTypes.put(clazz, m);
                    continue;
                }
                packagePrivateTypes.put(clazz, m);
            }
            if (packagePrivateTypes.isEmpty() && modulePrivateTypes.isEmpty()) {
                return loader != null ? loader.getUnnamedModule() : BootLoader.getUnnamedModule();
            }
            if (packagePrivateTypes.size() > 0) {
                if (packagePrivateTypes.size() > 1 && (packagePrivateTypes.keySet().stream().map(Class::getPackageName).distinct().count() > 1L || packagePrivateTypes.values().stream().distinct().count() > 1L)) {
                    throw new IllegalArgumentException("non-public interfaces from different packages");
                }
                target = null;
                for (Module m : packagePrivateTypes.values()) {
                    if (Proxy.getLoader(m) != loader) {
                        throw new IllegalArgumentException("non-public interface is not defined by the given loader");
                    }
                    target = m;
                }
                for (Class<?> intf : interfaces) {
                    Module module = intf.getModule();
                    if (module == target || target.canRead(module) && module.isExported(intf.getPackageName(), target)) continue;
                    throw new IllegalArgumentException(target + " can't access " + intf.getName());
                }
                return target;
            }
            target = ProxyBuilder.getDynamicModule(loader);
            HashSet hashSet = new HashSet(interfaces);
            hashSet.addAll(refTypes);
            for (Class clazz : hashSet) {
                ProxyBuilder.ensureAccess(target, clazz);
            }
            return target;
        }

        private static void ensureAccess(Module target, Class<?> c) {
            String pn;
            Module m = c.getModule();
            if (!target.canRead(m)) {
                Modules.addReads((Module)target, (Module)m);
            }
            if (!m.isExported(pn = c.getPackageName(), target)) {
                Modules.addExports((Module)m, (String)pn, (Module)target);
            }
        }

        private static void ensureVisible(ClassLoader ld, Class<?> c) {
            Class<?> type = null;
            try {
                type = Class.forName(c.getName(), false, ld);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (type != c) {
                throw new IllegalArgumentException(c.getName() + " referenced from a method is not visible from class loader");
            }
        }

        private static Class<?> getElementType(Class<?> type) {
            Class<?> e = type;
            while (e.isArray()) {
                e = e.getComponentType();
            }
            return e;
        }

        private static Module getDynamicModule(ClassLoader loader) {
            return dynProxyModules.computeIfAbsent(loader, (ld, clv) -> {
                String mn = "jdk.proxy" + counter.incrementAndGet();
                String pn = "com.sun.proxy." + mn;
                Module m = Modules.defineModule((ClassLoader)ld, (String)mn, Collections.singleton(pn));
                Modules.addReads((Module)m, (Module)Proxy.class.getModule());
                Modules.addExports((Module)m, (String)pn, (Module)Object.class.getModule());
                return m;
            });
        }
    }
}

