/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import sun.reflect.annotation.AnnotationSupport;

public final class Parameter
implements AnnotatedElement {
    private final String name;
    private final int modifiers;
    private final Executable executable;
    private final int index;
    private volatile transient Type parameterTypeCache;
    private volatile transient Class<?> parameterClassCache;
    private transient Map<Class<? extends Annotation>, Annotation> declaredAnnotations;

    Parameter(String name, int modifiers, Executable executable, int index) {
        this.name = name;
        this.modifiers = modifiers;
        this.executable = executable;
        this.index = index;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Parameter) {
            Parameter other = (Parameter)obj;
            return other.executable.equals(this.executable) && other.index == this.index;
        }
        return false;
    }

    public int hashCode() {
        return this.executable.hashCode() ^ this.index;
    }

    public boolean isNamePresent() {
        return this.executable.hasRealParameterData() && this.name != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Type type = this.getParameterizedType();
        String typename = type.getTypeName();
        sb.append(Modifier.toString(this.getModifiers()));
        if (0 != this.modifiers) {
            sb.append(' ');
        }
        if (this.isVarArgs()) {
            sb.append(typename.replaceFirst("\\[\\]$", "..."));
        } else {
            sb.append(typename);
        }
        sb.append(' ');
        sb.append(this.getName());
        return sb.toString();
    }

    public Executable getDeclaringExecutable() {
        return this.executable;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        if (this.name == null || this.name.equals("")) {
            return "arg" + this.index;
        }
        return this.name;
    }

    String getRealName() {
        return this.name;
    }

    public Type getParameterizedType() {
        Type tmp = this.parameterTypeCache;
        if (null == tmp) {
            this.parameterTypeCache = tmp = this.executable.getAllGenericParameterTypes()[this.index];
        }
        return tmp;
    }

    public Class<?> getType() {
        Class<?> tmp = this.parameterClassCache;
        if (null == tmp) {
            this.parameterClassCache = tmp = this.executable.getParameterTypes()[this.index];
        }
        return tmp;
    }

    public AnnotatedType getAnnotatedType() {
        return this.executable.getAnnotatedParameterTypes()[this.index];
    }

    public boolean isImplicit() {
        return Modifier.isMandated(this.getModifiers());
    }

    public boolean isSynthetic() {
        return Modifier.isSynthetic(this.getModifiers());
    }

    public boolean isVarArgs() {
        return this.executable.isVarArgs() && this.index == this.executable.getParameterCount() - 1;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        Objects.requireNonNull(annotationClass);
        return (T)((Annotation)annotationClass.cast(this.declaredAnnotations().get(annotationClass)));
    }

    @Override
    public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        Objects.requireNonNull(annotationClass);
        return AnnotationSupport.getDirectlyAndIndirectlyPresent(this.declaredAnnotations(), annotationClass);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.executable.getParameterAnnotations()[this.index];
    }

    @Override
    public <T extends Annotation> T getDeclaredAnnotation(Class<T> annotationClass) {
        return this.getAnnotation(annotationClass);
    }

    @Override
    public <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> annotationClass) {
        return this.getAnnotationsByType(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    private synchronized Map<Class<? extends Annotation>, Annotation> declaredAnnotations() {
        if (null == this.declaredAnnotations) {
            this.declaredAnnotations = new HashMap<Class<? extends Annotation>, Annotation>();
            for (Annotation a : this.getDeclaredAnnotations()) {
                this.declaredAnnotations.put(a.annotationType(), a);
            }
        }
        return this.declaredAnnotations;
    }
}

