/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Layer;
import java.lang.reflect.WeakPairMap;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import jdk.internal.loader.BootLoader;
import jdk.internal.loader.BuiltinClassLoader;
import jdk.internal.loader.ResourceHelper;
import jdk.internal.misc.JavaLangAccess;
import jdk.internal.misc.JavaLangReflectModuleAccess;
import jdk.internal.misc.SharedSecrets;
import jdk.internal.module.ServicesCatalog;
import jdk.internal.org.objectweb.asm.AnnotationVisitor;
import jdk.internal.org.objectweb.asm.Attribute;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.ClassVisitor;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;
import sun.security.util.SecurityConstants;

public final class Module
implements AnnotatedElement {
    private final Layer layer;
    private final String name;
    private final ClassLoader loader;
    private final ModuleDescriptor descriptor;
    private static final Module ALL_UNNAMED_MODULE = new Module(null);
    private static final Module EVERYONE_MODULE = new Module(null);
    private static final Set<Module> EVERYONE_SET = Set.of(EVERYONE_MODULE);
    private volatile Set<Module> reads;
    private static final WeakPairMap<Module, Module, Boolean> reflectivelyReads = new WeakPairMap();
    private volatile Map<String, Set<Module>> openPackages;
    private volatile Map<String, Set<Module>> exportedPackages;
    private static final WeakPairMap<Module, Module, Map<String, Boolean>> reflectivelyExports = new WeakPairMap();
    private static final WeakPairMap<Module, Class<?>, Boolean> reflectivelyUses = new WeakPairMap();
    private volatile Set<String> extraPackages;
    private volatile Class<?> moduleInfoClass;

    private Module(Layer layer, ClassLoader loader, ModuleDescriptor descriptor, URI uri) {
        this.layer = layer;
        this.name = descriptor.name();
        this.loader = loader;
        this.descriptor = descriptor;
        boolean isOpen = descriptor.isOpen();
        ModuleDescriptor.Version version = descriptor.version().orElse(null);
        String vs = Objects.toString(version, null);
        String loc = Objects.toString(uri, null);
        Set<String> packages = descriptor.packages();
        int n = packages.size();
        String[] array = new String[n];
        int i = 0;
        for (String pn : packages) {
            array[i++] = pn.replace('.', '/');
        }
        Module.defineModule0(this, isOpen, vs, loc, array);
    }

    private Module(ClassLoader loader) {
        this.layer = null;
        this.name = null;
        this.loader = loader;
        this.descriptor = null;
    }

    Module(ClassLoader loader, ModuleDescriptor descriptor) {
        this.layer = null;
        this.name = descriptor.name();
        this.loader = loader;
        this.descriptor = descriptor;
    }

    public boolean isNamed() {
        return this.name != null;
    }

    public String getName() {
        return this.name;
    }

    public ClassLoader getClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return this.loader;
    }

    public ModuleDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Layer getLayer() {
        if (this.isNamed()) {
            Layer layer = this.layer;
            if (layer != null) {
                return layer;
            }
            if (this.loader == null && this.name.equals("java.base")) {
                return SharedSecrets.getJavaLangAccess().getBootLayer();
            }
        }
        return null;
    }

    public boolean canRead(Module other) {
        Set<Module> reads;
        Objects.requireNonNull(other);
        if (!this.isNamed()) {
            return true;
        }
        if (other == this) {
            return true;
        }
        if (other.isNamed() && (reads = this.reads) != null && reads.contains(other)) {
            return true;
        }
        if (reflectivelyReads.containsKeyPair(this, other)) {
            return true;
        }
        return !other.isNamed() && reflectivelyReads.containsKeyPair(this, ALL_UNNAMED_MODULE);
    }

    @CallerSensitive
    public Module addReads(Module other) {
        Objects.requireNonNull(other);
        if (this.isNamed()) {
            Module caller = Reflection.getCallerClass().getModule();
            if (caller != this) {
                throw new IllegalStateException(caller + " != " + this);
            }
            this.implAddReads(other, true);
        }
        return this;
    }

    void implAddReads(Module other) {
        this.implAddReads(other, true);
    }

    void implAddReadsNoSync(Module other) {
        this.implAddReads(other, false);
    }

    private void implAddReads(Module other, boolean syncVM) {
        Objects.requireNonNull(other);
        if (other == this || !this.isNamed()) {
            return;
        }
        Set<Module> reads = this.reads;
        if (reads != null && reads.contains(other)) {
            return;
        }
        if (syncVM) {
            if (other == ALL_UNNAMED_MODULE) {
                Module.addReads0(this, null);
            } else {
                Module.addReads0(this, other);
            }
        }
        reflectivelyReads.putIfAbsent(this, other, Boolean.TRUE);
    }

    public boolean isExported(String pn, Module other) {
        Objects.requireNonNull(pn);
        Objects.requireNonNull(other);
        return this.implIsExportedOrOpen(pn, other, false);
    }

    public boolean isOpen(String pn, Module other) {
        Objects.requireNonNull(pn);
        Objects.requireNonNull(other);
        return this.implIsExportedOrOpen(pn, other, true);
    }

    public boolean isExported(String pn) {
        Objects.requireNonNull(pn);
        return this.implIsExportedOrOpen(pn, EVERYONE_MODULE, false);
    }

    public boolean isOpen(String pn) {
        Objects.requireNonNull(pn);
        return this.implIsExportedOrOpen(pn, EVERYONE_MODULE, true);
    }

    private boolean implIsExportedOrOpen(String pn, Module other, boolean open) {
        if (!this.isNamed()) {
            return true;
        }
        if (other == this && this.containsPackage(pn)) {
            return true;
        }
        if (this.descriptor.isOpen()) {
            return this.containsPackage(pn);
        }
        if (this.isStaticallyExportedOrOpen(pn, other, open)) {
            return true;
        }
        return this.isReflectivelyExportedOrOpen(pn, other, open);
    }

    boolean isStaticallyExportedOrOpen(String pn, Module other, boolean open) {
        Set<Module> targets;
        Map<String, Set<Module>> exportedPackages;
        Set<Module> targets2;
        Map<String, Set<Module>> openPackages = this.openPackages;
        if (openPackages != null && (targets2 = openPackages.get(pn)) != null) {
            if (targets2.contains(EVERYONE_MODULE)) {
                return true;
            }
            if (other != EVERYONE_MODULE && targets2.contains(other)) {
                return true;
            }
        }
        if (!open && (exportedPackages = this.exportedPackages) != null && (targets = exportedPackages.get(pn)) != null) {
            if (targets.contains(EVERYONE_MODULE)) {
                return true;
            }
            if (other != EVERYONE_MODULE && targets.contains(other)) {
                return true;
            }
        }
        return false;
    }

    private boolean isReflectivelyExportedOrOpen(String pn, Module other, boolean open) {
        boolean isOpen;
        Boolean b;
        Map<String, Boolean> exports = reflectivelyExports.get(this, EVERYONE_MODULE);
        if (exports != null && (b = exports.get(pn)) != null) {
            isOpen = b;
            if (!open || isOpen) {
                return true;
            }
        }
        if (other != EVERYONE_MODULE) {
            exports = reflectivelyExports.get(this, other);
            if (exports != null && (b = exports.get(pn)) != null) {
                isOpen = b;
                if (!open || isOpen) {
                    return true;
                }
            }
            if (!other.isNamed() && (exports = reflectivelyExports.get(this, ALL_UNNAMED_MODULE)) != null && (b = exports.get(pn)) != null) {
                isOpen = b;
                if (!open || isOpen) {
                    return true;
                }
            }
        }
        return false;
    }

    @CallerSensitive
    public Module addExports(String pn, Module other) {
        if (pn == null) {
            throw new IllegalArgumentException("package is null");
        }
        Objects.requireNonNull(other);
        if (this.isNamed() && !this.descriptor.isOpen()) {
            Module caller = Reflection.getCallerClass().getModule();
            if (caller != this) {
                throw new IllegalStateException(caller + " != " + this);
            }
            this.implAddExportsOrOpens(pn, other, false, true);
        }
        return this;
    }

    @CallerSensitive
    public Module addOpens(String pn, Module other) {
        if (pn == null) {
            throw new IllegalArgumentException("package is null");
        }
        Objects.requireNonNull(other);
        if (this.isNamed() && !this.descriptor.isOpen()) {
            Module caller = Reflection.getCallerClass().getModule();
            if (caller != this && !this.isOpen(pn, caller)) {
                throw new IllegalStateException(pn + " is not open to " + caller);
            }
            this.implAddExportsOrOpens(pn, other, true, true);
        }
        return this;
    }

    void implAddExportsNoSync(String pn, Module other) {
        if (other == null) {
            other = EVERYONE_MODULE;
        }
        this.implAddExportsOrOpens(pn.replace('/', '.'), other, false, false);
    }

    void implAddExports(String pn, Module other) {
        this.implAddExportsOrOpens(pn, other, false, true);
    }

    void implAddOpens(String pn, Module other) {
        this.implAddExportsOrOpens(pn, other, true, true);
    }

    private void implAddExportsOrOpens(String pn, Module other, boolean open, boolean syncVM) {
        Objects.requireNonNull(other);
        Objects.requireNonNull(pn);
        if (!this.isNamed() || this.descriptor.isOpen()) {
            return;
        }
        if (this.implIsExportedOrOpen(pn, other, open)) {
            return;
        }
        if (!this.containsPackage(pn)) {
            throw new IllegalArgumentException("package " + pn + " not in contents");
        }
        if (syncVM) {
            String pkgInternalForm = pn.replace('.', '/');
            if (other == EVERYONE_MODULE) {
                Module.addExportsToAll0(this, pkgInternalForm);
            } else if (other == ALL_UNNAMED_MODULE) {
                Module.addExportsToAllUnnamed0(this, pkgInternalForm);
            } else {
                Module.addExports0(this, pkgInternalForm, other);
            }
        }
        Map map = reflectivelyExports.computeIfAbsent(this, other, (m1, m2) -> new ConcurrentHashMap());
        if (open) {
            map.put(pn, Boolean.TRUE);
        } else {
            map.putIfAbsent(pn, Boolean.FALSE);
        }
    }

    @CallerSensitive
    public Module addUses(Class<?> service) {
        Objects.requireNonNull(service);
        if (this.isNamed() && !this.descriptor.isAutomatic()) {
            Module caller = Reflection.getCallerClass().getModule();
            if (caller != this) {
                throw new IllegalStateException(caller + " != " + this);
            }
            this.implAddUses(service);
        }
        return this;
    }

    void implAddUses(Class<?> service) {
        if (!this.canUse(service)) {
            reflectivelyUses.putIfAbsent(this, service, Boolean.TRUE);
        }
    }

    public boolean canUse(Class<?> service) {
        Objects.requireNonNull(service);
        if (!this.isNamed()) {
            return true;
        }
        if (this.descriptor.isAutomatic()) {
            return true;
        }
        if (this.descriptor.uses().contains(service.getName())) {
            return true;
        }
        return reflectivelyUses.containsKeyPair(this, service);
    }

    private boolean containsPackage(String pn) {
        if (this.descriptor.packages().contains(pn)) {
            return true;
        }
        Set<String> extraPackages = this.extraPackages;
        return extraPackages != null && extraPackages.contains(pn);
    }

    public String[] getPackages() {
        if (this.isNamed()) {
            Set<String> packages = this.descriptor.packages();
            Set<String> extraPackages = this.extraPackages;
            if (extraPackages == null) {
                return packages.toArray(new String[0]);
            }
            return (String[])Stream.concat(packages.stream(), extraPackages.stream()).toArray(String[]::new);
        }
        Stream packages = this.loader == null ? BootLoader.packages() : SharedSecrets.getJavaLangAccess().packages(this.loader);
        return (String[])packages.map(Package::getName).toArray(String[]::new);
    }

    void addPackage(String pn) {
        this.implAddPackage(pn, true);
    }

    void implAddPackageNoSync(String pn) {
        this.implAddPackage(pn.replace('/', '.'), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void implAddPackage(String pn, boolean syncVM) {
        if (!this.isNamed()) {
            throw new InternalError("adding package to unnamed module?");
        }
        if (this.descriptor.isOpen()) {
            throw new InternalError("adding package to open module?");
        }
        if (pn.isEmpty()) {
            throw new InternalError("adding <unnamed> package to module?");
        }
        if (this.descriptor.packages().contains(pn)) {
            return;
        }
        Set<String> extraPackages = this.extraPackages;
        if (extraPackages != null && extraPackages.contains(pn)) {
            return;
        }
        Module module = this;
        synchronized (module) {
            extraPackages = this.extraPackages;
            if (extraPackages != null) {
                if (extraPackages.contains(pn)) {
                    return;
                }
                extraPackages = new HashSet<String>(extraPackages);
                extraPackages.add(pn);
            } else {
                extraPackages = Collections.singleton(pn);
            }
            if (syncVM) {
                Module.addPackage0(this, pn.replace('.', '/'));
            }
            this.extraPackages = extraPackages;
        }
    }

    static Map<String, Module> defineModules(Configuration cf, Function<String, ClassLoader> clf, Layer layer) {
        Module m;
        ClassLoader loader;
        String name;
        ModuleDescriptor descriptor;
        ModuleReference mref;
        HashMap<String, Module> nameToModule = new HashMap<String, Module>();
        HashMap<String, ClassLoader> moduleToLoader = new HashMap<String, ClassLoader>();
        boolean isBootLayer = Layer.boot() == null;
        HashSet<ClassLoader> loaders = new HashSet<ClassLoader>();
        for (ResolvedModule resolvedModule : cf.modules()) {
            String name2 = resolvedModule.name();
            ClassLoader loader2 = clf.apply(name2);
            if (loader2 != null) {
                moduleToLoader.put(name2, loader2);
                loaders.add(loader2);
                continue;
            }
            if (isBootLayer) continue;
            throw new IllegalArgumentException("loader can't be 'null'");
        }
        for (ResolvedModule resolvedModule : cf.modules()) {
            mref = resolvedModule.reference();
            descriptor = mref.descriptor();
            name = descriptor.name();
            URI uri = mref.location().orElse(null);
            loader = (ClassLoader)moduleToLoader.get(resolvedModule.name());
            Module m2 = loader == null && isBootLayer && name.equals("java.base") ? Object.class.getModule() : new Module(layer, loader, descriptor, uri);
            nameToModule.put(name, m2);
            moduleToLoader.put(name, loader);
        }
        for (ResolvedModule resolvedModule : cf.modules()) {
            mref = resolvedModule.reference();
            descriptor = mref.descriptor();
            String mn = descriptor.name();
            m = (Module)nameToModule.get(mn);
            assert (m != null);
            HashSet<Module> reads = new HashSet<Module>();
            for (ResolvedModule other : resolvedModule.reads()) {
                Module m2 = null;
                if (other.configuration() == cf) {
                    String dn = other.reference().descriptor().name();
                    m2 = (Module)nameToModule.get(dn);
                } else {
                    Layer parent;
                    Iterator<Layer> iterator = layer.parents().iterator();
                    while (iterator.hasNext() && (m2 = Module.findModule(parent = iterator.next(), other)) == null) {
                    }
                }
                assert (m2 != null);
                reads.add(m2);
                Module.addReads0(m, m2);
            }
            m.reads = reads;
            if (descriptor.isAutomatic()) {
                m.implAddReads(ALL_UNNAMED_MODULE, true);
            }
            Module.initExportsAndOpens(descriptor, nameToModule, m);
        }
        if (isBootLayer) {
            for (ResolvedModule resolvedModule : cf.modules()) {
                mref = resolvedModule.reference();
                descriptor = mref.descriptor();
                if (descriptor.provides().isEmpty()) continue;
                name = descriptor.name();
                m = (Module)nameToModule.get(name);
                loader = (ClassLoader)moduleToLoader.get(name);
                ServicesCatalog catalog = loader == null ? BootLoader.getServicesCatalog() : ServicesCatalog.getServicesCatalog(loader);
                catalog.register(m);
            }
        }
        for (ClassLoader loader3 : loaders) {
            layer.bindToLoader(loader3);
        }
        return nameToModule;
    }

    private static Module findModule(Layer parent, ResolvedModule resolvedModule) {
        Configuration cf = resolvedModule.configuration();
        String dn = resolvedModule.name();
        return parent.layers().filter(l -> l.configuration() == cf).findAny().map(layer -> {
            Optional<Module> om = layer.findModule(dn);
            assert (om.isPresent()) : dn + " not found in layer";
            Module m = om.get();
            assert (m.getLayer() == layer) : m + " not in expected layer";
            return m;
        }).orElse(null);
    }

    private static void initExportsAndOpens(ModuleDescriptor descriptor, Map<String, Module> nameToModule, Module m) {
        String sourceInternalForm;
        String source;
        if (descriptor.isOpen()) {
            assert (descriptor.opens().isEmpty());
            for (String source2 : descriptor.packages()) {
                String sourceInternalForm2 = source2.replace('.', '/');
                Module.addExportsToAll0(m, sourceInternalForm2);
            }
            return;
        }
        HashMap<String, Set<Module>> openPackages = new HashMap<String, Set<Module>>();
        HashMap<String, Set<Module>> exportedPackages = new HashMap<String, Set<Module>>();
        for (ModuleDescriptor.Opens opens : descriptor.opens()) {
            source = opens.source();
            sourceInternalForm = source.replace('.', '/');
            if (opens.isQualified()) {
                HashSet<Module> targets = new HashSet<Module>();
                for (String target : opens.targets()) {
                    Module m2 = nameToModule.get(target);
                    if (m2 == null) continue;
                    Module.addExports0(m, sourceInternalForm, m2);
                    targets.add(m2);
                }
                if (targets.isEmpty()) continue;
                openPackages.put(source, targets);
                continue;
            }
            Module.addExportsToAll0(m, sourceInternalForm);
            openPackages.put(source, EVERYONE_SET);
        }
        for (ModuleDescriptor.Exports exports : descriptor.exports()) {
            source = exports.source();
            sourceInternalForm = source.replace('.', '/');
            Set openToTargets = (Set)openPackages.get(source);
            if (openToTargets != null && openToTargets.contains(EVERYONE_MODULE)) continue;
            if (exports.isQualified()) {
                HashSet<Module> targets = new HashSet<Module>();
                for (String target : exports.targets()) {
                    Module m2 = nameToModule.get(target);
                    if (m2 == null || openToTargets != null && openToTargets.contains(m2)) continue;
                    Module.addExports0(m, sourceInternalForm, m2);
                    targets.add(m2);
                }
                if (targets.isEmpty()) continue;
                exportedPackages.put(source, targets);
                continue;
            }
            Module.addExportsToAll0(m, sourceInternalForm);
            exportedPackages.put(source, EVERYONE_SET);
        }
        if (!openPackages.isEmpty()) {
            m.openPackages = openPackages;
        }
        if (!exportedPackages.isEmpty()) {
            m.exportedPackages = exportedPackages;
        }
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.moduleInfoClass().getDeclaredAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.moduleInfoClass().getAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.moduleInfoClass().getDeclaredAnnotations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> moduleInfoClass() {
        Class<?> clazz = this.moduleInfoClass;
        if (clazz != null) {
            return clazz;
        }
        Module module = this;
        synchronized (module) {
            clazz = this.moduleInfoClass;
            if (clazz == null) {
                if (this.isNamed()) {
                    PrivilegedAction<Class> pa = this::loadModuleInfoClass;
                    clazz = AccessController.doPrivileged(pa);
                }
                if (clazz == null) {
                    class DummyModuleInfo {
                        DummyModuleInfo() {
                        }
                    }
                    clazz = DummyModuleInfo.class;
                }
                this.moduleInfoClass = clazz;
            }
            return clazz;
        }
    }

    private Class<?> loadModuleInfoClass() {
        Class<?> clazz = null;
        try (InputStream in = this.getResourceAsStream("module-info.class");){
            if (in != null) {
                clazz = this.loadModuleInfoClass(in);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clazz;
    }

    private Class<?> loadModuleInfoClass(InputStream in) throws IOException {
        String MODULE_INFO = "module-info";
        final ClassWriter cw = new ClassWriter(3);
        ClassVisitor cv = new ClassVisitor(327680, cw){

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                cw.visit(version, 5632, "module-info", null, "java/lang/Object", null);
            }

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                return super.visitAnnotation(desc, visible);
            }

            @Override
            public void visitAttribute(Attribute attr) {
            }
        };
        ClassReader cr = new ClassReader(in);
        cr.accept(cv, 0);
        final byte[] bytes = cw.toByteArray();
        ClassLoader cl = new ClassLoader(this.loader){

            @Override
            protected Class<?> findClass(String cn) throws ClassNotFoundException {
                if (cn.equals("module-info")) {
                    return super.defineClass(cn, bytes, 0, bytes.length);
                }
                throw new ClassNotFoundException(cn);
            }
        };
        try {
            return cl.loadClass("module-info");
        }
        catch (ClassNotFoundException e) {
            throw new InternalError(e);
        }
    }

    @CallerSensitive
    public InputStream getResourceAsStream(String name) throws IOException {
        String pn;
        Set<String> packages;
        Module caller;
        Objects.requireNonNull(name);
        if (this.isNamed() && !ResourceHelper.isSimpleResource((String)name) && (caller = Reflection.getCallerClass().getModule()) != this && caller != Object.class.getModule() && (packages = this.getDescriptor().packages()).contains(pn = ResourceHelper.getPackageName((String)name)) && !this.isOpen(pn, caller)) {
            return null;
        }
        String mn = this.name;
        if (this.loader == null) {
            return BootLoader.findResourceAsStream(mn, name);
        }
        if (this.loader instanceof BuiltinClassLoader) {
            return ((BuiltinClassLoader)this.loader).findResourceAsStream(mn, name);
        }
        JavaLangAccess jla = SharedSecrets.getJavaLangAccess();
        URL url = jla.findResource(this.loader, mn, name);
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return null;
    }

    public String toString() {
        if (this.isNamed()) {
            return "module " + this.name;
        }
        String id = Integer.toHexString(System.identityHashCode(this));
        return "unnamed module @" + id;
    }

    private static native void defineModule0(Module var0, boolean var1, String var2, String var3, String[] var4);

    private static native void addReads0(Module var0, Module var1);

    private static native void addExports0(Module var0, String var1, Module var2);

    private static native void addExportsToAll0(Module var0, String var1);

    private static native void addExportsToAllUnnamed0(Module var0, String var1);

    private static native void addPackage0(Module var0, String var1);

    static {
        SharedSecrets.setJavaLangReflectModuleAccess((JavaLangReflectModuleAccess)new JavaLangReflectModuleAccess(){

            public Module defineUnnamedModule(ClassLoader loader) {
                return new Module(loader);
            }

            public Module defineModule(ClassLoader loader, ModuleDescriptor descriptor, URI uri) {
                return new Module(null, loader, descriptor, uri);
            }

            public void addReads(Module m1, Module m2) {
                m1.implAddReads(m2, true);
            }

            public void addReadsAllUnnamed(Module m) {
                m.implAddReads(ALL_UNNAMED_MODULE);
            }

            public void addExports(Module m, String pn, Module other) {
                m.implAddExportsOrOpens(pn, other, false, true);
            }

            public void addOpens(Module m, String pn, Module other) {
                m.implAddExportsOrOpens(pn, other, true, true);
            }

            public void addExportsToAll(Module m, String pn) {
                m.implAddExportsOrOpens(pn, EVERYONE_MODULE, false, true);
            }

            public void addOpensToAll(Module m, String pn) {
                m.implAddExportsOrOpens(pn, EVERYONE_MODULE, true, true);
            }

            public void addExportsToAllUnnamed(Module m, String pn) {
                m.implAddExportsOrOpens(pn, ALL_UNNAMED_MODULE, false, true);
            }

            public void addOpensToAllUnnamed(Module m, String pn) {
                m.implAddExportsOrOpens(pn, ALL_UNNAMED_MODULE, true, true);
            }

            public void addUses(Module m, Class<?> service) {
                m.implAddUses(service);
            }

            public void addPackage(Module m, String pn) {
                m.implAddPackage(pn, true);
            }

            public ServicesCatalog getServicesCatalog(Layer layer) {
                return layer.getServicesCatalog();
            }

            public Stream<Layer> layers(Layer layer) {
                return layer.layers();
            }

            public Stream<Layer> layers(ClassLoader loader) {
                return Layer.layers(loader);
            }

            public boolean isStaticallyExported(Module module, String pn, Module other) {
                return module.isStaticallyExportedOrOpen(pn, other, false);
            }
        });
    }
}

