/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.invoke.LambdaMetafactory;
import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ResolvedModule;
import java.lang.reflect.LayerInstantiationException;
import java.lang.reflect.Module;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.internal.loader.ClassLoaderValue;
import jdk.internal.loader.Loader;
import jdk.internal.loader.LoaderPool;
import jdk.internal.misc.SharedSecrets;
import jdk.internal.module.Modules;
import jdk.internal.module.ServicesCatalog;
import sun.security.util.SecurityConstants;

public final class Layer {
    private static final Layer EMPTY_LAYER = new Layer(Configuration.empty(), List.of(), null);
    private final Configuration cf;
    private final List<Layer> parents;
    private final Map<String, Module> nameToModule;
    private volatile List<Layer> allLayers;
    private volatile ServicesCatalog servicesCatalog;
    private static final ClassLoaderValue<List<Layer>> CLV = new ClassLoaderValue();

    private Layer(Configuration cf, List<Layer> parents, Function<String, ClassLoader> clf) {
        this.cf = cf;
        this.parents = parents;
        Map<Object, Object> map = parents.isEmpty() ? Collections.emptyMap() : Module.defineModules(cf, clf, this);
        this.nameToModule = map;
    }

    public Layer defineModulesWithOneLoader(Configuration cf, ClassLoader parentLoader) {
        return Layer.defineModulesWithOneLoader(cf, List.of(this), parentLoader).layer();
    }

    public Layer defineModulesWithManyLoaders(Configuration cf, ClassLoader parentLoader) {
        return Layer.defineModulesWithManyLoaders(cf, List.of(this), parentLoader).layer();
    }

    public Layer defineModules(Configuration cf, Function<String, ClassLoader> clf) {
        return Layer.defineModules(cf, List.of(this), clf).layer();
    }

    public static Controller defineModulesWithOneLoader(Configuration cf, List<Layer> parentLayers, ClassLoader parentLoader) {
        ArrayList<Layer> parents = new ArrayList<Layer>(parentLayers);
        Layer.checkConfiguration(cf, parents);
        Layer.checkCreateClassLoaderPermission();
        Layer.checkGetClassLoaderPermission();
        try {
            Loader loader = new Loader(cf.modules(), parentLoader);
            loader.initRemotePackageMap(cf, parents);
            Layer layer = new Layer(cf, parents, mn -> loader);
            return new Controller(layer);
        }
        catch (IllegalArgumentException e) {
            throw new LayerInstantiationException(e.getMessage());
        }
    }

    public static Controller defineModulesWithManyLoaders(Configuration cf, List<Layer> parentLayers, ClassLoader parentLoader) {
        ArrayList<Layer> parents = new ArrayList<Layer>(parentLayers);
        Layer.checkConfiguration(cf, parents);
        Layer.checkCreateClassLoaderPermission();
        Layer.checkGetClassLoaderPermission();
        LoaderPool pool = new LoaderPool(cf, parents, parentLoader);
        try {
            Layer layer = new Layer(cf, parents, pool::loaderFor);
            return new Controller(layer);
        }
        catch (IllegalArgumentException e) {
            throw new LayerInstantiationException(e.getMessage());
        }
    }

    public static Controller defineModules(Configuration cf, List<Layer> parentLayers, Function<String, ClassLoader> clf) {
        ArrayList<Layer> parents = new ArrayList<Layer>(parentLayers);
        Layer.checkConfiguration(cf, parents);
        Objects.requireNonNull(clf);
        Layer.checkGetClassLoaderPermission();
        if (Layer.boot() != null) {
            Layer.checkForDuplicatePkgs(cf, clf);
        }
        try {
            Layer layer = new Layer(cf, parents, clf);
            return new Controller(layer);
        }
        catch (IllegalArgumentException iae) {
            throw new LayerInstantiationException(iae.getMessage());
        }
    }

    private static void checkConfiguration(Configuration cf, List<Layer> parentLayers) {
        Objects.requireNonNull(cf);
        List<Configuration> parentConfigurations = cf.parents();
        if (parentLayers.size() != parentConfigurations.size()) {
            throw new IllegalArgumentException("wrong number of parents");
        }
        int index = 0;
        for (Layer parent : parentLayers) {
            if (parent.configuration() != parentConfigurations.get(index)) {
                throw new IllegalArgumentException("Parent of configuration != configuration of this Layer");
            }
            ++index;
        }
    }

    private static void checkCreateClassLoaderPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityConstants.CREATE_CLASSLOADER_PERMISSION);
        }
    }

    private static void checkGetClassLoaderPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
    }

    private static void checkForDuplicatePkgs(Configuration cf, Function<String, ClassLoader> clf) {
        HashMap<ClassLoader, Set> loaderToPackages = new HashMap<ClassLoader, Set>();
        for (ResolvedModule resolvedModule : cf.modules()) {
            ModuleDescriptor descriptor = resolvedModule.reference().descriptor();
            ClassLoader loader = clf.apply(descriptor.name());
            Set loaderPackages = loaderToPackages.computeIfAbsent(loader, k -> new HashSet());
            for (String pkg : descriptor.packages()) {
                boolean added = loaderPackages.add(pkg);
                if (added) continue;
                throw Layer.fail("More than one module with package %s mapped to the same class loader", pkg);
            }
        }
    }

    private static LayerInstantiationException fail(String fmt, Object ... args) {
        String msg = String.format(fmt, args);
        return new LayerInstantiationException(msg);
    }

    public Configuration configuration() {
        return this.cf;
    }

    public List<Layer> parents() {
        return this.parents;
    }

    Stream<Layer> layers() {
        List<Layer> allLayers = this.allLayers;
        if (allLayers != null) {
            return allLayers.stream();
        }
        allLayers = new ArrayList<Layer>();
        HashSet<Layer> visited = new HashSet<Layer>();
        ArrayDeque<Layer> stack = new ArrayDeque<Layer>();
        visited.add(this);
        stack.push(this);
        while (!stack.isEmpty()) {
            Layer layer = (Layer)stack.pop();
            allLayers.add(layer);
            for (int i = layer.parents.size() - 1; i >= 0; --i) {
                Layer parent = layer.parents.get(i);
                if (visited.contains(parent)) continue;
                visited.add(parent);
                stack.push(parent);
            }
        }
        this.allLayers = allLayers = Collections.unmodifiableList(allLayers);
        return allLayers.stream();
    }

    public Set<Module> modules() {
        return Collections.unmodifiableSet(this.nameToModule.values().stream().collect(Collectors.toSet()));
    }

    public Optional<Module> findModule(String name) {
        Objects.requireNonNull(name);
        Module m = this.nameToModule.get(name);
        if (m != null) {
            return Optional.of(m);
        }
        return this.layers().skip(1L).map(l -> l.nameToModule).filter(map -> map.containsKey(name)).map(map -> (Module)map.get(name)).findAny();
    }

    public ClassLoader findLoader(String name) {
        Optional<Module> om = this.findModule(name);
        if (om.isPresent()) {
            return om.get().getClassLoader();
        }
        throw new IllegalArgumentException("Module " + name + " not known to this layer");
    }

    public String toString() {
        return this.modules().stream().map(Module::getName).collect(Collectors.joining(", "));
    }

    public static Layer empty() {
        return EMPTY_LAYER;
    }

    public static Layer boot() {
        return SharedSecrets.getJavaLangAccess().getBootLayer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServicesCatalog getServicesCatalog() {
        ServicesCatalog servicesCatalog = this.servicesCatalog;
        if (servicesCatalog != null) {
            return servicesCatalog;
        }
        Layer layer = this;
        synchronized (layer) {
            servicesCatalog = this.servicesCatalog;
            if (servicesCatalog == null) {
                servicesCatalog = ServicesCatalog.create();
                this.nameToModule.values().forEach((Consumer<Module>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, register(java.lang.reflect.Module ), (Ljava/lang/reflect/Module;)V)((ServicesCatalog)servicesCatalog));
                this.servicesCatalog = servicesCatalog;
            }
        }
        return servicesCatalog;
    }

    void bindToLoader(ClassLoader loader) {
        List previous;
        List<Layer> list = (CopyOnWriteArrayList<Layer>)CLV.get(loader);
        if (list == null && (previous = (List)CLV.putIfAbsent(loader, list = new CopyOnWriteArrayList<Layer>())) != null) {
            list = previous;
        }
        list.add(this);
    }

    static Stream<Layer> layers(ClassLoader loader) {
        List list = (List)CLV.get(loader);
        if (list != null) {
            return list.stream();
        }
        return Stream.empty();
    }

    public static final class Controller {
        private final Layer layer;

        Controller(Layer layer) {
            this.layer = layer;
        }

        public Layer layer() {
            return this.layer;
        }

        private void ensureInLayer(Module source) {
            if (!this.layer.modules().contains(source)) {
                throw new IllegalArgumentException(source + " not in layer");
            }
        }

        public Controller addReads(Module source, Module target) {
            Objects.requireNonNull(source);
            Objects.requireNonNull(target);
            this.ensureInLayer(source);
            Modules.addReads((Module)source, (Module)target);
            return this;
        }

        public Controller addOpens(Module source, String pn, Module target) {
            Objects.requireNonNull(source);
            Objects.requireNonNull(target);
            this.ensureInLayer(source);
            Modules.addOpens((Module)source, (String)pn, (Module)target);
            return this;
        }
    }
}

