/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Module;
import java.lang.reflect.ReflectPermission;
import java.security.AccessController;
import java.security.Permission;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;
import jdk.internal.reflect.ReflectionFactory;

public class AccessibleObject
implements AnnotatedElement {
    private static final Permission ACCESS_PERMISSION = new ReflectPermission("suppressAccessChecks");
    boolean override;
    static final ReflectionFactory reflectionFactory = AccessController.doPrivileged(new ReflectionFactory.GetReflectionFactoryAction());
    volatile Object securityCheckCache;

    static void checkPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ACCESS_PERMISSION);
        }
    }

    @CallerSensitive
    public static void setAccessible(AccessibleObject[] array, boolean flag) {
        AccessibleObject.checkPermission();
        if (flag) {
            Class<?> caller = Reflection.getCallerClass();
            AccessibleObject[] accessibleObjectArray = array = (AccessibleObject[])array.clone();
            int n = accessibleObjectArray.length;
            for (int i = 0; i < n; ++i) {
                AccessibleObject ao = accessibleObjectArray[i];
                ao.checkCanSetAccessible(caller);
            }
        }
        for (AccessibleObject ao : array) {
            ao.setAccessible0(flag);
        }
    }

    public void setAccessible(boolean flag) {
        AccessibleObject.checkPermission();
        this.setAccessible0(flag);
    }

    void setAccessible0(boolean flag) {
        this.override = flag;
    }

    void checkCanSetAccessible(Class<?> caller) {
    }

    void checkCanSetAccessible(Class<?> caller, Class<?> declaringClass) {
        Module declaringModule;
        Module callerModule = caller.getModule();
        if (callerModule == (declaringModule = declaringClass.getModule())) {
            return;
        }
        if (callerModule == Object.class.getModule()) {
            return;
        }
        if (!declaringModule.isNamed()) {
            return;
        }
        String pn = AccessibleObject.packageName(declaringClass);
        if (declaringModule.isOpen(pn, callerModule)) {
            this.printStackTraceIfOpenedReflectively(declaringModule, pn, callerModule);
            return;
        }
        boolean isExported = declaringModule.isExported(pn, callerModule);
        boolean isClassPublic = Modifier.isPublic(declaringClass.getModifiers());
        int modifiers = this instanceof Executable ? ((Executable)this).getModifiers() : ((Field)this).getModifiers();
        boolean isMemberPublic = Modifier.isPublic(modifiers);
        if (isExported && isClassPublic && isMemberPublic) {
            this.printStackTraceIfExportedReflectively(declaringModule, pn, callerModule);
            return;
        }
        String msg = "Unable to make ";
        if (this instanceof Field) {
            msg = msg + "field ";
        }
        msg = msg + this + " accessible: " + declaringModule + " does not \"";
        msg = isClassPublic && isMemberPublic ? msg + "exports" : msg + "opens";
        msg = msg + " " + pn + "\" to " + callerModule;
        InaccessibleObjectException e = new InaccessibleObjectException(msg);
        if (Reflection.printStackTraceWhenAccessFails()) {
            e.printStackTrace(System.err);
        }
        throw e;
    }

    private void printStackTraceIfOpenedReflectively(Module module, String pn, Module other) {
        this.printStackTraceIfExposedReflectively(module, pn, other, true);
    }

    private void printStackTraceIfExportedReflectively(Module module, String pn, Module other) {
        this.printStackTraceIfExposedReflectively(module, pn, other, false);
    }

    private void printStackTraceIfExposedReflectively(Module module, String pn, Module other, boolean open) {
        if (Reflection.printStackTraceWhenAccessSucceeds() && !module.isStaticallyExportedOrOpen(pn, other, open)) {
            String msg = other + " allowed to invoke setAccessible on ";
            if (this instanceof Field) {
                msg = msg + "field ";
            }
            msg = msg + this;
            new Exception(msg){
                private static final long serialVersionUID = 42L;

                @Override
                public String toString() {
                    return "WARNING: " + this.getMessage();
                }
            }.printStackTrace(System.err);
        }
    }

    private static String packageName(Class<?> c) {
        while (c.isArray()) {
            c = c.getComponentType();
        }
        String pn = c.getPackageName();
        return pn != null ? pn : "";
    }

    public boolean isAccessible() {
        return this.override;
    }

    protected AccessibleObject() {
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        throw new AssertionError((Object)"All subclasses should override this method");
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return AnnotatedElement.super.isAnnotationPresent(annotationClass);
    }

    @Override
    public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        throw new AssertionError((Object)"All subclasses should override this method");
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    @Override
    public <T extends Annotation> T getDeclaredAnnotation(Class<T> annotationClass) {
        return this.getAnnotation(annotationClass);
    }

    @Override
    public <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> annotationClass) {
        return this.getAnnotationsByType(annotationClass);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        throw new AssertionError((Object)"All subclasses should override this method");
    }

    final void checkAccess(Class<?> caller, Class<?> memberClass, Class<?> targetClass, int modifiers) throws IllegalAccessException {
        Class[] cache2;
        if (caller == memberClass) {
            return;
        }
        Object cache = this.securityCheckCache;
        if (targetClass != null && Modifier.isProtected(modifiers) && targetClass != memberClass ? cache instanceof Class[] && (cache2 = (Class[])cache)[1] == targetClass && cache2[0] == caller : cache == caller) {
            return;
        }
        this.slowCheckMemberAccess(caller, memberClass, targetClass, modifiers);
    }

    void slowCheckMemberAccess(Class<?> caller, Class<?> memberClass, Class<?> targetClass, int modifiers) throws IllegalAccessException {
        Class[] cache;
        Class[] classArray;
        Reflection.ensureMemberAccess(caller, memberClass, targetClass, modifiers);
        if (targetClass != null && Modifier.isProtected(modifiers) && targetClass != memberClass) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = caller;
            classArray = classArray2;
            classArray2[1] = targetClass;
        } else {
            classArray = caller;
        }
        this.securityCheckCache = cache = classArray;
    }
}

