/*
 * Decompiled with CFR 0.152.
 */
package java.lang.module;

import java.io.PrintStream;
import java.lang.module.Configuration;
import java.lang.module.FindException;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.lang.module.ResolutionException;
import java.lang.module.ResolvedModule;
import java.lang.reflect.Layer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import jdk.internal.module.ModuleHashes;
import jdk.internal.module.ModuleReferenceImpl;

final class Resolver {
    private final ModuleFinder beforeFinder;
    private final List<Configuration> parents;
    private final ModuleFinder afterFinder;
    private final PrintStream traceOutput;
    private final Map<String, ModuleReference> nameToReference = new HashMap<String, ModuleReference>();
    private Set<ModuleDescriptor> visited;
    private Set<ModuleDescriptor> visitPath;

    Resolver(ModuleFinder beforeFinder, List<Configuration> parents, ModuleFinder afterFinder, PrintStream traceOutput) {
        this.beforeFinder = beforeFinder;
        this.parents = parents;
        this.afterFinder = afterFinder;
        this.traceOutput = traceOutput;
    }

    Resolver resolveRequires(Collection<String> roots) {
        ArrayDeque<ModuleDescriptor> q = new ArrayDeque<ModuleDescriptor>();
        for (String root : roots) {
            ModuleReference mref = this.findWithBeforeFinder(root);
            if (mref == null) {
                if (this.findInParent(root) != null) continue;
                mref = this.findWithAfterFinder(root);
                if (mref == null) {
                    Resolver.fail("Module %s not found", root);
                }
            }
            if (this.isTracing()) {
                this.trace("Root module %s located", root);
                mref.location().ifPresent(uri -> this.trace("  (%s)", uri));
            }
            assert (mref.descriptor().name().equals(root));
            this.nameToReference.put(root, mref);
            q.push(mref.descriptor());
        }
        this.resolve(q);
        return this;
    }

    private Set<ModuleDescriptor> resolve(Deque<ModuleDescriptor> q) {
        HashSet<ModuleDescriptor> resolved = new HashSet<ModuleDescriptor>();
        while (!q.isEmpty()) {
            ModuleDescriptor descriptor = q.poll();
            assert (this.nameToReference.containsKey(descriptor.name()));
            for (ModuleDescriptor.Requires requires : descriptor.requires()) {
                if (requires.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.STATIC)) continue;
                String dn = requires.name();
                ModuleReference mref = this.findWithBeforeFinder(dn);
                if (mref == null) {
                    if (this.findInParent(dn) != null) continue;
                    mref = this.findWithAfterFinder(dn);
                    if (mref == null) {
                        Resolver.fail("Module %s not found, required by %s", dn, descriptor.name());
                    }
                }
                if (this.nameToReference.containsKey(dn)) continue;
                this.nameToReference.put(dn, mref);
                q.offer(mref.descriptor());
                resolved.add(mref.descriptor());
                if (!this.isTracing()) continue;
                this.trace("Module %s located, required by %s", dn, descriptor.name());
                mref.location().ifPresent(uri -> this.trace("  (%s)", uri));
            }
            resolved.add(descriptor);
        }
        return resolved;
    }

    Resolver resolveUses() {
        HashMap<String, HashSet<ModuleReference>> availableProviders = new HashMap<String, HashSet<ModuleReference>>();
        for (ModuleReference mref : this.findAll()) {
            ModuleDescriptor descriptor = mref.descriptor();
            if (descriptor.provides().isEmpty()) continue;
            for (ModuleDescriptor.Provides provides : descriptor.provides()) {
                String sn = provides.service();
                HashSet<ModuleReference> providers = (HashSet<ModuleReference>)availableProviders.get(sn);
                if (providers == null) {
                    providers = new HashSet<ModuleReference>();
                    availableProviders.put(sn, providers);
                }
                providers.add(mref);
            }
        }
        ArrayDeque<ModuleDescriptor> q = new ArrayDeque<ModuleDescriptor>();
        Set<Object> initialConsumers = Layer.boot() == null ? new HashSet() : this.parents.stream().flatMap(Configuration::configurations).distinct().flatMap(c -> c.descriptors().stream()).collect(Collectors.toSet());
        for (ModuleReference mref : this.nameToReference.values()) {
            initialConsumers.add(mref.descriptor());
        }
        Set<Object> candidateConsumers = initialConsumers;
        do {
            for (ModuleDescriptor moduleDescriptor : candidateConsumers) {
                if (moduleDescriptor.uses().isEmpty()) continue;
                for (String service : moduleDescriptor.uses()) {
                    Set mrefs = (Set)availableProviders.get(service);
                    if (mrefs == null) continue;
                    for (ModuleReference mref : mrefs) {
                        ModuleDescriptor provider = mref.descriptor();
                        if (provider.equals(moduleDescriptor)) continue;
                        this.trace("Module %s provides %s, used by %s", provider.name(), service, moduleDescriptor.name());
                        String pn = provider.name();
                        if (this.nameToReference.containsKey(pn)) continue;
                        if (this.isTracing()) {
                            mref.location().ifPresent(uri -> this.trace("  (%s)", uri));
                        }
                        this.nameToReference.put(pn, mref);
                        q.push(provider);
                    }
                }
            }
        } while (!(candidateConsumers = this.resolve(q)).isEmpty());
        return this;
    }

    Map<ResolvedModule, Set<ResolvedModule>> finish(Configuration cf, boolean check) {
        if (this.isTracing()) {
            this.trace("Result:", new Object[0]);
            Set<String> names = this.nameToReference.keySet();
            names.stream().sorted().forEach(name -> this.trace("  %s", name));
        }
        if (check) {
            this.detectCycles();
            this.checkPlatformConstraints();
            this.checkHashes();
        }
        Map<ResolvedModule, Set<ResolvedModule>> graph = this.makeGraph(cf);
        if (check) {
            this.checkExportSuppliers(graph);
        }
        return graph;
    }

    private void detectCycles() {
        this.visited = new HashSet<ModuleDescriptor>();
        this.visitPath = new LinkedHashSet<ModuleDescriptor>();
        for (ModuleReference mref : this.nameToReference.values()) {
            this.visit(mref.descriptor());
        }
        this.visited.clear();
    }

    private void visit(ModuleDescriptor descriptor) {
        if (!this.visited.contains(descriptor)) {
            boolean added = this.visitPath.add(descriptor);
            if (!added) {
                throw new ResolutionException("Cycle detected: " + this.cycleAsString(descriptor));
            }
            for (ModuleDescriptor.Requires requires : descriptor.requires()) {
                ModuleDescriptor other;
                String dn = requires.name();
                ModuleReference mref = this.nameToReference.get(dn);
                if (mref == null || (other = mref.descriptor()) == descriptor) continue;
                this.visit(other);
            }
            this.visitPath.remove(descriptor);
            this.visited.add(descriptor);
        }
    }

    private String cycleAsString(ModuleDescriptor descriptor) {
        ArrayList<ModuleDescriptor> list = new ArrayList<ModuleDescriptor>(this.visitPath);
        list.add(descriptor);
        int index = list.indexOf(descriptor);
        return list.stream().skip(index).map(ModuleDescriptor::name).collect(Collectors.joining(" -> "));
    }

    private void checkPlatformConstraints() {
        String savedModuleName = null;
        String savedOsName = null;
        String savedOsArch = null;
        String savedOsVersion = null;
        for (ModuleReference mref : this.nameToReference.values()) {
            ModuleDescriptor descriptor = mref.descriptor();
            String osName = descriptor.osName().orElse(null);
            String osArch = descriptor.osArch().orElse(null);
            String osVersion = descriptor.osVersion().orElse(null);
            if (osName == null && osArch == null && osVersion == null) continue;
            if (savedModuleName == null) {
                savedModuleName = descriptor.name();
                savedOsName = osName;
                savedOsArch = osArch;
                savedOsVersion = osVersion;
                continue;
            }
            boolean matches = this.platformMatches(osName, savedOsName) && this.platformMatches(osArch, savedOsArch) && this.platformMatches(osVersion, savedOsVersion);
            if (matches) continue;
            String s1 = this.platformAsString(savedOsName, savedOsArch, savedOsVersion);
            String s2 = this.platformAsString(osName, osArch, osVersion);
            Resolver.fail("Mismatching constraints on target platform: " + savedModuleName + ": " + s1 + ", " + descriptor.name() + ": " + s2, new Object[0]);
        }
    }

    private boolean platformMatches(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return true;
        }
        return Objects.equals(s1, s2);
    }

    private String platformAsString(String osName, String osArch, String osVersion) {
        return new StringJoiner("-").add(Objects.toString(osName, "*")).add(Objects.toString(osArch, "*")).add(Objects.toString(osVersion, "*")).toString();
    }

    private void checkHashes() {
        for (ModuleReference mref : this.nameToReference.values()) {
            ModuleHashes hashes;
            if (!(mref instanceof ModuleReferenceImpl) || (hashes = ((ModuleReferenceImpl)mref).recordedHashes()) == null) continue;
            ModuleDescriptor descriptor = mref.descriptor();
            String algorithm = hashes.algorithm();
            for (String dn : hashes.names()) {
                ModuleReferenceImpl other;
                ResolvedModule resolvedModule;
                ModuleReference mref2 = this.nameToReference.get(dn);
                if (mref2 == null && (resolvedModule = this.findInParent(dn)) != null) {
                    mref2 = resolvedModule.reference();
                }
                if (mref2 == null) continue;
                if (!(mref2 instanceof ModuleReferenceImpl)) {
                    Resolver.fail("Unable to compute the hash of module %s", dn);
                }
                if ((other = (ModuleReferenceImpl)mref2) == null || other.isPatched()) continue;
                byte[] recordedHash = hashes.hashFor(dn);
                byte[] actualHash = other.computeHash(algorithm);
                if (actualHash == null) {
                    Resolver.fail("Unable to compute the hash of module %s", dn);
                }
                if (Arrays.equals(recordedHash, actualHash)) continue;
                Resolver.fail("Hash of %s (%s) differs to expected hash (%s) recorded in %s", dn, Resolver.toHexString(actualHash), Resolver.toHexString(recordedHash), descriptor.name());
            }
        }
    }

    private static String toHexString(byte[] ba) {
        StringBuilder sb = new StringBuilder(ba.length * 2);
        for (byte b : ba) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    private Map<ResolvedModule, Set<ResolvedModule>> makeGraph(Configuration cf) {
        boolean changed;
        int capacity = 1 + 4 * this.nameToReference.size() / 3;
        HashMap<ResolvedModule, Set<ResolvedModule>> g1 = new HashMap<ResolvedModule, Set<ResolvedModule>>(capacity);
        Map g2 = Layer.boot() == null ? new HashMap(capacity) : (Map)this.parents.stream().flatMap(Configuration::configurations).distinct().flatMap(c -> c.modules().stream().flatMap(m1 -> m1.descriptor().requires().stream().filter(r -> r.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.TRANSITIVE)).flatMap(r -> {
            Optional<ResolvedModule> m2 = c.findModule(r.name());
            assert (m2.isPresent() || r.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.STATIC));
            return m2.stream();
        }).map(m2 -> Map.entry(m1, m2)))).collect(Collectors.groupingBy(Map.Entry::getKey, HashMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.toSet())));
        HashMap<String, ResolvedModule> nameToResolved = new HashMap<String, ResolvedModule>(capacity);
        for (ModuleReference mref : this.nameToReference.values()) {
            ModuleDescriptor descriptor = mref.descriptor();
            String name = descriptor.name();
            ResolvedModule m1 = this.computeIfAbsent(nameToResolved, name, cf, mref);
            HashSet<ResolvedModule> reads = new HashSet<ResolvedModule>();
            HashSet<ResolvedModule> requiresTransitive = new HashSet<ResolvedModule>();
            for (ModuleDescriptor.Requires requires : descriptor.requires()) {
                String dn = requires.name();
                ResolvedModule m2 = null;
                ModuleReference mref2 = this.nameToReference.get(dn);
                if (mref2 != null) {
                    m2 = this.computeIfAbsent(nameToResolved, dn, cf, mref2);
                } else {
                    m2 = this.findInParent(dn);
                    if (m2 == null) {
                        assert (requires.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.STATIC));
                        continue;
                    }
                }
                reads.add(m2);
                if (!requires.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.TRANSITIVE)) continue;
                requiresTransitive.add(m2);
            }
            if (descriptor.isAutomatic()) {
                for (ModuleReference mref2 : this.nameToReference.values()) {
                    ModuleDescriptor descriptor2 = mref2.descriptor();
                    String name2 = descriptor2.name();
                    if (name.equals(name2)) continue;
                    ResolvedModule m2 = this.computeIfAbsent(nameToResolved, name2, cf, mref2);
                    reads.add(m2);
                    if (!descriptor2.isAutomatic()) continue;
                    requiresTransitive.add(m2);
                }
                for (Configuration parent : this.parents) {
                    parent.configurations().map(Configuration::modules).flatMap(Collection::stream).forEach(m -> {
                        reads.add((ResolvedModule)m);
                        if (m.reference().descriptor().isAutomatic()) {
                            requiresTransitive.add((ResolvedModule)m);
                        }
                    });
                }
            }
            g1.put(m1, reads);
            g2.put(m1, requiresTransitive);
        }
        ArrayList<ResolvedModule> toAdd = new ArrayList<ResolvedModule>();
        do {
            changed = false;
            for (Set m1Reads : g1.values()) {
                for (ResolvedModule m2 : m1Reads) {
                    Set m2RequiresTransitive = (Set)g2.get(m2);
                    if (m2RequiresTransitive == null) continue;
                    for (ResolvedModule m3 : m2RequiresTransitive) {
                        if (m1Reads.contains(m3)) continue;
                        toAdd.add(m3);
                    }
                }
                if (toAdd.isEmpty()) continue;
                m1Reads.addAll(toAdd);
                toAdd.clear();
                changed = true;
            }
        } while (changed);
        return g1;
    }

    private ResolvedModule computeIfAbsent(Map<String, ResolvedModule> map, String name, Configuration cf, ModuleReference mref) {
        ResolvedModule m = map.get(name);
        if (m == null) {
            m = new ResolvedModule(cf, mref);
            map.put(name, m);
        }
        return m;
    }

    private void checkExportSuppliers(Map<ResolvedModule, Set<ResolvedModule>> graph) {
        for (Map.Entry<ResolvedModule, Set<ResolvedModule>> e : graph.entrySet()) {
            String pn;
            ModuleDescriptor descriptor1 = e.getKey().descriptor();
            HashMap<String, ModuleDescriptor> packageToExporter = new HashMap<String, ModuleDescriptor>();
            Set<String> packages = descriptor1.packages();
            for (String pn2 : packages) {
                packageToExporter.put(pn2, descriptor1);
            }
            Set<ResolvedModule> reads = e.getValue();
            for (ResolvedModule endpoint : reads) {
                ModuleDescriptor descriptor2 = endpoint.descriptor();
                for (ModuleDescriptor.Exports export : descriptor2.exports()) {
                    String source;
                    ModuleDescriptor other;
                    if (export.isQualified() && !export.targets().contains(descriptor1.name()) || (other = packageToExporter.putIfAbsent(source = export.source(), descriptor2)) == null || other == descriptor2) continue;
                    if (other == descriptor1) {
                        Resolver.fail("Module %s contains package %s, module %s exports package %s to %s", descriptor1.name(), source, descriptor2.name(), source, descriptor1.name());
                        continue;
                    }
                    Resolver.fail("Modules %s and %s export package %s to module %s", descriptor2.name(), other.name(), source, descriptor1.name());
                }
            }
            if (descriptor1.isAutomatic()) continue;
            for (String service : descriptor1.uses()) {
                pn = Resolver.packageName(service);
                if (packageToExporter.containsKey(pn)) continue;
                Resolver.fail("Module %s does not read a module that exports %s", descriptor1.name(), pn);
            }
            for (ModuleDescriptor.Provides provides : descriptor1.provides()) {
                pn = Resolver.packageName(provides.service());
                if (!packageToExporter.containsKey(pn)) {
                    Resolver.fail("Module %s does not read a module that exports %s", descriptor1.name(), pn);
                }
                for (String provider : provides.providers()) {
                    if (packages.contains(Resolver.packageName(provider))) continue;
                    Resolver.fail("Provider %s not in module %s", provider, descriptor1.name());
                }
            }
        }
    }

    private ResolvedModule findInParent(String mn) {
        for (Configuration parent : this.parents) {
            Optional<ResolvedModule> om = parent.findModule(mn);
            if (!om.isPresent()) continue;
            return om.get();
        }
        return null;
    }

    private ModuleReference findWithBeforeFinder(String mn) {
        try {
            return this.beforeFinder.find(mn).orElse(null);
        }
        catch (FindException e) {
            throw new ResolutionException(e.getMessage(), e.getCause());
        }
    }

    private ModuleReference findWithAfterFinder(String mn) {
        try {
            return this.afterFinder.find(mn).orElse(null);
        }
        catch (FindException e) {
            throw new ResolutionException(e.getMessage(), e.getCause());
        }
    }

    private Set<ModuleReference> findAll() {
        try {
            Set<ModuleReference> beforeModules = this.beforeFinder.findAll();
            Set<ModuleReference> afterModules = this.afterFinder.findAll();
            if (afterModules.isEmpty()) {
                return beforeModules;
            }
            if (beforeModules.isEmpty() && this.parents.size() == 1 && this.parents.get(0) == Configuration.empty()) {
                return afterModules;
            }
            HashSet<ModuleReference> result = new HashSet<ModuleReference>(beforeModules);
            for (ModuleReference mref : afterModules) {
                String name = mref.descriptor().name();
                if (this.beforeFinder.find(name).isPresent() || this.findInParent(name) != null) continue;
                result.add(mref);
            }
            return result;
        }
        catch (FindException e) {
            throw new ResolutionException(e.getMessage(), e.getCause());
        }
    }

    private static String packageName(String cn) {
        int index = cn.lastIndexOf(".");
        return index == -1 ? "" : cn.substring(0, index);
    }

    private static void fail(String fmt, Object ... args) {
        String msg = String.format(fmt, args);
        throw new ResolutionException(msg);
    }

    private boolean isTracing() {
        return this.traceOutput != null;
    }

    private void trace(String fmt, Object ... args) {
        if (this.traceOutput != null) {
            this.traceOutput.format("[Resolver] " + fmt, args);
            this.traceOutput.println();
        }
    }
}

