/*
 * Decompiled with CFR 0.152.
 */
package java.lang.module;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public interface ModuleReader
extends Closeable {
    public Optional<URI> find(String var1) throws IOException;

    default public Optional<InputStream> open(String name) throws IOException {
        Optional<URI> ouri = this.find(name);
        if (ouri.isPresent()) {
            return Optional.of(ouri.get().toURL().openStream());
        }
        return Optional.empty();
    }

    default public Optional<ByteBuffer> read(String name) throws IOException {
        Optional<InputStream> oin = this.open(name);
        if (oin.isPresent()) {
            try (InputStream in = oin.get();){
                Optional<ByteBuffer> optional = Optional.of(ByteBuffer.wrap(in.readAllBytes()));
                return optional;
            }
        }
        return Optional.empty();
    }

    default public void release(ByteBuffer bb) {
        Objects.requireNonNull(bb);
    }

    public Stream<String> list() throws IOException;

    @Override
    public void close() throws IOException;
}

