/*
 * Decompiled with CFR 0.152.
 */
package java.lang.module;

import java.io.File;
import java.io.FilePermission;
import java.lang.module.ModuleReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import jdk.internal.module.ModulePath;
import jdk.internal.module.SystemModuleFinder;
import sun.security.action.GetPropertyAction;

public interface ModuleFinder {
    public Optional<ModuleReference> find(String var1);

    public Set<ModuleReference> findAll();

    public static ModuleFinder ofSystem() {
        String home;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            GetPropertyAction pa = new GetPropertyAction("java.home");
            home = AccessController.doPrivileged(pa);
            FilePermission p = new FilePermission(home + File.separator + "-", "read");
            sm.checkPermission(p);
        } else {
            home = System.getProperty("java.home");
        }
        Path modules = Paths.get(home, "lib", "modules");
        if (Files.isRegularFile(modules, new LinkOption[0])) {
            return SystemModuleFinder.getInstance();
        }
        Path mlib = Paths.get(home, "modules");
        if (Files.isDirectory(mlib, new LinkOption[0])) {
            return ModuleFinder.of(mlib);
        }
        throw new InternalError("Unable to detect the run-time image");
    }

    public static ModuleFinder of(Path ... entries) {
        if (entries.length == 0) {
            return new ModuleFinder(){

                @Override
                public Optional<ModuleReference> find(String name) {
                    Objects.requireNonNull(name);
                    return Optional.empty();
                }

                @Override
                public Set<ModuleReference> findAll() {
                    return Collections.emptySet();
                }
            };
        }
        return new ModulePath(entries);
    }

    public static ModuleFinder compose(ModuleFinder ... finders) {
        final List<ModuleFinder> finderList = List.of(finders);
        return new ModuleFinder(){
            private final Map<String, ModuleReference> nameToModule = new HashMap<String, ModuleReference>();
            private Set<ModuleReference> allModules;

            @Override
            public Optional<ModuleReference> find(String name) {
                ModuleReference mref = this.nameToModule.get(name);
                if (mref != null) {
                    return Optional.of(mref);
                }
                Optional<ModuleReference> omref = finderList.stream().map(f -> f.find(name)).flatMap(Optional::stream).findFirst();
                omref.ifPresent(m -> this.nameToModule.put(name, (ModuleReference)m));
                return omref;
            }

            @Override
            public Set<ModuleReference> findAll() {
                if (this.allModules != null) {
                    return this.allModules;
                }
                HashSet<ModuleReference> result = new HashSet<ModuleReference>(this.nameToModule.values());
                finderList.stream().flatMap(f -> f.findAll().stream()).forEach(mref -> {
                    String name = mref.descriptor().name();
                    if (this.nameToModule.putIfAbsent(name, (ModuleReference)mref) == null) {
                        result.add((ModuleReference)mref);
                    }
                });
                this.allModules = Collections.unmodifiableSet(result);
                return this.allModules;
            }
        };
    }
}

