/*
 * Decompiled with CFR 0.152.
 */
package java.lang.module;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.internal.misc.JavaLangModuleAccess;
import jdk.internal.misc.SharedSecrets;
import jdk.internal.module.Checks;
import jdk.internal.module.ModuleInfo;

public class ModuleDescriptor
implements Comparable<ModuleDescriptor> {
    private final String name;
    private final Version version;
    private final boolean open;
    private final boolean automatic;
    private final boolean synthetic;
    private final Set<Requires> requires;
    private final Set<Exports> exports;
    private final Set<Opens> opens;
    private final Set<String> uses;
    private final Set<Provides> provides;
    private final Set<String> packages;
    private final String mainClass;
    private final String osName;
    private final String osArch;
    private final String osVersion;
    private transient int hash;

    private ModuleDescriptor(String name, Version version, boolean open, boolean automatic, boolean synthetic, Set<Requires> requires, Set<Exports> exports, Set<Opens> opens, Set<String> uses, Set<Provides> provides, Set<String> packages, String mainClass, String osName, String osArch, String osVersion) {
        this.name = name;
        this.version = version;
        this.open = open;
        this.automatic = automatic;
        this.synthetic = synthetic;
        assert (requires.stream().map(Requires::name).distinct().count() == (long)requires.size());
        this.requires = ModuleDescriptor.emptyOrUnmodifiableSet(requires);
        this.exports = ModuleDescriptor.emptyOrUnmodifiableSet(exports);
        this.opens = ModuleDescriptor.emptyOrUnmodifiableSet(opens);
        this.uses = ModuleDescriptor.emptyOrUnmodifiableSet(uses);
        this.provides = ModuleDescriptor.emptyOrUnmodifiableSet(provides);
        this.packages = ModuleDescriptor.emptyOrUnmodifiableSet(packages);
        this.mainClass = mainClass;
        this.osName = osName;
        this.osArch = osArch;
        this.osVersion = osVersion;
    }

    ModuleDescriptor(ModuleDescriptor md, Set<String> pkgs) {
        this.name = md.name;
        this.version = md.version;
        this.open = md.open;
        this.automatic = md.automatic;
        this.synthetic = md.synthetic;
        this.requires = md.requires;
        this.exports = md.exports;
        this.opens = md.opens;
        this.uses = md.uses;
        this.provides = md.provides;
        HashSet<String> packages = new HashSet<String>(md.packages);
        packages.addAll(pkgs);
        this.packages = ModuleDescriptor.emptyOrUnmodifiableSet(packages);
        this.mainClass = md.mainClass;
        this.osName = md.osName;
        this.osArch = md.osArch;
        this.osVersion = md.osVersion;
    }

    ModuleDescriptor(String name, Version version, boolean open, boolean automatic, boolean synthetic, Set<Requires> requires, Set<Exports> exports, Set<Opens> opens, Set<String> uses, Set<Provides> provides, Set<String> packages, String mainClass, String osName, String osArch, String osVersion, int hashCode, boolean unused) {
        this.name = name;
        this.version = version;
        this.open = open;
        this.automatic = automatic;
        this.synthetic = synthetic;
        this.requires = requires;
        this.exports = exports;
        this.opens = opens;
        this.uses = uses;
        this.provides = provides;
        this.packages = packages;
        this.mainClass = mainClass;
        this.osName = osName;
        this.osArch = osArch;
        this.osVersion = osVersion;
        this.hash = hashCode;
    }

    public String name() {
        return this.name;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public Set<Requires> requires() {
        return this.requires;
    }

    public Set<Exports> exports() {
        return this.exports;
    }

    public Set<Opens> opens() {
        return this.opens;
    }

    public Set<String> uses() {
        return this.uses;
    }

    public Set<Provides> provides() {
        return this.provides;
    }

    public Optional<Version> version() {
        return Optional.ofNullable(this.version);
    }

    public String toNameAndVersion() {
        if (this.version != null) {
            return this.name() + "@" + this.version;
        }
        return this.name();
    }

    public Optional<String> mainClass() {
        return Optional.ofNullable(this.mainClass);
    }

    public Optional<String> osName() {
        return Optional.ofNullable(this.osName);
    }

    public Optional<String> osArch() {
        return Optional.ofNullable(this.osArch);
    }

    public Optional<String> osVersion() {
        return Optional.ofNullable(this.osVersion);
    }

    public Set<String> packages() {
        return this.packages;
    }

    @Override
    public int compareTo(ModuleDescriptor that) {
        int c = this.name().compareTo(that.name());
        if (c != 0) {
            return c;
        }
        if (this.version == null) {
            if (that.version == null) {
                return 0;
            }
            return -1;
        }
        if (that.version == null) {
            return 1;
        }
        return this.version.compareTo(that.version);
    }

    public boolean equals(Object ob) {
        if (ob == this) {
            return true;
        }
        if (!(ob instanceof ModuleDescriptor)) {
            return false;
        }
        ModuleDescriptor that = (ModuleDescriptor)ob;
        return this.name.equals(that.name) && this.open == that.open && this.automatic == that.automatic && this.synthetic == that.synthetic && this.requires.equals(that.requires) && this.exports.equals(that.exports) && this.opens.equals(that.opens) && this.uses.equals(that.uses) && this.provides.equals(that.provides) && Objects.equals(this.version, that.version) && Objects.equals(this.mainClass, that.mainClass) && Objects.equals(this.osName, that.osName) && Objects.equals(this.osArch, that.osArch) && Objects.equals(this.osVersion, that.osVersion) && Objects.equals(this.packages, that.packages);
    }

    public int hashCode() {
        int hc = this.hash;
        if (hc == 0) {
            hc = this.name.hashCode();
            hc = hc * 43 + Boolean.hashCode(this.open);
            hc = hc * 43 + Boolean.hashCode(this.automatic);
            hc = hc * 43 + Boolean.hashCode(this.synthetic);
            hc = hc * 43 + this.requires.hashCode();
            hc = hc * 43 + this.exports.hashCode();
            hc = hc * 43 + this.opens.hashCode();
            hc = hc * 43 + this.uses.hashCode();
            hc = hc * 43 + this.provides.hashCode();
            hc = hc * 43 + Objects.hashCode(this.version);
            hc = hc * 43 + Objects.hashCode(this.mainClass);
            hc = hc * 43 + Objects.hashCode(this.osName);
            hc = hc * 43 + Objects.hashCode(this.osArch);
            hc = hc * 43 + Objects.hashCode(this.osVersion);
            if ((hc = hc * 43 + Objects.hashCode(this.packages)) == 0) {
                hc = -1;
            }
            this.hash = hc;
        }
        return hc;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isOpen()) {
            sb.append("open ");
        }
        sb.append("module { name: ").append(this.toNameAndVersion());
        if (!this.requires.isEmpty()) {
            sb.append(", ").append(this.requires);
        }
        if (!this.uses.isEmpty()) {
            sb.append(", uses: ").append(this.uses);
        }
        if (!this.exports.isEmpty()) {
            sb.append(", exports: ").append(this.exports);
        }
        if (!this.opens.isEmpty()) {
            sb.append(", opens: ").append(this.opens);
        }
        if (!this.provides.isEmpty()) {
            sb.append(", provides: ").append(this.provides);
        }
        sb.append(" }");
        return sb.toString();
    }

    public static Builder module(String name) {
        return new Builder(name, true, false, false);
    }

    public static Builder openModule(String name) {
        return new Builder(name, true, true, false);
    }

    public static Builder automaticModule(String name) {
        return new Builder(name, true, false, false).automatic(true);
    }

    public static ModuleDescriptor read(InputStream in, Supplier<Set<String>> packageFinder) throws IOException {
        return ModuleInfo.read(in, Objects.requireNonNull(packageFinder)).descriptor();
    }

    public static ModuleDescriptor read(InputStream in) throws IOException {
        return ModuleInfo.read(in, null).descriptor();
    }

    public static ModuleDescriptor read(ByteBuffer bb, Supplier<Set<String>> packageFinder) {
        return ModuleInfo.read(bb, Objects.requireNonNull(packageFinder)).descriptor();
    }

    public static ModuleDescriptor read(ByteBuffer bb) {
        return ModuleInfo.read(bb, null).descriptor();
    }

    private static <K, V> Map<K, V> emptyOrUnmodifiableMap(Map<K, V> map) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        if (map.size() == 1) {
            Map.Entry<K, V> entry = map.entrySet().iterator().next();
            return Collections.singletonMap(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(map);
    }

    private static <T> Set<T> emptyOrUnmodifiableSet(Set<T> set) {
        if (set.isEmpty()) {
            return Collections.emptySet();
        }
        if (set.size() == 1) {
            return Collections.singleton(set.iterator().next());
        }
        return Collections.unmodifiableSet(set);
    }

    private static <M> String toString(Set<M> mods, String what) {
        return Stream.concat(mods.stream().map(e -> e.toString().toLowerCase()), Stream.of(what)).collect(Collectors.joining(" "));
    }

    static {
        SharedSecrets.setJavaLangModuleAccess((JavaLangModuleAccess)new JavaLangModuleAccess(){

            public Builder newModuleBuilder(String mn, boolean strict, boolean open, boolean synthetic) {
                return new Builder(mn, strict, open, synthetic);
            }

            public Set<String> exportedPackages(Builder builder) {
                return builder.exportedPackages();
            }

            public Set<String> openPackages(Builder builder) {
                return builder.openPackages();
            }

            public Requires newRequires(Set<Requires.Modifier> ms, String mn, Version v) {
                return new Requires(ms, mn, v, true);
            }

            public Exports newExports(Set<Exports.Modifier> ms, String source) {
                return new Exports(ms, source, Collections.emptySet(), true);
            }

            public Exports newExports(Set<Exports.Modifier> ms, String source, Set<String> targets) {
                return new Exports(ms, source, targets, true);
            }

            public Opens newOpens(Set<Opens.Modifier> ms, String source, Set<String> targets) {
                return new Opens(ms, source, targets, true);
            }

            public Opens newOpens(Set<Opens.Modifier> ms, String source) {
                return new Opens(ms, source, Collections.emptySet(), true);
            }

            public Provides newProvides(String service, List<String> providers) {
                return new Provides(service, providers, true);
            }

            public Version newVersion(String v) {
                return new Version(v);
            }

            public ModuleDescriptor newModuleDescriptor(ModuleDescriptor md, Set<String> pkgs) {
                return new ModuleDescriptor(md, pkgs);
            }

            public ModuleDescriptor newModuleDescriptor(String name, Version version, boolean open, boolean automatic, boolean synthetic, Set<Requires> requires, Set<Exports> exports, Set<Opens> opens, Set<String> uses, Set<Provides> provides, Set<String> packages, String mainClass, String osName, String osArch, String osVersion, int hashCode) {
                return new ModuleDescriptor(name, version, open, automatic, synthetic, requires, exports, opens, uses, provides, packages, mainClass, osName, osArch, osVersion, hashCode, false);
            }

            public Configuration resolveRequiresAndUses(ModuleFinder finder, Collection<String> roots, boolean check, PrintStream traceOutput) {
                return Configuration.resolveRequiresAndUses(finder, roots, check, traceOutput);
            }
        });
    }

    public static final class Builder {
        final String name;
        final boolean strict;
        final boolean open;
        final boolean synthetic;
        boolean automatic;
        final Map<String, Requires> requires = new HashMap<String, Requires>();
        final Map<String, Exports> exports = new HashMap<String, Exports>();
        final Map<String, Opens> opens = new HashMap<String, Opens>();
        final Set<String> concealedPackages = new HashSet<String>();
        final Set<String> uses = new HashSet<String>();
        final Map<String, Provides> provides = new HashMap<String, Provides>();
        Version version;
        String osName;
        String osArch;
        String osVersion;
        String mainClass;

        Builder(String name, boolean strict, boolean open, boolean synthetic) {
            this.name = strict ? Checks.requireModuleName(name) : name;
            this.strict = strict;
            this.open = open;
            this.synthetic = synthetic;
        }

        Builder automatic(boolean automatic) {
            this.automatic = automatic;
            return this;
        }

        Set<String> exportedPackages() {
            return this.exports.keySet();
        }

        Set<String> openPackages() {
            return this.opens.keySet();
        }

        public Builder requires(Requires req) {
            String mn = req.name();
            if (this.name.equals(mn)) {
                throw new IllegalArgumentException("Dependence on self");
            }
            if (this.requires.containsKey(mn)) {
                throw new IllegalStateException("Dependence upon " + mn + " already declared");
            }
            this.requires.put(mn, req);
            return this;
        }

        public Builder requires(Set<Requires.Modifier> ms, String mn, Version compiledVersion) {
            Objects.requireNonNull(compiledVersion);
            if (this.strict) {
                mn = Checks.requireModuleName(mn);
            }
            return this.requires(new Requires(ms, mn, compiledVersion));
        }

        public Builder requires(Set<Requires.Modifier> ms, String mn) {
            if (this.strict) {
                mn = Checks.requireModuleName(mn);
            }
            return this.requires(new Requires(ms, mn, null));
        }

        public Builder requires(String mn) {
            return this.requires(EnumSet.noneOf(Requires.Modifier.class), mn);
        }

        public Builder exports(Exports e) {
            String source = e.source();
            if (this.concealedPackages.contains(source)) {
                throw new IllegalStateException("Package " + source + " already declared");
            }
            if (this.exports.containsKey(source)) {
                throw new IllegalStateException("Exported package " + source + " already declared");
            }
            this.exports.put(source, e);
            return this;
        }

        public Builder exports(Set<Exports.Modifier> ms, String pn, Set<String> targets) {
            Exports e = new Exports(ms, Checks.requirePackageName(pn), targets);
            targets = e.targets();
            if (targets.isEmpty()) {
                throw new IllegalArgumentException("Empty target set");
            }
            if (this.strict) {
                targets.stream().forEach(Checks::requireModuleName);
            }
            return this.exports(e);
        }

        public Builder exports(Set<Exports.Modifier> ms, String pn) {
            Exports e = new Exports(ms, Checks.requirePackageName(pn), Collections.emptySet());
            return this.exports(e);
        }

        public Builder exports(String pn, Set<String> targets) {
            return this.exports(Collections.emptySet(), pn, targets);
        }

        public Builder exports(String pn) {
            return this.exports(Collections.emptySet(), pn);
        }

        public Builder opens(Opens obj) {
            if (this.open) {
                throw new IllegalStateException("open modules cannot declare open packages");
            }
            String source = obj.source();
            if (this.concealedPackages.contains(source)) {
                throw new IllegalStateException("Package " + source + " already declared");
            }
            if (this.opens.containsKey(source)) {
                throw new IllegalStateException("Open package " + source + " already declared");
            }
            this.opens.put(source, obj);
            return this;
        }

        public Builder opens(Set<Opens.Modifier> ms, String pn, Set<String> targets) {
            Opens e = new Opens(ms, Checks.requirePackageName(pn), targets);
            targets = e.targets();
            if (targets.isEmpty()) {
                throw new IllegalArgumentException("Empty target set");
            }
            if (this.strict) {
                targets.stream().forEach(Checks::requireModuleName);
            }
            return this.opens(e);
        }

        public Builder opens(Set<Opens.Modifier> ms, String pn) {
            Opens e = new Opens(ms, Checks.requirePackageName(pn), Collections.emptySet());
            return this.opens(e);
        }

        public Builder opens(String pn, Set<String> targets) {
            return this.opens(Collections.emptySet(), pn, targets);
        }

        public Builder opens(String pn) {
            return this.opens(Collections.emptySet(), pn);
        }

        public Builder uses(String service) {
            if (this.uses.contains(Checks.requireServiceTypeName(service))) {
                throw new IllegalStateException("Dependence upon service " + service + " already declared");
            }
            this.uses.add(service);
            return this;
        }

        public Builder provides(Provides p) {
            String st = p.service();
            if (this.provides.containsKey(st)) {
                throw new IllegalStateException("Providers of service " + st + " already declared");
            }
            this.provides.put(st, p);
            return this;
        }

        public Builder provides(String service, List<String> providers) {
            if (this.provides.containsKey(service)) {
                throw new IllegalStateException("Providers of service " + service + " already declared by " + this.name);
            }
            Provides p = new Provides(Checks.requireServiceTypeName(service), providers);
            List<String> providerNames = p.providers();
            if (providerNames.isEmpty()) {
                throw new IllegalArgumentException("Empty providers set");
            }
            providerNames.forEach(Checks::requireServiceProviderName);
            this.provides.put(service, p);
            return this;
        }

        public Builder provides(String service, String provider) {
            if (provider == null) {
                throw new IllegalArgumentException("'provider' is null");
            }
            return this.provides(service, List.of(provider));
        }

        public Builder contains(Set<String> pns) {
            pns.forEach(this::contains);
            return this;
        }

        public Builder contains(String pn) {
            Checks.requirePackageName(pn);
            if (this.concealedPackages.contains(pn)) {
                throw new IllegalStateException("Package " + pn + " already declared");
            }
            if (this.exports.containsKey(pn)) {
                throw new IllegalStateException("Exported package " + pn + " already declared");
            }
            if (this.opens.containsKey(pn)) {
                throw new IllegalStateException("Open package " + pn + " already declared");
            }
            this.concealedPackages.add(pn);
            return this;
        }

        public Builder version(Version v) {
            this.version = Objects.requireNonNull(v);
            return this;
        }

        public Builder version(String v) {
            return this.version(Version.parse(v));
        }

        public Builder mainClass(String mc) {
            this.mainClass = Checks.requireBinaryName((String)"main class name", (String)mc);
            return this;
        }

        public Builder osName(String name) {
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException("OS name is null or empty");
            }
            this.osName = name;
            return this;
        }

        public Builder osArch(String arch) {
            if (arch == null || arch.isEmpty()) {
                throw new IllegalArgumentException("OS arch is null or empty");
            }
            this.osArch = arch;
            return this;
        }

        public Builder osVersion(String version) {
            if (version == null || version.isEmpty()) {
                throw new IllegalArgumentException("OS version is null or empty");
            }
            this.osVersion = version;
            return this;
        }

        public ModuleDescriptor build() {
            HashSet<Requires> requires = new HashSet<Requires>(this.requires.values());
            HashSet<String> packages = new HashSet<String>();
            packages.addAll(this.exports.keySet());
            packages.addAll(this.opens.keySet());
            packages.addAll(this.concealedPackages);
            HashSet<Exports> exports = new HashSet<Exports>(this.exports.values());
            HashSet<Opens> opens = new HashSet<Opens>(this.opens.values());
            HashSet<Provides> provides = new HashSet<Provides>(this.provides.values());
            return new ModuleDescriptor(this.name, this.version, this.open, this.automatic, this.synthetic, requires, exports, opens, this.uses, provides, packages, this.mainClass, this.osName, this.osArch, this.osVersion);
        }
    }

    public static final class Version
    implements Comparable<Version> {
        private final String version;
        private final List<Object> sequence;
        private final List<Object> pre;
        private final List<Object> build;

        private static int takeNumber(String s, int i, List<Object> acc) {
            char c = s.charAt(i);
            int d = c - 48;
            int n = s.length();
            while (++i < n && (c = s.charAt(i)) >= '0' && c <= '9') {
                d = d * 10 + (c - 48);
            }
            acc.add(d);
            return i;
        }

        private static int takeString(String s, int i, List<Object> acc) {
            char c;
            int b = i;
            int n = s.length();
            while (++i < n && (c = s.charAt(i)) != '.' && c != '-' && c != '+' && (c < '0' || c > '9')) {
            }
            acc.add(s.substring(b, i));
            return i;
        }

        private Version(String v) {
            if (v == null) {
                throw new IllegalArgumentException("Null version string");
            }
            int n = v.length();
            if (n == 0) {
                throw new IllegalArgumentException("Empty version string");
            }
            int i = 0;
            char c = v.charAt(i);
            if (c < '0' || c > '9') {
                throw new IllegalArgumentException(v + ": Version string does not start with a number");
            }
            ArrayList<Object> sequence = new ArrayList<Object>(4);
            ArrayList<Object> pre = new ArrayList<Object>(2);
            ArrayList<Object> build = new ArrayList<Object>(2);
            i = Version.takeNumber(v, i, sequence);
            while (i < n) {
                c = v.charAt(i);
                if (c == '.') {
                    ++i;
                    continue;
                }
                if (c == '-' || c == '+') {
                    ++i;
                    break;
                }
                if (c >= '0' && c <= '9') {
                    i = Version.takeNumber(v, i, sequence);
                    continue;
                }
                i = Version.takeString(v, i, sequence);
            }
            if (c == '-' && i >= n) {
                throw new IllegalArgumentException(v + ": Empty pre-release");
            }
            while (i < n && (i = (c = v.charAt(i)) >= '0' && c <= '9' ? Version.takeNumber(v, i, pre) : Version.takeString(v, i, pre)) < n) {
                c = v.charAt(i);
                if (c == '.' || c == '-') {
                    ++i;
                    continue;
                }
                if (c != '+') continue;
                ++i;
                break;
            }
            if (c == '+' && i >= n) {
                throw new IllegalArgumentException(v + ": Empty pre-release");
            }
            while (i < n && (i = (c = v.charAt(i)) >= '0' && c <= '9' ? Version.takeNumber(v, i, build) : Version.takeString(v, i, build)) < n) {
                c = v.charAt(i);
                if (c != '.' && c != '-' && c != '+') continue;
                ++i;
            }
            this.version = v;
            this.sequence = sequence;
            this.pre = pre;
            this.build = build;
        }

        public static Version parse(String v) {
            return new Version(v);
        }

        private int cmp(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }

        private int compareTokens(List<Object> ts1, List<Object> ts2) {
            int n = Math.min(ts1.size(), ts2.size());
            for (int i = 0; i < n; ++i) {
                int c;
                Object o1 = ts1.get(i);
                Object o2 = ts2.get(i);
                if (o1 instanceof Integer && o2 instanceof Integer || o1 instanceof String && o2 instanceof String) {
                    c = this.cmp(o1, o2);
                    if (c == 0) continue;
                    return c;
                }
                c = o1.toString().compareTo(o2.toString());
                if (c == 0) continue;
                return c;
            }
            List<Object> rest = ts1.size() > ts2.size() ? ts1 : ts2;
            int e = rest.size();
            for (int i = n; i < e; ++i) {
                Object o = rest.get(i);
                if (o instanceof Integer && (Integer)o == 0) continue;
                return ts1.size() - ts2.size();
            }
            return 0;
        }

        @Override
        public int compareTo(Version that) {
            int c = this.compareTokens(this.sequence, that.sequence);
            if (c != 0) {
                return c;
            }
            if (this.pre.isEmpty()) {
                if (!that.pre.isEmpty()) {
                    return 1;
                }
            } else if (that.pre.isEmpty()) {
                return -1;
            }
            if ((c = this.compareTokens(this.pre, that.pre)) != 0) {
                return c;
            }
            return this.compareTokens(this.build, that.build);
        }

        public boolean equals(Object ob) {
            if (!(ob instanceof Version)) {
                return false;
            }
            return this.compareTo((Version)ob) == 0;
        }

        public int hashCode() {
            return this.version.hashCode();
        }

        public String toString() {
            return this.version;
        }
    }

    public static final class Provides {
        private final String service;
        private final List<String> providers;

        private Provides(String service, List<String> providers) {
            this.service = service;
            this.providers = Collections.unmodifiableList(providers);
        }

        private Provides(String service, List<String> providers, boolean unused) {
            this.service = service;
            this.providers = providers;
        }

        public String service() {
            return this.service;
        }

        public List<String> providers() {
            return this.providers;
        }

        public int hashCode() {
            return this.service.hashCode() * 43 + this.providers.hashCode();
        }

        public boolean equals(Object ob) {
            if (!(ob instanceof Provides)) {
                return false;
            }
            Provides other = (Provides)ob;
            return Objects.equals(this.service, other.service) && Objects.equals(this.providers, other.providers);
        }

        public String toString() {
            return this.service + " with " + this.providers;
        }
    }

    public static final class Opens {
        private final Set<Modifier> mods;
        private final String source;
        private final Set<String> targets;

        private Opens(Set<Modifier> ms, String source, Set<String> targets) {
            ms = ms.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(EnumSet.copyOf(ms));
            this.mods = ms;
            this.source = source;
            this.targets = ModuleDescriptor.emptyOrUnmodifiableSet(targets);
        }

        private Opens(Set<Modifier> ms, String source, Set<String> targets, boolean unused) {
            this.mods = ms;
            this.source = source;
            this.targets = targets;
        }

        public Set<Modifier> modifiers() {
            return this.mods;
        }

        public boolean isQualified() {
            return !this.targets.isEmpty();
        }

        public String source() {
            return this.source;
        }

        public Set<String> targets() {
            return this.targets;
        }

        public int hashCode() {
            int hash = this.mods.hashCode();
            hash = hash * 43 + this.source.hashCode();
            return hash * 43 + this.targets.hashCode();
        }

        public boolean equals(Object ob) {
            if (!(ob instanceof Opens)) {
                return false;
            }
            Opens other = (Opens)ob;
            return Objects.equals(this.mods, other.mods) && Objects.equals(this.source, other.source) && Objects.equals(this.targets, other.targets);
        }

        public String toString() {
            String s = ModuleDescriptor.toString(this.mods, this.source);
            if (this.targets.isEmpty()) {
                return s;
            }
            return s + " to " + this.targets;
        }

        public static enum Modifier {
            SYNTHETIC,
            MANDATED;

        }
    }

    public static final class Exports {
        private final Set<Modifier> mods;
        private final String source;
        private final Set<String> targets;

        private Exports(Set<Modifier> ms, String source, Set<String> targets) {
            ms = ms.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(EnumSet.copyOf(ms));
            this.mods = ms;
            this.source = source;
            this.targets = ModuleDescriptor.emptyOrUnmodifiableSet(targets);
        }

        private Exports(Set<Modifier> ms, String source, Set<String> targets, boolean unused) {
            this.mods = ms;
            this.source = source;
            this.targets = targets;
        }

        public Set<Modifier> modifiers() {
            return this.mods;
        }

        public boolean isQualified() {
            return !this.targets.isEmpty();
        }

        public String source() {
            return this.source;
        }

        public Set<String> targets() {
            return this.targets;
        }

        public int hashCode() {
            int hash = this.mods.hashCode();
            hash = hash * 43 + this.source.hashCode();
            return hash * 43 + this.targets.hashCode();
        }

        public boolean equals(Object ob) {
            if (!(ob instanceof Exports)) {
                return false;
            }
            Exports other = (Exports)ob;
            return Objects.equals(this.mods, other.mods) && Objects.equals(this.source, other.source) && Objects.equals(this.targets, other.targets);
        }

        public String toString() {
            String s = ModuleDescriptor.toString(this.mods, this.source);
            if (this.targets.isEmpty()) {
                return s;
            }
            return s + " to " + this.targets;
        }

        public static enum Modifier {
            SYNTHETIC,
            MANDATED;

        }
    }

    public static final class Requires
    implements Comparable<Requires> {
        private final Set<Modifier> mods;
        private final String name;
        private final Version compiledVersion;

        private Requires(Set<Modifier> ms, String mn, Version v) {
            ms = ms.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(EnumSet.copyOf(ms));
            this.mods = ms;
            this.name = mn;
            this.compiledVersion = v;
        }

        private Requires(Set<Modifier> ms, String mn, Version v, boolean unused) {
            this.mods = ms;
            this.name = mn;
            this.compiledVersion = v;
        }

        public Set<Modifier> modifiers() {
            return this.mods;
        }

        public String name() {
            return this.name;
        }

        public Optional<Version> compiledVersion() {
            return Optional.ofNullable(this.compiledVersion);
        }

        @Override
        public int compareTo(Requires that) {
            int c = this.name().compareTo(that.name());
            if (c != 0) {
                return c;
            }
            c = Long.compare(this.modsValue(), that.modsValue());
            if (c != 0) {
                return c;
            }
            if (this.compiledVersion != null) {
                c = that.compiledVersion != null ? this.compiledVersion.compareTo(that.compiledVersion) : 1;
            } else if (that.compiledVersion != null) {
                c = -1;
            }
            return c;
        }

        private long modsValue() {
            long value = 0L;
            for (Modifier m : this.mods) {
                value += (long)(1 << m.ordinal());
            }
            return value;
        }

        public boolean equals(Object ob) {
            if (!(ob instanceof Requires)) {
                return false;
            }
            Requires that = (Requires)ob;
            return this.name.equals(that.name) && this.mods.equals(that.mods) && Objects.equals(this.compiledVersion, that.compiledVersion);
        }

        public int hashCode() {
            int hash = this.name.hashCode() * 43 + this.mods.hashCode();
            if (this.compiledVersion != null) {
                hash = hash * 43 + this.compiledVersion.hashCode();
            }
            return hash;
        }

        public String toString() {
            String what = this.compiledVersion != null ? this.name() + " (@" + this.compiledVersion + ")" : this.name();
            return ModuleDescriptor.toString(this.mods, what);
        }

        public static enum Modifier {
            TRANSITIVE,
            STATIC,
            SYNTHETIC,
            MANDATED;

        }
    }
}

