/*
 * Decompiled with CFR 0.152.
 */
package java.lang.module;

import java.io.PrintStream;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.lang.module.Resolver;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Configuration {
    private static final Configuration EMPTY_CONFIGURATION = new Configuration();
    private final List<Configuration> parents;
    private final Map<ResolvedModule, Set<ResolvedModule>> graph;
    private final Set<ResolvedModule> modules;
    private final Map<String, ResolvedModule> nameToModule;
    private volatile List<Configuration> allConfigurations;

    private Configuration() {
        this.parents = Collections.emptyList();
        this.graph = Collections.emptyMap();
        this.modules = Collections.emptySet();
        this.nameToModule = Collections.emptyMap();
    }

    private Configuration(List<Configuration> parents, Resolver resolver, boolean check) {
        Map<ResolvedModule, Set<ResolvedModule>> g = resolver.finish(this, check);
        Map.Entry[] nameEntries = new Map.Entry[g.size()];
        ResolvedModule[] moduleArray = new ResolvedModule[g.size()];
        int i = 0;
        Iterator<ResolvedModule> iterator = g.keySet().iterator();
        while (iterator.hasNext()) {
            ResolvedModule resolvedModule;
            moduleArray[i] = resolvedModule = iterator.next();
            nameEntries[i] = Map.entry(resolvedModule.name(), resolvedModule);
            ++i;
        }
        this.parents = Collections.unmodifiableList(parents);
        this.graph = g;
        this.modules = Set.of(moduleArray);
        this.nameToModule = Map.ofEntries(nameEntries);
    }

    public Configuration resolveRequires(ModuleFinder before, ModuleFinder after, Collection<String> roots) {
        return Configuration.resolveRequires(before, List.of(this), after, roots);
    }

    public Configuration resolveRequiresAndUses(ModuleFinder before, ModuleFinder after, Collection<String> roots) {
        return Configuration.resolveRequiresAndUses(before, List.of(this), after, roots);
    }

    static Configuration resolveRequiresAndUses(ModuleFinder finder, Collection<String> roots, boolean check, PrintStream traceOutput) {
        List<Configuration> parents = List.of(Configuration.empty());
        Resolver resolver = new Resolver(finder, parents, ModuleFinder.of(new Path[0]), traceOutput);
        resolver.resolveRequires(roots).resolveUses();
        return new Configuration(parents, resolver, check);
    }

    public static Configuration resolveRequires(ModuleFinder before, List<Configuration> parents, ModuleFinder after, Collection<String> roots) {
        Objects.requireNonNull(before);
        Objects.requireNonNull(after);
        Objects.requireNonNull(roots);
        ArrayList<Configuration> parentList = new ArrayList<Configuration>(parents);
        if (parentList.isEmpty()) {
            throw new IllegalArgumentException("'parents' is empty");
        }
        Resolver resolver = new Resolver(before, parentList, after, null);
        resolver.resolveRequires(roots);
        return new Configuration(parentList, resolver, true);
    }

    public static Configuration resolveRequiresAndUses(ModuleFinder before, List<Configuration> parents, ModuleFinder after, Collection<String> roots) {
        Objects.requireNonNull(before);
        Objects.requireNonNull(after);
        Objects.requireNonNull(roots);
        ArrayList<Configuration> parentList = new ArrayList<Configuration>(parents);
        if (parentList.isEmpty()) {
            throw new IllegalArgumentException("'parents' is empty");
        }
        Resolver resolver = new Resolver(before, parentList, after, null);
        resolver.resolveRequires(roots).resolveUses();
        return new Configuration(parentList, resolver, true);
    }

    public static Configuration empty() {
        return EMPTY_CONFIGURATION;
    }

    public List<Configuration> parents() {
        return this.parents;
    }

    public Set<ResolvedModule> modules() {
        return this.modules;
    }

    public Optional<ResolvedModule> findModule(String name) {
        Objects.requireNonNull(name);
        ResolvedModule m = this.nameToModule.get(name);
        if (m != null) {
            return Optional.of(m);
        }
        if (!this.parents.isEmpty()) {
            return this.configurations().skip(1L).map(cf -> cf.nameToModule).filter(map -> map.containsKey(name)).map(map -> (ResolvedModule)map.get(name)).findFirst();
        }
        return Optional.empty();
    }

    Set<ModuleDescriptor> descriptors() {
        if (this.modules.isEmpty()) {
            return Collections.emptySet();
        }
        return this.modules.stream().map(ResolvedModule::reference).map(ModuleReference::descriptor).collect(Collectors.toSet());
    }

    Set<ResolvedModule> reads(ResolvedModule m) {
        return Collections.unmodifiableSet(this.graph.get(m));
    }

    Stream<Configuration> configurations() {
        List<Configuration> allConfigurations = this.allConfigurations;
        if (allConfigurations == null) {
            allConfigurations = new ArrayList<Configuration>();
            HashSet<Configuration> visited = new HashSet<Configuration>();
            ArrayDeque<Configuration> stack = new ArrayDeque<Configuration>();
            visited.add(this);
            stack.push(this);
            while (!stack.isEmpty()) {
                Configuration layer = (Configuration)stack.pop();
                allConfigurations.add(layer);
                for (int i = layer.parents.size() - 1; i >= 0; --i) {
                    Configuration parent = layer.parents.get(i);
                    if (visited.contains(parent)) continue;
                    visited.add(parent);
                    stack.push(parent);
                }
            }
            this.allConfigurations = Collections.unmodifiableList(allConfigurations);
        }
        return allConfigurations.stream();
    }

    public String toString() {
        return this.modules().stream().map(ResolvedModule::name).collect(Collectors.joining(", "));
    }
}

