/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.VarHandle;
import java.lang.invoke.VarHandleBooleans;
import java.lang.invoke.VarHandleByteArrayAsChars;
import java.lang.invoke.VarHandleByteArrayAsDoubles;
import java.lang.invoke.VarHandleByteArrayAsFloats;
import java.lang.invoke.VarHandleByteArrayAsInts;
import java.lang.invoke.VarHandleByteArrayAsLongs;
import java.lang.invoke.VarHandleByteArrayAsShorts;
import java.lang.invoke.VarHandleBytes;
import java.lang.invoke.VarHandleChars;
import java.lang.invoke.VarHandleDoubles;
import java.lang.invoke.VarHandleFloats;
import java.lang.invoke.VarHandleInts;
import java.lang.invoke.VarHandleLongs;
import java.lang.invoke.VarHandleObjects;
import java.lang.invoke.VarHandleShorts;

final class VarHandles {
    VarHandles() {
    }

    static VarHandle makeFieldHandle(MemberName f, Class<?> refc, Class<?> type, boolean isWriteAllowedOnFinalFields) {
        if (!f.isStatic()) {
            long foffset = MethodHandleNatives.objectFieldOffset(f);
            if (!type.isPrimitive()) {
                return f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleObjects.FieldInstanceReadOnly(refc, foffset, type) : new VarHandleObjects.FieldInstanceReadWrite(refc, foffset, type);
            }
            if (type == Boolean.TYPE) {
                return f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleBooleans.FieldInstanceReadOnly(refc, foffset) : new VarHandleBooleans.FieldInstanceReadWrite(refc, foffset);
            }
            if (type == Byte.TYPE) {
                return f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleBytes.FieldInstanceReadOnly(refc, foffset) : new VarHandleBytes.FieldInstanceReadWrite(refc, foffset);
            }
            if (type == Short.TYPE) {
                return f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleShorts.FieldInstanceReadOnly(refc, foffset) : new VarHandleShorts.FieldInstanceReadWrite(refc, foffset);
            }
            if (type == Character.TYPE) {
                return f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleChars.FieldInstanceReadOnly(refc, foffset) : new VarHandleChars.FieldInstanceReadWrite(refc, foffset);
            }
            if (type == Integer.TYPE) {
                return f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleInts.FieldInstanceReadOnly(refc, foffset) : new VarHandleInts.FieldInstanceReadWrite(refc, foffset);
            }
            if (type == Long.TYPE) {
                return f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleLongs.FieldInstanceReadOnly(refc, foffset) : new VarHandleLongs.FieldInstanceReadWrite(refc, foffset);
            }
            if (type == Float.TYPE) {
                return f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleFloats.FieldInstanceReadOnly(refc, foffset) : new VarHandleFloats.FieldInstanceReadWrite(refc, foffset);
            }
            if (type == Double.TYPE) {
                return f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleDoubles.FieldInstanceReadOnly(refc, foffset) : new VarHandleDoubles.FieldInstanceReadWrite(refc, foffset);
            }
            throw new UnsupportedOperationException();
        }
        if (MethodHandleStatics.UNSAFE.shouldBeInitialized(refc)) {
            MethodHandleStatics.UNSAFE.ensureClassInitialized(refc);
        }
        Object base = MethodHandleNatives.staticFieldBase(f);
        long foffset = MethodHandleNatives.staticFieldOffset(f);
        if (!type.isPrimitive()) {
            return f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleObjects.FieldStaticReadOnly(base, foffset, type) : new VarHandleObjects.FieldStaticReadWrite(base, foffset, type);
        }
        if (type == Boolean.TYPE) {
            return f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleBooleans.FieldStaticReadOnly(base, foffset) : new VarHandleBooleans.FieldStaticReadWrite(base, foffset);
        }
        if (type == Byte.TYPE) {
            return f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleBytes.FieldStaticReadOnly(base, foffset) : new VarHandleBytes.FieldStaticReadWrite(base, foffset);
        }
        if (type == Short.TYPE) {
            return f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleShorts.FieldStaticReadOnly(base, foffset) : new VarHandleShorts.FieldStaticReadWrite(base, foffset);
        }
        if (type == Character.TYPE) {
            return f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleChars.FieldStaticReadOnly(base, foffset) : new VarHandleChars.FieldStaticReadWrite(base, foffset);
        }
        if (type == Integer.TYPE) {
            return f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleInts.FieldStaticReadOnly(base, foffset) : new VarHandleInts.FieldStaticReadWrite(base, foffset);
        }
        if (type == Long.TYPE) {
            return f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleLongs.FieldStaticReadOnly(base, foffset) : new VarHandleLongs.FieldStaticReadWrite(base, foffset);
        }
        if (type == Float.TYPE) {
            return f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleFloats.FieldStaticReadOnly(base, foffset) : new VarHandleFloats.FieldStaticReadWrite(base, foffset);
        }
        if (type == Double.TYPE) {
            return f.isFinal() && !isWriteAllowedOnFinalFields ? new VarHandleDoubles.FieldStaticReadOnly(base, foffset) : new VarHandleDoubles.FieldStaticReadWrite(base, foffset);
        }
        throw new UnsupportedOperationException();
    }

    static VarHandle makeArrayElementHandle(Class<?> arrayClass) {
        if (!arrayClass.isArray()) {
            throw new IllegalArgumentException("not an array: " + arrayClass);
        }
        Class<?> componentType = arrayClass.getComponentType();
        int aoffset = MethodHandleStatics.UNSAFE.arrayBaseOffset(arrayClass);
        int ascale = MethodHandleStatics.UNSAFE.arrayIndexScale(arrayClass);
        int ashift = 31 - Integer.numberOfLeadingZeros(ascale);
        if (!componentType.isPrimitive()) {
            return new VarHandleObjects.Array(aoffset, ashift, arrayClass);
        }
        if (componentType == Boolean.TYPE) {
            return new VarHandleBooleans.Array(aoffset, ashift);
        }
        if (componentType == Byte.TYPE) {
            return new VarHandleBytes.Array(aoffset, ashift);
        }
        if (componentType == Short.TYPE) {
            return new VarHandleShorts.Array(aoffset, ashift);
        }
        if (componentType == Character.TYPE) {
            return new VarHandleChars.Array(aoffset, ashift);
        }
        if (componentType == Integer.TYPE) {
            return new VarHandleInts.Array(aoffset, ashift);
        }
        if (componentType == Long.TYPE) {
            return new VarHandleLongs.Array(aoffset, ashift);
        }
        if (componentType == Float.TYPE) {
            return new VarHandleFloats.Array(aoffset, ashift);
        }
        if (componentType == Double.TYPE) {
            return new VarHandleDoubles.Array(aoffset, ashift);
        }
        throw new UnsupportedOperationException();
    }

    static VarHandle byteArrayViewHandle(Class<?> viewArrayClass, boolean be) {
        if (!viewArrayClass.isArray()) {
            throw new IllegalArgumentException("not an array: " + viewArrayClass);
        }
        Class<?> viewComponentType = viewArrayClass.getComponentType();
        if (viewComponentType == Long.TYPE) {
            return new VarHandleByteArrayAsLongs.ArrayHandle(be);
        }
        if (viewComponentType == Integer.TYPE) {
            return new VarHandleByteArrayAsInts.ArrayHandle(be);
        }
        if (viewComponentType == Short.TYPE) {
            return new VarHandleByteArrayAsShorts.ArrayHandle(be);
        }
        if (viewComponentType == Character.TYPE) {
            return new VarHandleByteArrayAsChars.ArrayHandle(be);
        }
        if (viewComponentType == Double.TYPE) {
            return new VarHandleByteArrayAsDoubles.ArrayHandle(be);
        }
        if (viewComponentType == Float.TYPE) {
            return new VarHandleByteArrayAsFloats.ArrayHandle(be);
        }
        throw new UnsupportedOperationException();
    }

    static VarHandle makeByteBufferViewHandle(Class<?> viewArrayClass, boolean be) {
        if (!viewArrayClass.isArray()) {
            throw new IllegalArgumentException("not an array: " + viewArrayClass);
        }
        Class<?> viewComponentType = viewArrayClass.getComponentType();
        if (viewComponentType == Long.TYPE) {
            return new VarHandleByteArrayAsLongs.ByteBufferHandle(be);
        }
        if (viewComponentType == Integer.TYPE) {
            return new VarHandleByteArrayAsInts.ByteBufferHandle(be);
        }
        if (viewComponentType == Short.TYPE) {
            return new VarHandleByteArrayAsShorts.ByteBufferHandle(be);
        }
        if (viewComponentType == Character.TYPE) {
            return new VarHandleByteArrayAsChars.ByteBufferHandle(be);
        }
        if (viewComponentType == Double.TYPE) {
            return new VarHandleByteArrayAsDoubles.ByteBufferHandle(be);
        }
        if (viewComponentType == Float.TYPE) {
            return new VarHandleByteArrayAsFloats.ByteBufferHandle(be);
        }
        throw new UnsupportedOperationException();
    }
}

