/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import jdk.internal.util.Preconditions;
import jdk.internal.vm.annotation.ForceInline;

final class VarHandleShorts {
    VarHandleShorts() {
    }

    static final class Array
    extends VarHandle {
        final int abase;
        final int ashift;
        static final VarForm FORM = new VarForm(Array.class, short[].class, Short.TYPE, Integer.TYPE);

        Array(int abase, int ashift) {
            super(FORM);
            this.abase = abase;
            this.ashift = ashift;
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(short[].class, Short.TYPE, Integer.TYPE);
        }

        @ForceInline
        static short get(Array handle, Object oarray, int index) {
            short[] array = (short[])oarray;
            return array[index];
        }

        @ForceInline
        static void set(Array handle, Object oarray, int index, short value) {
            short[] array = (short[])oarray;
            array[index] = value;
        }

        @ForceInline
        static short getVolatile(Array handle, Object oarray, int index) {
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getShortVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setVolatile(Array handle, Object oarray, int index, short value) {
            short[] array = (short[])oarray;
            MethodHandleStatics.UNSAFE.putShortVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getOpaque(Array handle, Object oarray, int index) {
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getShortOpaque(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setOpaque(Array handle, Object oarray, int index, short value) {
            short[] array = (short[])oarray;
            MethodHandleStatics.UNSAFE.putShortOpaque(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAcquire(Array handle, Object oarray, int index) {
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getShortAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setRelease(Array handle, Object oarray, int index, short value) {
            short[] array = (short[])oarray;
            MethodHandleStatics.UNSAFE.putShortRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean compareAndSet(Array handle, Object oarray, int index, short expected, short value) {
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndSwapShort(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static short compareAndExchange(Array handle, Object oarray, int index, short expected, short value) {
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeShortVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static short compareAndExchangeAcquire(Array handle, Object oarray, int index, short expected, short value) {
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeShortAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static short compareAndExchangeRelease(Array handle, Object oarray, int index, short expected, short value) {
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeShortRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(Array handle, Object oarray, int index, short expected, short value) {
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapShort(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(Array handle, Object oarray, int index, short expected, short value) {
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapShortVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(Array handle, Object oarray, int index, short expected, short value) {
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapShortAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(Array handle, Object oarray, int index, short expected, short value) {
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapShortRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static short getAndSet(Array handle, Object oarray, int index, short value) {
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetShort(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAndSetAcquire(Array handle, Object oarray, int index, short value) {
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetShortAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAndSetRelease(Array handle, Object oarray, int index, short value) {
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetShortRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAndAdd(Array handle, Object oarray, int index, short value) {
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddShort(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAndAddAcquire(Array handle, Object oarray, int index, short value) {
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddShortAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAndAddRelease(Array handle, Object oarray, int index, short value) {
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddShortRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAndBitwiseOr(Array handle, Object oarray, int index, short value) {
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrShort(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAndBitwiseOrRelease(Array handle, Object oarray, int index, short value) {
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrShortRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAndBitwiseOrAcquire(Array handle, Object oarray, int index, short value) {
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrShortAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAndBitwiseAnd(Array handle, Object oarray, int index, short value) {
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndShort(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAndBitwiseAndRelease(Array handle, Object oarray, int index, short value) {
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndShortRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAndBitwiseAndAcquire(Array handle, Object oarray, int index, short value) {
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndShortAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAndBitwiseXor(Array handle, Object oarray, int index, short value) {
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorShort(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAndBitwiseXorRelease(Array handle, Object oarray, int index, short value) {
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorShortRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static short getAndBitwiseXorAcquire(Array handle, Object oarray, int index, short value) {
            short[] array = (short[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorShortAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }
    }

    static final class FieldStaticReadWrite
    extends FieldStaticReadOnly {
        static final VarForm FORM = new VarForm(FieldStaticReadWrite.class, null, Short.TYPE, new Class[0]);

        FieldStaticReadWrite(Object base, long fieldOffset) {
            super(base, fieldOffset, FORM);
        }

        @ForceInline
        static void set(FieldStaticReadWrite handle, short value) {
            MethodHandleStatics.UNSAFE.putShort(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setVolatile(FieldStaticReadWrite handle, short value) {
            MethodHandleStatics.UNSAFE.putShortVolatile(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setOpaque(FieldStaticReadWrite handle, short value) {
            MethodHandleStatics.UNSAFE.putShortOpaque(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setRelease(FieldStaticReadWrite handle, short value) {
            MethodHandleStatics.UNSAFE.putShortRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean compareAndSet(FieldStaticReadWrite handle, short expected, short value) {
            return MethodHandleStatics.UNSAFE.compareAndSwapShort(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static short compareAndExchange(FieldStaticReadWrite handle, short expected, short value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeShortVolatile(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static short compareAndExchangeAcquire(FieldStaticReadWrite handle, short expected, short value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeShortAcquire(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static short compareAndExchangeRelease(FieldStaticReadWrite handle, short expected, short value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeShortRelease(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(FieldStaticReadWrite handle, short expected, short value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapShort(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(FieldStaticReadWrite handle, short expected, short value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapShortVolatile(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(FieldStaticReadWrite handle, short expected, short value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapShortAcquire(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(FieldStaticReadWrite handle, short expected, short value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapShortRelease(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static short getAndSet(FieldStaticReadWrite handle, short value) {
            return MethodHandleStatics.UNSAFE.getAndSetShort(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndSetAcquire(FieldStaticReadWrite handle, short value) {
            return MethodHandleStatics.UNSAFE.getAndSetShortAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndSetRelease(FieldStaticReadWrite handle, short value) {
            return MethodHandleStatics.UNSAFE.getAndSetShortRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndAdd(FieldStaticReadWrite handle, short value) {
            return MethodHandleStatics.UNSAFE.getAndAddShort(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndAddAcquire(FieldStaticReadWrite handle, short value) {
            return MethodHandleStatics.UNSAFE.getAndAddShortAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndAddRelease(FieldStaticReadWrite handle, short value) {
            return MethodHandleStatics.UNSAFE.getAndAddShortRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseOr(FieldStaticReadWrite handle, short value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrShort(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseOrRelease(FieldStaticReadWrite handle, short value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrShortRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseOrAcquire(FieldStaticReadWrite handle, short value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrShortAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseAnd(FieldStaticReadWrite handle, short value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndShort(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseAndRelease(FieldStaticReadWrite handle, short value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndShortRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseAndAcquire(FieldStaticReadWrite handle, short value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndShortAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseXor(FieldStaticReadWrite handle, short value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorShort(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseXorRelease(FieldStaticReadWrite handle, short value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorShortRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseXorAcquire(FieldStaticReadWrite handle, short value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorShortAcquire(handle.base, handle.fieldOffset, value);
        }
    }

    static class FieldStaticReadOnly
    extends VarHandle {
        final Object base;
        final long fieldOffset;
        static final VarForm FORM = new VarForm(FieldStaticReadOnly.class, null, Short.TYPE, new Class[0]);

        FieldStaticReadOnly(Object base, long fieldOffset) {
            this(base, fieldOffset, FORM);
        }

        protected FieldStaticReadOnly(Object base, long fieldOffset, VarForm form) {
            super(form);
            this.base = base;
            this.fieldOffset = fieldOffset;
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(null, Short.TYPE, new Class[0]);
        }

        @ForceInline
        static short get(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getShort(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static short getVolatile(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getShortVolatile(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static short getOpaque(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getShortOpaque(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static short getAcquire(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getShortAcquire(handle.base, handle.fieldOffset);
        }
    }

    static final class FieldInstanceReadWrite
    extends FieldInstanceReadOnly {
        static final VarForm FORM = new VarForm(FieldInstanceReadWrite.class, Object.class, Short.TYPE, new Class[0]);

        FieldInstanceReadWrite(Class<?> receiverType, long fieldOffset) {
            super(receiverType, fieldOffset, FORM);
        }

        @ForceInline
        static void set(FieldInstanceReadWrite handle, Object holder, short value) {
            MethodHandleStatics.UNSAFE.putShort(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setVolatile(FieldInstanceReadWrite handle, Object holder, short value) {
            MethodHandleStatics.UNSAFE.putShortVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setOpaque(FieldInstanceReadWrite handle, Object holder, short value) {
            MethodHandleStatics.UNSAFE.putShortOpaque(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setRelease(FieldInstanceReadWrite handle, Object holder, short value) {
            MethodHandleStatics.UNSAFE.putShortRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean compareAndSet(FieldInstanceReadWrite handle, Object holder, short expected, short value) {
            return MethodHandleStatics.UNSAFE.compareAndSwapShort(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static short compareAndExchange(FieldInstanceReadWrite handle, Object holder, short expected, short value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeShortVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static short compareAndExchangeAcquire(FieldInstanceReadWrite handle, Object holder, short expected, short value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeShortAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static short compareAndExchangeRelease(FieldInstanceReadWrite handle, Object holder, short expected, short value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeShortRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(FieldInstanceReadWrite handle, Object holder, short expected, short value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapShort(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(FieldInstanceReadWrite handle, Object holder, short expected, short value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapShortVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(FieldInstanceReadWrite handle, Object holder, short expected, short value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapShortAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(FieldInstanceReadWrite handle, Object holder, short expected, short value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapShortRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static short getAndSet(FieldInstanceReadWrite handle, Object holder, short value) {
            return MethodHandleStatics.UNSAFE.getAndSetShort(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndSetAcquire(FieldInstanceReadWrite handle, Object holder, short value) {
            return MethodHandleStatics.UNSAFE.getAndSetShortAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndSetRelease(FieldInstanceReadWrite handle, Object holder, short value) {
            return MethodHandleStatics.UNSAFE.getAndSetShortRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndAdd(FieldInstanceReadWrite handle, Object holder, short value) {
            return MethodHandleStatics.UNSAFE.getAndAddShort(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndAddAcquire(FieldInstanceReadWrite handle, Object holder, short value) {
            return MethodHandleStatics.UNSAFE.getAndAddShortAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndAddRelease(FieldInstanceReadWrite handle, Object holder, short value) {
            return MethodHandleStatics.UNSAFE.getAndAddShortRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseOr(FieldInstanceReadWrite handle, Object holder, short value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrShort(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseOrRelease(FieldInstanceReadWrite handle, Object holder, short value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrShortRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseOrAcquire(FieldInstanceReadWrite handle, Object holder, short value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrShortAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseAnd(FieldInstanceReadWrite handle, Object holder, short value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndShort(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseAndRelease(FieldInstanceReadWrite handle, Object holder, short value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndShortRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseAndAcquire(FieldInstanceReadWrite handle, Object holder, short value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndShortAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseXor(FieldInstanceReadWrite handle, Object holder, short value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorShort(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseXorRelease(FieldInstanceReadWrite handle, Object holder, short value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorShortRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static short getAndBitwiseXorAcquire(FieldInstanceReadWrite handle, Object holder, short value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorShortAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }
    }

    static class FieldInstanceReadOnly
    extends VarHandle {
        final long fieldOffset;
        final Class<?> receiverType;
        static final VarForm FORM = new VarForm(FieldInstanceReadOnly.class, Object.class, Short.TYPE, new Class[0]);

        FieldInstanceReadOnly(Class<?> receiverType, long fieldOffset) {
            this(receiverType, fieldOffset, FORM);
        }

        protected FieldInstanceReadOnly(Class<?> receiverType, long fieldOffset, VarForm form) {
            super(form);
            this.fieldOffset = fieldOffset;
            this.receiverType = receiverType;
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(this.receiverType, Short.TYPE, new Class[0]);
        }

        @ForceInline
        static short get(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getShort(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static short getVolatile(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getShortVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static short getOpaque(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getShortOpaque(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static short getAcquire(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getShortAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }
    }
}

