/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import jdk.internal.util.Preconditions;
import jdk.internal.vm.annotation.ForceInline;

final class VarHandleObjects {
    VarHandleObjects() {
    }

    static final class Array
    extends VarHandle {
        final int abase;
        final int ashift;
        final Class<?> arrayType;
        final Class<?> componentType;
        static final VarForm FORM = new VarForm(Array.class, Object[].class, Object.class, Integer.TYPE);

        Array(int abase, int ashift, Class<?> arrayType) {
            super(FORM);
            this.abase = abase;
            this.ashift = ashift;
            this.arrayType = arrayType;
            this.componentType = arrayType.getComponentType();
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(this.arrayType, this.arrayType.getComponentType(), Integer.TYPE);
        }

        @ForceInline
        static Object get(Array handle, Object oarray, int index) {
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return array[index];
        }

        @ForceInline
        static void set(Array handle, Object oarray, int index, Object value) {
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            array[index] = handle.componentType.cast(value);
        }

        @ForceInline
        static Object getVolatile(Array handle, Object oarray, int index) {
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return MethodHandleStatics.UNSAFE.getObjectVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setVolatile(Array handle, Object oarray, int index, Object value) {
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            MethodHandleStatics.UNSAFE.putObjectVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, handle.componentType.cast(value));
        }

        @ForceInline
        static Object getOpaque(Array handle, Object oarray, int index) {
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return MethodHandleStatics.UNSAFE.getObjectOpaque(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setOpaque(Array handle, Object oarray, int index, Object value) {
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            MethodHandleStatics.UNSAFE.putObjectOpaque(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, handle.componentType.cast(value));
        }

        @ForceInline
        static Object getAcquire(Array handle, Object oarray, int index) {
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return MethodHandleStatics.UNSAFE.getObjectAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setRelease(Array handle, Object oarray, int index, Object value) {
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            MethodHandleStatics.UNSAFE.putObjectRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, handle.componentType.cast(value));
        }

        @ForceInline
        static boolean compareAndSet(Array handle, Object oarray, int index, Object expected, Object value) {
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return MethodHandleStatics.UNSAFE.compareAndSwapObject(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, handle.componentType.cast(expected), handle.componentType.cast(value));
        }

        @ForceInline
        static Object compareAndExchange(Array handle, Object oarray, int index, Object expected, Object value) {
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return MethodHandleStatics.UNSAFE.compareAndExchangeObjectVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, handle.componentType.cast(expected), handle.componentType.cast(value));
        }

        @ForceInline
        static Object compareAndExchangeAcquire(Array handle, Object oarray, int index, Object expected, Object value) {
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return MethodHandleStatics.UNSAFE.compareAndExchangeObjectAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, handle.componentType.cast(expected), handle.componentType.cast(value));
        }

        @ForceInline
        static Object compareAndExchangeRelease(Array handle, Object oarray, int index, Object expected, Object value) {
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return MethodHandleStatics.UNSAFE.compareAndExchangeObjectRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, handle.componentType.cast(expected), handle.componentType.cast(value));
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(Array handle, Object oarray, int index, Object expected, Object value) {
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapObject(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, handle.componentType.cast(expected), handle.componentType.cast(value));
        }

        @ForceInline
        static boolean weakCompareAndSet(Array handle, Object oarray, int index, Object expected, Object value) {
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapObjectVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, handle.componentType.cast(expected), handle.componentType.cast(value));
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(Array handle, Object oarray, int index, Object expected, Object value) {
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapObjectAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, handle.componentType.cast(expected), handle.componentType.cast(value));
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(Array handle, Object oarray, int index, Object expected, Object value) {
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapObjectRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, handle.componentType.cast(expected), handle.componentType.cast(value));
        }

        @ForceInline
        static Object getAndSet(Array handle, Object oarray, int index, Object value) {
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return MethodHandleStatics.UNSAFE.getAndSetObject(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, handle.componentType.cast(value));
        }

        @ForceInline
        static Object getAndSetAcquire(Array handle, Object oarray, int index, Object value) {
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return MethodHandleStatics.UNSAFE.getAndSetObjectAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, handle.componentType.cast(value));
        }

        @ForceInline
        static Object getAndSetRelease(Array handle, Object oarray, int index, Object value) {
            Object[] array = (Object[])handle.arrayType.cast(oarray);
            return MethodHandleStatics.UNSAFE.getAndSetObjectRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, handle.componentType.cast(value));
        }
    }

    static final class FieldStaticReadWrite
    extends FieldStaticReadOnly {
        static final VarForm FORM = new VarForm(FieldStaticReadWrite.class, null, Object.class, new Class[0]);

        FieldStaticReadWrite(Object base, long fieldOffset, Class<?> fieldType) {
            super(base, fieldOffset, fieldType, FORM);
        }

        @ForceInline
        static void set(FieldStaticReadWrite handle, Object value) {
            MethodHandleStatics.UNSAFE.putObject(handle.base, handle.fieldOffset, handle.fieldType.cast(value));
        }

        @ForceInline
        static void setVolatile(FieldStaticReadWrite handle, Object value) {
            MethodHandleStatics.UNSAFE.putObjectVolatile(handle.base, handle.fieldOffset, handle.fieldType.cast(value));
        }

        @ForceInline
        static void setOpaque(FieldStaticReadWrite handle, Object value) {
            MethodHandleStatics.UNSAFE.putObjectOpaque(handle.base, handle.fieldOffset, handle.fieldType.cast(value));
        }

        @ForceInline
        static void setRelease(FieldStaticReadWrite handle, Object value) {
            MethodHandleStatics.UNSAFE.putObjectRelease(handle.base, handle.fieldOffset, handle.fieldType.cast(value));
        }

        @ForceInline
        static boolean compareAndSet(FieldStaticReadWrite handle, Object expected, Object value) {
            return MethodHandleStatics.UNSAFE.compareAndSwapObject(handle.base, handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static Object compareAndExchange(FieldStaticReadWrite handle, Object expected, Object value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeObjectVolatile(handle.base, handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static Object compareAndExchangeAcquire(FieldStaticReadWrite handle, Object expected, Object value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeObjectAcquire(handle.base, handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static Object compareAndExchangeRelease(FieldStaticReadWrite handle, Object expected, Object value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeObjectRelease(handle.base, handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(FieldStaticReadWrite handle, Object expected, Object value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapObject(handle.base, handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static boolean weakCompareAndSet(FieldStaticReadWrite handle, Object expected, Object value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapObjectVolatile(handle.base, handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(FieldStaticReadWrite handle, Object expected, Object value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapObjectAcquire(handle.base, handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(FieldStaticReadWrite handle, Object expected, Object value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapObjectRelease(handle.base, handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static Object getAndSet(FieldStaticReadWrite handle, Object value) {
            return MethodHandleStatics.UNSAFE.getAndSetObject(handle.base, handle.fieldOffset, handle.fieldType.cast(value));
        }

        @ForceInline
        static Object getAndSetAcquire(FieldStaticReadWrite handle, Object value) {
            return MethodHandleStatics.UNSAFE.getAndSetObjectAcquire(handle.base, handle.fieldOffset, handle.fieldType.cast(value));
        }

        @ForceInline
        static Object getAndSetRelease(FieldStaticReadWrite handle, Object value) {
            return MethodHandleStatics.UNSAFE.getAndSetObjectRelease(handle.base, handle.fieldOffset, handle.fieldType.cast(value));
        }
    }

    static class FieldStaticReadOnly
    extends VarHandle {
        final Object base;
        final long fieldOffset;
        final Class<?> fieldType;
        static final VarForm FORM = new VarForm(FieldStaticReadOnly.class, null, Object.class, new Class[0]);

        FieldStaticReadOnly(Object base, long fieldOffset, Class<?> fieldType) {
            this(base, fieldOffset, fieldType, FORM);
        }

        protected FieldStaticReadOnly(Object base, long fieldOffset, Class<?> fieldType, VarForm form) {
            super(form);
            this.base = base;
            this.fieldOffset = fieldOffset;
            this.fieldType = fieldType;
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(null, this.fieldType, new Class[0]);
        }

        @ForceInline
        static Object get(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getObject(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static Object getVolatile(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getObjectVolatile(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static Object getOpaque(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getObjectOpaque(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static Object getAcquire(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getObjectAcquire(handle.base, handle.fieldOffset);
        }
    }

    static final class FieldInstanceReadWrite
    extends FieldInstanceReadOnly {
        static final VarForm FORM = new VarForm(FieldInstanceReadWrite.class, Object.class, Object.class, new Class[0]);

        FieldInstanceReadWrite(Class<?> receiverType, long fieldOffset, Class<?> fieldType) {
            super(receiverType, fieldOffset, fieldType, FORM);
        }

        @ForceInline
        static void set(FieldInstanceReadWrite handle, Object holder, Object value) {
            MethodHandleStatics.UNSAFE.putObject(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(value));
        }

        @ForceInline
        static void setVolatile(FieldInstanceReadWrite handle, Object holder, Object value) {
            MethodHandleStatics.UNSAFE.putObjectVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(value));
        }

        @ForceInline
        static void setOpaque(FieldInstanceReadWrite handle, Object holder, Object value) {
            MethodHandleStatics.UNSAFE.putObjectOpaque(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(value));
        }

        @ForceInline
        static void setRelease(FieldInstanceReadWrite handle, Object holder, Object value) {
            MethodHandleStatics.UNSAFE.putObjectRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(value));
        }

        @ForceInline
        static boolean compareAndSet(FieldInstanceReadWrite handle, Object holder, Object expected, Object value) {
            return MethodHandleStatics.UNSAFE.compareAndSwapObject(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static Object compareAndExchange(FieldInstanceReadWrite handle, Object holder, Object expected, Object value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeObjectVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static Object compareAndExchangeAcquire(FieldInstanceReadWrite handle, Object holder, Object expected, Object value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeObjectAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static Object compareAndExchangeRelease(FieldInstanceReadWrite handle, Object holder, Object expected, Object value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeObjectRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(FieldInstanceReadWrite handle, Object holder, Object expected, Object value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapObject(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static boolean weakCompareAndSet(FieldInstanceReadWrite handle, Object holder, Object expected, Object value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapObjectVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(FieldInstanceReadWrite handle, Object holder, Object expected, Object value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapObjectAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(FieldInstanceReadWrite handle, Object holder, Object expected, Object value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapObjectRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(expected), handle.fieldType.cast(value));
        }

        @ForceInline
        static Object getAndSet(FieldInstanceReadWrite handle, Object holder, Object value) {
            return MethodHandleStatics.UNSAFE.getAndSetObject(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(value));
        }

        @ForceInline
        static Object getAndSetAcquire(FieldInstanceReadWrite handle, Object holder, Object value) {
            return MethodHandleStatics.UNSAFE.getAndSetObjectAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(value));
        }

        @ForceInline
        static Object getAndSetRelease(FieldInstanceReadWrite handle, Object holder, Object value) {
            return MethodHandleStatics.UNSAFE.getAndSetObjectRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, handle.fieldType.cast(value));
        }
    }

    static class FieldInstanceReadOnly
    extends VarHandle {
        final long fieldOffset;
        final Class<?> receiverType;
        final Class<?> fieldType;
        static final VarForm FORM = new VarForm(FieldInstanceReadOnly.class, Object.class, Object.class, new Class[0]);

        FieldInstanceReadOnly(Class<?> receiverType, long fieldOffset, Class<?> fieldType) {
            this(receiverType, fieldOffset, fieldType, FORM);
        }

        protected FieldInstanceReadOnly(Class<?> receiverType, long fieldOffset, Class<?> fieldType, VarForm form) {
            super(form);
            this.fieldOffset = fieldOffset;
            this.receiverType = receiverType;
            this.fieldType = fieldType;
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(this.receiverType, this.fieldType, new Class[0]);
        }

        @ForceInline
        static Object get(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getObject(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static Object getVolatile(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getObjectVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static Object getOpaque(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getObjectOpaque(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static Object getAcquire(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getObjectAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }
    }
}

