/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import jdk.internal.util.Preconditions;
import jdk.internal.vm.annotation.ForceInline;

final class VarHandleLongs {
    VarHandleLongs() {
    }

    static final class Array
    extends VarHandle {
        final int abase;
        final int ashift;
        static final VarForm FORM = new VarForm(Array.class, long[].class, Long.TYPE, Integer.TYPE);

        Array(int abase, int ashift) {
            super(FORM);
            this.abase = abase;
            this.ashift = ashift;
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(long[].class, Long.TYPE, Integer.TYPE);
        }

        @ForceInline
        static long get(Array handle, Object oarray, int index) {
            long[] array = (long[])oarray;
            return array[index];
        }

        @ForceInline
        static void set(Array handle, Object oarray, int index, long value) {
            long[] array = (long[])oarray;
            array[index] = value;
        }

        @ForceInline
        static long getVolatile(Array handle, Object oarray, int index) {
            long[] array = (long[])oarray;
            return MethodHandleStatics.UNSAFE.getLongVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setVolatile(Array handle, Object oarray, int index, long value) {
            long[] array = (long[])oarray;
            MethodHandleStatics.UNSAFE.putLongVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static long getOpaque(Array handle, Object oarray, int index) {
            long[] array = (long[])oarray;
            return MethodHandleStatics.UNSAFE.getLongOpaque(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setOpaque(Array handle, Object oarray, int index, long value) {
            long[] array = (long[])oarray;
            MethodHandleStatics.UNSAFE.putLongOpaque(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static long getAcquire(Array handle, Object oarray, int index) {
            long[] array = (long[])oarray;
            return MethodHandleStatics.UNSAFE.getLongAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setRelease(Array handle, Object oarray, int index, long value) {
            long[] array = (long[])oarray;
            MethodHandleStatics.UNSAFE.putLongRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean compareAndSet(Array handle, Object oarray, int index, long expected, long value) {
            long[] array = (long[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndSwapLong(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static long compareAndExchange(Array handle, Object oarray, int index, long expected, long value) {
            long[] array = (long[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeLongVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static long compareAndExchangeAcquire(Array handle, Object oarray, int index, long expected, long value) {
            long[] array = (long[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeLongAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static long compareAndExchangeRelease(Array handle, Object oarray, int index, long expected, long value) {
            long[] array = (long[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeLongRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(Array handle, Object oarray, int index, long expected, long value) {
            long[] array = (long[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapLong(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(Array handle, Object oarray, int index, long expected, long value) {
            long[] array = (long[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapLongVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(Array handle, Object oarray, int index, long expected, long value) {
            long[] array = (long[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapLongAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(Array handle, Object oarray, int index, long expected, long value) {
            long[] array = (long[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapLongRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static long getAndSet(Array handle, Object oarray, int index, long value) {
            long[] array = (long[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetLong(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static long getAndSetAcquire(Array handle, Object oarray, int index, long value) {
            long[] array = (long[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetLongAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static long getAndSetRelease(Array handle, Object oarray, int index, long value) {
            long[] array = (long[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetLongRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static long getAndAdd(Array handle, Object oarray, int index, long value) {
            long[] array = (long[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddLong(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static long getAndAddAcquire(Array handle, Object oarray, int index, long value) {
            long[] array = (long[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddLongAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static long getAndAddRelease(Array handle, Object oarray, int index, long value) {
            long[] array = (long[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddLongRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static long getAndBitwiseOr(Array handle, Object oarray, int index, long value) {
            long[] array = (long[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrLong(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static long getAndBitwiseOrRelease(Array handle, Object oarray, int index, long value) {
            long[] array = (long[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrLongRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static long getAndBitwiseOrAcquire(Array handle, Object oarray, int index, long value) {
            long[] array = (long[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrLongAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static long getAndBitwiseAnd(Array handle, Object oarray, int index, long value) {
            long[] array = (long[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndLong(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static long getAndBitwiseAndRelease(Array handle, Object oarray, int index, long value) {
            long[] array = (long[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndLongRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static long getAndBitwiseAndAcquire(Array handle, Object oarray, int index, long value) {
            long[] array = (long[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndLongAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static long getAndBitwiseXor(Array handle, Object oarray, int index, long value) {
            long[] array = (long[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorLong(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static long getAndBitwiseXorRelease(Array handle, Object oarray, int index, long value) {
            long[] array = (long[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorLongRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static long getAndBitwiseXorAcquire(Array handle, Object oarray, int index, long value) {
            long[] array = (long[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorLongAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }
    }

    static final class FieldStaticReadWrite
    extends FieldStaticReadOnly {
        static final VarForm FORM = new VarForm(FieldStaticReadWrite.class, null, Long.TYPE, new Class[0]);

        FieldStaticReadWrite(Object base, long fieldOffset) {
            super(base, fieldOffset, FORM);
        }

        @ForceInline
        static void set(FieldStaticReadWrite handle, long value) {
            MethodHandleStatics.UNSAFE.putLong(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setVolatile(FieldStaticReadWrite handle, long value) {
            MethodHandleStatics.UNSAFE.putLongVolatile(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setOpaque(FieldStaticReadWrite handle, long value) {
            MethodHandleStatics.UNSAFE.putLongOpaque(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setRelease(FieldStaticReadWrite handle, long value) {
            MethodHandleStatics.UNSAFE.putLongRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean compareAndSet(FieldStaticReadWrite handle, long expected, long value) {
            return MethodHandleStatics.UNSAFE.compareAndSwapLong(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static long compareAndExchange(FieldStaticReadWrite handle, long expected, long value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeLongVolatile(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static long compareAndExchangeAcquire(FieldStaticReadWrite handle, long expected, long value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeLongAcquire(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static long compareAndExchangeRelease(FieldStaticReadWrite handle, long expected, long value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeLongRelease(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(FieldStaticReadWrite handle, long expected, long value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapLong(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(FieldStaticReadWrite handle, long expected, long value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapLongVolatile(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(FieldStaticReadWrite handle, long expected, long value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapLongAcquire(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(FieldStaticReadWrite handle, long expected, long value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapLongRelease(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static long getAndSet(FieldStaticReadWrite handle, long value) {
            return MethodHandleStatics.UNSAFE.getAndSetLong(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static long getAndSetAcquire(FieldStaticReadWrite handle, long value) {
            return MethodHandleStatics.UNSAFE.getAndSetLongAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static long getAndSetRelease(FieldStaticReadWrite handle, long value) {
            return MethodHandleStatics.UNSAFE.getAndSetLongRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static long getAndAdd(FieldStaticReadWrite handle, long value) {
            return MethodHandleStatics.UNSAFE.getAndAddLong(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static long getAndAddAcquire(FieldStaticReadWrite handle, long value) {
            return MethodHandleStatics.UNSAFE.getAndAddLongAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static long getAndAddRelease(FieldStaticReadWrite handle, long value) {
            return MethodHandleStatics.UNSAFE.getAndAddLongRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static long getAndBitwiseOr(FieldStaticReadWrite handle, long value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrLong(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static long getAndBitwiseOrRelease(FieldStaticReadWrite handle, long value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrLongRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static long getAndBitwiseOrAcquire(FieldStaticReadWrite handle, long value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrLongAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static long getAndBitwiseAnd(FieldStaticReadWrite handle, long value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndLong(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static long getAndBitwiseAndRelease(FieldStaticReadWrite handle, long value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndLongRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static long getAndBitwiseAndAcquire(FieldStaticReadWrite handle, long value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndLongAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static long getAndBitwiseXor(FieldStaticReadWrite handle, long value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorLong(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static long getAndBitwiseXorRelease(FieldStaticReadWrite handle, long value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorLongRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static long getAndBitwiseXorAcquire(FieldStaticReadWrite handle, long value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorLongAcquire(handle.base, handle.fieldOffset, value);
        }
    }

    static class FieldStaticReadOnly
    extends VarHandle {
        final Object base;
        final long fieldOffset;
        static final VarForm FORM = new VarForm(FieldStaticReadOnly.class, null, Long.TYPE, new Class[0]);

        FieldStaticReadOnly(Object base, long fieldOffset) {
            this(base, fieldOffset, FORM);
        }

        protected FieldStaticReadOnly(Object base, long fieldOffset, VarForm form) {
            super(form);
            this.base = base;
            this.fieldOffset = fieldOffset;
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(null, Long.TYPE, new Class[0]);
        }

        @ForceInline
        static long get(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getLong(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static long getVolatile(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getLongVolatile(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static long getOpaque(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getLongOpaque(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static long getAcquire(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getLongAcquire(handle.base, handle.fieldOffset);
        }
    }

    static final class FieldInstanceReadWrite
    extends FieldInstanceReadOnly {
        static final VarForm FORM = new VarForm(FieldInstanceReadWrite.class, Object.class, Long.TYPE, new Class[0]);

        FieldInstanceReadWrite(Class<?> receiverType, long fieldOffset) {
            super(receiverType, fieldOffset, FORM);
        }

        @ForceInline
        static void set(FieldInstanceReadWrite handle, Object holder, long value) {
            MethodHandleStatics.UNSAFE.putLong(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setVolatile(FieldInstanceReadWrite handle, Object holder, long value) {
            MethodHandleStatics.UNSAFE.putLongVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setOpaque(FieldInstanceReadWrite handle, Object holder, long value) {
            MethodHandleStatics.UNSAFE.putLongOpaque(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setRelease(FieldInstanceReadWrite handle, Object holder, long value) {
            MethodHandleStatics.UNSAFE.putLongRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean compareAndSet(FieldInstanceReadWrite handle, Object holder, long expected, long value) {
            return MethodHandleStatics.UNSAFE.compareAndSwapLong(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static long compareAndExchange(FieldInstanceReadWrite handle, Object holder, long expected, long value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeLongVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static long compareAndExchangeAcquire(FieldInstanceReadWrite handle, Object holder, long expected, long value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeLongAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static long compareAndExchangeRelease(FieldInstanceReadWrite handle, Object holder, long expected, long value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeLongRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(FieldInstanceReadWrite handle, Object holder, long expected, long value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapLong(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(FieldInstanceReadWrite handle, Object holder, long expected, long value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapLongVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(FieldInstanceReadWrite handle, Object holder, long expected, long value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapLongAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(FieldInstanceReadWrite handle, Object holder, long expected, long value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapLongRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static long getAndSet(FieldInstanceReadWrite handle, Object holder, long value) {
            return MethodHandleStatics.UNSAFE.getAndSetLong(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static long getAndSetAcquire(FieldInstanceReadWrite handle, Object holder, long value) {
            return MethodHandleStatics.UNSAFE.getAndSetLongAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static long getAndSetRelease(FieldInstanceReadWrite handle, Object holder, long value) {
            return MethodHandleStatics.UNSAFE.getAndSetLongRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static long getAndAdd(FieldInstanceReadWrite handle, Object holder, long value) {
            return MethodHandleStatics.UNSAFE.getAndAddLong(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static long getAndAddAcquire(FieldInstanceReadWrite handle, Object holder, long value) {
            return MethodHandleStatics.UNSAFE.getAndAddLongAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static long getAndAddRelease(FieldInstanceReadWrite handle, Object holder, long value) {
            return MethodHandleStatics.UNSAFE.getAndAddLongRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static long getAndBitwiseOr(FieldInstanceReadWrite handle, Object holder, long value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrLong(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static long getAndBitwiseOrRelease(FieldInstanceReadWrite handle, Object holder, long value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrLongRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static long getAndBitwiseOrAcquire(FieldInstanceReadWrite handle, Object holder, long value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrLongAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static long getAndBitwiseAnd(FieldInstanceReadWrite handle, Object holder, long value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndLong(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static long getAndBitwiseAndRelease(FieldInstanceReadWrite handle, Object holder, long value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndLongRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static long getAndBitwiseAndAcquire(FieldInstanceReadWrite handle, Object holder, long value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndLongAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static long getAndBitwiseXor(FieldInstanceReadWrite handle, Object holder, long value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorLong(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static long getAndBitwiseXorRelease(FieldInstanceReadWrite handle, Object holder, long value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorLongRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static long getAndBitwiseXorAcquire(FieldInstanceReadWrite handle, Object holder, long value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorLongAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }
    }

    static class FieldInstanceReadOnly
    extends VarHandle {
        final long fieldOffset;
        final Class<?> receiverType;
        static final VarForm FORM = new VarForm(FieldInstanceReadOnly.class, Object.class, Long.TYPE, new Class[0]);

        FieldInstanceReadOnly(Class<?> receiverType, long fieldOffset) {
            this(receiverType, fieldOffset, FORM);
        }

        protected FieldInstanceReadOnly(Class<?> receiverType, long fieldOffset, VarForm form) {
            super(form);
            this.fieldOffset = fieldOffset;
            this.receiverType = receiverType;
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(this.receiverType, Long.TYPE, new Class[0]);
        }

        @ForceInline
        static long get(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getLong(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static long getVolatile(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getLongVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static long getOpaque(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getLongOpaque(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static long getAcquire(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getLongAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }
    }
}

