/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import jdk.internal.util.Preconditions;
import jdk.internal.vm.annotation.ForceInline;

final class VarHandleInts {
    VarHandleInts() {
    }

    static final class Array
    extends VarHandle {
        final int abase;
        final int ashift;
        static final VarForm FORM = new VarForm(Array.class, int[].class, Integer.TYPE, Integer.TYPE);

        Array(int abase, int ashift) {
            super(FORM);
            this.abase = abase;
            this.ashift = ashift;
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(int[].class, Integer.TYPE, Integer.TYPE);
        }

        @ForceInline
        static int get(Array handle, Object oarray, int index) {
            int[] array = (int[])oarray;
            return array[index];
        }

        @ForceInline
        static void set(Array handle, Object oarray, int index, int value) {
            int[] array = (int[])oarray;
            array[index] = value;
        }

        @ForceInline
        static int getVolatile(Array handle, Object oarray, int index) {
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getIntVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setVolatile(Array handle, Object oarray, int index, int value) {
            int[] array = (int[])oarray;
            MethodHandleStatics.UNSAFE.putIntVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getOpaque(Array handle, Object oarray, int index) {
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getIntOpaque(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setOpaque(Array handle, Object oarray, int index, int value) {
            int[] array = (int[])oarray;
            MethodHandleStatics.UNSAFE.putIntOpaque(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAcquire(Array handle, Object oarray, int index) {
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getIntAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setRelease(Array handle, Object oarray, int index, int value) {
            int[] array = (int[])oarray;
            MethodHandleStatics.UNSAFE.putIntRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean compareAndSet(Array handle, Object oarray, int index, int expected, int value) {
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndSwapInt(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static int compareAndExchange(Array handle, Object oarray, int index, int expected, int value) {
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeIntVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static int compareAndExchangeAcquire(Array handle, Object oarray, int index, int expected, int value) {
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeIntAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static int compareAndExchangeRelease(Array handle, Object oarray, int index, int expected, int value) {
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeIntRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(Array handle, Object oarray, int index, int expected, int value) {
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapInt(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(Array handle, Object oarray, int index, int expected, int value) {
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapIntVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(Array handle, Object oarray, int index, int expected, int value) {
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapIntAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(Array handle, Object oarray, int index, int expected, int value) {
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapIntRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static int getAndSet(Array handle, Object oarray, int index, int value) {
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetInt(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAndSetAcquire(Array handle, Object oarray, int index, int value) {
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetIntAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAndSetRelease(Array handle, Object oarray, int index, int value) {
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetIntRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAndAdd(Array handle, Object oarray, int index, int value) {
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddInt(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAndAddAcquire(Array handle, Object oarray, int index, int value) {
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddIntAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAndAddRelease(Array handle, Object oarray, int index, int value) {
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddIntRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAndBitwiseOr(Array handle, Object oarray, int index, int value) {
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrInt(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAndBitwiseOrRelease(Array handle, Object oarray, int index, int value) {
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrIntRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAndBitwiseOrAcquire(Array handle, Object oarray, int index, int value) {
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrIntAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAndBitwiseAnd(Array handle, Object oarray, int index, int value) {
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndInt(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAndBitwiseAndRelease(Array handle, Object oarray, int index, int value) {
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndIntRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAndBitwiseAndAcquire(Array handle, Object oarray, int index, int value) {
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndIntAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAndBitwiseXor(Array handle, Object oarray, int index, int value) {
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorInt(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAndBitwiseXorRelease(Array handle, Object oarray, int index, int value) {
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorIntRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static int getAndBitwiseXorAcquire(Array handle, Object oarray, int index, int value) {
            int[] array = (int[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorIntAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }
    }

    static final class FieldStaticReadWrite
    extends FieldStaticReadOnly {
        static final VarForm FORM = new VarForm(FieldStaticReadWrite.class, null, Integer.TYPE, new Class[0]);

        FieldStaticReadWrite(Object base, long fieldOffset) {
            super(base, fieldOffset, FORM);
        }

        @ForceInline
        static void set(FieldStaticReadWrite handle, int value) {
            MethodHandleStatics.UNSAFE.putInt(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setVolatile(FieldStaticReadWrite handle, int value) {
            MethodHandleStatics.UNSAFE.putIntVolatile(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setOpaque(FieldStaticReadWrite handle, int value) {
            MethodHandleStatics.UNSAFE.putIntOpaque(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setRelease(FieldStaticReadWrite handle, int value) {
            MethodHandleStatics.UNSAFE.putIntRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean compareAndSet(FieldStaticReadWrite handle, int expected, int value) {
            return MethodHandleStatics.UNSAFE.compareAndSwapInt(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static int compareAndExchange(FieldStaticReadWrite handle, int expected, int value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeIntVolatile(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static int compareAndExchangeAcquire(FieldStaticReadWrite handle, int expected, int value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeIntAcquire(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static int compareAndExchangeRelease(FieldStaticReadWrite handle, int expected, int value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeIntRelease(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(FieldStaticReadWrite handle, int expected, int value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapInt(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(FieldStaticReadWrite handle, int expected, int value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapIntVolatile(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(FieldStaticReadWrite handle, int expected, int value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapIntAcquire(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(FieldStaticReadWrite handle, int expected, int value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapIntRelease(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static int getAndSet(FieldStaticReadWrite handle, int value) {
            return MethodHandleStatics.UNSAFE.getAndSetInt(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndSetAcquire(FieldStaticReadWrite handle, int value) {
            return MethodHandleStatics.UNSAFE.getAndSetIntAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndSetRelease(FieldStaticReadWrite handle, int value) {
            return MethodHandleStatics.UNSAFE.getAndSetIntRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndAdd(FieldStaticReadWrite handle, int value) {
            return MethodHandleStatics.UNSAFE.getAndAddInt(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndAddAcquire(FieldStaticReadWrite handle, int value) {
            return MethodHandleStatics.UNSAFE.getAndAddIntAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndAddRelease(FieldStaticReadWrite handle, int value) {
            return MethodHandleStatics.UNSAFE.getAndAddIntRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseOr(FieldStaticReadWrite handle, int value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrInt(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseOrRelease(FieldStaticReadWrite handle, int value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrIntRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseOrAcquire(FieldStaticReadWrite handle, int value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrIntAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseAnd(FieldStaticReadWrite handle, int value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndInt(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseAndRelease(FieldStaticReadWrite handle, int value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndIntRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseAndAcquire(FieldStaticReadWrite handle, int value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndIntAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseXor(FieldStaticReadWrite handle, int value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorInt(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseXorRelease(FieldStaticReadWrite handle, int value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorIntRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseXorAcquire(FieldStaticReadWrite handle, int value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorIntAcquire(handle.base, handle.fieldOffset, value);
        }
    }

    static class FieldStaticReadOnly
    extends VarHandle {
        final Object base;
        final long fieldOffset;
        static final VarForm FORM = new VarForm(FieldStaticReadOnly.class, null, Integer.TYPE, new Class[0]);

        FieldStaticReadOnly(Object base, long fieldOffset) {
            this(base, fieldOffset, FORM);
        }

        protected FieldStaticReadOnly(Object base, long fieldOffset, VarForm form) {
            super(form);
            this.base = base;
            this.fieldOffset = fieldOffset;
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(null, Integer.TYPE, new Class[0]);
        }

        @ForceInline
        static int get(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getInt(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static int getVolatile(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getIntVolatile(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static int getOpaque(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getIntOpaque(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static int getAcquire(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getIntAcquire(handle.base, handle.fieldOffset);
        }
    }

    static final class FieldInstanceReadWrite
    extends FieldInstanceReadOnly {
        static final VarForm FORM = new VarForm(FieldInstanceReadWrite.class, Object.class, Integer.TYPE, new Class[0]);

        FieldInstanceReadWrite(Class<?> receiverType, long fieldOffset) {
            super(receiverType, fieldOffset, FORM);
        }

        @ForceInline
        static void set(FieldInstanceReadWrite handle, Object holder, int value) {
            MethodHandleStatics.UNSAFE.putInt(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setVolatile(FieldInstanceReadWrite handle, Object holder, int value) {
            MethodHandleStatics.UNSAFE.putIntVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setOpaque(FieldInstanceReadWrite handle, Object holder, int value) {
            MethodHandleStatics.UNSAFE.putIntOpaque(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setRelease(FieldInstanceReadWrite handle, Object holder, int value) {
            MethodHandleStatics.UNSAFE.putIntRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean compareAndSet(FieldInstanceReadWrite handle, Object holder, int expected, int value) {
            return MethodHandleStatics.UNSAFE.compareAndSwapInt(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static int compareAndExchange(FieldInstanceReadWrite handle, Object holder, int expected, int value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeIntVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static int compareAndExchangeAcquire(FieldInstanceReadWrite handle, Object holder, int expected, int value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeIntAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static int compareAndExchangeRelease(FieldInstanceReadWrite handle, Object holder, int expected, int value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeIntRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(FieldInstanceReadWrite handle, Object holder, int expected, int value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapInt(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(FieldInstanceReadWrite handle, Object holder, int expected, int value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapIntVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(FieldInstanceReadWrite handle, Object holder, int expected, int value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapIntAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(FieldInstanceReadWrite handle, Object holder, int expected, int value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapIntRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static int getAndSet(FieldInstanceReadWrite handle, Object holder, int value) {
            return MethodHandleStatics.UNSAFE.getAndSetInt(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndSetAcquire(FieldInstanceReadWrite handle, Object holder, int value) {
            return MethodHandleStatics.UNSAFE.getAndSetIntAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndSetRelease(FieldInstanceReadWrite handle, Object holder, int value) {
            return MethodHandleStatics.UNSAFE.getAndSetIntRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndAdd(FieldInstanceReadWrite handle, Object holder, int value) {
            return MethodHandleStatics.UNSAFE.getAndAddInt(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndAddAcquire(FieldInstanceReadWrite handle, Object holder, int value) {
            return MethodHandleStatics.UNSAFE.getAndAddIntAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndAddRelease(FieldInstanceReadWrite handle, Object holder, int value) {
            return MethodHandleStatics.UNSAFE.getAndAddIntRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseOr(FieldInstanceReadWrite handle, Object holder, int value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrInt(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseOrRelease(FieldInstanceReadWrite handle, Object holder, int value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrIntRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseOrAcquire(FieldInstanceReadWrite handle, Object holder, int value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrIntAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseAnd(FieldInstanceReadWrite handle, Object holder, int value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndInt(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseAndRelease(FieldInstanceReadWrite handle, Object holder, int value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndIntRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseAndAcquire(FieldInstanceReadWrite handle, Object holder, int value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndIntAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseXor(FieldInstanceReadWrite handle, Object holder, int value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorInt(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseXorRelease(FieldInstanceReadWrite handle, Object holder, int value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorIntRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static int getAndBitwiseXorAcquire(FieldInstanceReadWrite handle, Object holder, int value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorIntAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }
    }

    static class FieldInstanceReadOnly
    extends VarHandle {
        final long fieldOffset;
        final Class<?> receiverType;
        static final VarForm FORM = new VarForm(FieldInstanceReadOnly.class, Object.class, Integer.TYPE, new Class[0]);

        FieldInstanceReadOnly(Class<?> receiverType, long fieldOffset) {
            this(receiverType, fieldOffset, FORM);
        }

        protected FieldInstanceReadOnly(Class<?> receiverType, long fieldOffset, VarForm form) {
            super(form);
            this.fieldOffset = fieldOffset;
            this.receiverType = receiverType;
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(this.receiverType, Integer.TYPE, new Class[0]);
        }

        @ForceInline
        static int get(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getInt(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static int getVolatile(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getIntVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static int getOpaque(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getIntOpaque(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static int getAcquire(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getIntAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }
    }
}

