/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import jdk.internal.util.Preconditions;
import jdk.internal.vm.annotation.ForceInline;

final class VarHandleFloats {
    VarHandleFloats() {
    }

    static final class Array
    extends VarHandle {
        final int abase;
        final int ashift;
        static final VarForm FORM = new VarForm(Array.class, float[].class, Float.TYPE, Integer.TYPE);

        Array(int abase, int ashift) {
            super(FORM);
            this.abase = abase;
            this.ashift = ashift;
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(float[].class, Float.TYPE, Integer.TYPE);
        }

        @ForceInline
        static float get(Array handle, Object oarray, int index) {
            float[] array = (float[])oarray;
            return array[index];
        }

        @ForceInline
        static void set(Array handle, Object oarray, int index, float value) {
            float[] array = (float[])oarray;
            array[index] = value;
        }

        @ForceInline
        static float getVolatile(Array handle, Object oarray, int index) {
            float[] array = (float[])oarray;
            return MethodHandleStatics.UNSAFE.getFloatVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setVolatile(Array handle, Object oarray, int index, float value) {
            float[] array = (float[])oarray;
            MethodHandleStatics.UNSAFE.putFloatVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static float getOpaque(Array handle, Object oarray, int index) {
            float[] array = (float[])oarray;
            return MethodHandleStatics.UNSAFE.getFloatOpaque(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setOpaque(Array handle, Object oarray, int index, float value) {
            float[] array = (float[])oarray;
            MethodHandleStatics.UNSAFE.putFloatOpaque(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static float getAcquire(Array handle, Object oarray, int index) {
            float[] array = (float[])oarray;
            return MethodHandleStatics.UNSAFE.getFloatAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setRelease(Array handle, Object oarray, int index, float value) {
            float[] array = (float[])oarray;
            MethodHandleStatics.UNSAFE.putFloatRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean compareAndSet(Array handle, Object oarray, int index, float expected, float value) {
            float[] array = (float[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndSwapFloat(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static float compareAndExchange(Array handle, Object oarray, int index, float expected, float value) {
            float[] array = (float[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeFloatVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static float compareAndExchangeAcquire(Array handle, Object oarray, int index, float expected, float value) {
            float[] array = (float[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeFloatAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static float compareAndExchangeRelease(Array handle, Object oarray, int index, float expected, float value) {
            float[] array = (float[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeFloatRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(Array handle, Object oarray, int index, float expected, float value) {
            float[] array = (float[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapFloat(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(Array handle, Object oarray, int index, float expected, float value) {
            float[] array = (float[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapFloatVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(Array handle, Object oarray, int index, float expected, float value) {
            float[] array = (float[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapFloatAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(Array handle, Object oarray, int index, float expected, float value) {
            float[] array = (float[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapFloatRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static float getAndSet(Array handle, Object oarray, int index, float value) {
            float[] array = (float[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetFloat(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static float getAndSetAcquire(Array handle, Object oarray, int index, float value) {
            float[] array = (float[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetFloatAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static float getAndSetRelease(Array handle, Object oarray, int index, float value) {
            float[] array = (float[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetFloatRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static float getAndAdd(Array handle, Object oarray, int index, float value) {
            float[] array = (float[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddFloat(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static float getAndAddAcquire(Array handle, Object oarray, int index, float value) {
            float[] array = (float[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddFloatAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static float getAndAddRelease(Array handle, Object oarray, int index, float value) {
            float[] array = (float[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddFloatRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }
    }

    static final class FieldStaticReadWrite
    extends FieldStaticReadOnly {
        static final VarForm FORM = new VarForm(FieldStaticReadWrite.class, null, Float.TYPE, new Class[0]);

        FieldStaticReadWrite(Object base, long fieldOffset) {
            super(base, fieldOffset, FORM);
        }

        @ForceInline
        static void set(FieldStaticReadWrite handle, float value) {
            MethodHandleStatics.UNSAFE.putFloat(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setVolatile(FieldStaticReadWrite handle, float value) {
            MethodHandleStatics.UNSAFE.putFloatVolatile(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setOpaque(FieldStaticReadWrite handle, float value) {
            MethodHandleStatics.UNSAFE.putFloatOpaque(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setRelease(FieldStaticReadWrite handle, float value) {
            MethodHandleStatics.UNSAFE.putFloatRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean compareAndSet(FieldStaticReadWrite handle, float expected, float value) {
            return MethodHandleStatics.UNSAFE.compareAndSwapFloat(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static float compareAndExchange(FieldStaticReadWrite handle, float expected, float value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeFloatVolatile(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static float compareAndExchangeAcquire(FieldStaticReadWrite handle, float expected, float value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeFloatAcquire(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static float compareAndExchangeRelease(FieldStaticReadWrite handle, float expected, float value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeFloatRelease(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(FieldStaticReadWrite handle, float expected, float value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapFloat(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(FieldStaticReadWrite handle, float expected, float value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapFloatVolatile(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(FieldStaticReadWrite handle, float expected, float value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapFloatAcquire(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(FieldStaticReadWrite handle, float expected, float value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapFloatRelease(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static float getAndSet(FieldStaticReadWrite handle, float value) {
            return MethodHandleStatics.UNSAFE.getAndSetFloat(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static float getAndSetAcquire(FieldStaticReadWrite handle, float value) {
            return MethodHandleStatics.UNSAFE.getAndSetFloatAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static float getAndSetRelease(FieldStaticReadWrite handle, float value) {
            return MethodHandleStatics.UNSAFE.getAndSetFloatRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static float getAndAdd(FieldStaticReadWrite handle, float value) {
            return MethodHandleStatics.UNSAFE.getAndAddFloat(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static float getAndAddAcquire(FieldStaticReadWrite handle, float value) {
            return MethodHandleStatics.UNSAFE.getAndAddFloatAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static float getAndAddRelease(FieldStaticReadWrite handle, float value) {
            return MethodHandleStatics.UNSAFE.getAndAddFloatRelease(handle.base, handle.fieldOffset, value);
        }
    }

    static class FieldStaticReadOnly
    extends VarHandle {
        final Object base;
        final long fieldOffset;
        static final VarForm FORM = new VarForm(FieldStaticReadOnly.class, null, Float.TYPE, new Class[0]);

        FieldStaticReadOnly(Object base, long fieldOffset) {
            this(base, fieldOffset, FORM);
        }

        protected FieldStaticReadOnly(Object base, long fieldOffset, VarForm form) {
            super(form);
            this.base = base;
            this.fieldOffset = fieldOffset;
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(null, Float.TYPE, new Class[0]);
        }

        @ForceInline
        static float get(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getFloat(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static float getVolatile(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getFloatVolatile(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static float getOpaque(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getFloatOpaque(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static float getAcquire(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getFloatAcquire(handle.base, handle.fieldOffset);
        }
    }

    static final class FieldInstanceReadWrite
    extends FieldInstanceReadOnly {
        static final VarForm FORM = new VarForm(FieldInstanceReadWrite.class, Object.class, Float.TYPE, new Class[0]);

        FieldInstanceReadWrite(Class<?> receiverType, long fieldOffset) {
            super(receiverType, fieldOffset, FORM);
        }

        @ForceInline
        static void set(FieldInstanceReadWrite handle, Object holder, float value) {
            MethodHandleStatics.UNSAFE.putFloat(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setVolatile(FieldInstanceReadWrite handle, Object holder, float value) {
            MethodHandleStatics.UNSAFE.putFloatVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setOpaque(FieldInstanceReadWrite handle, Object holder, float value) {
            MethodHandleStatics.UNSAFE.putFloatOpaque(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setRelease(FieldInstanceReadWrite handle, Object holder, float value) {
            MethodHandleStatics.UNSAFE.putFloatRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean compareAndSet(FieldInstanceReadWrite handle, Object holder, float expected, float value) {
            return MethodHandleStatics.UNSAFE.compareAndSwapFloat(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static float compareAndExchange(FieldInstanceReadWrite handle, Object holder, float expected, float value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeFloatVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static float compareAndExchangeAcquire(FieldInstanceReadWrite handle, Object holder, float expected, float value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeFloatAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static float compareAndExchangeRelease(FieldInstanceReadWrite handle, Object holder, float expected, float value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeFloatRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(FieldInstanceReadWrite handle, Object holder, float expected, float value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapFloat(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(FieldInstanceReadWrite handle, Object holder, float expected, float value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapFloatVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(FieldInstanceReadWrite handle, Object holder, float expected, float value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapFloatAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(FieldInstanceReadWrite handle, Object holder, float expected, float value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapFloatRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static float getAndSet(FieldInstanceReadWrite handle, Object holder, float value) {
            return MethodHandleStatics.UNSAFE.getAndSetFloat(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static float getAndSetAcquire(FieldInstanceReadWrite handle, Object holder, float value) {
            return MethodHandleStatics.UNSAFE.getAndSetFloatAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static float getAndSetRelease(FieldInstanceReadWrite handle, Object holder, float value) {
            return MethodHandleStatics.UNSAFE.getAndSetFloatRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static float getAndAdd(FieldInstanceReadWrite handle, Object holder, float value) {
            return MethodHandleStatics.UNSAFE.getAndAddFloat(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static float getAndAddAcquire(FieldInstanceReadWrite handle, Object holder, float value) {
            return MethodHandleStatics.UNSAFE.getAndAddFloatAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static float getAndAddRelease(FieldInstanceReadWrite handle, Object holder, float value) {
            return MethodHandleStatics.UNSAFE.getAndAddFloatRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }
    }

    static class FieldInstanceReadOnly
    extends VarHandle {
        final long fieldOffset;
        final Class<?> receiverType;
        static final VarForm FORM = new VarForm(FieldInstanceReadOnly.class, Object.class, Float.TYPE, new Class[0]);

        FieldInstanceReadOnly(Class<?> receiverType, long fieldOffset) {
            this(receiverType, fieldOffset, FORM);
        }

        protected FieldInstanceReadOnly(Class<?> receiverType, long fieldOffset, VarForm form) {
            super(form);
            this.fieldOffset = fieldOffset;
            this.receiverType = receiverType;
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(this.receiverType, Float.TYPE, new Class[0]);
        }

        @ForceInline
        static float get(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getFloat(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static float getVolatile(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getFloatVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static float getOpaque(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getFloatOpaque(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static float getAcquire(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getFloatAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }
    }
}

