/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import jdk.internal.util.Preconditions;
import jdk.internal.vm.annotation.ForceInline;

final class VarHandleDoubles {
    VarHandleDoubles() {
    }

    static final class Array
    extends VarHandle {
        final int abase;
        final int ashift;
        static final VarForm FORM = new VarForm(Array.class, double[].class, Double.TYPE, Integer.TYPE);

        Array(int abase, int ashift) {
            super(FORM);
            this.abase = abase;
            this.ashift = ashift;
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(double[].class, Double.TYPE, Integer.TYPE);
        }

        @ForceInline
        static double get(Array handle, Object oarray, int index) {
            double[] array = (double[])oarray;
            return array[index];
        }

        @ForceInline
        static void set(Array handle, Object oarray, int index, double value) {
            double[] array = (double[])oarray;
            array[index] = value;
        }

        @ForceInline
        static double getVolatile(Array handle, Object oarray, int index) {
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.getDoubleVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setVolatile(Array handle, Object oarray, int index, double value) {
            double[] array = (double[])oarray;
            MethodHandleStatics.UNSAFE.putDoubleVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static double getOpaque(Array handle, Object oarray, int index) {
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.getDoubleOpaque(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setOpaque(Array handle, Object oarray, int index, double value) {
            double[] array = (double[])oarray;
            MethodHandleStatics.UNSAFE.putDoubleOpaque(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static double getAcquire(Array handle, Object oarray, int index) {
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.getDoubleAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setRelease(Array handle, Object oarray, int index, double value) {
            double[] array = (double[])oarray;
            MethodHandleStatics.UNSAFE.putDoubleRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean compareAndSet(Array handle, Object oarray, int index, double expected, double value) {
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndSwapDouble(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static double compareAndExchange(Array handle, Object oarray, int index, double expected, double value) {
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeDoubleVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static double compareAndExchangeAcquire(Array handle, Object oarray, int index, double expected, double value) {
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeDoubleAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static double compareAndExchangeRelease(Array handle, Object oarray, int index, double expected, double value) {
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeDoubleRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(Array handle, Object oarray, int index, double expected, double value) {
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapDouble(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(Array handle, Object oarray, int index, double expected, double value) {
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapDoubleVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(Array handle, Object oarray, int index, double expected, double value) {
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapDoubleAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(Array handle, Object oarray, int index, double expected, double value) {
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapDoubleRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static double getAndSet(Array handle, Object oarray, int index, double value) {
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetDouble(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static double getAndSetAcquire(Array handle, Object oarray, int index, double value) {
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetDoubleAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static double getAndSetRelease(Array handle, Object oarray, int index, double value) {
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetDoubleRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static double getAndAdd(Array handle, Object oarray, int index, double value) {
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddDouble(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static double getAndAddAcquire(Array handle, Object oarray, int index, double value) {
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddDoubleAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static double getAndAddRelease(Array handle, Object oarray, int index, double value) {
            double[] array = (double[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddDoubleRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }
    }

    static final class FieldStaticReadWrite
    extends FieldStaticReadOnly {
        static final VarForm FORM = new VarForm(FieldStaticReadWrite.class, null, Double.TYPE, new Class[0]);

        FieldStaticReadWrite(Object base, long fieldOffset) {
            super(base, fieldOffset, FORM);
        }

        @ForceInline
        static void set(FieldStaticReadWrite handle, double value) {
            MethodHandleStatics.UNSAFE.putDouble(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setVolatile(FieldStaticReadWrite handle, double value) {
            MethodHandleStatics.UNSAFE.putDoubleVolatile(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setOpaque(FieldStaticReadWrite handle, double value) {
            MethodHandleStatics.UNSAFE.putDoubleOpaque(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setRelease(FieldStaticReadWrite handle, double value) {
            MethodHandleStatics.UNSAFE.putDoubleRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean compareAndSet(FieldStaticReadWrite handle, double expected, double value) {
            return MethodHandleStatics.UNSAFE.compareAndSwapDouble(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static double compareAndExchange(FieldStaticReadWrite handle, double expected, double value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeDoubleVolatile(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static double compareAndExchangeAcquire(FieldStaticReadWrite handle, double expected, double value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeDoubleAcquire(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static double compareAndExchangeRelease(FieldStaticReadWrite handle, double expected, double value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeDoubleRelease(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(FieldStaticReadWrite handle, double expected, double value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapDouble(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(FieldStaticReadWrite handle, double expected, double value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapDoubleVolatile(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(FieldStaticReadWrite handle, double expected, double value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapDoubleAcquire(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(FieldStaticReadWrite handle, double expected, double value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapDoubleRelease(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static double getAndSet(FieldStaticReadWrite handle, double value) {
            return MethodHandleStatics.UNSAFE.getAndSetDouble(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static double getAndSetAcquire(FieldStaticReadWrite handle, double value) {
            return MethodHandleStatics.UNSAFE.getAndSetDoubleAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static double getAndSetRelease(FieldStaticReadWrite handle, double value) {
            return MethodHandleStatics.UNSAFE.getAndSetDoubleRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static double getAndAdd(FieldStaticReadWrite handle, double value) {
            return MethodHandleStatics.UNSAFE.getAndAddDouble(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static double getAndAddAcquire(FieldStaticReadWrite handle, double value) {
            return MethodHandleStatics.UNSAFE.getAndAddDoubleAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static double getAndAddRelease(FieldStaticReadWrite handle, double value) {
            return MethodHandleStatics.UNSAFE.getAndAddDoubleRelease(handle.base, handle.fieldOffset, value);
        }
    }

    static class FieldStaticReadOnly
    extends VarHandle {
        final Object base;
        final long fieldOffset;
        static final VarForm FORM = new VarForm(FieldStaticReadOnly.class, null, Double.TYPE, new Class[0]);

        FieldStaticReadOnly(Object base, long fieldOffset) {
            this(base, fieldOffset, FORM);
        }

        protected FieldStaticReadOnly(Object base, long fieldOffset, VarForm form) {
            super(form);
            this.base = base;
            this.fieldOffset = fieldOffset;
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(null, Double.TYPE, new Class[0]);
        }

        @ForceInline
        static double get(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getDouble(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static double getVolatile(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getDoubleVolatile(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static double getOpaque(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getDoubleOpaque(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static double getAcquire(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getDoubleAcquire(handle.base, handle.fieldOffset);
        }
    }

    static final class FieldInstanceReadWrite
    extends FieldInstanceReadOnly {
        static final VarForm FORM = new VarForm(FieldInstanceReadWrite.class, Object.class, Double.TYPE, new Class[0]);

        FieldInstanceReadWrite(Class<?> receiverType, long fieldOffset) {
            super(receiverType, fieldOffset, FORM);
        }

        @ForceInline
        static void set(FieldInstanceReadWrite handle, Object holder, double value) {
            MethodHandleStatics.UNSAFE.putDouble(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setVolatile(FieldInstanceReadWrite handle, Object holder, double value) {
            MethodHandleStatics.UNSAFE.putDoubleVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setOpaque(FieldInstanceReadWrite handle, Object holder, double value) {
            MethodHandleStatics.UNSAFE.putDoubleOpaque(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setRelease(FieldInstanceReadWrite handle, Object holder, double value) {
            MethodHandleStatics.UNSAFE.putDoubleRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean compareAndSet(FieldInstanceReadWrite handle, Object holder, double expected, double value) {
            return MethodHandleStatics.UNSAFE.compareAndSwapDouble(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static double compareAndExchange(FieldInstanceReadWrite handle, Object holder, double expected, double value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeDoubleVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static double compareAndExchangeAcquire(FieldInstanceReadWrite handle, Object holder, double expected, double value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeDoubleAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static double compareAndExchangeRelease(FieldInstanceReadWrite handle, Object holder, double expected, double value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeDoubleRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(FieldInstanceReadWrite handle, Object holder, double expected, double value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapDouble(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(FieldInstanceReadWrite handle, Object holder, double expected, double value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapDoubleVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(FieldInstanceReadWrite handle, Object holder, double expected, double value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapDoubleAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(FieldInstanceReadWrite handle, Object holder, double expected, double value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapDoubleRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static double getAndSet(FieldInstanceReadWrite handle, Object holder, double value) {
            return MethodHandleStatics.UNSAFE.getAndSetDouble(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static double getAndSetAcquire(FieldInstanceReadWrite handle, Object holder, double value) {
            return MethodHandleStatics.UNSAFE.getAndSetDoubleAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static double getAndSetRelease(FieldInstanceReadWrite handle, Object holder, double value) {
            return MethodHandleStatics.UNSAFE.getAndSetDoubleRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static double getAndAdd(FieldInstanceReadWrite handle, Object holder, double value) {
            return MethodHandleStatics.UNSAFE.getAndAddDouble(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static double getAndAddAcquire(FieldInstanceReadWrite handle, Object holder, double value) {
            return MethodHandleStatics.UNSAFE.getAndAddDoubleAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static double getAndAddRelease(FieldInstanceReadWrite handle, Object holder, double value) {
            return MethodHandleStatics.UNSAFE.getAndAddDoubleRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }
    }

    static class FieldInstanceReadOnly
    extends VarHandle {
        final long fieldOffset;
        final Class<?> receiverType;
        static final VarForm FORM = new VarForm(FieldInstanceReadOnly.class, Object.class, Double.TYPE, new Class[0]);

        FieldInstanceReadOnly(Class<?> receiverType, long fieldOffset) {
            this(receiverType, fieldOffset, FORM);
        }

        protected FieldInstanceReadOnly(Class<?> receiverType, long fieldOffset, VarForm form) {
            super(form);
            this.fieldOffset = fieldOffset;
            this.receiverType = receiverType;
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(this.receiverType, Double.TYPE, new Class[0]);
        }

        @ForceInline
        static double get(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getDouble(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static double getVolatile(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getDoubleVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static double getOpaque(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getDoubleOpaque(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static double getAcquire(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getDoubleAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }
    }
}

