/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import jdk.internal.util.Preconditions;
import jdk.internal.vm.annotation.ForceInline;

final class VarHandleChars {
    VarHandleChars() {
    }

    static final class Array
    extends VarHandle {
        final int abase;
        final int ashift;
        static final VarForm FORM = new VarForm(Array.class, char[].class, Character.TYPE, Integer.TYPE);

        Array(int abase, int ashift) {
            super(FORM);
            this.abase = abase;
            this.ashift = ashift;
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(char[].class, Character.TYPE, Integer.TYPE);
        }

        @ForceInline
        static char get(Array handle, Object oarray, int index) {
            char[] array = (char[])oarray;
            return array[index];
        }

        @ForceInline
        static void set(Array handle, Object oarray, int index, char value) {
            char[] array = (char[])oarray;
            array[index] = value;
        }

        @ForceInline
        static char getVolatile(Array handle, Object oarray, int index) {
            char[] array = (char[])oarray;
            return MethodHandleStatics.UNSAFE.getCharVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setVolatile(Array handle, Object oarray, int index, char value) {
            char[] array = (char[])oarray;
            MethodHandleStatics.UNSAFE.putCharVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static char getOpaque(Array handle, Object oarray, int index) {
            char[] array = (char[])oarray;
            return MethodHandleStatics.UNSAFE.getCharOpaque(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setOpaque(Array handle, Object oarray, int index, char value) {
            char[] array = (char[])oarray;
            MethodHandleStatics.UNSAFE.putCharOpaque(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static char getAcquire(Array handle, Object oarray, int index) {
            char[] array = (char[])oarray;
            return MethodHandleStatics.UNSAFE.getCharAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setRelease(Array handle, Object oarray, int index, char value) {
            char[] array = (char[])oarray;
            MethodHandleStatics.UNSAFE.putCharRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean compareAndSet(Array handle, Object oarray, int index, char expected, char value) {
            char[] array = (char[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndSwapChar(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static char compareAndExchange(Array handle, Object oarray, int index, char expected, char value) {
            char[] array = (char[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeCharVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static char compareAndExchangeAcquire(Array handle, Object oarray, int index, char expected, char value) {
            char[] array = (char[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeCharAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static char compareAndExchangeRelease(Array handle, Object oarray, int index, char expected, char value) {
            char[] array = (char[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeCharRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(Array handle, Object oarray, int index, char expected, char value) {
            char[] array = (char[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapChar(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(Array handle, Object oarray, int index, char expected, char value) {
            char[] array = (char[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapCharVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(Array handle, Object oarray, int index, char expected, char value) {
            char[] array = (char[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapCharAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(Array handle, Object oarray, int index, char expected, char value) {
            char[] array = (char[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapCharRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static char getAndSet(Array handle, Object oarray, int index, char value) {
            char[] array = (char[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetChar(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static char getAndSetAcquire(Array handle, Object oarray, int index, char value) {
            char[] array = (char[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetCharAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static char getAndSetRelease(Array handle, Object oarray, int index, char value) {
            char[] array = (char[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetCharRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static char getAndAdd(Array handle, Object oarray, int index, char value) {
            char[] array = (char[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddChar(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static char getAndAddAcquire(Array handle, Object oarray, int index, char value) {
            char[] array = (char[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddCharAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static char getAndAddRelease(Array handle, Object oarray, int index, char value) {
            char[] array = (char[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddCharRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static char getAndBitwiseOr(Array handle, Object oarray, int index, char value) {
            char[] array = (char[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrChar(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static char getAndBitwiseOrRelease(Array handle, Object oarray, int index, char value) {
            char[] array = (char[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrCharRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static char getAndBitwiseOrAcquire(Array handle, Object oarray, int index, char value) {
            char[] array = (char[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrCharAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static char getAndBitwiseAnd(Array handle, Object oarray, int index, char value) {
            char[] array = (char[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndChar(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static char getAndBitwiseAndRelease(Array handle, Object oarray, int index, char value) {
            char[] array = (char[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndCharRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static char getAndBitwiseAndAcquire(Array handle, Object oarray, int index, char value) {
            char[] array = (char[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndCharAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static char getAndBitwiseXor(Array handle, Object oarray, int index, char value) {
            char[] array = (char[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorChar(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static char getAndBitwiseXorRelease(Array handle, Object oarray, int index, char value) {
            char[] array = (char[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorCharRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static char getAndBitwiseXorAcquire(Array handle, Object oarray, int index, char value) {
            char[] array = (char[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorCharAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }
    }

    static final class FieldStaticReadWrite
    extends FieldStaticReadOnly {
        static final VarForm FORM = new VarForm(FieldStaticReadWrite.class, null, Character.TYPE, new Class[0]);

        FieldStaticReadWrite(Object base, long fieldOffset) {
            super(base, fieldOffset, FORM);
        }

        @ForceInline
        static void set(FieldStaticReadWrite handle, char value) {
            MethodHandleStatics.UNSAFE.putChar(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setVolatile(FieldStaticReadWrite handle, char value) {
            MethodHandleStatics.UNSAFE.putCharVolatile(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setOpaque(FieldStaticReadWrite handle, char value) {
            MethodHandleStatics.UNSAFE.putCharOpaque(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setRelease(FieldStaticReadWrite handle, char value) {
            MethodHandleStatics.UNSAFE.putCharRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean compareAndSet(FieldStaticReadWrite handle, char expected, char value) {
            return MethodHandleStatics.UNSAFE.compareAndSwapChar(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static char compareAndExchange(FieldStaticReadWrite handle, char expected, char value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeCharVolatile(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static char compareAndExchangeAcquire(FieldStaticReadWrite handle, char expected, char value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeCharAcquire(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static char compareAndExchangeRelease(FieldStaticReadWrite handle, char expected, char value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeCharRelease(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(FieldStaticReadWrite handle, char expected, char value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapChar(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(FieldStaticReadWrite handle, char expected, char value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapCharVolatile(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(FieldStaticReadWrite handle, char expected, char value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapCharAcquire(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(FieldStaticReadWrite handle, char expected, char value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapCharRelease(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static char getAndSet(FieldStaticReadWrite handle, char value) {
            return MethodHandleStatics.UNSAFE.getAndSetChar(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static char getAndSetAcquire(FieldStaticReadWrite handle, char value) {
            return MethodHandleStatics.UNSAFE.getAndSetCharAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static char getAndSetRelease(FieldStaticReadWrite handle, char value) {
            return MethodHandleStatics.UNSAFE.getAndSetCharRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static char getAndAdd(FieldStaticReadWrite handle, char value) {
            return MethodHandleStatics.UNSAFE.getAndAddChar(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static char getAndAddAcquire(FieldStaticReadWrite handle, char value) {
            return MethodHandleStatics.UNSAFE.getAndAddCharAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static char getAndAddRelease(FieldStaticReadWrite handle, char value) {
            return MethodHandleStatics.UNSAFE.getAndAddCharRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static char getAndBitwiseOr(FieldStaticReadWrite handle, char value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrChar(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static char getAndBitwiseOrRelease(FieldStaticReadWrite handle, char value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrCharRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static char getAndBitwiseOrAcquire(FieldStaticReadWrite handle, char value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrCharAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static char getAndBitwiseAnd(FieldStaticReadWrite handle, char value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndChar(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static char getAndBitwiseAndRelease(FieldStaticReadWrite handle, char value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndCharRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static char getAndBitwiseAndAcquire(FieldStaticReadWrite handle, char value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndCharAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static char getAndBitwiseXor(FieldStaticReadWrite handle, char value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorChar(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static char getAndBitwiseXorRelease(FieldStaticReadWrite handle, char value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorCharRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static char getAndBitwiseXorAcquire(FieldStaticReadWrite handle, char value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorCharAcquire(handle.base, handle.fieldOffset, value);
        }
    }

    static class FieldStaticReadOnly
    extends VarHandle {
        final Object base;
        final long fieldOffset;
        static final VarForm FORM = new VarForm(FieldStaticReadOnly.class, null, Character.TYPE, new Class[0]);

        FieldStaticReadOnly(Object base, long fieldOffset) {
            this(base, fieldOffset, FORM);
        }

        protected FieldStaticReadOnly(Object base, long fieldOffset, VarForm form) {
            super(form);
            this.base = base;
            this.fieldOffset = fieldOffset;
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(null, Character.TYPE, new Class[0]);
        }

        @ForceInline
        static char get(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getChar(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static char getVolatile(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getCharVolatile(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static char getOpaque(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getCharOpaque(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static char getAcquire(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getCharAcquire(handle.base, handle.fieldOffset);
        }
    }

    static final class FieldInstanceReadWrite
    extends FieldInstanceReadOnly {
        static final VarForm FORM = new VarForm(FieldInstanceReadWrite.class, Object.class, Character.TYPE, new Class[0]);

        FieldInstanceReadWrite(Class<?> receiverType, long fieldOffset) {
            super(receiverType, fieldOffset, FORM);
        }

        @ForceInline
        static void set(FieldInstanceReadWrite handle, Object holder, char value) {
            MethodHandleStatics.UNSAFE.putChar(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setVolatile(FieldInstanceReadWrite handle, Object holder, char value) {
            MethodHandleStatics.UNSAFE.putCharVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setOpaque(FieldInstanceReadWrite handle, Object holder, char value) {
            MethodHandleStatics.UNSAFE.putCharOpaque(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setRelease(FieldInstanceReadWrite handle, Object holder, char value) {
            MethodHandleStatics.UNSAFE.putCharRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean compareAndSet(FieldInstanceReadWrite handle, Object holder, char expected, char value) {
            return MethodHandleStatics.UNSAFE.compareAndSwapChar(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static char compareAndExchange(FieldInstanceReadWrite handle, Object holder, char expected, char value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeCharVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static char compareAndExchangeAcquire(FieldInstanceReadWrite handle, Object holder, char expected, char value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeCharAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static char compareAndExchangeRelease(FieldInstanceReadWrite handle, Object holder, char expected, char value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeCharRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(FieldInstanceReadWrite handle, Object holder, char expected, char value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapChar(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(FieldInstanceReadWrite handle, Object holder, char expected, char value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapCharVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(FieldInstanceReadWrite handle, Object holder, char expected, char value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapCharAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(FieldInstanceReadWrite handle, Object holder, char expected, char value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapCharRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static char getAndSet(FieldInstanceReadWrite handle, Object holder, char value) {
            return MethodHandleStatics.UNSAFE.getAndSetChar(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static char getAndSetAcquire(FieldInstanceReadWrite handle, Object holder, char value) {
            return MethodHandleStatics.UNSAFE.getAndSetCharAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static char getAndSetRelease(FieldInstanceReadWrite handle, Object holder, char value) {
            return MethodHandleStatics.UNSAFE.getAndSetCharRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static char getAndAdd(FieldInstanceReadWrite handle, Object holder, char value) {
            return MethodHandleStatics.UNSAFE.getAndAddChar(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static char getAndAddAcquire(FieldInstanceReadWrite handle, Object holder, char value) {
            return MethodHandleStatics.UNSAFE.getAndAddCharAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static char getAndAddRelease(FieldInstanceReadWrite handle, Object holder, char value) {
            return MethodHandleStatics.UNSAFE.getAndAddCharRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static char getAndBitwiseOr(FieldInstanceReadWrite handle, Object holder, char value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrChar(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static char getAndBitwiseOrRelease(FieldInstanceReadWrite handle, Object holder, char value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrCharRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static char getAndBitwiseOrAcquire(FieldInstanceReadWrite handle, Object holder, char value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrCharAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static char getAndBitwiseAnd(FieldInstanceReadWrite handle, Object holder, char value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndChar(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static char getAndBitwiseAndRelease(FieldInstanceReadWrite handle, Object holder, char value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndCharRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static char getAndBitwiseAndAcquire(FieldInstanceReadWrite handle, Object holder, char value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndCharAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static char getAndBitwiseXor(FieldInstanceReadWrite handle, Object holder, char value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorChar(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static char getAndBitwiseXorRelease(FieldInstanceReadWrite handle, Object holder, char value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorCharRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static char getAndBitwiseXorAcquire(FieldInstanceReadWrite handle, Object holder, char value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorCharAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }
    }

    static class FieldInstanceReadOnly
    extends VarHandle {
        final long fieldOffset;
        final Class<?> receiverType;
        static final VarForm FORM = new VarForm(FieldInstanceReadOnly.class, Object.class, Character.TYPE, new Class[0]);

        FieldInstanceReadOnly(Class<?> receiverType, long fieldOffset) {
            this(receiverType, fieldOffset, FORM);
        }

        protected FieldInstanceReadOnly(Class<?> receiverType, long fieldOffset, VarForm form) {
            super(form);
            this.fieldOffset = fieldOffset;
            this.receiverType = receiverType;
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(this.receiverType, Character.TYPE, new Class[0]);
        }

        @ForceInline
        static char get(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getChar(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static char getVolatile(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getCharVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static char getOpaque(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getCharOpaque(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static char getAcquire(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getCharAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }
    }
}

