/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import jdk.internal.util.Preconditions;
import jdk.internal.vm.annotation.ForceInline;

final class VarHandleBytes {
    VarHandleBytes() {
    }

    static final class Array
    extends VarHandle {
        final int abase;
        final int ashift;
        static final VarForm FORM = new VarForm(Array.class, byte[].class, Byte.TYPE, Integer.TYPE);

        Array(int abase, int ashift) {
            super(FORM);
            this.abase = abase;
            this.ashift = ashift;
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(byte[].class, Byte.TYPE, Integer.TYPE);
        }

        @ForceInline
        static byte get(Array handle, Object oarray, int index) {
            byte[] array = (byte[])oarray;
            return array[index];
        }

        @ForceInline
        static void set(Array handle, Object oarray, int index, byte value) {
            byte[] array = (byte[])oarray;
            array[index] = value;
        }

        @ForceInline
        static byte getVolatile(Array handle, Object oarray, int index) {
            byte[] array = (byte[])oarray;
            return MethodHandleStatics.UNSAFE.getByteVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setVolatile(Array handle, Object oarray, int index, byte value) {
            byte[] array = (byte[])oarray;
            MethodHandleStatics.UNSAFE.putByteVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static byte getOpaque(Array handle, Object oarray, int index) {
            byte[] array = (byte[])oarray;
            return MethodHandleStatics.UNSAFE.getByteOpaque(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setOpaque(Array handle, Object oarray, int index, byte value) {
            byte[] array = (byte[])oarray;
            MethodHandleStatics.UNSAFE.putByteOpaque(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static byte getAcquire(Array handle, Object oarray, int index) {
            byte[] array = (byte[])oarray;
            return MethodHandleStatics.UNSAFE.getByteAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setRelease(Array handle, Object oarray, int index, byte value) {
            byte[] array = (byte[])oarray;
            MethodHandleStatics.UNSAFE.putByteRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean compareAndSet(Array handle, Object oarray, int index, byte expected, byte value) {
            byte[] array = (byte[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndSwapByte(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static byte compareAndExchange(Array handle, Object oarray, int index, byte expected, byte value) {
            byte[] array = (byte[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeByteVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static byte compareAndExchangeAcquire(Array handle, Object oarray, int index, byte expected, byte value) {
            byte[] array = (byte[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeByteAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static byte compareAndExchangeRelease(Array handle, Object oarray, int index, byte expected, byte value) {
            byte[] array = (byte[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeByteRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(Array handle, Object oarray, int index, byte expected, byte value) {
            byte[] array = (byte[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapByte(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(Array handle, Object oarray, int index, byte expected, byte value) {
            byte[] array = (byte[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapByteVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(Array handle, Object oarray, int index, byte expected, byte value) {
            byte[] array = (byte[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapByteAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(Array handle, Object oarray, int index, byte expected, byte value) {
            byte[] array = (byte[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapByteRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static byte getAndSet(Array handle, Object oarray, int index, byte value) {
            byte[] array = (byte[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetByte(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static byte getAndSetAcquire(Array handle, Object oarray, int index, byte value) {
            byte[] array = (byte[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetByteAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static byte getAndSetRelease(Array handle, Object oarray, int index, byte value) {
            byte[] array = (byte[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetByteRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static byte getAndAdd(Array handle, Object oarray, int index, byte value) {
            byte[] array = (byte[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddByte(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static byte getAndAddAcquire(Array handle, Object oarray, int index, byte value) {
            byte[] array = (byte[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddByteAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static byte getAndAddRelease(Array handle, Object oarray, int index, byte value) {
            byte[] array = (byte[])oarray;
            return MethodHandleStatics.UNSAFE.getAndAddByteRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static byte getAndBitwiseOr(Array handle, Object oarray, int index, byte value) {
            byte[] array = (byte[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrByte(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static byte getAndBitwiseOrRelease(Array handle, Object oarray, int index, byte value) {
            byte[] array = (byte[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrByteRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static byte getAndBitwiseOrAcquire(Array handle, Object oarray, int index, byte value) {
            byte[] array = (byte[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrByteAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static byte getAndBitwiseAnd(Array handle, Object oarray, int index, byte value) {
            byte[] array = (byte[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndByte(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static byte getAndBitwiseAndRelease(Array handle, Object oarray, int index, byte value) {
            byte[] array = (byte[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndByteRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static byte getAndBitwiseAndAcquire(Array handle, Object oarray, int index, byte value) {
            byte[] array = (byte[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndByteAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static byte getAndBitwiseXor(Array handle, Object oarray, int index, byte value) {
            byte[] array = (byte[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorByte(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static byte getAndBitwiseXorRelease(Array handle, Object oarray, int index, byte value) {
            byte[] array = (byte[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorByteRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static byte getAndBitwiseXorAcquire(Array handle, Object oarray, int index, byte value) {
            byte[] array = (byte[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorByteAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }
    }

    static final class FieldStaticReadWrite
    extends FieldStaticReadOnly {
        static final VarForm FORM = new VarForm(FieldStaticReadWrite.class, null, Byte.TYPE, new Class[0]);

        FieldStaticReadWrite(Object base, long fieldOffset) {
            super(base, fieldOffset, FORM);
        }

        @ForceInline
        static void set(FieldStaticReadWrite handle, byte value) {
            MethodHandleStatics.UNSAFE.putByte(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setVolatile(FieldStaticReadWrite handle, byte value) {
            MethodHandleStatics.UNSAFE.putByteVolatile(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setOpaque(FieldStaticReadWrite handle, byte value) {
            MethodHandleStatics.UNSAFE.putByteOpaque(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setRelease(FieldStaticReadWrite handle, byte value) {
            MethodHandleStatics.UNSAFE.putByteRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean compareAndSet(FieldStaticReadWrite handle, byte expected, byte value) {
            return MethodHandleStatics.UNSAFE.compareAndSwapByte(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static byte compareAndExchange(FieldStaticReadWrite handle, byte expected, byte value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeByteVolatile(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static byte compareAndExchangeAcquire(FieldStaticReadWrite handle, byte expected, byte value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeByteAcquire(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static byte compareAndExchangeRelease(FieldStaticReadWrite handle, byte expected, byte value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeByteRelease(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(FieldStaticReadWrite handle, byte expected, byte value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapByte(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(FieldStaticReadWrite handle, byte expected, byte value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapByteVolatile(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(FieldStaticReadWrite handle, byte expected, byte value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapByteAcquire(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(FieldStaticReadWrite handle, byte expected, byte value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapByteRelease(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static byte getAndSet(FieldStaticReadWrite handle, byte value) {
            return MethodHandleStatics.UNSAFE.getAndSetByte(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static byte getAndSetAcquire(FieldStaticReadWrite handle, byte value) {
            return MethodHandleStatics.UNSAFE.getAndSetByteAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static byte getAndSetRelease(FieldStaticReadWrite handle, byte value) {
            return MethodHandleStatics.UNSAFE.getAndSetByteRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static byte getAndAdd(FieldStaticReadWrite handle, byte value) {
            return MethodHandleStatics.UNSAFE.getAndAddByte(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static byte getAndAddAcquire(FieldStaticReadWrite handle, byte value) {
            return MethodHandleStatics.UNSAFE.getAndAddByteAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static byte getAndAddRelease(FieldStaticReadWrite handle, byte value) {
            return MethodHandleStatics.UNSAFE.getAndAddByteRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static byte getAndBitwiseOr(FieldStaticReadWrite handle, byte value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrByte(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static byte getAndBitwiseOrRelease(FieldStaticReadWrite handle, byte value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrByteRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static byte getAndBitwiseOrAcquire(FieldStaticReadWrite handle, byte value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrByteAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static byte getAndBitwiseAnd(FieldStaticReadWrite handle, byte value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndByte(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static byte getAndBitwiseAndRelease(FieldStaticReadWrite handle, byte value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndByteRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static byte getAndBitwiseAndAcquire(FieldStaticReadWrite handle, byte value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndByteAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static byte getAndBitwiseXor(FieldStaticReadWrite handle, byte value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorByte(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static byte getAndBitwiseXorRelease(FieldStaticReadWrite handle, byte value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorByteRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static byte getAndBitwiseXorAcquire(FieldStaticReadWrite handle, byte value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorByteAcquire(handle.base, handle.fieldOffset, value);
        }
    }

    static class FieldStaticReadOnly
    extends VarHandle {
        final Object base;
        final long fieldOffset;
        static final VarForm FORM = new VarForm(FieldStaticReadOnly.class, null, Byte.TYPE, new Class[0]);

        FieldStaticReadOnly(Object base, long fieldOffset) {
            this(base, fieldOffset, FORM);
        }

        protected FieldStaticReadOnly(Object base, long fieldOffset, VarForm form) {
            super(form);
            this.base = base;
            this.fieldOffset = fieldOffset;
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(null, Byte.TYPE, new Class[0]);
        }

        @ForceInline
        static byte get(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getByte(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static byte getVolatile(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getByteVolatile(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static byte getOpaque(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getByteOpaque(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static byte getAcquire(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getByteAcquire(handle.base, handle.fieldOffset);
        }
    }

    static final class FieldInstanceReadWrite
    extends FieldInstanceReadOnly {
        static final VarForm FORM = new VarForm(FieldInstanceReadWrite.class, Object.class, Byte.TYPE, new Class[0]);

        FieldInstanceReadWrite(Class<?> receiverType, long fieldOffset) {
            super(receiverType, fieldOffset, FORM);
        }

        @ForceInline
        static void set(FieldInstanceReadWrite handle, Object holder, byte value) {
            MethodHandleStatics.UNSAFE.putByte(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setVolatile(FieldInstanceReadWrite handle, Object holder, byte value) {
            MethodHandleStatics.UNSAFE.putByteVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setOpaque(FieldInstanceReadWrite handle, Object holder, byte value) {
            MethodHandleStatics.UNSAFE.putByteOpaque(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setRelease(FieldInstanceReadWrite handle, Object holder, byte value) {
            MethodHandleStatics.UNSAFE.putByteRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean compareAndSet(FieldInstanceReadWrite handle, Object holder, byte expected, byte value) {
            return MethodHandleStatics.UNSAFE.compareAndSwapByte(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static byte compareAndExchange(FieldInstanceReadWrite handle, Object holder, byte expected, byte value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeByteVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static byte compareAndExchangeAcquire(FieldInstanceReadWrite handle, Object holder, byte expected, byte value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeByteAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static byte compareAndExchangeRelease(FieldInstanceReadWrite handle, Object holder, byte expected, byte value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeByteRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(FieldInstanceReadWrite handle, Object holder, byte expected, byte value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapByte(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(FieldInstanceReadWrite handle, Object holder, byte expected, byte value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapByteVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(FieldInstanceReadWrite handle, Object holder, byte expected, byte value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapByteAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(FieldInstanceReadWrite handle, Object holder, byte expected, byte value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapByteRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static byte getAndSet(FieldInstanceReadWrite handle, Object holder, byte value) {
            return MethodHandleStatics.UNSAFE.getAndSetByte(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static byte getAndSetAcquire(FieldInstanceReadWrite handle, Object holder, byte value) {
            return MethodHandleStatics.UNSAFE.getAndSetByteAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static byte getAndSetRelease(FieldInstanceReadWrite handle, Object holder, byte value) {
            return MethodHandleStatics.UNSAFE.getAndSetByteRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static byte getAndAdd(FieldInstanceReadWrite handle, Object holder, byte value) {
            return MethodHandleStatics.UNSAFE.getAndAddByte(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static byte getAndAddAcquire(FieldInstanceReadWrite handle, Object holder, byte value) {
            return MethodHandleStatics.UNSAFE.getAndAddByteAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static byte getAndAddRelease(FieldInstanceReadWrite handle, Object holder, byte value) {
            return MethodHandleStatics.UNSAFE.getAndAddByteRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static byte getAndBitwiseOr(FieldInstanceReadWrite handle, Object holder, byte value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrByte(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static byte getAndBitwiseOrRelease(FieldInstanceReadWrite handle, Object holder, byte value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrByteRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static byte getAndBitwiseOrAcquire(FieldInstanceReadWrite handle, Object holder, byte value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrByteAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static byte getAndBitwiseAnd(FieldInstanceReadWrite handle, Object holder, byte value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndByte(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static byte getAndBitwiseAndRelease(FieldInstanceReadWrite handle, Object holder, byte value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndByteRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static byte getAndBitwiseAndAcquire(FieldInstanceReadWrite handle, Object holder, byte value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndByteAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static byte getAndBitwiseXor(FieldInstanceReadWrite handle, Object holder, byte value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorByte(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static byte getAndBitwiseXorRelease(FieldInstanceReadWrite handle, Object holder, byte value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorByteRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static byte getAndBitwiseXorAcquire(FieldInstanceReadWrite handle, Object holder, byte value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorByteAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }
    }

    static class FieldInstanceReadOnly
    extends VarHandle {
        final long fieldOffset;
        final Class<?> receiverType;
        static final VarForm FORM = new VarForm(FieldInstanceReadOnly.class, Object.class, Byte.TYPE, new Class[0]);

        FieldInstanceReadOnly(Class<?> receiverType, long fieldOffset) {
            this(receiverType, fieldOffset, FORM);
        }

        protected FieldInstanceReadOnly(Class<?> receiverType, long fieldOffset, VarForm form) {
            super(form);
            this.fieldOffset = fieldOffset;
            this.receiverType = receiverType;
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(this.receiverType, Byte.TYPE, new Class[0]);
        }

        @ForceInline
        static byte get(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getByte(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static byte getVolatile(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getByteVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static byte getOpaque(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getByteOpaque(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static byte getAcquire(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getByteAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }
    }
}

