/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.lang.invoke.VarHandleByteArrayBase;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import jdk.internal.misc.Unsafe;
import jdk.internal.util.Preconditions;
import jdk.internal.vm.annotation.ForceInline;

final class VarHandleByteArrayAsShorts
extends VarHandleByteArrayBase {
    static final int ALIGN = 1;

    VarHandleByteArrayAsShorts() {
    }

    @ForceInline
    static short convEndian(boolean big, short n) {
        return big == BE ? n : Short.reverseBytes(n);
    }

    static final class ByteBufferHandle
    extends ByteArrayViewVarHandle {
        static final VarForm FORM = new VarForm(ByteBufferHandle.class, ByteBuffer.class, Short.TYPE, Integer.TYPE);

        ByteBufferHandle(boolean be) {
            super(FORM, be);
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(ByteBuffer.class, Short.TYPE, Integer.TYPE);
        }

        @ForceInline
        static int index(ByteBuffer bb, int index) {
            return Preconditions.checkIndex(index, MethodHandleStatics.UNSAFE.getInt(bb, VarHandleByteArrayBase.BUFFER_LIMIT) - 1, null);
        }

        @ForceInline
        static int indexRO(ByteBuffer bb, int index) {
            if (MethodHandleStatics.UNSAFE.getBoolean(bb, VarHandleByteArrayBase.BYTE_BUFFER_IS_READ_ONLY)) {
                throw new ReadOnlyBufferException();
            }
            return Preconditions.checkIndex(index, MethodHandleStatics.UNSAFE.getInt(bb, VarHandleByteArrayBase.BUFFER_LIMIT) - 1, null);
        }

        @ForceInline
        static long address(ByteBuffer bb, int index) {
            long address = (long)index + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS);
            if ((address & 1L) != 0L) {
                throw VarHandleByteArrayBase.newIllegalStateExceptionForMisalignedAccess(index);
            }
            return address;
        }

        @ForceInline
        static short get(ByteBufferHandle handle, Object obb, int index) {
            ByteBuffer bb = (ByteBuffer)obb;
            return MethodHandleStatics.UNSAFE.getShortUnaligned(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), (long)ByteBufferHandle.index(bb, index) + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS), handle.be);
        }

        @ForceInline
        static void set(ByteBufferHandle handle, Object obb, int index, short value) {
            ByteBuffer bb = (ByteBuffer)obb;
            MethodHandleStatics.UNSAFE.putShortUnaligned(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), (long)ByteBufferHandle.indexRO(bb, index) + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS), value, handle.be);
        }

        @ForceInline
        static short getVolatile(ByteBufferHandle handle, Object obb, int index) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsShorts.convEndian(handle.be, MethodHandleStatics.UNSAFE.getShortVolatile(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setVolatile(ByteBufferHandle handle, Object obb, int index, short value) {
            ByteBuffer bb = (ByteBuffer)obb;
            MethodHandleStatics.UNSAFE.putShortVolatile(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsShorts.convEndian(handle.be, value));
        }

        @ForceInline
        static short getAcquire(ByteBufferHandle handle, Object obb, int index) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsShorts.convEndian(handle.be, MethodHandleStatics.UNSAFE.getShortAcquire(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setRelease(ByteBufferHandle handle, Object obb, int index, short value) {
            ByteBuffer bb = (ByteBuffer)obb;
            MethodHandleStatics.UNSAFE.putShortRelease(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsShorts.convEndian(handle.be, value));
        }

        @ForceInline
        static short getOpaque(ByteBufferHandle handle, Object obb, int index) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsShorts.convEndian(handle.be, MethodHandleStatics.UNSAFE.getShortOpaque(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setOpaque(ByteBufferHandle handle, Object obb, int index, short value) {
            ByteBuffer bb = (ByteBuffer)obb;
            MethodHandleStatics.UNSAFE.putShortOpaque(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsShorts.convEndian(handle.be, value));
        }
    }

    static final class ArrayHandle
    extends ByteArrayViewVarHandle {
        static final VarForm FORM = new VarForm(ArrayHandle.class, byte[].class, Short.TYPE, Integer.TYPE);

        ArrayHandle(boolean be) {
            super(FORM, be);
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(byte[].class, Short.TYPE, Integer.TYPE);
        }

        @ForceInline
        static int index(byte[] ba, int index) {
            return Preconditions.checkIndex(index, ba.length - 1, null);
        }

        @ForceInline
        static long address(byte[] ba, int index) {
            long address = (long)index + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET;
            if ((address & 1L) != 0L) {
                throw VarHandleByteArrayBase.newIllegalStateExceptionForMisalignedAccess(index);
            }
            return address;
        }

        @ForceInline
        static short get(ArrayHandle handle, Object oba, int index) {
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.getShortUnaligned(ba, (long)ArrayHandle.index(ba, index) + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, handle.be);
        }

        @ForceInline
        static void set(ArrayHandle handle, Object oba, int index, short value) {
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putShortUnaligned(ba, (long)ArrayHandle.index(ba, index) + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, value, handle.be);
        }

        @ForceInline
        static short getVolatile(ArrayHandle handle, Object oba, int index) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsShorts.convEndian(handle.be, MethodHandleStatics.UNSAFE.getShortVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setVolatile(ArrayHandle handle, Object oba, int index, short value) {
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putShortVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsShorts.convEndian(handle.be, value));
        }

        @ForceInline
        static short getAcquire(ArrayHandle handle, Object oba, int index) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsShorts.convEndian(handle.be, MethodHandleStatics.UNSAFE.getShortAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setRelease(ArrayHandle handle, Object oba, int index, short value) {
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putShortRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsShorts.convEndian(handle.be, value));
        }

        @ForceInline
        static short getOpaque(ArrayHandle handle, Object oba, int index) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsShorts.convEndian(handle.be, MethodHandleStatics.UNSAFE.getShortOpaque(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setOpaque(ArrayHandle handle, Object oba, int index, short value) {
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putShortOpaque(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsShorts.convEndian(handle.be, value));
        }
    }

    private static abstract class ByteArrayViewVarHandle
    extends VarHandle {
        final boolean be;

        ByteArrayViewVarHandle(VarForm form, boolean be) {
            super(form);
            this.be = be;
        }
    }
}

