/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.lang.invoke.VarHandleByteArrayBase;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import jdk.internal.misc.Unsafe;
import jdk.internal.util.Preconditions;
import jdk.internal.vm.annotation.ForceInline;

final class VarHandleByteArrayAsLongs
extends VarHandleByteArrayBase {
    static final int ALIGN = 7;

    VarHandleByteArrayAsLongs() {
    }

    @ForceInline
    static long convEndian(boolean big, long n) {
        return big == BE ? n : Long.reverseBytes(n);
    }

    static final class ByteBufferHandle
    extends ByteArrayViewVarHandle {
        static final VarForm FORM = new VarForm(ByteBufferHandle.class, ByteBuffer.class, Long.TYPE, Integer.TYPE);

        ByteBufferHandle(boolean be) {
            super(FORM, be);
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(ByteBuffer.class, Long.TYPE, Integer.TYPE);
        }

        @ForceInline
        static int index(ByteBuffer bb, int index) {
            return Preconditions.checkIndex(index, MethodHandleStatics.UNSAFE.getInt(bb, VarHandleByteArrayBase.BUFFER_LIMIT) - 7, null);
        }

        @ForceInline
        static int indexRO(ByteBuffer bb, int index) {
            if (MethodHandleStatics.UNSAFE.getBoolean(bb, VarHandleByteArrayBase.BYTE_BUFFER_IS_READ_ONLY)) {
                throw new ReadOnlyBufferException();
            }
            return Preconditions.checkIndex(index, MethodHandleStatics.UNSAFE.getInt(bb, VarHandleByteArrayBase.BUFFER_LIMIT) - 7, null);
        }

        @ForceInline
        static long address(ByteBuffer bb, int index) {
            long address = (long)index + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS);
            if ((address & 7L) != 0L) {
                throw VarHandleByteArrayBase.newIllegalStateExceptionForMisalignedAccess(index);
            }
            return address;
        }

        @ForceInline
        static long get(ByteBufferHandle handle, Object obb, int index) {
            ByteBuffer bb = (ByteBuffer)obb;
            return MethodHandleStatics.UNSAFE.getLongUnaligned(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), (long)ByteBufferHandle.index(bb, index) + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS), handle.be);
        }

        @ForceInline
        static void set(ByteBufferHandle handle, Object obb, int index, long value) {
            ByteBuffer bb = (ByteBuffer)obb;
            MethodHandleStatics.UNSAFE.putLongUnaligned(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), (long)ByteBufferHandle.indexRO(bb, index) + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS), value, handle.be);
        }

        @ForceInline
        static long getVolatile(ByteBufferHandle handle, Object obb, int index) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsLongs.convEndian(handle.be, MethodHandleStatics.UNSAFE.getLongVolatile(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setVolatile(ByteBufferHandle handle, Object obb, int index, long value) {
            ByteBuffer bb = (ByteBuffer)obb;
            MethodHandleStatics.UNSAFE.putLongVolatile(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static long getAcquire(ByteBufferHandle handle, Object obb, int index) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsLongs.convEndian(handle.be, MethodHandleStatics.UNSAFE.getLongAcquire(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setRelease(ByteBufferHandle handle, Object obb, int index, long value) {
            ByteBuffer bb = (ByteBuffer)obb;
            MethodHandleStatics.UNSAFE.putLongRelease(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static long getOpaque(ByteBufferHandle handle, Object obb, int index) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsLongs.convEndian(handle.be, MethodHandleStatics.UNSAFE.getLongOpaque(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setOpaque(ByteBufferHandle handle, Object obb, int index, long value) {
            ByteBuffer bb = (ByteBuffer)obb;
            MethodHandleStatics.UNSAFE.putLongOpaque(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean compareAndSet(ByteBufferHandle handle, Object obb, int index, long expected, long value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return MethodHandleStatics.UNSAFE.compareAndSwapLong(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static long compareAndExchange(ByteBufferHandle handle, Object obb, int index, long expected, long value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsLongs.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeLongVolatile(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value)));
        }

        @ForceInline
        static long compareAndExchangeAcquire(ByteBufferHandle handle, Object obb, int index, long expected, long value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsLongs.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeLongAcquire(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value)));
        }

        @ForceInline
        static long compareAndExchangeRelease(ByteBufferHandle handle, Object obb, int index, long expected, long value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsLongs.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeLongRelease(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value)));
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(ByteBufferHandle handle, Object obb, int index, long expected, long value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapLong(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSet(ByteBufferHandle handle, Object obb, int index, long expected, long value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapLongVolatile(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(ByteBufferHandle handle, Object obb, int index, long expected, long value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapLongAcquire(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(ByteBufferHandle handle, Object obb, int index, long expected, long value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapLongRelease(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static long getAndSet(ByteBufferHandle handle, Object obb, int index, long value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsLongs.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetLong(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, value)));
        }

        @ForceInline
        static long getAndSetAcquire(ByteBufferHandle handle, Object obb, int index, long value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsLongs.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetLongAcquire(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, value)));
        }

        @ForceInline
        static long getAndSetRelease(ByteBufferHandle handle, Object obb, int index, long value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsLongs.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetLongRelease(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, value)));
        }

        @ForceInline
        static long getAndAdd(ByteBufferHandle handle, Object obb, int index, long delta) {
            ByteBuffer bb = (ByteBuffer)obb;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndAddLong(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), delta);
            }
            return ByteBufferHandle.getAndAddConvEndianWithCAS(bb, index, delta);
        }

        @ForceInline
        static long getAndAddAcquire(ByteBufferHandle handle, Object obb, int index, long delta) {
            ByteBuffer bb = (ByteBuffer)obb;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndAddLongAcquire(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), delta);
            }
            return ByteBufferHandle.getAndAddConvEndianWithCAS(bb, index, delta);
        }

        @ForceInline
        static long getAndAddRelease(ByteBufferHandle handle, Object obb, int index, long delta) {
            ByteBuffer bb = (ByteBuffer)obb;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndAddLongRelease(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), delta);
            }
            return ByteBufferHandle.getAndAddConvEndianWithCAS(bb, index, delta);
        }

        @ForceInline
        static long getAndAddConvEndianWithCAS(ByteBuffer bb, int index, long delta) {
            long expectedValue;
            long nativeExpectedValue;
            Object base = MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB);
            long offset = ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSwapLongVolatile(base, offset, nativeExpectedValue = MethodHandleStatics.UNSAFE.getLongVolatile(base, offset), Long.reverseBytes((expectedValue = Long.reverseBytes(nativeExpectedValue)) + delta))) {
            }
            return expectedValue;
        }

        @ForceInline
        static long getAndBitwiseOr(ByteBufferHandle handle, Object obb, int index, long value) {
            ByteBuffer bb = (ByteBuffer)obb;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseOrLong(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseOrConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static long getAndBitwiseOrRelease(ByteBufferHandle handle, Object obb, int index, long value) {
            ByteBuffer bb = (ByteBuffer)obb;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseOrLongRelease(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseOrConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static long getAndBitwiseOrAcquire(ByteBufferHandle handle, Object obb, int index, long value) {
            ByteBuffer bb = (ByteBuffer)obb;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseOrLongAcquire(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseOrConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static long getAndBitwiseOrConvEndianWithCAS(ByteBuffer bb, int index, long value) {
            long expectedValue;
            long nativeExpectedValue;
            Object base = MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB);
            long offset = ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSwapLongVolatile(base, offset, nativeExpectedValue = MethodHandleStatics.UNSAFE.getLongVolatile(base, offset), Long.reverseBytes((expectedValue = Long.reverseBytes(nativeExpectedValue)) | value))) {
            }
            return expectedValue;
        }

        @ForceInline
        static long getAndBitwiseAnd(ByteBufferHandle handle, Object obb, int index, long value) {
            ByteBuffer bb = (ByteBuffer)obb;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseAndLong(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseAndConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static long getAndBitwiseAndRelease(ByteBufferHandle handle, Object obb, int index, long value) {
            ByteBuffer bb = (ByteBuffer)obb;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseAndLongRelease(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseAndConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static long getAndBitwiseAndAcquire(ByteBufferHandle handle, Object obb, int index, long value) {
            ByteBuffer bb = (ByteBuffer)obb;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseAndLongAcquire(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseAndConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static long getAndBitwiseAndConvEndianWithCAS(ByteBuffer bb, int index, long value) {
            long expectedValue;
            long nativeExpectedValue;
            Object base = MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB);
            long offset = ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSwapLongVolatile(base, offset, nativeExpectedValue = MethodHandleStatics.UNSAFE.getLongVolatile(base, offset), Long.reverseBytes((expectedValue = Long.reverseBytes(nativeExpectedValue)) & value))) {
            }
            return expectedValue;
        }

        @ForceInline
        static long getAndBitwiseXor(ByteBufferHandle handle, Object obb, int index, long value) {
            ByteBuffer bb = (ByteBuffer)obb;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseXorLong(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseXorConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static long getAndBitwiseXorRelease(ByteBufferHandle handle, Object obb, int index, long value) {
            ByteBuffer bb = (ByteBuffer)obb;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseXorLongRelease(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseXorConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static long getAndBitwiseXorAcquire(ByteBufferHandle handle, Object obb, int index, long value) {
            ByteBuffer bb = (ByteBuffer)obb;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseXorLongAcquire(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseXorConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static long getAndBitwiseXorConvEndianWithCAS(ByteBuffer bb, int index, long value) {
            long expectedValue;
            long nativeExpectedValue;
            Object base = MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB);
            long offset = ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSwapLongVolatile(base, offset, nativeExpectedValue = MethodHandleStatics.UNSAFE.getLongVolatile(base, offset), Long.reverseBytes((expectedValue = Long.reverseBytes(nativeExpectedValue)) ^ value))) {
            }
            return expectedValue;
        }
    }

    static final class ArrayHandle
    extends ByteArrayViewVarHandle {
        static final VarForm FORM = new VarForm(ArrayHandle.class, byte[].class, Long.TYPE, Integer.TYPE);

        ArrayHandle(boolean be) {
            super(FORM, be);
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(byte[].class, Long.TYPE, Integer.TYPE);
        }

        @ForceInline
        static int index(byte[] ba, int index) {
            return Preconditions.checkIndex(index, ba.length - 7, null);
        }

        @ForceInline
        static long address(byte[] ba, int index) {
            long address = (long)index + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET;
            if ((address & 7L) != 0L) {
                throw VarHandleByteArrayBase.newIllegalStateExceptionForMisalignedAccess(index);
            }
            return address;
        }

        @ForceInline
        static long get(ArrayHandle handle, Object oba, int index) {
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.getLongUnaligned(ba, (long)ArrayHandle.index(ba, index) + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, handle.be);
        }

        @ForceInline
        static void set(ArrayHandle handle, Object oba, int index, long value) {
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putLongUnaligned(ba, (long)ArrayHandle.index(ba, index) + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, value, handle.be);
        }

        @ForceInline
        static long getVolatile(ArrayHandle handle, Object oba, int index) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsLongs.convEndian(handle.be, MethodHandleStatics.UNSAFE.getLongVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setVolatile(ArrayHandle handle, Object oba, int index, long value) {
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putLongVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static long getAcquire(ArrayHandle handle, Object oba, int index) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsLongs.convEndian(handle.be, MethodHandleStatics.UNSAFE.getLongAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setRelease(ArrayHandle handle, Object oba, int index, long value) {
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putLongRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static long getOpaque(ArrayHandle handle, Object oba, int index) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsLongs.convEndian(handle.be, MethodHandleStatics.UNSAFE.getLongOpaque(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setOpaque(ArrayHandle handle, Object oba, int index, long value) {
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putLongOpaque(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean compareAndSet(ArrayHandle handle, Object oba, int index, long expected, long value) {
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.compareAndSwapLong(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static long compareAndExchange(ArrayHandle handle, Object oba, int index, long expected, long value) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsLongs.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeLongVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value)));
        }

        @ForceInline
        static long compareAndExchangeAcquire(ArrayHandle handle, Object oba, int index, long expected, long value) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsLongs.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeLongAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value)));
        }

        @ForceInline
        static long compareAndExchangeRelease(ArrayHandle handle, Object oba, int index, long expected, long value) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsLongs.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeLongRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value)));
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(ArrayHandle handle, Object oba, int index, long expected, long value) {
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapLong(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSet(ArrayHandle handle, Object oba, int index, long expected, long value) {
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapLongVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(ArrayHandle handle, Object oba, int index, long expected, long value) {
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapLongAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(ArrayHandle handle, Object oba, int index, long expected, long value) {
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapLongRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, expected), VarHandleByteArrayAsLongs.convEndian(handle.be, value));
        }

        @ForceInline
        static long getAndSet(ArrayHandle handle, Object oba, int index, long value) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsLongs.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetLong(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, value)));
        }

        @ForceInline
        static long getAndSetAcquire(ArrayHandle handle, Object oba, int index, long value) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsLongs.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetLongAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, value)));
        }

        @ForceInline
        static long getAndSetRelease(ArrayHandle handle, Object oba, int index, long value) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsLongs.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetLongRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsLongs.convEndian(handle.be, value)));
        }

        @ForceInline
        static long getAndAdd(ArrayHandle handle, Object oba, int index, long delta) {
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndAddLong(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), delta);
            }
            return ArrayHandle.getAndAddConvEndianWithCAS(ba, index, delta);
        }

        @ForceInline
        static long getAndAddAcquire(ArrayHandle handle, Object oba, int index, long delta) {
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndAddLongAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), delta);
            }
            return ArrayHandle.getAndAddConvEndianWithCAS(ba, index, delta);
        }

        @ForceInline
        static long getAndAddRelease(ArrayHandle handle, Object oba, int index, long delta) {
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndAddLongRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), delta);
            }
            return ArrayHandle.getAndAddConvEndianWithCAS(ba, index, delta);
        }

        @ForceInline
        static long getAndAddConvEndianWithCAS(byte[] ba, int index, long delta) {
            long expectedValue;
            long nativeExpectedValue;
            long offset = ArrayHandle.address(ba, ArrayHandle.index(ba, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSwapLongVolatile(ba, offset, nativeExpectedValue = MethodHandleStatics.UNSAFE.getLongVolatile(ba, offset), Long.reverseBytes((expectedValue = Long.reverseBytes(nativeExpectedValue)) + delta))) {
            }
            return expectedValue;
        }

        @ForceInline
        static long getAndBitwiseOr(ArrayHandle handle, Object oba, int index, long value) {
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseOrLong(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseOrConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static long getAndBitwiseOrRelease(ArrayHandle handle, Object oba, int index, long value) {
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseOrLongRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseOrConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static long getAndBitwiseOrAcquire(ArrayHandle handle, Object oba, int index, long value) {
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseOrLongAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseOrConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static long getAndBitwiseOrConvEndianWithCAS(byte[] ba, int index, long value) {
            long expectedValue;
            long nativeExpectedValue;
            long offset = ArrayHandle.address(ba, ArrayHandle.index(ba, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSwapLongVolatile(ba, offset, nativeExpectedValue = MethodHandleStatics.UNSAFE.getLongVolatile(ba, offset), Long.reverseBytes((expectedValue = Long.reverseBytes(nativeExpectedValue)) | value))) {
            }
            return expectedValue;
        }

        @ForceInline
        static long getAndBitwiseAnd(ArrayHandle handle, Object oba, int index, long value) {
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseAndLong(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseAndConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static long getAndBitwiseAndRelease(ArrayHandle handle, Object oba, int index, long value) {
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseAndLongRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseAndConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static long getAndBitwiseAndAcquire(ArrayHandle handle, Object oba, int index, long value) {
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseAndLongAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseAndConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static long getAndBitwiseAndConvEndianWithCAS(byte[] ba, int index, long value) {
            long expectedValue;
            long nativeExpectedValue;
            long offset = ArrayHandle.address(ba, ArrayHandle.index(ba, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSwapLongVolatile(ba, offset, nativeExpectedValue = MethodHandleStatics.UNSAFE.getLongVolatile(ba, offset), Long.reverseBytes((expectedValue = Long.reverseBytes(nativeExpectedValue)) & value))) {
            }
            return expectedValue;
        }

        @ForceInline
        static long getAndBitwiseXor(ArrayHandle handle, Object oba, int index, long value) {
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseXorLong(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseXorConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static long getAndBitwiseXorRelease(ArrayHandle handle, Object oba, int index, long value) {
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseXorLongRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseXorConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static long getAndBitwiseXorAcquire(ArrayHandle handle, Object oba, int index, long value) {
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseXorLongAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseXorConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static long getAndBitwiseXorConvEndianWithCAS(byte[] ba, int index, long value) {
            long expectedValue;
            long nativeExpectedValue;
            long offset = ArrayHandle.address(ba, ArrayHandle.index(ba, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSwapLongVolatile(ba, offset, nativeExpectedValue = MethodHandleStatics.UNSAFE.getLongVolatile(ba, offset), Long.reverseBytes((expectedValue = Long.reverseBytes(nativeExpectedValue)) ^ value))) {
            }
            return expectedValue;
        }
    }

    private static abstract class ByteArrayViewVarHandle
    extends VarHandle {
        final boolean be;

        ByteArrayViewVarHandle(VarForm form, boolean be) {
            super(form);
            this.be = be;
        }
    }
}

