/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.lang.invoke.VarHandleByteArrayBase;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import jdk.internal.misc.Unsafe;
import jdk.internal.util.Preconditions;
import jdk.internal.vm.annotation.ForceInline;

final class VarHandleByteArrayAsInts
extends VarHandleByteArrayBase {
    static final int ALIGN = 3;

    VarHandleByteArrayAsInts() {
    }

    @ForceInline
    static int convEndian(boolean big, int n) {
        return big == BE ? n : Integer.reverseBytes(n);
    }

    static final class ByteBufferHandle
    extends ByteArrayViewVarHandle {
        static final VarForm FORM = new VarForm(ByteBufferHandle.class, ByteBuffer.class, Integer.TYPE, Integer.TYPE);

        ByteBufferHandle(boolean be) {
            super(FORM, be);
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(ByteBuffer.class, Integer.TYPE, Integer.TYPE);
        }

        @ForceInline
        static int index(ByteBuffer bb, int index) {
            return Preconditions.checkIndex(index, MethodHandleStatics.UNSAFE.getInt(bb, VarHandleByteArrayBase.BUFFER_LIMIT) - 3, null);
        }

        @ForceInline
        static int indexRO(ByteBuffer bb, int index) {
            if (MethodHandleStatics.UNSAFE.getBoolean(bb, VarHandleByteArrayBase.BYTE_BUFFER_IS_READ_ONLY)) {
                throw new ReadOnlyBufferException();
            }
            return Preconditions.checkIndex(index, MethodHandleStatics.UNSAFE.getInt(bb, VarHandleByteArrayBase.BUFFER_LIMIT) - 3, null);
        }

        @ForceInline
        static long address(ByteBuffer bb, int index) {
            long address = (long)index + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS);
            if ((address & 3L) != 0L) {
                throw VarHandleByteArrayBase.newIllegalStateExceptionForMisalignedAccess(index);
            }
            return address;
        }

        @ForceInline
        static int get(ByteBufferHandle handle, Object obb, int index) {
            ByteBuffer bb = (ByteBuffer)obb;
            return MethodHandleStatics.UNSAFE.getIntUnaligned(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), (long)ByteBufferHandle.index(bb, index) + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS), handle.be);
        }

        @ForceInline
        static void set(ByteBufferHandle handle, Object obb, int index, int value) {
            ByteBuffer bb = (ByteBuffer)obb;
            MethodHandleStatics.UNSAFE.putIntUnaligned(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), (long)ByteBufferHandle.indexRO(bb, index) + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS), value, handle.be);
        }

        @ForceInline
        static int getVolatile(ByteBufferHandle handle, Object obb, int index) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsInts.convEndian(handle.be, MethodHandleStatics.UNSAFE.getIntVolatile(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setVolatile(ByteBufferHandle handle, Object obb, int index, int value) {
            ByteBuffer bb = (ByteBuffer)obb;
            MethodHandleStatics.UNSAFE.putIntVolatile(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static int getAcquire(ByteBufferHandle handle, Object obb, int index) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsInts.convEndian(handle.be, MethodHandleStatics.UNSAFE.getIntAcquire(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setRelease(ByteBufferHandle handle, Object obb, int index, int value) {
            ByteBuffer bb = (ByteBuffer)obb;
            MethodHandleStatics.UNSAFE.putIntRelease(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static int getOpaque(ByteBufferHandle handle, Object obb, int index) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsInts.convEndian(handle.be, MethodHandleStatics.UNSAFE.getIntOpaque(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setOpaque(ByteBufferHandle handle, Object obb, int index, int value) {
            ByteBuffer bb = (ByteBuffer)obb;
            MethodHandleStatics.UNSAFE.putIntOpaque(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean compareAndSet(ByteBufferHandle handle, Object obb, int index, int expected, int value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return MethodHandleStatics.UNSAFE.compareAndSwapInt(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static int compareAndExchange(ByteBufferHandle handle, Object obb, int index, int expected, int value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsInts.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeIntVolatile(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value)));
        }

        @ForceInline
        static int compareAndExchangeAcquire(ByteBufferHandle handle, Object obb, int index, int expected, int value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsInts.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeIntAcquire(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value)));
        }

        @ForceInline
        static int compareAndExchangeRelease(ByteBufferHandle handle, Object obb, int index, int expected, int value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsInts.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeIntRelease(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value)));
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(ByteBufferHandle handle, Object obb, int index, int expected, int value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapInt(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSet(ByteBufferHandle handle, Object obb, int index, int expected, int value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapIntVolatile(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(ByteBufferHandle handle, Object obb, int index, int expected, int value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapIntAcquire(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(ByteBufferHandle handle, Object obb, int index, int expected, int value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapIntRelease(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static int getAndSet(ByteBufferHandle handle, Object obb, int index, int value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsInts.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetInt(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsInts.convEndian(handle.be, value)));
        }

        @ForceInline
        static int getAndSetAcquire(ByteBufferHandle handle, Object obb, int index, int value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsInts.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetIntAcquire(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsInts.convEndian(handle.be, value)));
        }

        @ForceInline
        static int getAndSetRelease(ByteBufferHandle handle, Object obb, int index, int value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsInts.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetIntRelease(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsInts.convEndian(handle.be, value)));
        }

        @ForceInline
        static int getAndAdd(ByteBufferHandle handle, Object obb, int index, int delta) {
            ByteBuffer bb = (ByteBuffer)obb;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndAddInt(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), delta);
            }
            return ByteBufferHandle.getAndAddConvEndianWithCAS(bb, index, delta);
        }

        @ForceInline
        static int getAndAddAcquire(ByteBufferHandle handle, Object obb, int index, int delta) {
            ByteBuffer bb = (ByteBuffer)obb;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndAddIntAcquire(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), delta);
            }
            return ByteBufferHandle.getAndAddConvEndianWithCAS(bb, index, delta);
        }

        @ForceInline
        static int getAndAddRelease(ByteBufferHandle handle, Object obb, int index, int delta) {
            ByteBuffer bb = (ByteBuffer)obb;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndAddIntRelease(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), delta);
            }
            return ByteBufferHandle.getAndAddConvEndianWithCAS(bb, index, delta);
        }

        @ForceInline
        static int getAndAddConvEndianWithCAS(ByteBuffer bb, int index, int delta) {
            int expectedValue;
            int nativeExpectedValue;
            Object base = MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB);
            long offset = ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSwapIntVolatile(base, offset, nativeExpectedValue = MethodHandleStatics.UNSAFE.getIntVolatile(base, offset), Integer.reverseBytes((expectedValue = Integer.reverseBytes(nativeExpectedValue)) + delta))) {
            }
            return expectedValue;
        }

        @ForceInline
        static int getAndBitwiseOr(ByteBufferHandle handle, Object obb, int index, int value) {
            ByteBuffer bb = (ByteBuffer)obb;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseOrInt(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseOrConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static int getAndBitwiseOrRelease(ByteBufferHandle handle, Object obb, int index, int value) {
            ByteBuffer bb = (ByteBuffer)obb;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseOrIntRelease(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseOrConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static int getAndBitwiseOrAcquire(ByteBufferHandle handle, Object obb, int index, int value) {
            ByteBuffer bb = (ByteBuffer)obb;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseOrIntAcquire(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseOrConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static int getAndBitwiseOrConvEndianWithCAS(ByteBuffer bb, int index, int value) {
            int expectedValue;
            int nativeExpectedValue;
            Object base = MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB);
            long offset = ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSwapIntVolatile(base, offset, nativeExpectedValue = MethodHandleStatics.UNSAFE.getIntVolatile(base, offset), Integer.reverseBytes((expectedValue = Integer.reverseBytes(nativeExpectedValue)) | value))) {
            }
            return expectedValue;
        }

        @ForceInline
        static int getAndBitwiseAnd(ByteBufferHandle handle, Object obb, int index, int value) {
            ByteBuffer bb = (ByteBuffer)obb;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseAndInt(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseAndConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static int getAndBitwiseAndRelease(ByteBufferHandle handle, Object obb, int index, int value) {
            ByteBuffer bb = (ByteBuffer)obb;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseAndIntRelease(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseAndConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static int getAndBitwiseAndAcquire(ByteBufferHandle handle, Object obb, int index, int value) {
            ByteBuffer bb = (ByteBuffer)obb;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseAndIntAcquire(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseAndConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static int getAndBitwiseAndConvEndianWithCAS(ByteBuffer bb, int index, int value) {
            int expectedValue;
            int nativeExpectedValue;
            Object base = MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB);
            long offset = ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSwapIntVolatile(base, offset, nativeExpectedValue = MethodHandleStatics.UNSAFE.getIntVolatile(base, offset), Integer.reverseBytes((expectedValue = Integer.reverseBytes(nativeExpectedValue)) & value))) {
            }
            return expectedValue;
        }

        @ForceInline
        static int getAndBitwiseXor(ByteBufferHandle handle, Object obb, int index, int value) {
            ByteBuffer bb = (ByteBuffer)obb;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseXorInt(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseXorConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static int getAndBitwiseXorRelease(ByteBufferHandle handle, Object obb, int index, int value) {
            ByteBuffer bb = (ByteBuffer)obb;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseXorIntRelease(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseXorConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static int getAndBitwiseXorAcquire(ByteBufferHandle handle, Object obb, int index, int value) {
            ByteBuffer bb = (ByteBuffer)obb;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseXorIntAcquire(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), value);
            }
            return ByteBufferHandle.getAndBitwiseXorConvEndianWithCAS(bb, index, value);
        }

        @ForceInline
        static int getAndBitwiseXorConvEndianWithCAS(ByteBuffer bb, int index, int value) {
            int expectedValue;
            int nativeExpectedValue;
            Object base = MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB);
            long offset = ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSwapIntVolatile(base, offset, nativeExpectedValue = MethodHandleStatics.UNSAFE.getIntVolatile(base, offset), Integer.reverseBytes((expectedValue = Integer.reverseBytes(nativeExpectedValue)) ^ value))) {
            }
            return expectedValue;
        }
    }

    static final class ArrayHandle
    extends ByteArrayViewVarHandle {
        static final VarForm FORM = new VarForm(ArrayHandle.class, byte[].class, Integer.TYPE, Integer.TYPE);

        ArrayHandle(boolean be) {
            super(FORM, be);
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(byte[].class, Integer.TYPE, Integer.TYPE);
        }

        @ForceInline
        static int index(byte[] ba, int index) {
            return Preconditions.checkIndex(index, ba.length - 3, null);
        }

        @ForceInline
        static long address(byte[] ba, int index) {
            long address = (long)index + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET;
            if ((address & 3L) != 0L) {
                throw VarHandleByteArrayBase.newIllegalStateExceptionForMisalignedAccess(index);
            }
            return address;
        }

        @ForceInline
        static int get(ArrayHandle handle, Object oba, int index) {
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.getIntUnaligned(ba, (long)ArrayHandle.index(ba, index) + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, handle.be);
        }

        @ForceInline
        static void set(ArrayHandle handle, Object oba, int index, int value) {
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putIntUnaligned(ba, (long)ArrayHandle.index(ba, index) + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, value, handle.be);
        }

        @ForceInline
        static int getVolatile(ArrayHandle handle, Object oba, int index) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsInts.convEndian(handle.be, MethodHandleStatics.UNSAFE.getIntVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setVolatile(ArrayHandle handle, Object oba, int index, int value) {
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putIntVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static int getAcquire(ArrayHandle handle, Object oba, int index) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsInts.convEndian(handle.be, MethodHandleStatics.UNSAFE.getIntAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setRelease(ArrayHandle handle, Object oba, int index, int value) {
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putIntRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static int getOpaque(ArrayHandle handle, Object oba, int index) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsInts.convEndian(handle.be, MethodHandleStatics.UNSAFE.getIntOpaque(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setOpaque(ArrayHandle handle, Object oba, int index, int value) {
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putIntOpaque(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean compareAndSet(ArrayHandle handle, Object oba, int index, int expected, int value) {
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.compareAndSwapInt(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static int compareAndExchange(ArrayHandle handle, Object oba, int index, int expected, int value) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsInts.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeIntVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value)));
        }

        @ForceInline
        static int compareAndExchangeAcquire(ArrayHandle handle, Object oba, int index, int expected, int value) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsInts.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeIntAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value)));
        }

        @ForceInline
        static int compareAndExchangeRelease(ArrayHandle handle, Object oba, int index, int expected, int value) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsInts.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeIntRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value)));
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(ArrayHandle handle, Object oba, int index, int expected, int value) {
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapInt(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSet(ArrayHandle handle, Object oba, int index, int expected, int value) {
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapIntVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(ArrayHandle handle, Object oba, int index, int expected, int value) {
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapIntAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(ArrayHandle handle, Object oba, int index, int expected, int value) {
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapIntRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsInts.convEndian(handle.be, expected), VarHandleByteArrayAsInts.convEndian(handle.be, value));
        }

        @ForceInline
        static int getAndSet(ArrayHandle handle, Object oba, int index, int value) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsInts.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetInt(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsInts.convEndian(handle.be, value)));
        }

        @ForceInline
        static int getAndSetAcquire(ArrayHandle handle, Object oba, int index, int value) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsInts.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetIntAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsInts.convEndian(handle.be, value)));
        }

        @ForceInline
        static int getAndSetRelease(ArrayHandle handle, Object oba, int index, int value) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsInts.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetIntRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsInts.convEndian(handle.be, value)));
        }

        @ForceInline
        static int getAndAdd(ArrayHandle handle, Object oba, int index, int delta) {
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndAddInt(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), delta);
            }
            return ArrayHandle.getAndAddConvEndianWithCAS(ba, index, delta);
        }

        @ForceInline
        static int getAndAddAcquire(ArrayHandle handle, Object oba, int index, int delta) {
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndAddIntAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), delta);
            }
            return ArrayHandle.getAndAddConvEndianWithCAS(ba, index, delta);
        }

        @ForceInline
        static int getAndAddRelease(ArrayHandle handle, Object oba, int index, int delta) {
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndAddIntRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), delta);
            }
            return ArrayHandle.getAndAddConvEndianWithCAS(ba, index, delta);
        }

        @ForceInline
        static int getAndAddConvEndianWithCAS(byte[] ba, int index, int delta) {
            int expectedValue;
            int nativeExpectedValue;
            long offset = ArrayHandle.address(ba, ArrayHandle.index(ba, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSwapIntVolatile(ba, offset, nativeExpectedValue = MethodHandleStatics.UNSAFE.getIntVolatile(ba, offset), Integer.reverseBytes((expectedValue = Integer.reverseBytes(nativeExpectedValue)) + delta))) {
            }
            return expectedValue;
        }

        @ForceInline
        static int getAndBitwiseOr(ArrayHandle handle, Object oba, int index, int value) {
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseOrInt(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseOrConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static int getAndBitwiseOrRelease(ArrayHandle handle, Object oba, int index, int value) {
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseOrIntRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseOrConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static int getAndBitwiseOrAcquire(ArrayHandle handle, Object oba, int index, int value) {
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseOrIntAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseOrConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static int getAndBitwiseOrConvEndianWithCAS(byte[] ba, int index, int value) {
            int expectedValue;
            int nativeExpectedValue;
            long offset = ArrayHandle.address(ba, ArrayHandle.index(ba, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSwapIntVolatile(ba, offset, nativeExpectedValue = MethodHandleStatics.UNSAFE.getIntVolatile(ba, offset), Integer.reverseBytes((expectedValue = Integer.reverseBytes(nativeExpectedValue)) | value))) {
            }
            return expectedValue;
        }

        @ForceInline
        static int getAndBitwiseAnd(ArrayHandle handle, Object oba, int index, int value) {
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseAndInt(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseAndConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static int getAndBitwiseAndRelease(ArrayHandle handle, Object oba, int index, int value) {
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseAndIntRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseAndConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static int getAndBitwiseAndAcquire(ArrayHandle handle, Object oba, int index, int value) {
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseAndIntAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseAndConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static int getAndBitwiseAndConvEndianWithCAS(byte[] ba, int index, int value) {
            int expectedValue;
            int nativeExpectedValue;
            long offset = ArrayHandle.address(ba, ArrayHandle.index(ba, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSwapIntVolatile(ba, offset, nativeExpectedValue = MethodHandleStatics.UNSAFE.getIntVolatile(ba, offset), Integer.reverseBytes((expectedValue = Integer.reverseBytes(nativeExpectedValue)) & value))) {
            }
            return expectedValue;
        }

        @ForceInline
        static int getAndBitwiseXor(ArrayHandle handle, Object oba, int index, int value) {
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseXorInt(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseXorConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static int getAndBitwiseXorRelease(ArrayHandle handle, Object oba, int index, int value) {
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseXorIntRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseXorConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static int getAndBitwiseXorAcquire(ArrayHandle handle, Object oba, int index, int value) {
            byte[] ba = (byte[])oba;
            if (handle.be == VarHandleByteArrayBase.BE) {
                return MethodHandleStatics.UNSAFE.getAndBitwiseXorIntAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), value);
            }
            return ArrayHandle.getAndBitwiseXorConvEndianWithCAS(ba, index, value);
        }

        @ForceInline
        static int getAndBitwiseXorConvEndianWithCAS(byte[] ba, int index, int value) {
            int expectedValue;
            int nativeExpectedValue;
            long offset = ArrayHandle.address(ba, ArrayHandle.index(ba, index));
            while (!MethodHandleStatics.UNSAFE.weakCompareAndSwapIntVolatile(ba, offset, nativeExpectedValue = MethodHandleStatics.UNSAFE.getIntVolatile(ba, offset), Integer.reverseBytes((expectedValue = Integer.reverseBytes(nativeExpectedValue)) ^ value))) {
            }
            return expectedValue;
        }
    }

    private static abstract class ByteArrayViewVarHandle
    extends VarHandle {
        final boolean be;

        ByteArrayViewVarHandle(VarForm form, boolean be) {
            super(form);
            this.be = be;
        }
    }
}

