/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.lang.invoke.VarHandleByteArrayBase;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import jdk.internal.misc.Unsafe;
import jdk.internal.util.Preconditions;
import jdk.internal.vm.annotation.ForceInline;

final class VarHandleByteArrayAsFloats
extends VarHandleByteArrayBase {
    static final int ALIGN = 3;

    VarHandleByteArrayAsFloats() {
    }

    @ForceInline
    static int convEndian(boolean big, float v) {
        int rv = Float.floatToRawIntBits(v);
        return big == BE ? rv : Integer.reverseBytes(rv);
    }

    @ForceInline
    static float convEndian(boolean big, int rv) {
        rv = big == BE ? rv : Integer.reverseBytes(rv);
        return Float.intBitsToFloat(rv);
    }

    static final class ByteBufferHandle
    extends ByteArrayViewVarHandle {
        static final VarForm FORM = new VarForm(ByteBufferHandle.class, ByteBuffer.class, Float.TYPE, Integer.TYPE);

        ByteBufferHandle(boolean be) {
            super(FORM, be);
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(ByteBuffer.class, Float.TYPE, Integer.TYPE);
        }

        @ForceInline
        static int index(ByteBuffer bb, int index) {
            return Preconditions.checkIndex(index, MethodHandleStatics.UNSAFE.getInt(bb, VarHandleByteArrayBase.BUFFER_LIMIT) - 3, null);
        }

        @ForceInline
        static int indexRO(ByteBuffer bb, int index) {
            if (MethodHandleStatics.UNSAFE.getBoolean(bb, VarHandleByteArrayBase.BYTE_BUFFER_IS_READ_ONLY)) {
                throw new ReadOnlyBufferException();
            }
            return Preconditions.checkIndex(index, MethodHandleStatics.UNSAFE.getInt(bb, VarHandleByteArrayBase.BUFFER_LIMIT) - 3, null);
        }

        @ForceInline
        static long address(ByteBuffer bb, int index) {
            long address = (long)index + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS);
            if ((address & 3L) != 0L) {
                throw VarHandleByteArrayBase.newIllegalStateExceptionForMisalignedAccess(index);
            }
            return address;
        }

        @ForceInline
        static float get(ByteBufferHandle handle, Object obb, int index) {
            ByteBuffer bb = (ByteBuffer)obb;
            int rawValue = MethodHandleStatics.UNSAFE.getIntUnaligned(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), (long)ByteBufferHandle.index(bb, index) + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS), handle.be);
            return Float.intBitsToFloat(rawValue);
        }

        @ForceInline
        static void set(ByteBufferHandle handle, Object obb, int index, float value) {
            ByteBuffer bb = (ByteBuffer)obb;
            MethodHandleStatics.UNSAFE.putIntUnaligned(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), (long)ByteBufferHandle.indexRO(bb, index) + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS), Float.floatToRawIntBits(value), handle.be);
        }

        @ForceInline
        static float getVolatile(ByteBufferHandle handle, Object obb, int index) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsFloats.convEndian(handle.be, MethodHandleStatics.UNSAFE.getIntVolatile(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setVolatile(ByteBufferHandle handle, Object obb, int index, float value) {
            ByteBuffer bb = (ByteBuffer)obb;
            MethodHandleStatics.UNSAFE.putIntVolatile(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsFloats.convEndian(handle.be, value));
        }

        @ForceInline
        static float getAcquire(ByteBufferHandle handle, Object obb, int index) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsFloats.convEndian(handle.be, MethodHandleStatics.UNSAFE.getIntAcquire(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setRelease(ByteBufferHandle handle, Object obb, int index, float value) {
            ByteBuffer bb = (ByteBuffer)obb;
            MethodHandleStatics.UNSAFE.putIntRelease(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsFloats.convEndian(handle.be, value));
        }

        @ForceInline
        static float getOpaque(ByteBufferHandle handle, Object obb, int index) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsFloats.convEndian(handle.be, MethodHandleStatics.UNSAFE.getIntOpaque(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setOpaque(ByteBufferHandle handle, Object obb, int index, float value) {
            ByteBuffer bb = (ByteBuffer)obb;
            MethodHandleStatics.UNSAFE.putIntOpaque(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsFloats.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean compareAndSet(ByteBufferHandle handle, Object obb, int index, float expected, float value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return MethodHandleStatics.UNSAFE.compareAndSwapInt(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsFloats.convEndian(handle.be, expected), VarHandleByteArrayAsFloats.convEndian(handle.be, value));
        }

        @ForceInline
        static float compareAndExchange(ByteBufferHandle handle, Object obb, int index, float expected, float value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsFloats.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeIntVolatile(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsFloats.convEndian(handle.be, expected), VarHandleByteArrayAsFloats.convEndian(handle.be, value)));
        }

        @ForceInline
        static float compareAndExchangeAcquire(ByteBufferHandle handle, Object obb, int index, float expected, float value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsFloats.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeIntAcquire(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsFloats.convEndian(handle.be, expected), VarHandleByteArrayAsFloats.convEndian(handle.be, value)));
        }

        @ForceInline
        static float compareAndExchangeRelease(ByteBufferHandle handle, Object obb, int index, float expected, float value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsFloats.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeIntRelease(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsFloats.convEndian(handle.be, expected), VarHandleByteArrayAsFloats.convEndian(handle.be, value)));
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(ByteBufferHandle handle, Object obb, int index, float expected, float value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapInt(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsFloats.convEndian(handle.be, expected), VarHandleByteArrayAsFloats.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSet(ByteBufferHandle handle, Object obb, int index, float expected, float value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapIntVolatile(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsFloats.convEndian(handle.be, expected), VarHandleByteArrayAsFloats.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(ByteBufferHandle handle, Object obb, int index, float expected, float value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapIntAcquire(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsFloats.convEndian(handle.be, expected), VarHandleByteArrayAsFloats.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(ByteBufferHandle handle, Object obb, int index, float expected, float value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapIntRelease(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsFloats.convEndian(handle.be, expected), VarHandleByteArrayAsFloats.convEndian(handle.be, value));
        }

        @ForceInline
        static float getAndSet(ByteBufferHandle handle, Object obb, int index, float value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsFloats.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetInt(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsFloats.convEndian(handle.be, value)));
        }

        @ForceInline
        static float getAndSetAcquire(ByteBufferHandle handle, Object obb, int index, float value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsFloats.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetIntAcquire(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsFloats.convEndian(handle.be, value)));
        }

        @ForceInline
        static float getAndSetRelease(ByteBufferHandle handle, Object obb, int index, float value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsFloats.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetIntRelease(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsFloats.convEndian(handle.be, value)));
        }
    }

    static final class ArrayHandle
    extends ByteArrayViewVarHandle {
        static final VarForm FORM = new VarForm(ArrayHandle.class, byte[].class, Float.TYPE, Integer.TYPE);

        ArrayHandle(boolean be) {
            super(FORM, be);
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(byte[].class, Float.TYPE, Integer.TYPE);
        }

        @ForceInline
        static int index(byte[] ba, int index) {
            return Preconditions.checkIndex(index, ba.length - 3, null);
        }

        @ForceInline
        static long address(byte[] ba, int index) {
            long address = (long)index + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET;
            if ((address & 3L) != 0L) {
                throw VarHandleByteArrayBase.newIllegalStateExceptionForMisalignedAccess(index);
            }
            return address;
        }

        @ForceInline
        static float get(ArrayHandle handle, Object oba, int index) {
            byte[] ba = (byte[])oba;
            int rawValue = MethodHandleStatics.UNSAFE.getIntUnaligned(ba, (long)ArrayHandle.index(ba, index) + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, handle.be);
            return Float.intBitsToFloat(rawValue);
        }

        @ForceInline
        static void set(ArrayHandle handle, Object oba, int index, float value) {
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putIntUnaligned(ba, (long)ArrayHandle.index(ba, index) + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, Float.floatToRawIntBits(value), handle.be);
        }

        @ForceInline
        static float getVolatile(ArrayHandle handle, Object oba, int index) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsFloats.convEndian(handle.be, MethodHandleStatics.UNSAFE.getIntVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setVolatile(ArrayHandle handle, Object oba, int index, float value) {
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putIntVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsFloats.convEndian(handle.be, value));
        }

        @ForceInline
        static float getAcquire(ArrayHandle handle, Object oba, int index) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsFloats.convEndian(handle.be, MethodHandleStatics.UNSAFE.getIntAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setRelease(ArrayHandle handle, Object oba, int index, float value) {
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putIntRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsFloats.convEndian(handle.be, value));
        }

        @ForceInline
        static float getOpaque(ArrayHandle handle, Object oba, int index) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsFloats.convEndian(handle.be, MethodHandleStatics.UNSAFE.getIntOpaque(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setOpaque(ArrayHandle handle, Object oba, int index, float value) {
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putIntOpaque(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsFloats.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean compareAndSet(ArrayHandle handle, Object oba, int index, float expected, float value) {
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.compareAndSwapInt(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsFloats.convEndian(handle.be, expected), VarHandleByteArrayAsFloats.convEndian(handle.be, value));
        }

        @ForceInline
        static float compareAndExchange(ArrayHandle handle, Object oba, int index, float expected, float value) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsFloats.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeIntVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsFloats.convEndian(handle.be, expected), VarHandleByteArrayAsFloats.convEndian(handle.be, value)));
        }

        @ForceInline
        static float compareAndExchangeAcquire(ArrayHandle handle, Object oba, int index, float expected, float value) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsFloats.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeIntAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsFloats.convEndian(handle.be, expected), VarHandleByteArrayAsFloats.convEndian(handle.be, value)));
        }

        @ForceInline
        static float compareAndExchangeRelease(ArrayHandle handle, Object oba, int index, float expected, float value) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsFloats.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeIntRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsFloats.convEndian(handle.be, expected), VarHandleByteArrayAsFloats.convEndian(handle.be, value)));
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(ArrayHandle handle, Object oba, int index, float expected, float value) {
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapInt(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsFloats.convEndian(handle.be, expected), VarHandleByteArrayAsFloats.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSet(ArrayHandle handle, Object oba, int index, float expected, float value) {
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapIntVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsFloats.convEndian(handle.be, expected), VarHandleByteArrayAsFloats.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(ArrayHandle handle, Object oba, int index, float expected, float value) {
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapIntAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsFloats.convEndian(handle.be, expected), VarHandleByteArrayAsFloats.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(ArrayHandle handle, Object oba, int index, float expected, float value) {
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapIntRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsFloats.convEndian(handle.be, expected), VarHandleByteArrayAsFloats.convEndian(handle.be, value));
        }

        @ForceInline
        static float getAndSet(ArrayHandle handle, Object oba, int index, float value) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsFloats.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetInt(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsFloats.convEndian(handle.be, value)));
        }

        @ForceInline
        static float getAndSetAcquire(ArrayHandle handle, Object oba, int index, float value) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsFloats.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetIntAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsFloats.convEndian(handle.be, value)));
        }

        @ForceInline
        static float getAndSetRelease(ArrayHandle handle, Object oba, int index, float value) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsFloats.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetIntRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsFloats.convEndian(handle.be, value)));
        }
    }

    private static abstract class ByteArrayViewVarHandle
    extends VarHandle {
        final boolean be;

        ByteArrayViewVarHandle(VarForm form, boolean be) {
            super(form);
            this.be = be;
        }
    }
}

