/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.lang.invoke.VarHandleByteArrayBase;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import jdk.internal.misc.Unsafe;
import jdk.internal.util.Preconditions;
import jdk.internal.vm.annotation.ForceInline;

final class VarHandleByteArrayAsDoubles
extends VarHandleByteArrayBase {
    static final int ALIGN = 7;

    VarHandleByteArrayAsDoubles() {
    }

    @ForceInline
    static long convEndian(boolean big, double v) {
        long rv = Double.doubleToRawLongBits(v);
        return big == BE ? rv : Long.reverseBytes(rv);
    }

    @ForceInline
    static double convEndian(boolean big, long rv) {
        rv = big == BE ? rv : Long.reverseBytes(rv);
        return Double.longBitsToDouble(rv);
    }

    static final class ByteBufferHandle
    extends ByteArrayViewVarHandle {
        static final VarForm FORM = new VarForm(ByteBufferHandle.class, ByteBuffer.class, Double.TYPE, Integer.TYPE);

        ByteBufferHandle(boolean be) {
            super(FORM, be);
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(ByteBuffer.class, Double.TYPE, Integer.TYPE);
        }

        @ForceInline
        static int index(ByteBuffer bb, int index) {
            return Preconditions.checkIndex(index, MethodHandleStatics.UNSAFE.getInt(bb, VarHandleByteArrayBase.BUFFER_LIMIT) - 7, null);
        }

        @ForceInline
        static int indexRO(ByteBuffer bb, int index) {
            if (MethodHandleStatics.UNSAFE.getBoolean(bb, VarHandleByteArrayBase.BYTE_BUFFER_IS_READ_ONLY)) {
                throw new ReadOnlyBufferException();
            }
            return Preconditions.checkIndex(index, MethodHandleStatics.UNSAFE.getInt(bb, VarHandleByteArrayBase.BUFFER_LIMIT) - 7, null);
        }

        @ForceInline
        static long address(ByteBuffer bb, int index) {
            long address = (long)index + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS);
            if ((address & 7L) != 0L) {
                throw VarHandleByteArrayBase.newIllegalStateExceptionForMisalignedAccess(index);
            }
            return address;
        }

        @ForceInline
        static double get(ByteBufferHandle handle, Object obb, int index) {
            ByteBuffer bb = (ByteBuffer)obb;
            long rawValue = MethodHandleStatics.UNSAFE.getLongUnaligned(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), (long)ByteBufferHandle.index(bb, index) + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS), handle.be);
            return Double.longBitsToDouble(rawValue);
        }

        @ForceInline
        static void set(ByteBufferHandle handle, Object obb, int index, double value) {
            ByteBuffer bb = (ByteBuffer)obb;
            MethodHandleStatics.UNSAFE.putLongUnaligned(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), (long)ByteBufferHandle.indexRO(bb, index) + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS), Double.doubleToRawLongBits(value), handle.be);
        }

        @ForceInline
        static double getVolatile(ByteBufferHandle handle, Object obb, int index) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, MethodHandleStatics.UNSAFE.getLongVolatile(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setVolatile(ByteBufferHandle handle, Object obb, int index, double value) {
            ByteBuffer bb = (ByteBuffer)obb;
            MethodHandleStatics.UNSAFE.putLongVolatile(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static double getAcquire(ByteBufferHandle handle, Object obb, int index) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, MethodHandleStatics.UNSAFE.getLongAcquire(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setRelease(ByteBufferHandle handle, Object obb, int index, double value) {
            ByteBuffer bb = (ByteBuffer)obb;
            MethodHandleStatics.UNSAFE.putLongRelease(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static double getOpaque(ByteBufferHandle handle, Object obb, int index) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, MethodHandleStatics.UNSAFE.getLongOpaque(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setOpaque(ByteBufferHandle handle, Object obb, int index, double value) {
            ByteBuffer bb = (ByteBuffer)obb;
            MethodHandleStatics.UNSAFE.putLongOpaque(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean compareAndSet(ByteBufferHandle handle, Object obb, int index, double expected, double value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return MethodHandleStatics.UNSAFE.compareAndSwapLong(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static double compareAndExchange(ByteBufferHandle handle, Object obb, int index, double expected, double value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeLongVolatile(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value)));
        }

        @ForceInline
        static double compareAndExchangeAcquire(ByteBufferHandle handle, Object obb, int index, double expected, double value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeLongAcquire(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value)));
        }

        @ForceInline
        static double compareAndExchangeRelease(ByteBufferHandle handle, Object obb, int index, double expected, double value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeLongRelease(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value)));
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(ByteBufferHandle handle, Object obb, int index, double expected, double value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapLong(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSet(ByteBufferHandle handle, Object obb, int index, double expected, double value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapLongVolatile(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(ByteBufferHandle handle, Object obb, int index, double expected, double value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapLongAcquire(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(ByteBufferHandle handle, Object obb, int index, double expected, double value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapLongRelease(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static double getAndSet(ByteBufferHandle handle, Object obb, int index, double value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetLong(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, value)));
        }

        @ForceInline
        static double getAndSetAcquire(ByteBufferHandle handle, Object obb, int index, double value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetLongAcquire(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, value)));
        }

        @ForceInline
        static double getAndSetRelease(ByteBufferHandle handle, Object obb, int index, double value) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetLongRelease(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, value)));
        }
    }

    static final class ArrayHandle
    extends ByteArrayViewVarHandle {
        static final VarForm FORM = new VarForm(ArrayHandle.class, byte[].class, Double.TYPE, Integer.TYPE);

        ArrayHandle(boolean be) {
            super(FORM, be);
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(byte[].class, Double.TYPE, Integer.TYPE);
        }

        @ForceInline
        static int index(byte[] ba, int index) {
            return Preconditions.checkIndex(index, ba.length - 7, null);
        }

        @ForceInline
        static long address(byte[] ba, int index) {
            long address = (long)index + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET;
            if ((address & 7L) != 0L) {
                throw VarHandleByteArrayBase.newIllegalStateExceptionForMisalignedAccess(index);
            }
            return address;
        }

        @ForceInline
        static double get(ArrayHandle handle, Object oba, int index) {
            byte[] ba = (byte[])oba;
            long rawValue = MethodHandleStatics.UNSAFE.getLongUnaligned(ba, (long)ArrayHandle.index(ba, index) + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, handle.be);
            return Double.longBitsToDouble(rawValue);
        }

        @ForceInline
        static void set(ArrayHandle handle, Object oba, int index, double value) {
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putLongUnaligned(ba, (long)ArrayHandle.index(ba, index) + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, Double.doubleToRawLongBits(value), handle.be);
        }

        @ForceInline
        static double getVolatile(ArrayHandle handle, Object oba, int index) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, MethodHandleStatics.UNSAFE.getLongVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setVolatile(ArrayHandle handle, Object oba, int index, double value) {
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putLongVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static double getAcquire(ArrayHandle handle, Object oba, int index) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, MethodHandleStatics.UNSAFE.getLongAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setRelease(ArrayHandle handle, Object oba, int index, double value) {
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putLongRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static double getOpaque(ArrayHandle handle, Object oba, int index) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, MethodHandleStatics.UNSAFE.getLongOpaque(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setOpaque(ArrayHandle handle, Object oba, int index, double value) {
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putLongOpaque(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean compareAndSet(ArrayHandle handle, Object oba, int index, double expected, double value) {
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.compareAndSwapLong(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static double compareAndExchange(ArrayHandle handle, Object oba, int index, double expected, double value) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeLongVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value)));
        }

        @ForceInline
        static double compareAndExchangeAcquire(ArrayHandle handle, Object oba, int index, double expected, double value) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeLongAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value)));
        }

        @ForceInline
        static double compareAndExchangeRelease(ArrayHandle handle, Object oba, int index, double expected, double value) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, MethodHandleStatics.UNSAFE.compareAndExchangeLongRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value)));
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(ArrayHandle handle, Object oba, int index, double expected, double value) {
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapLong(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSet(ArrayHandle handle, Object oba, int index, double expected, double value) {
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapLongVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(ArrayHandle handle, Object oba, int index, double expected, double value) {
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapLongAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(ArrayHandle handle, Object oba, int index, double expected, double value) {
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapLongRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, expected), VarHandleByteArrayAsDoubles.convEndian(handle.be, value));
        }

        @ForceInline
        static double getAndSet(ArrayHandle handle, Object oba, int index, double value) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetLong(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, value)));
        }

        @ForceInline
        static double getAndSetAcquire(ArrayHandle handle, Object oba, int index, double value) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetLongAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, value)));
        }

        @ForceInline
        static double getAndSetRelease(ArrayHandle handle, Object oba, int index, double value) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsDoubles.convEndian(handle.be, MethodHandleStatics.UNSAFE.getAndSetLongRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsDoubles.convEndian(handle.be, value)));
        }
    }

    private static abstract class ByteArrayViewVarHandle
    extends VarHandle {
        final boolean be;

        ByteArrayViewVarHandle(VarForm form, boolean be) {
            super(form);
            this.be = be;
        }
    }
}

