/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.lang.invoke.VarHandleByteArrayBase;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import jdk.internal.misc.Unsafe;
import jdk.internal.util.Preconditions;
import jdk.internal.vm.annotation.ForceInline;

final class VarHandleByteArrayAsChars
extends VarHandleByteArrayBase {
    static final int ALIGN = 1;

    VarHandleByteArrayAsChars() {
    }

    @ForceInline
    static char convEndian(boolean big, char n) {
        return big == BE ? n : Character.reverseBytes(n);
    }

    static final class ByteBufferHandle
    extends ByteArrayViewVarHandle {
        static final VarForm FORM = new VarForm(ByteBufferHandle.class, ByteBuffer.class, Character.TYPE, Integer.TYPE);

        ByteBufferHandle(boolean be) {
            super(FORM, be);
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(ByteBuffer.class, Character.TYPE, Integer.TYPE);
        }

        @ForceInline
        static int index(ByteBuffer bb, int index) {
            return Preconditions.checkIndex(index, MethodHandleStatics.UNSAFE.getInt(bb, VarHandleByteArrayBase.BUFFER_LIMIT) - 1, null);
        }

        @ForceInline
        static int indexRO(ByteBuffer bb, int index) {
            if (MethodHandleStatics.UNSAFE.getBoolean(bb, VarHandleByteArrayBase.BYTE_BUFFER_IS_READ_ONLY)) {
                throw new ReadOnlyBufferException();
            }
            return Preconditions.checkIndex(index, MethodHandleStatics.UNSAFE.getInt(bb, VarHandleByteArrayBase.BUFFER_LIMIT) - 1, null);
        }

        @ForceInline
        static long address(ByteBuffer bb, int index) {
            long address = (long)index + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS);
            if ((address & 1L) != 0L) {
                throw VarHandleByteArrayBase.newIllegalStateExceptionForMisalignedAccess(index);
            }
            return address;
        }

        @ForceInline
        static char get(ByteBufferHandle handle, Object obb, int index) {
            ByteBuffer bb = (ByteBuffer)obb;
            return MethodHandleStatics.UNSAFE.getCharUnaligned(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), (long)ByteBufferHandle.index(bb, index) + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS), handle.be);
        }

        @ForceInline
        static void set(ByteBufferHandle handle, Object obb, int index, char value) {
            ByteBuffer bb = (ByteBuffer)obb;
            MethodHandleStatics.UNSAFE.putCharUnaligned(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), (long)ByteBufferHandle.indexRO(bb, index) + MethodHandleStatics.UNSAFE.getLong(bb, VarHandleByteArrayBase.BUFFER_ADDRESS), value, handle.be);
        }

        @ForceInline
        static char getVolatile(ByteBufferHandle handle, Object obb, int index) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsChars.convEndian(handle.be, MethodHandleStatics.UNSAFE.getCharVolatile(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setVolatile(ByteBufferHandle handle, Object obb, int index, char value) {
            ByteBuffer bb = (ByteBuffer)obb;
            MethodHandleStatics.UNSAFE.putCharVolatile(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsChars.convEndian(handle.be, value));
        }

        @ForceInline
        static char getAcquire(ByteBufferHandle handle, Object obb, int index) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsChars.convEndian(handle.be, MethodHandleStatics.UNSAFE.getCharAcquire(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setRelease(ByteBufferHandle handle, Object obb, int index, char value) {
            ByteBuffer bb = (ByteBuffer)obb;
            MethodHandleStatics.UNSAFE.putCharRelease(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsChars.convEndian(handle.be, value));
        }

        @ForceInline
        static char getOpaque(ByteBufferHandle handle, Object obb, int index) {
            ByteBuffer bb = (ByteBuffer)obb;
            return VarHandleByteArrayAsChars.convEndian(handle.be, MethodHandleStatics.UNSAFE.getCharOpaque(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.index(bb, index))));
        }

        @ForceInline
        static void setOpaque(ByteBufferHandle handle, Object obb, int index, char value) {
            ByteBuffer bb = (ByteBuffer)obb;
            MethodHandleStatics.UNSAFE.putCharOpaque(MethodHandleStatics.UNSAFE.getObject(bb, VarHandleByteArrayBase.BYTE_BUFFER_HB), ByteBufferHandle.address(bb, ByteBufferHandle.indexRO(bb, index)), VarHandleByteArrayAsChars.convEndian(handle.be, value));
        }
    }

    static final class ArrayHandle
    extends ByteArrayViewVarHandle {
        static final VarForm FORM = new VarForm(ArrayHandle.class, byte[].class, Character.TYPE, Integer.TYPE);

        ArrayHandle(boolean be) {
            super(FORM, be);
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(byte[].class, Character.TYPE, Integer.TYPE);
        }

        @ForceInline
        static int index(byte[] ba, int index) {
            return Preconditions.checkIndex(index, ba.length - 1, null);
        }

        @ForceInline
        static long address(byte[] ba, int index) {
            long address = (long)index + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET;
            if ((address & 1L) != 0L) {
                throw VarHandleByteArrayBase.newIllegalStateExceptionForMisalignedAccess(index);
            }
            return address;
        }

        @ForceInline
        static char get(ArrayHandle handle, Object oba, int index) {
            byte[] ba = (byte[])oba;
            return MethodHandleStatics.UNSAFE.getCharUnaligned(ba, (long)ArrayHandle.index(ba, index) + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, handle.be);
        }

        @ForceInline
        static void set(ArrayHandle handle, Object oba, int index, char value) {
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putCharUnaligned(ba, (long)ArrayHandle.index(ba, index) + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, value, handle.be);
        }

        @ForceInline
        static char getVolatile(ArrayHandle handle, Object oba, int index) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsChars.convEndian(handle.be, MethodHandleStatics.UNSAFE.getCharVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setVolatile(ArrayHandle handle, Object oba, int index, char value) {
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putCharVolatile(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsChars.convEndian(handle.be, value));
        }

        @ForceInline
        static char getAcquire(ArrayHandle handle, Object oba, int index) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsChars.convEndian(handle.be, MethodHandleStatics.UNSAFE.getCharAcquire(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setRelease(ArrayHandle handle, Object oba, int index, char value) {
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putCharRelease(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsChars.convEndian(handle.be, value));
        }

        @ForceInline
        static char getOpaque(ArrayHandle handle, Object oba, int index) {
            byte[] ba = (byte[])oba;
            return VarHandleByteArrayAsChars.convEndian(handle.be, MethodHandleStatics.UNSAFE.getCharOpaque(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index))));
        }

        @ForceInline
        static void setOpaque(ArrayHandle handle, Object oba, int index, char value) {
            byte[] ba = (byte[])oba;
            MethodHandleStatics.UNSAFE.putCharOpaque(ba, ArrayHandle.address(ba, ArrayHandle.index(ba, index)), VarHandleByteArrayAsChars.convEndian(handle.be, value));
        }
    }

    private static abstract class ByteArrayViewVarHandle
    extends VarHandle {
        final boolean be;

        ByteArrayViewVarHandle(VarForm form, boolean be) {
            super(form);
            this.be = be;
        }
    }
}

