/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import jdk.internal.util.Preconditions;
import jdk.internal.vm.annotation.ForceInline;

final class VarHandleBooleans {
    VarHandleBooleans() {
    }

    static final class Array
    extends VarHandle {
        final int abase;
        final int ashift;
        static final VarForm FORM = new VarForm(Array.class, boolean[].class, Boolean.TYPE, Integer.TYPE);

        Array(int abase, int ashift) {
            super(FORM);
            this.abase = abase;
            this.ashift = ashift;
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(boolean[].class, Boolean.TYPE, Integer.TYPE);
        }

        @ForceInline
        static boolean get(Array handle, Object oarray, int index) {
            boolean[] array = (boolean[])oarray;
            return array[index];
        }

        @ForceInline
        static void set(Array handle, Object oarray, int index, boolean value) {
            boolean[] array = (boolean[])oarray;
            array[index] = value;
        }

        @ForceInline
        static boolean getVolatile(Array handle, Object oarray, int index) {
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getBooleanVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setVolatile(Array handle, Object oarray, int index, boolean value) {
            boolean[] array = (boolean[])oarray;
            MethodHandleStatics.UNSAFE.putBooleanVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean getOpaque(Array handle, Object oarray, int index) {
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getBooleanOpaque(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setOpaque(Array handle, Object oarray, int index, boolean value) {
            boolean[] array = (boolean[])oarray;
            MethodHandleStatics.UNSAFE.putBooleanOpaque(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean getAcquire(Array handle, Object oarray, int index) {
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getBooleanAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase);
        }

        @ForceInline
        static void setRelease(Array handle, Object oarray, int index, boolean value) {
            boolean[] array = (boolean[])oarray;
            MethodHandleStatics.UNSAFE.putBooleanRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean compareAndSet(Array handle, Object oarray, int index, boolean expected, boolean value) {
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndSwapBoolean(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean compareAndExchange(Array handle, Object oarray, int index, boolean expected, boolean value) {
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeBooleanVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean compareAndExchangeAcquire(Array handle, Object oarray, int index, boolean expected, boolean value) {
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeBooleanAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean compareAndExchangeRelease(Array handle, Object oarray, int index, boolean expected, boolean value) {
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.compareAndExchangeBooleanRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(Array handle, Object oarray, int index, boolean expected, boolean value) {
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapBoolean(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(Array handle, Object oarray, int index, boolean expected, boolean value) {
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapBooleanVolatile(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(Array handle, Object oarray, int index, boolean expected, boolean value) {
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapBooleanAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(Array handle, Object oarray, int index, boolean expected, boolean value) {
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapBooleanRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, expected, value);
        }

        @ForceInline
        static boolean getAndSet(Array handle, Object oarray, int index, boolean value) {
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetBoolean(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean getAndSetAcquire(Array handle, Object oarray, int index, boolean value) {
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetBooleanAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean getAndSetRelease(Array handle, Object oarray, int index, boolean value) {
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getAndSetBooleanRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean getAndBitwiseOr(Array handle, Object oarray, int index, boolean value) {
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrBoolean(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean getAndBitwiseOrRelease(Array handle, Object oarray, int index, boolean value) {
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrBooleanRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean getAndBitwiseOrAcquire(Array handle, Object oarray, int index, boolean value) {
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrBooleanAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean getAndBitwiseAnd(Array handle, Object oarray, int index, boolean value) {
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndBoolean(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean getAndBitwiseAndRelease(Array handle, Object oarray, int index, boolean value) {
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndBooleanRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean getAndBitwiseAndAcquire(Array handle, Object oarray, int index, boolean value) {
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndBooleanAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean getAndBitwiseXor(Array handle, Object oarray, int index, boolean value) {
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorBoolean(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean getAndBitwiseXorRelease(Array handle, Object oarray, int index, boolean value) {
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorBooleanRelease(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }

        @ForceInline
        static boolean getAndBitwiseXorAcquire(Array handle, Object oarray, int index, boolean value) {
            boolean[] array = (boolean[])oarray;
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorBooleanAcquire(array, ((long)Preconditions.checkIndex(index, array.length, AIOOBE_SUPPLIER) << handle.ashift) + (long)handle.abase, value);
        }
    }

    static final class FieldStaticReadWrite
    extends FieldStaticReadOnly {
        static final VarForm FORM = new VarForm(FieldStaticReadWrite.class, null, Boolean.TYPE, new Class[0]);

        FieldStaticReadWrite(Object base, long fieldOffset) {
            super(base, fieldOffset, FORM);
        }

        @ForceInline
        static void set(FieldStaticReadWrite handle, boolean value) {
            MethodHandleStatics.UNSAFE.putBoolean(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setVolatile(FieldStaticReadWrite handle, boolean value) {
            MethodHandleStatics.UNSAFE.putBooleanVolatile(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setOpaque(FieldStaticReadWrite handle, boolean value) {
            MethodHandleStatics.UNSAFE.putBooleanOpaque(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static void setRelease(FieldStaticReadWrite handle, boolean value) {
            MethodHandleStatics.UNSAFE.putBooleanRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean compareAndSet(FieldStaticReadWrite handle, boolean expected, boolean value) {
            return MethodHandleStatics.UNSAFE.compareAndSwapBoolean(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean compareAndExchange(FieldStaticReadWrite handle, boolean expected, boolean value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeBooleanVolatile(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean compareAndExchangeAcquire(FieldStaticReadWrite handle, boolean expected, boolean value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeBooleanAcquire(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean compareAndExchangeRelease(FieldStaticReadWrite handle, boolean expected, boolean value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeBooleanRelease(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(FieldStaticReadWrite handle, boolean expected, boolean value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapBoolean(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(FieldStaticReadWrite handle, boolean expected, boolean value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapBooleanVolatile(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(FieldStaticReadWrite handle, boolean expected, boolean value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapBooleanAcquire(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(FieldStaticReadWrite handle, boolean expected, boolean value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapBooleanRelease(handle.base, handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean getAndSet(FieldStaticReadWrite handle, boolean value) {
            return MethodHandleStatics.UNSAFE.getAndSetBoolean(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndSetAcquire(FieldStaticReadWrite handle, boolean value) {
            return MethodHandleStatics.UNSAFE.getAndSetBooleanAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndSetRelease(FieldStaticReadWrite handle, boolean value) {
            return MethodHandleStatics.UNSAFE.getAndSetBooleanRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseOr(FieldStaticReadWrite handle, boolean value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrBoolean(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseOrRelease(FieldStaticReadWrite handle, boolean value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrBooleanRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseOrAcquire(FieldStaticReadWrite handle, boolean value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrBooleanAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseAnd(FieldStaticReadWrite handle, boolean value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndBoolean(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseAndRelease(FieldStaticReadWrite handle, boolean value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndBooleanRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseAndAcquire(FieldStaticReadWrite handle, boolean value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndBooleanAcquire(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseXor(FieldStaticReadWrite handle, boolean value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorBoolean(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseXorRelease(FieldStaticReadWrite handle, boolean value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorBooleanRelease(handle.base, handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseXorAcquire(FieldStaticReadWrite handle, boolean value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorBooleanAcquire(handle.base, handle.fieldOffset, value);
        }
    }

    static class FieldStaticReadOnly
    extends VarHandle {
        final Object base;
        final long fieldOffset;
        static final VarForm FORM = new VarForm(FieldStaticReadOnly.class, null, Boolean.TYPE, new Class[0]);

        FieldStaticReadOnly(Object base, long fieldOffset) {
            this(base, fieldOffset, FORM);
        }

        protected FieldStaticReadOnly(Object base, long fieldOffset, VarForm form) {
            super(form);
            this.base = base;
            this.fieldOffset = fieldOffset;
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(null, Boolean.TYPE, new Class[0]);
        }

        @ForceInline
        static boolean get(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getBoolean(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static boolean getVolatile(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getBooleanVolatile(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static boolean getOpaque(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getBooleanOpaque(handle.base, handle.fieldOffset);
        }

        @ForceInline
        static boolean getAcquire(FieldStaticReadOnly handle) {
            return MethodHandleStatics.UNSAFE.getBooleanAcquire(handle.base, handle.fieldOffset);
        }
    }

    static final class FieldInstanceReadWrite
    extends FieldInstanceReadOnly {
        static final VarForm FORM = new VarForm(FieldInstanceReadWrite.class, Object.class, Boolean.TYPE, new Class[0]);

        FieldInstanceReadWrite(Class<?> receiverType, long fieldOffset) {
            super(receiverType, fieldOffset, FORM);
        }

        @ForceInline
        static void set(FieldInstanceReadWrite handle, Object holder, boolean value) {
            MethodHandleStatics.UNSAFE.putBoolean(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setVolatile(FieldInstanceReadWrite handle, Object holder, boolean value) {
            MethodHandleStatics.UNSAFE.putBooleanVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setOpaque(FieldInstanceReadWrite handle, Object holder, boolean value) {
            MethodHandleStatics.UNSAFE.putBooleanOpaque(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static void setRelease(FieldInstanceReadWrite handle, Object holder, boolean value) {
            MethodHandleStatics.UNSAFE.putBooleanRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean compareAndSet(FieldInstanceReadWrite handle, Object holder, boolean expected, boolean value) {
            return MethodHandleStatics.UNSAFE.compareAndSwapBoolean(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean compareAndExchange(FieldInstanceReadWrite handle, Object holder, boolean expected, boolean value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeBooleanVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean compareAndExchangeAcquire(FieldInstanceReadWrite handle, Object holder, boolean expected, boolean value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeBooleanAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean compareAndExchangeRelease(FieldInstanceReadWrite handle, Object holder, boolean expected, boolean value) {
            return MethodHandleStatics.UNSAFE.compareAndExchangeBooleanRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetPlain(FieldInstanceReadWrite handle, Object holder, boolean expected, boolean value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapBoolean(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSet(FieldInstanceReadWrite handle, Object holder, boolean expected, boolean value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapBooleanVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetAcquire(FieldInstanceReadWrite handle, Object holder, boolean expected, boolean value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapBooleanAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean weakCompareAndSetRelease(FieldInstanceReadWrite handle, Object holder, boolean expected, boolean value) {
            return MethodHandleStatics.UNSAFE.weakCompareAndSwapBooleanRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, expected, value);
        }

        @ForceInline
        static boolean getAndSet(FieldInstanceReadWrite handle, Object holder, boolean value) {
            return MethodHandleStatics.UNSAFE.getAndSetBoolean(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndSetAcquire(FieldInstanceReadWrite handle, Object holder, boolean value) {
            return MethodHandleStatics.UNSAFE.getAndSetBooleanAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndSetRelease(FieldInstanceReadWrite handle, Object holder, boolean value) {
            return MethodHandleStatics.UNSAFE.getAndSetBooleanRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseOr(FieldInstanceReadWrite handle, Object holder, boolean value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrBoolean(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseOrRelease(FieldInstanceReadWrite handle, Object holder, boolean value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrBooleanRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseOrAcquire(FieldInstanceReadWrite handle, Object holder, boolean value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseOrBooleanAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseAnd(FieldInstanceReadWrite handle, Object holder, boolean value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndBoolean(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseAndRelease(FieldInstanceReadWrite handle, Object holder, boolean value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndBooleanRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseAndAcquire(FieldInstanceReadWrite handle, Object holder, boolean value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseAndBooleanAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseXor(FieldInstanceReadWrite handle, Object holder, boolean value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorBoolean(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseXorRelease(FieldInstanceReadWrite handle, Object holder, boolean value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorBooleanRelease(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }

        @ForceInline
        static boolean getAndBitwiseXorAcquire(FieldInstanceReadWrite handle, Object holder, boolean value) {
            return MethodHandleStatics.UNSAFE.getAndBitwiseXorBooleanAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset, value);
        }
    }

    static class FieldInstanceReadOnly
    extends VarHandle {
        final long fieldOffset;
        final Class<?> receiverType;
        static final VarForm FORM = new VarForm(FieldInstanceReadOnly.class, Object.class, Boolean.TYPE, new Class[0]);

        FieldInstanceReadOnly(Class<?> receiverType, long fieldOffset) {
            this(receiverType, fieldOffset, FORM);
        }

        protected FieldInstanceReadOnly(Class<?> receiverType, long fieldOffset, VarForm form) {
            super(form);
            this.fieldOffset = fieldOffset;
            this.receiverType = receiverType;
        }

        @Override
        final MethodType accessModeTypeUncached(VarHandle.AccessMode accessMode) {
            return accessMode.at.accessModeType(this.receiverType, Boolean.TYPE, new Class[0]);
        }

        @ForceInline
        static boolean get(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getBoolean(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static boolean getVolatile(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getBooleanVolatile(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static boolean getOpaque(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getBooleanOpaque(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }

        @ForceInline
        static boolean getAcquire(FieldInstanceReadOnly handle, Object holder) {
            return MethodHandleStatics.UNSAFE.getBooleanAcquire(Objects.requireNonNull(handle.receiverType.cast(holder)), handle.fieldOffset);
        }
    }
}

