/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandleGuards;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import jdk.internal.HotSpotIntrinsicCandidate;
import jdk.internal.util.Preconditions;
import jdk.internal.vm.annotation.ForceInline;
import jdk.internal.vm.annotation.Stable;

public abstract class VarHandle {
    final VarForm vform;
    @Stable
    TypesAndInvokers typesAndInvokers;
    static final BiFunction<String, List<Integer>, ArrayIndexOutOfBoundsException> AIOOBE_SUPPLIER = Preconditions.outOfBoundsExceptionFormatter(new Function<String, ArrayIndexOutOfBoundsException>(){

        @Override
        public ArrayIndexOutOfBoundsException apply(String s) {
            return new ArrayIndexOutOfBoundsException(s);
        }
    });
    private static final long VFORM_OFFSET;

    VarHandle(VarForm vform) {
        this.vform = vform;
    }

    RuntimeException unsupported() {
        return new UnsupportedOperationException();
    }

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native Object get(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native void set(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native Object getVolatile(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native void setVolatile(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native Object getOpaque(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native void setOpaque(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native Object getAcquire(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native void setRelease(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native boolean compareAndSet(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native Object compareAndExchange(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native Object compareAndExchangeAcquire(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native Object compareAndExchangeRelease(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native boolean weakCompareAndSetPlain(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native boolean weakCompareAndSet(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native boolean weakCompareAndSetAcquire(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native boolean weakCompareAndSetRelease(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native Object getAndSet(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native Object getAndSetAcquire(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native Object getAndSetRelease(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native Object getAndAdd(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native Object getAndAddAcquire(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native Object getAndAddRelease(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native Object getAndBitwiseOr(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native Object getAndBitwiseOrAcquire(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native Object getAndBitwiseOrRelease(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native Object getAndBitwiseAnd(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native Object getAndBitwiseAndAcquire(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native Object getAndBitwiseAndRelease(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native Object getAndBitwiseXor(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native Object getAndBitwiseXorAcquire(Object ... var1);

    @MethodHandle.PolymorphicSignature
    @HotSpotIntrinsicCandidate
    public final native Object getAndBitwiseXorRelease(Object ... var1);

    public final Class<?> varType() {
        MethodType typeSet = this.accessModeType(AccessMode.SET);
        return typeSet.parameterType(typeSet.parameterCount() - 1);
    }

    public final List<Class<?>> coordinateTypes() {
        MethodType typeGet = this.accessModeType(AccessMode.GET);
        return typeGet.parameterList();
    }

    public final MethodType accessModeType(AccessMode accessMode) {
        TypesAndInvokers tis = this.getTypesAndInvokers();
        MethodType mt = tis.methodType_table[accessMode.at.ordinal()];
        if (mt == null) {
            MethodType methodType = this.accessModeTypeUncached(accessMode);
            tis.methodType_table[accessMode.at.ordinal()] = methodType;
            mt = methodType;
        }
        return mt;
    }

    abstract MethodType accessModeTypeUncached(AccessMode var1);

    public final boolean isAccessModeSupported(AccessMode accessMode) {
        return AccessMode.getMemberName(accessMode.ordinal(), this.vform) != null;
    }

    public final MethodHandle toMethodHandle(AccessMode accessMode) {
        MemberName mn = AccessMode.getMemberName(accessMode.ordinal(), this.vform);
        if (mn != null) {
            MethodHandle mh = this.getMethodHandle(accessMode.ordinal());
            return mh.bindTo(this);
        }
        return MethodHandles.varHandleInvoker(accessMode, this.accessModeType(accessMode)).bindTo(this);
    }

    @ForceInline
    private final TypesAndInvokers getTypesAndInvokers() {
        TypesAndInvokers tis = this.typesAndInvokers;
        if (tis == null) {
            tis = this.typesAndInvokers = new TypesAndInvokers();
        }
        return tis;
    }

    @ForceInline
    final MethodHandle getMethodHandle(int mode) {
        TypesAndInvokers tis = this.getTypesAndInvokers();
        MethodHandle mh = tis.methodHandle_table[mode];
        if (mh == null) {
            mh = tis.methodHandle_table[mode] = this.getMethodHandleUncached(mode);
        }
        return mh;
    }

    private final MethodHandle getMethodHandleUncached(int mode) {
        MethodType mt = this.accessModeType(AccessMode.values()[mode]).insertParameterTypes(0, VarHandle.class);
        MemberName mn = this.vform.getMemberName(mode);
        DirectMethodHandle dmh = DirectMethodHandle.make(mn);
        MethodHandle mh = dmh.copyWith(mt, dmh.form);
        assert (mh.type().erase() == mn.getMethodType().erase());
        return mh;
    }

    final void updateVarForm(VarForm newVForm) {
        if (this.vform == newVForm) {
            return;
        }
        MethodHandleStatics.UNSAFE.putObject(this, VFORM_OFFSET, newVForm);
        MethodHandleStatics.UNSAFE.fullFence();
    }

    @ForceInline
    public static void fullFence() {
        MethodHandleStatics.UNSAFE.fullFence();
    }

    @ForceInline
    public static void acquireFence() {
        MethodHandleStatics.UNSAFE.loadFence();
    }

    @ForceInline
    public static void releaseFence() {
        MethodHandleStatics.UNSAFE.storeFence();
    }

    @ForceInline
    public static void loadLoadFence() {
        MethodHandleStatics.UNSAFE.loadLoadFence();
    }

    @ForceInline
    public static void storeStoreFence() {
        MethodHandleStatics.UNSAFE.storeStoreFence();
    }

    static {
        try {
            VFORM_OFFSET = MethodHandleStatics.UNSAFE.objectFieldOffset(VarHandle.class.getDeclaredField("vform"));
        }
        catch (ReflectiveOperationException e) {
            throw MethodHandleStatics.newInternalError(e);
        }
        MethodHandleStatics.UNSAFE.ensureClassInitialized(VarHandleGuards.class);
    }

    static class TypesAndInvokers {
        @Stable
        final MethodType[] methodType_table = new MethodType[AccessType.values().length];
        @Stable
        final MethodHandle[] methodHandle_table = new MethodHandle[AccessMode.values().length];

        TypesAndInvokers() {
        }
    }

    static final class AccessDescriptor {
        final MethodType symbolicMethodTypeErased;
        final MethodType symbolicMethodTypeInvoker;
        final Class<?> returnType;
        final int type;
        final int mode;

        public AccessDescriptor(MethodType symbolicMethodType, int type, int mode) {
            this.symbolicMethodTypeErased = symbolicMethodType.erase();
            this.symbolicMethodTypeInvoker = symbolicMethodType.insertParameterTypes(0, VarHandle.class);
            this.returnType = symbolicMethodType.returnType();
            this.type = type;
            this.mode = mode;
        }
    }

    public static enum AccessMode {
        GET("get", AccessType.GET),
        SET("set", AccessType.SET),
        GET_VOLATILE("getVolatile", AccessType.GET),
        SET_VOLATILE("setVolatile", AccessType.SET),
        GET_ACQUIRE("getAcquire", AccessType.GET),
        SET_RELEASE("setRelease", AccessType.SET),
        GET_OPAQUE("getOpaque", AccessType.GET),
        SET_OPAQUE("setOpaque", AccessType.SET),
        COMPARE_AND_SET("compareAndSet", AccessType.COMPARE_AND_SWAP),
        COMPARE_AND_EXCHANGE("compareAndExchange", AccessType.COMPARE_AND_EXCHANGE),
        COMPARE_AND_EXCHANGE_ACQUIRE("compareAndExchangeAcquire", AccessType.COMPARE_AND_EXCHANGE),
        COMPARE_AND_EXCHANGE_RELEASE("compareAndExchangeRelease", AccessType.COMPARE_AND_EXCHANGE),
        WEAK_COMPARE_AND_SET_PLAIN("weakCompareAndSetPlain", AccessType.COMPARE_AND_SWAP),
        WEAK_COMPARE_AND_SET("weakCompareAndSet", AccessType.COMPARE_AND_SWAP),
        WEAK_COMPARE_AND_SET_ACQUIRE("weakCompareAndSetAcquire", AccessType.COMPARE_AND_SWAP),
        WEAK_COMPARE_AND_SET_RELEASE("weakCompareAndSetRelease", AccessType.COMPARE_AND_SWAP),
        GET_AND_SET("getAndSet", AccessType.GET_AND_UPDATE),
        GET_AND_SET_ACQUIRE("getAndSetAcquire", AccessType.GET_AND_UPDATE),
        GET_AND_SET_RELEASE("getAndSetRelease", AccessType.GET_AND_UPDATE),
        GET_AND_ADD("getAndAdd", AccessType.GET_AND_UPDATE),
        GET_AND_ADD_ACQUIRE("getAndAddAcquire", AccessType.GET_AND_UPDATE),
        GET_AND_ADD_RELEASE("getAndAddRelease", AccessType.GET_AND_UPDATE),
        GET_AND_BITWISE_OR("getAndBitwiseOr", AccessType.GET_AND_UPDATE),
        GET_AND_BITWISE_OR_RELEASE("getAndBitwiseOrRelease", AccessType.GET_AND_UPDATE),
        GET_AND_BITWISE_OR_ACQUIRE("getAndBitwiseOrAcquire", AccessType.GET_AND_UPDATE),
        GET_AND_BITWISE_AND("getAndBitwiseAnd", AccessType.GET_AND_UPDATE),
        GET_AND_BITWISE_AND_RELEASE("getAndBitwiseAndRelease", AccessType.GET_AND_UPDATE),
        GET_AND_BITWISE_AND_ACQUIRE("getAndBitwiseAndAcquire", AccessType.GET_AND_UPDATE),
        GET_AND_BITWISE_XOR("getAndBitwiseXor", AccessType.GET_AND_UPDATE),
        GET_AND_BITWISE_XOR_RELEASE("getAndBitwiseXorRelease", AccessType.GET_AND_UPDATE),
        GET_AND_BITWISE_XOR_ACQUIRE("getAndBitwiseXorAcquire", AccessType.GET_AND_UPDATE);

        static final Map<String, AccessMode> methodNameToAccessMode;
        final String methodName;
        final AccessType at;

        private AccessMode(String methodName, AccessType at) {
            this.methodName = methodName;
            this.at = at;
        }

        public String methodName() {
            return this.methodName;
        }

        public static AccessMode valueFromMethodName(String methodName) {
            AccessMode am = methodNameToAccessMode.get(methodName);
            if (am != null) {
                return am;
            }
            throw new IllegalArgumentException("No AccessMode value for method name " + methodName);
        }

        @ForceInline
        static MemberName getMemberName(int ordinal, VarForm vform) {
            return vform.memberName_table[ordinal];
        }

        static {
            methodNameToAccessMode = new HashMap<String, AccessMode>(AccessMode.values().length);
            for (AccessMode am : AccessMode.values()) {
                methodNameToAccessMode.put(am.methodName, am);
            }
        }
    }

    static enum AccessType {
        GET(Object.class),
        SET(Void.TYPE),
        COMPARE_AND_SWAP(Boolean.TYPE),
        COMPARE_AND_EXCHANGE(Object.class),
        GET_AND_UPDATE(Object.class);

        final Class<?> returnType;
        final boolean isMonomorphicInReturnType;

        private AccessType(Class<?> returnType) {
            this.returnType = returnType;
            this.isMonomorphicInReturnType = returnType != Object.class;
        }

        MethodType accessModeType(Class<?> receiver, Class<?> value, Class<?> ... intermediate) {
            switch (this) {
                case GET: {
                    Class<?>[] ps = AccessType.allocateParameters(0, receiver, intermediate);
                    AccessType.fillParameters(ps, receiver, intermediate);
                    return MethodType.methodType(value, ps);
                }
                case SET: {
                    Class<?>[] ps = AccessType.allocateParameters(1, receiver, intermediate);
                    int i = AccessType.fillParameters(ps, receiver, intermediate);
                    ps[i] = value;
                    return MethodType.methodType(Void.TYPE, ps);
                }
                case COMPARE_AND_SWAP: {
                    Class<?>[] ps = AccessType.allocateParameters(2, receiver, intermediate);
                    int i = AccessType.fillParameters(ps, receiver, intermediate);
                    ps[i++] = value;
                    ps[i] = value;
                    return MethodType.methodType(Boolean.TYPE, ps);
                }
                case COMPARE_AND_EXCHANGE: {
                    Class<?>[] ps = AccessType.allocateParameters(2, receiver, intermediate);
                    int i = AccessType.fillParameters(ps, receiver, intermediate);
                    ps[i++] = value;
                    ps[i] = value;
                    return MethodType.methodType(value, ps);
                }
                case GET_AND_UPDATE: {
                    Class<?>[] ps = AccessType.allocateParameters(1, receiver, intermediate);
                    int i = AccessType.fillParameters(ps, receiver, intermediate);
                    ps[i] = value;
                    return MethodType.methodType(value, ps);
                }
            }
            throw new InternalError("Unknown AccessType");
        }

        private static Class<?>[] allocateParameters(int values, Class<?> receiver, Class<?> ... intermediate) {
            int size = (receiver != null ? 1 : 0) + intermediate.length + values;
            return new Class[size];
        }

        private static int fillParameters(Class<?>[] ps, Class<?> receiver, Class<?> ... intermediate) {
            int i = 0;
            if (receiver != null) {
                ps[i++] = receiver;
            }
            for (int j = 0; j < intermediate.length; ++j) {
                ps[i++] = intermediate[j];
            }
            return i;
        }
    }
}

