/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MemberName;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import jdk.internal.vm.annotation.ForceInline;
import jdk.internal.vm.annotation.Stable;

final class VarForm {
    @Stable
    final MethodType[] methodType_table = new MethodType[VarHandle.AccessType.values().length];
    @Stable
    final MemberName[] memberName_table;
    @Stable
    MethodType[] methodType_V_table;

    VarForm(Class<?> implClass, Class<?> receiver, Class<?> value, Class<?> ... intermediate) {
        this.memberName_table = VarForm.linkFromStatic(implClass);
        ArrayList l = new ArrayList();
        if (receiver != null) {
            l.add(receiver);
        }
        for (Class<?> c : intermediate) {
            l.add(c);
        }
        this.methodType_table[VarHandle.AccessType.GET.ordinal()] = MethodType.methodType(value, l).erase();
        l.add(value);
        this.methodType_table[VarHandle.AccessType.SET.ordinal()] = MethodType.methodType(Void.TYPE, l).erase();
        this.methodType_table[VarHandle.AccessType.GET_AND_UPDATE.ordinal()] = MethodType.methodType(value, l).erase();
        l.add(value);
        this.methodType_table[VarHandle.AccessType.COMPARE_AND_SWAP.ordinal()] = MethodType.methodType(Boolean.TYPE, l).erase();
        this.methodType_table[VarHandle.AccessType.COMPARE_AND_EXCHANGE.ordinal()] = MethodType.methodType(value, l).erase();
    }

    @ForceInline
    final MethodType getMethodType(int type) {
        return this.methodType_table[type];
    }

    @ForceInline
    final MemberName getMemberName(int mode) {
        MemberName mn = this.memberName_table[mode];
        if (mn == null) {
            throw new UnsupportedOperationException();
        }
        return mn;
    }

    @ForceInline
    final MethodType[] getMethodType_V_init() {
        MethodType[] table = new MethodType[VarHandle.AccessType.values().length];
        for (int i = 0; i < this.methodType_table.length; ++i) {
            MethodType mt = this.methodType_table[i];
            table[i] = mt.changeReturnType(Void.TYPE);
        }
        this.methodType_V_table = table;
        return table;
    }

    @ForceInline
    final MethodType getMethodType_V(int type) {
        MethodType[] table = this.methodType_V_table;
        if (table == null) {
            table = this.getMethodType_V_init();
        }
        return table[type];
    }

    private static MemberName[] linkFromStatic(Class<?> implClass) {
        MemberName[] table = new MemberName[VarHandle.AccessMode.values().length];
        for (Class<?> c = implClass; c != VarHandle.class; c = c.getSuperclass()) {
            for (Method m : c.getDeclaredMethods()) {
                VarHandle.AccessMode am;
                if (!Modifier.isStatic(m.getModifiers()) || (am = VarHandle.AccessMode.methodNameToAccessMode.get(m.getName())) == null) continue;
                assert (table[am.ordinal()] == null);
                table[am.ordinal()] = new MemberName(m);
            }
        }
        return table;
    }
}

