/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.ProxyClassesDumper;
import java.lang.invoke.StringConcatException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import jdk.internal.misc.Unsafe;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.Label;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.vm.annotation.ForceInline;
import sun.security.action.GetPropertyAction;

public final class StringConcatFactory {
    private static final char TAG_ARG = '\u0001';
    private static final char TAG_CONST = '\u0002';
    private static final int MAX_INDY_CONCAT_ARG_SLOTS = 200;
    private static Strategy STRATEGY = DEFAULT_STRATEGY = Strategy.MH_INLINE_SIZED_EXACT;
    private static final Strategy DEFAULT_STRATEGY;
    private static final boolean DEBUG;
    private static final boolean CACHE_ENABLE;
    private static final ConcurrentMap<Key, MethodHandle> CACHE;
    private static final ProxyClassesDumper DUMPER;

    public static CallSite makeConcat(MethodHandles.Lookup lookup, String name, MethodType concatType) throws StringConcatException {
        if (DEBUG) {
            System.out.println("StringConcatFactory " + (Object)((Object)STRATEGY) + " is here for " + concatType);
        }
        return StringConcatFactory.doStringConcat(lookup, name, concatType, true, null, new Object[0]);
    }

    public static CallSite makeConcatWithConstants(MethodHandles.Lookup lookup, String name, MethodType concatType, String recipe, Object ... constants) throws StringConcatException {
        if (DEBUG) {
            System.out.println("StringConcatFactory " + (Object)((Object)STRATEGY) + " is here for " + concatType + ", {" + recipe + "}, " + Arrays.toString(constants));
        }
        return StringConcatFactory.doStringConcat(lookup, name, concatType, false, recipe, constants);
    }

    private static CallSite doStringConcat(MethodHandles.Lookup lookup, String name, MethodType concatType, boolean generateRecipe, String recipe, Object ... constants) throws StringConcatException {
        MethodHandle mh;
        Objects.requireNonNull(lookup, "Lookup is null");
        Objects.requireNonNull(name, "Name is null");
        Objects.requireNonNull(concatType, "Concat type is null");
        Objects.requireNonNull(constants, "Constants are null");
        for (Object o : constants) {
            Objects.requireNonNull(o, "Cannot accept null constants");
        }
        if ((lookup.lookupModes() & 2) == 0) {
            throw new StringConcatException("Invalid caller: " + lookup.lookupClass().getName());
        }
        int cCount = 0;
        int oCount = 0;
        if (generateRecipe) {
            char[] value = new char[concatType.parameterCount()];
            Arrays.fill(value, '\u0001');
            recipe = new String(value);
            oCount = concatType.parameterCount();
        } else {
            Objects.requireNonNull(recipe, "Recipe is null");
            for (int i = 0; i < recipe.length(); ++i) {
                char c = recipe.charAt(i);
                if (c == '\u0002') {
                    ++cCount;
                }
                if (c != '\u0001') continue;
                ++oCount;
            }
        }
        if (oCount != concatType.parameterCount()) {
            throw new StringConcatException("Mismatched number of concat arguments: recipe wants " + oCount + " arguments, but signature provides " + concatType.parameterCount());
        }
        if (cCount != constants.length) {
            throw new StringConcatException("Mismatched number of concat constants: recipe wants " + cCount + " constants, but only " + constants.length + " are passed");
        }
        if (!concatType.returnType().isAssignableFrom(String.class)) {
            throw new StringConcatException("The return type should be compatible with String, but it is " + concatType.returnType());
        }
        if (concatType.parameterCount() > 200) {
            throw new StringConcatException("Too many concat argument slots: " + concatType.parameterCount() + ", can only accept " + 200);
        }
        String className = StringConcatFactory.getClassName(lookup.lookupClass());
        MethodType mt = StringConcatFactory.adaptType(concatType);
        Recipe rec = new Recipe(recipe, constants);
        if (CACHE_ENABLE) {
            Key key = new Key(className, mt, rec);
            mh = (MethodHandle)CACHE.get(key);
            if (mh == null) {
                mh = StringConcatFactory.generate(lookup, className, mt, rec);
                CACHE.put(key, mh);
            }
        } else {
            mh = StringConcatFactory.generate(lookup, className, mt, rec);
        }
        return new ConstantCallSite(mh.asType(concatType));
    }

    private static MethodType adaptType(MethodType args) {
        Class<?>[] ptypes = null;
        for (int i = 0; i < args.parameterCount(); ++i) {
            Class<?> ptype = args.parameterType(i);
            if (ptype.isPrimitive() || ptype == String.class || ptype == Object.class) continue;
            if (ptypes == null) {
                ptypes = args.parameterArray();
            }
            ptypes[i] = Object.class;
        }
        return ptypes != null ? MethodType.methodType(args.returnType(), ptypes) : args;
    }

    private static String getClassName(Class<?> hostClass) throws StringConcatException {
        switch (STRATEGY) {
            case BC_SB: 
            case BC_SB_SIZED: 
            case BC_SB_SIZED_EXACT: {
                if (CACHE_ENABLE) {
                    String pkgName = hostClass.getPackageName();
                    return (pkgName != null && !pkgName.isEmpty() ? pkgName.replace('.', '/') + "/" : "") + "Stubs$$StringConcat";
                }
                return hostClass.getName().replace('.', '/') + "$$StringConcat";
            }
            case MH_SB_SIZED: 
            case MH_SB_SIZED_EXACT: 
            case MH_INLINE_SIZED_EXACT: {
                return "";
            }
        }
        throw new StringConcatException("Concatenation strategy " + (Object)((Object)STRATEGY) + " is not implemented");
    }

    private static MethodHandle generate(MethodHandles.Lookup lookup, String className, MethodType mt, Recipe recipe) throws StringConcatException {
        try {
            switch (STRATEGY) {
                case BC_SB: {
                    return BytecodeStringBuilderStrategy.generate(lookup, className, mt, recipe, Mode.DEFAULT);
                }
                case BC_SB_SIZED: {
                    return BytecodeStringBuilderStrategy.generate(lookup, className, mt, recipe, Mode.SIZED);
                }
                case BC_SB_SIZED_EXACT: {
                    return BytecodeStringBuilderStrategy.generate(lookup, className, mt, recipe, Mode.SIZED_EXACT);
                }
                case MH_SB_SIZED: {
                    return MethodHandleStringBuilderStrategy.generate(mt, recipe, Mode.SIZED);
                }
                case MH_SB_SIZED_EXACT: {
                    return MethodHandleStringBuilderStrategy.generate(mt, recipe, Mode.SIZED_EXACT);
                }
                case MH_INLINE_SIZED_EXACT: {
                    return MethodHandleInlineCopyStrategy.generate(mt, recipe);
                }
            }
            throw new StringConcatException("Concatenation strategy " + (Object)((Object)STRATEGY) + " is not implemented");
        }
        catch (Error | StringConcatException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new StringConcatException("Generator failed", t);
        }
    }

    static MethodHandle lookupStatic(MethodHandles.Lookup lookup, Class<?> refc, String name, Class<?> rtype, Class<?> ... ptypes) {
        try {
            return lookup.findStatic(refc, name, MethodType.methodType(rtype, ptypes));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    static MethodHandle lookupVirtual(MethodHandles.Lookup lookup, Class<?> refc, String name, Class<?> rtype, Class<?> ... ptypes) {
        try {
            return lookup.findVirtual(refc, name, MethodType.methodType(rtype, ptypes));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    static MethodHandle lookupConstructor(MethodHandles.Lookup lookup, Class<?> refc, Class<?> ptypes) {
        try {
            return lookup.findConstructor(refc, MethodType.methodType(Void.TYPE, ptypes));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    static int estimateSize(Class<?> cl) {
        if (cl == Integer.TYPE) {
            return 11;
        }
        if (cl == Boolean.TYPE) {
            return 5;
        }
        if (cl == Byte.TYPE) {
            return 4;
        }
        if (cl == Character.TYPE) {
            return 1;
        }
        if (cl == Short.TYPE) {
            return 6;
        }
        if (cl == Double.TYPE) {
            return 26;
        }
        if (cl == Float.TYPE) {
            return 26;
        }
        if (cl == Long.TYPE) {
            return 20;
        }
        throw new IllegalArgumentException("Cannot estimate the size for " + cl);
    }

    static Class<?> adaptToStringBuilder(Class<?> c) {
        if (c.isPrimitive()) {
            if (c == Byte.TYPE || c == Short.TYPE) {
                return Integer.TYPE;
            }
        } else if (c != String.class) {
            return Object.class;
        }
        return c;
    }

    private StringConcatFactory() {
    }

    static {
        Properties props = GetPropertyAction.privilegedGetProperties();
        String strategy = props.getProperty("java.lang.invoke.stringConcat");
        CACHE_ENABLE = Boolean.parseBoolean(props.getProperty("java.lang.invoke.stringConcat.cache"));
        DEBUG = Boolean.parseBoolean(props.getProperty("java.lang.invoke.stringConcat.debug"));
        String dumpPath = props.getProperty("java.lang.invoke.stringConcat.dumpClasses");
        STRATEGY = strategy == null ? DEFAULT_STRATEGY : Strategy.valueOf(strategy);
        CACHE = CACHE_ENABLE ? new ConcurrentHashMap() : null;
        DUMPER = dumpPath == null ? null : ProxyClassesDumper.getInstance(dumpPath);
    }

    private static final class Stringifiers {
        private static final ClassValue<MethodHandle> STRINGIFIERS_MOST = new StringifierMost();
        private static final ClassValue<MethodHandle> STRINGIFIERS_ANY = new StringifierAny();

        private Stringifiers() {
        }

        static MethodHandle forMost(Class<?> t) {
            return STRINGIFIERS_MOST.get(t);
        }

        static MethodHandle forAny(Class<?> t) {
            return STRINGIFIERS_ANY.get(t);
        }

        private static class StringifierAny
        extends ClassValue<MethodHandle> {
            private StringifierAny() {
            }

            @Override
            protected MethodHandle computeValue(Class<?> cl) {
                if (cl == Byte.TYPE || cl == Short.TYPE || cl == Integer.TYPE) {
                    return StringConcatFactory.lookupStatic(MethodHandles.publicLookup(), String.class, "valueOf", String.class, Integer.TYPE);
                }
                if (cl == Boolean.TYPE) {
                    return StringConcatFactory.lookupStatic(MethodHandles.publicLookup(), String.class, "valueOf", String.class, Boolean.TYPE);
                }
                if (cl == Character.TYPE) {
                    return StringConcatFactory.lookupStatic(MethodHandles.publicLookup(), String.class, "valueOf", String.class, Character.TYPE);
                }
                if (cl == Long.TYPE) {
                    return StringConcatFactory.lookupStatic(MethodHandles.publicLookup(), String.class, "valueOf", String.class, Long.TYPE);
                }
                MethodHandle mh = (MethodHandle)STRINGIFIERS_MOST.get(cl);
                if (mh != null) {
                    return mh;
                }
                throw new IllegalStateException("Unknown class: " + cl);
            }
        }

        private static class StringifierMost
        extends ClassValue<MethodHandle> {
            private StringifierMost() {
            }

            @Override
            protected MethodHandle computeValue(Class<?> cl) {
                if (cl == String.class) {
                    return StringConcatFactory.lookupStatic(MethodHandles.publicLookup(), String.class, "valueOf", String.class, Object.class);
                }
                if (cl == Float.TYPE) {
                    return StringConcatFactory.lookupStatic(MethodHandles.publicLookup(), String.class, "valueOf", String.class, Float.TYPE);
                }
                if (cl == Double.TYPE) {
                    return StringConcatFactory.lookupStatic(MethodHandles.publicLookup(), String.class, "valueOf", String.class, Double.TYPE);
                }
                if (!cl.isPrimitive()) {
                    MethodHandle mhObject = StringConcatFactory.lookupStatic(MethodHandles.publicLookup(), String.class, "valueOf", String.class, Object.class);
                    return MethodHandles.filterReturnValue(mhObject, mhObject.asType(MethodType.methodType(String.class, String.class)));
                }
                return null;
            }
        }
    }

    private static final class MethodHandleInlineCopyStrategy {
        static final Unsafe UNSAFE = Unsafe.getUnsafe();
        private static final Function<Class<?>, MethodHandle> PREPEND = new Function<Class<?>, MethodHandle>(){

            @Override
            public MethodHandle apply(Class<?> c) {
                return StringConcatFactory.lookupStatic(MethodHandles.Lookup.IMPL_LOOKUP, STRING_HELPER, "prepend", Integer.TYPE, Integer.TYPE, byte[].class, Byte.TYPE, c);
            }
        };
        private static final Function<Class<?>, MethodHandle> CODER_MIX = new Function<Class<?>, MethodHandle>(){

            @Override
            public MethodHandle apply(Class<?> c) {
                return StringConcatFactory.lookupStatic(MethodHandles.Lookup.IMPL_LOOKUP, STRING_HELPER, "mixCoder", Byte.TYPE, Byte.TYPE, c);
            }
        };
        private static final Function<Class<?>, MethodHandle> LENGTH_MIX = new Function<Class<?>, MethodHandle>(){

            @Override
            public MethodHandle apply(Class<?> c) {
                return StringConcatFactory.lookupStatic(MethodHandles.Lookup.IMPL_LOOKUP, STRING_HELPER, "mixLen", Integer.TYPE, Integer.TYPE, c);
            }
        };
        private static final MethodHandle NEW_STRING;
        private static final MethodHandle NEW_ARRAY;
        private static final ConcurrentMap<Class<?>, MethodHandle> PREPENDERS;
        private static final ConcurrentMap<Class<?>, MethodHandle> LENGTH_MIXERS;
        private static final ConcurrentMap<Class<?>, MethodHandle> CODER_MIXERS;
        private static final byte INITIAL_CODER;
        static final Class<?> STRING_HELPER;

        private MethodHandleInlineCopyStrategy() {
        }

        static MethodHandle generate(MethodType mt, Recipe recipe) throws Throwable {
            Class<?>[] ptypes = mt.parameterArray();
            MethodHandle[] filters = null;
            for (int i = 0; i < ptypes.length; ++i) {
                MethodHandle filter = Stringifiers.forMost(ptypes[i]);
                if (filter == null) continue;
                if (filters == null) {
                    filters = new MethodHandle[ptypes.length];
                }
                filters[i] = filter;
                ptypes[i] = filter.type().returnType();
            }
            MethodHandle mh = MethodHandles.dropArguments(NEW_STRING, 3, ptypes);
            block9: for (RecipeElement el : recipe.getElements()) {
                mh = MethodHandles.dropArguments(mh, 2, Integer.TYPE);
                switch (el.getTag()) {
                    case '\u0002': {
                        Object cnst = el.getValue();
                        MethodHandle prepender = MethodHandles.insertArguments(MethodHandleInlineCopyStrategy.prepender(cnst.getClass()), 3, cnst);
                        mh = MethodHandles.foldArguments(mh, 1, prepender, 2, 0, 3);
                        continue block9;
                    }
                    case '\u0001': {
                        int pos = el.getArgPos();
                        MethodHandle prepender = MethodHandleInlineCopyStrategy.prepender(ptypes[pos]);
                        mh = MethodHandles.foldArguments(mh, 1, prepender, 2, 0, 3, 4 + pos);
                        continue block9;
                    }
                }
                throw new StringConcatException("Unhandled tag: " + el.getTag());
            }
            mh = MethodHandles.foldArguments(mh, 0, NEW_ARRAY, 1, 2);
            byte initialCoder = INITIAL_CODER;
            int initialLen = 0;
            block10: for (RecipeElement el : recipe.getElements()) {
                switch (el.getTag()) {
                    case '\u0002': {
                        Object constant = el.getValue();
                        String s = constant.toString();
                        initialCoder = MethodHandleInlineCopyStrategy.coderMixer(String.class).invoke(initialCoder, s);
                        initialLen += s.length();
                        continue block10;
                    }
                    case '\u0001': {
                        int ac = el.getArgPos();
                        Class<?> argClass = ptypes[ac];
                        MethodHandle lm = MethodHandleInlineCopyStrategy.lengthMixer(argClass);
                        MethodHandle cm = MethodHandleInlineCopyStrategy.coderMixer(argClass);
                        mh = MethodHandles.dropArguments(mh, 2, Integer.TYPE, Byte.TYPE);
                        mh = MethodHandles.foldArguments(mh, 0, lm, 2, 4 + ac);
                        mh = MethodHandles.foldArguments(mh, 0, cm, 2, 3 + ac);
                        continue block10;
                    }
                }
                throw new StringConcatException("Unhandled tag: " + el.getTag());
            }
            mh = MethodHandles.insertArguments(mh, 0, initialLen, initialCoder);
            if (filters != null) {
                mh = MethodHandles.filterArguments(mh, 0, filters);
            }
            return mh;
        }

        @ForceInline
        private static byte[] newArray(int length, byte coder) {
            return (byte[])UNSAFE.allocateUninitializedArray(Byte.TYPE, length << coder);
        }

        private static MethodHandle prepender(Class<?> cl) {
            return PREPENDERS.computeIfAbsent(cl, PREPEND);
        }

        private static MethodHandle coderMixer(Class<?> cl) {
            return CODER_MIXERS.computeIfAbsent(cl, CODER_MIX);
        }

        private static MethodHandle lengthMixer(Class<?> cl) {
            return LENGTH_MIXERS.computeIfAbsent(cl, LENGTH_MIX);
        }

        static {
            try {
                STRING_HELPER = Class.forName("java.lang.StringConcatHelper");
                MethodHandle initCoder = StringConcatFactory.lookupStatic(MethodHandles.Lookup.IMPL_LOOKUP, STRING_HELPER, "initialCoder", Byte.TYPE, new Class[0]);
                INITIAL_CODER = initCoder.invoke();
            }
            catch (Throwable e) {
                throw new AssertionError((Object)e);
            }
            PREPENDERS = new ConcurrentHashMap();
            LENGTH_MIXERS = new ConcurrentHashMap();
            CODER_MIXERS = new ConcurrentHashMap();
            NEW_STRING = StringConcatFactory.lookupStatic(MethodHandles.Lookup.IMPL_LOOKUP, STRING_HELPER, "newString", String.class, byte[].class, Integer.TYPE, Byte.TYPE);
            NEW_ARRAY = StringConcatFactory.lookupStatic(MethodHandles.Lookup.IMPL_LOOKUP, MethodHandleInlineCopyStrategy.class, "newArray", byte[].class, Integer.TYPE, Byte.TYPE);
        }
    }

    private static final class MethodHandleStringBuilderStrategy {
        private static final ConcurrentMap<Integer, MethodHandle> SUMMERS;
        private static final Function<Integer, MethodHandle> SUMMER;
        private static final MethodHandle NEW_STRING_BUILDER;
        private static final MethodHandle STRING_LENGTH;
        private static final MethodHandle BUILDER_TO_STRING;
        private static final MethodHandle BUILDER_TO_STRING_CHECKED;

        private MethodHandleStringBuilderStrategy() {
        }

        private static MethodHandle generate(MethodType mt, Recipe recipe, Mode mode) throws Exception {
            int pc = mt.parameterCount();
            Class<?>[] ptypes = mt.parameterArray();
            MethodHandle[] filters = new MethodHandle[ptypes.length];
            for (int i = 0; i < ptypes.length; ++i) {
                MethodHandle filter;
                switch (mode) {
                    case SIZED: {
                        filter = Stringifiers.forMost(ptypes[i]);
                        break;
                    }
                    case SIZED_EXACT: {
                        filter = Stringifiers.forAny(ptypes[i]);
                        break;
                    }
                    default: {
                        throw new StringConcatException("Not supported");
                    }
                }
                if (filter == null) continue;
                filters[i] = filter;
                ptypes[i] = filter.type().returnType();
            }
            MethodHandle[] lengthers = new MethodHandle[pc];
            int initial = 0;
            block13: for (RecipeElement el : recipe.getElements()) {
                switch (el.getTag()) {
                    case '\u0002': {
                        Object cnst = el.getValue();
                        initial += cnst.toString().length();
                        continue block13;
                    }
                    case '\u0001': {
                        int i = el.getArgPos();
                        Class<?> type = ptypes[i];
                        if (type.isPrimitive()) {
                            MethodHandle est = MethodHandles.constant(Integer.TYPE, StringConcatFactory.estimateSize(type));
                            lengthers[i] = est = MethodHandles.dropArguments(est, 0, type);
                            continue block13;
                        }
                        lengthers[i] = STRING_LENGTH;
                        continue block13;
                    }
                }
                throw new StringConcatException("Unhandled tag: " + el.getTag());
            }
            MethodHandle builder = MethodHandles.dropArguments(MethodHandles.identity(StringBuilder.class), 1, ptypes);
            List<RecipeElement> elements = recipe.getElements();
            for (int i = elements.size() - 1; i >= 0; --i) {
                MethodHandle appender;
                RecipeElement el = elements.get(i);
                switch (el.getTag()) {
                    case '\u0002': {
                        Object constant = el.getValue();
                        MethodHandle mh = MethodHandleStringBuilderStrategy.appender(StringConcatFactory.adaptToStringBuilder(constant.getClass()));
                        appender = MethodHandles.insertArguments(mh, 1, constant);
                        break;
                    }
                    case '\u0001': {
                        int ac = el.getArgPos();
                        appender = MethodHandleStringBuilderStrategy.appender(ptypes[ac]);
                        if (ac == 0) break;
                        appender = MethodHandles.dropArguments(appender, 1, Arrays.copyOf(ptypes, ac));
                        break;
                    }
                    default: {
                        throw new StringConcatException("Unhandled tag: " + el.getTag());
                    }
                }
                builder = MethodHandles.foldArguments(builder, appender);
            }
            MethodHandle sum = MethodHandleStringBuilderStrategy.getReducerFor(pc + 1);
            MethodHandle adder = MethodHandles.insertArguments(sum, 0, initial);
            adder = MethodHandles.filterArguments(adder, 0, lengthers);
            MethodHandle newBuilder = MethodHandles.filterReturnValue(adder, NEW_STRING_BUILDER);
            MethodHandle mh = MethodHandles.foldArguments(builder, newBuilder);
            mh = MethodHandles.filterArguments(mh, 0, filters);
            mh = DEBUG && mode.isExact() ? MethodHandles.filterReturnValue(mh, BUILDER_TO_STRING_CHECKED) : MethodHandles.filterReturnValue(mh, BUILDER_TO_STRING);
            return mh;
        }

        private static MethodHandle getReducerFor(int cnt) {
            return SUMMERS.computeIfAbsent(cnt, SUMMER);
        }

        private static MethodHandle appender(Class<?> appendType) {
            MethodHandle appender = StringConcatFactory.lookupVirtual(MethodHandles.publicLookup(), StringBuilder.class, "append", StringBuilder.class, StringConcatFactory.adaptToStringBuilder(appendType));
            MethodType nt = MethodType.methodType(Void.TYPE, StringBuilder.class, appendType);
            return appender.asType(nt);
        }

        private static String toStringChecked(StringBuilder sb) {
            String s = sb.toString();
            if (s.length() != sb.capacity()) {
                throw new AssertionError((Object)("Exactness check failed: result length = " + s.length() + ", buffer capacity = " + sb.capacity()));
            }
            return s;
        }

        private static int sum(int v1, int v2) {
            return v1 + v2;
        }

        private static int sum(int v1, int v2, int v3) {
            return v1 + v2 + v3;
        }

        private static int sum(int v1, int v2, int v3, int v4) {
            return v1 + v2 + v3 + v4;
        }

        private static int sum(int v1, int v2, int v3, int v4, int v5) {
            return v1 + v2 + v3 + v4 + v5;
        }

        private static int sum(int v1, int v2, int v3, int v4, int v5, int v6) {
            return v1 + v2 + v3 + v4 + v5 + v6;
        }

        private static int sum(int v1, int v2, int v3, int v4, int v5, int v6, int v7) {
            return v1 + v2 + v3 + v4 + v5 + v6 + v7;
        }

        private static int sum(int v1, int v2, int v3, int v4, int v5, int v6, int v7, int v8) {
            return v1 + v2 + v3 + v4 + v5 + v6 + v7 + v8;
        }

        private static int sum(int initial, int[] vs) {
            int sum = initial;
            for (int v : vs) {
                sum += v;
            }
            return sum;
        }

        static {
            SUMMER = new Function<Integer, MethodHandle>(){

                @Override
                public MethodHandle apply(Integer cnt) {
                    if (cnt == 1) {
                        return MethodHandles.identity(Integer.TYPE);
                    }
                    if (cnt <= 8) {
                        Object[] cls = new Class[cnt.intValue()];
                        Arrays.fill(cls, Integer.TYPE);
                        return StringConcatFactory.lookupStatic(MethodHandles.Lookup.IMPL_LOOKUP, MethodHandleStringBuilderStrategy.class, "sum", Integer.TYPE, cls);
                    }
                    return StringConcatFactory.lookupStatic(MethodHandles.Lookup.IMPL_LOOKUP, MethodHandleStringBuilderStrategy.class, "sum", Integer.TYPE, Integer.TYPE, int[].class).asCollector(int[].class, cnt - 1);
                }
            };
            SUMMERS = new ConcurrentHashMap<Integer, MethodHandle>();
            MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();
            NEW_STRING_BUILDER = StringConcatFactory.lookupConstructor(publicLookup, StringBuilder.class, Integer.TYPE);
            STRING_LENGTH = StringConcatFactory.lookupVirtual(publicLookup, String.class, "length", Integer.TYPE, new Class[0]);
            BUILDER_TO_STRING = StringConcatFactory.lookupVirtual(publicLookup, StringBuilder.class, "toString", String.class, new Class[0]);
            BUILDER_TO_STRING_CHECKED = DEBUG ? StringConcatFactory.lookupStatic(MethodHandles.Lookup.IMPL_LOOKUP, MethodHandleStringBuilderStrategy.class, "toStringChecked", String.class, StringBuilder.class) : null;
        }
    }

    private static final class BytecodeStringBuilderStrategy {
        static final Unsafe UNSAFE = Unsafe.getUnsafe();
        static final int CLASSFILE_VERSION = 52;
        static final String METHOD_NAME = "concat";

        private BytecodeStringBuilderStrategy() {
        }

        private static MethodHandle generate(MethodHandles.Lookup lookup, String className, MethodType args, Recipe recipe, Mode mode) throws Exception {
            Class<?> cl;
            Object cnst;
            int off;
            ClassWriter cw = new ClassWriter(3);
            cw.visit(52, 4145, className, null, "java/lang/Object", null);
            MethodVisitor mv = cw.visitMethod(25, METHOD_NAME, args.toMethodDescriptorString(), null, null);
            mv.visitAnnotation("Ljdk/internal/vm/annotation/ForceInline;", true);
            mv.visitCode();
            Class<?>[] arr = args.parameterArray();
            boolean[] guaranteedNonNull = new boolean[arr.length];
            if (mode.isExact()) {
                off = 0;
                int modOff = 0;
                for (int c = 0; c < arr.length; ++c) {
                    Class<?> cl2 = arr[c];
                    if (cl2 == String.class) {
                        if (off != modOff) {
                            mv.visitIntInsn(BytecodeStringBuilderStrategy.getLoadOpcode(cl2), off);
                            mv.visitIntInsn(58, modOff);
                        }
                    } else {
                        mv.visitIntInsn(BytecodeStringBuilderStrategy.getLoadOpcode(cl2), off);
                        mv.visitMethodInsn(184, "java/lang/String", "valueOf", BytecodeStringBuilderStrategy.getStringValueOfDesc(cl2), false);
                        mv.visitIntInsn(58, modOff);
                        arr[c] = String.class;
                        guaranteedNonNull[c] = cl2.isPrimitive();
                    }
                    off += BytecodeStringBuilderStrategy.getParameterSize(cl2);
                    modOff += BytecodeStringBuilderStrategy.getParameterSize(String.class);
                }
            }
            if (mode.isSized()) {
                off = 0;
                block15: for (RecipeElement el : recipe.getElements()) {
                    switch (el.getTag()) {
                        case '\u0002': {
                            continue block15;
                        }
                        case '\u0001': {
                            int ac = el.getArgPos();
                            Class<?> cl3 = arr[ac];
                            if (cl3 == String.class && !guaranteedNonNull[ac]) {
                                Label l0 = new Label();
                                mv.visitIntInsn(25, off);
                                mv.visitJumpInsn(199, l0);
                                mv.visitLdcInsn("null");
                                mv.visitIntInsn(58, off);
                                mv.visitLabel(l0);
                            }
                            off += BytecodeStringBuilderStrategy.getParameterSize(cl3);
                            continue block15;
                        }
                    }
                    throw new StringConcatException("Unhandled tag: " + el.getTag());
                }
            }
            mv.visitTypeInsn(187, "java/lang/StringBuilder");
            mv.visitInsn(89);
            if (mode.isSized()) {
                int len = 0;
                int off2 = 0;
                mv.visitInsn(3);
                block16: for (RecipeElement el : recipe.getElements()) {
                    switch (el.getTag()) {
                        case '\u0002': {
                            cnst = el.getValue();
                            len += cnst.toString().length();
                            continue block16;
                        }
                        case '\u0001': {
                            cl = arr[el.getArgPos()];
                            if (cl == String.class) {
                                mv.visitIntInsn(25, off2);
                                mv.visitMethodInsn(182, "java/lang/String", "length", "()I", false);
                                mv.visitInsn(96);
                            } else if (cl.isPrimitive()) {
                                len += StringConcatFactory.estimateSize(cl);
                            }
                            off2 += BytecodeStringBuilderStrategy.getParameterSize(cl);
                            continue block16;
                        }
                    }
                    throw new StringConcatException("Unhandled tag: " + el.getTag());
                }
                if (len > 0) {
                    BytecodeStringBuilderStrategy.iconst(mv, len);
                    mv.visitInsn(96);
                }
                mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "(I)V", false);
            } else {
                mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V", false);
            }
            off = 0;
            for (RecipeElement el : recipe.getElements()) {
                String desc;
                switch (el.getTag()) {
                    case '\u0002': {
                        cnst = el.getValue();
                        mv.visitLdcInsn(cnst);
                        desc = BytecodeStringBuilderStrategy.getSBAppendDesc(cnst.getClass());
                        break;
                    }
                    case '\u0001': {
                        cl = arr[el.getArgPos()];
                        mv.visitVarInsn(BytecodeStringBuilderStrategy.getLoadOpcode(cl), off);
                        off += BytecodeStringBuilderStrategy.getParameterSize(cl);
                        desc = BytecodeStringBuilderStrategy.getSBAppendDesc(cl);
                        break;
                    }
                    default: {
                        throw new StringConcatException("Unhandled tag: " + el.getTag());
                    }
                }
                mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", desc, false);
            }
            if (DEBUG && mode.isExact()) {
                mv.visitInsn(89);
                mv.visitInsn(89);
                mv.visitMethodInsn(182, "java/lang/StringBuilder", "capacity", "()I", false);
                mv.visitInsn(95);
                mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
                mv.visitMethodInsn(182, "java/lang/String", "length", "()I", false);
                Label l0 = new Label();
                mv.visitJumpInsn(159, l0);
                mv.visitTypeInsn(187, "java/lang/AssertionError");
                mv.visitInsn(89);
                mv.visitLdcInsn("Failed exactness check");
                mv.visitMethodInsn(183, "java/lang/AssertionError", "<init>", "(Ljava/lang/Object;)V", false);
                mv.visitInsn(191);
                mv.visitLabel(l0);
            }
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
            mv.visitInsn(176);
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
            cw.visitEnd();
            byte[] classBytes = cw.toByteArray();
            try {
                Class<?> hostClass = lookup.lookupClass();
                Class innerClass = UNSAFE.defineAnonymousClass(hostClass, classBytes, null);
                UNSAFE.ensureClassInitialized(innerClass);
                BytecodeStringBuilderStrategy.dumpIfEnabled(innerClass.getName(), classBytes);
                return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(innerClass, METHOD_NAME, args);
            }
            catch (Exception e) {
                BytecodeStringBuilderStrategy.dumpIfEnabled(className + "$$FAILED", classBytes);
                throw new StringConcatException("Exception while spinning the class", e);
            }
        }

        private static void dumpIfEnabled(String name, byte[] bytes) {
            if (DUMPER != null) {
                DUMPER.dumpClass(name, bytes);
            }
        }

        private static String getSBAppendDesc(Class<?> cl) {
            if (cl.isPrimitive()) {
                if (cl == Integer.TYPE || cl == Byte.TYPE || cl == Short.TYPE) {
                    return "(I)Ljava/lang/StringBuilder;";
                }
                if (cl == Boolean.TYPE) {
                    return "(Z)Ljava/lang/StringBuilder;";
                }
                if (cl == Character.TYPE) {
                    return "(C)Ljava/lang/StringBuilder;";
                }
                if (cl == Double.TYPE) {
                    return "(D)Ljava/lang/StringBuilder;";
                }
                if (cl == Float.TYPE) {
                    return "(F)Ljava/lang/StringBuilder;";
                }
                if (cl == Long.TYPE) {
                    return "(J)Ljava/lang/StringBuilder;";
                }
                throw new IllegalStateException("Unhandled primitive StringBuilder.append: " + cl);
            }
            if (cl == String.class) {
                return "(Ljava/lang/String;)Ljava/lang/StringBuilder;";
            }
            return "(Ljava/lang/Object;)Ljava/lang/StringBuilder;";
        }

        private static String getStringValueOfDesc(Class<?> cl) {
            if (cl.isPrimitive()) {
                if (cl == Integer.TYPE || cl == Byte.TYPE || cl == Short.TYPE) {
                    return "(I)Ljava/lang/String;";
                }
                if (cl == Boolean.TYPE) {
                    return "(Z)Ljava/lang/String;";
                }
                if (cl == Character.TYPE) {
                    return "(C)Ljava/lang/String;";
                }
                if (cl == Double.TYPE) {
                    return "(D)Ljava/lang/String;";
                }
                if (cl == Float.TYPE) {
                    return "(F)Ljava/lang/String;";
                }
                if (cl == Long.TYPE) {
                    return "(J)Ljava/lang/String;";
                }
                throw new IllegalStateException("Unhandled String.valueOf: " + cl);
            }
            if (cl == String.class) {
                return "(Ljava/lang/String;)Ljava/lang/String;";
            }
            return "(Ljava/lang/Object;)Ljava/lang/String;";
        }

        private static void iconst(MethodVisitor mv, int cst) {
            if (cst >= -1 && cst <= 5) {
                mv.visitInsn(3 + cst);
            } else if (cst >= -128 && cst <= 127) {
                mv.visitIntInsn(16, cst);
            } else if (cst >= Short.MIN_VALUE && cst <= Short.MAX_VALUE) {
                mv.visitIntInsn(17, cst);
            } else {
                mv.visitLdcInsn(cst);
            }
        }

        private static int getLoadOpcode(Class<?> c) {
            if (c == Void.TYPE) {
                throw new InternalError("Unexpected void type of load opcode");
            }
            return 21 + BytecodeStringBuilderStrategy.getOpcodeOffset(c);
        }

        private static int getOpcodeOffset(Class<?> c) {
            if (c.isPrimitive()) {
                if (c == Long.TYPE) {
                    return 1;
                }
                if (c == Float.TYPE) {
                    return 2;
                }
                if (c == Double.TYPE) {
                    return 3;
                }
                return 0;
            }
            return 4;
        }

        private static int getParameterSize(Class<?> c) {
            if (c == Void.TYPE) {
                return 0;
            }
            if (c == Long.TYPE || c == Double.TYPE) {
                return 2;
            }
            return 1;
        }
    }

    private static enum Mode {
        DEFAULT(false, false),
        SIZED(true, false),
        SIZED_EXACT(true, true);

        private final boolean sized;
        private final boolean exact;

        private Mode(boolean sized, boolean exact) {
            this.sized = sized;
            this.exact = exact;
        }

        boolean isSized() {
            return this.sized;
        }

        boolean isExact() {
            return this.exact;
        }
    }

    private static final class RecipeElement {
        private final Object value;
        private final int argPos;
        private final char tag;

        public RecipeElement(Object cnst) {
            this.value = Objects.requireNonNull(cnst);
            this.argPos = -1;
            this.tag = (char)2;
        }

        public RecipeElement(int arg) {
            this.value = null;
            this.argPos = arg;
            this.tag = '\u0001';
        }

        public Object getValue() {
            assert (this.tag == '\u0002');
            return this.value;
        }

        public int getArgPos() {
            assert (this.tag == '\u0001');
            return this.argPos;
        }

        public char getTag() {
            return this.tag;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RecipeElement that = (RecipeElement)o;
            if (this.tag != that.tag) {
                return false;
            }
            if (this.tag == '\u0002' && !this.value.equals(that.value)) {
                return false;
            }
            return this.tag != '\u0001' || this.argPos == that.argPos;
        }

        public int hashCode() {
            return this.tag;
        }
    }

    private static final class Recipe {
        private final List<RecipeElement> elements;

        public Recipe(String src, Object[] constants) {
            ArrayList<RecipeElement> el = new ArrayList<RecipeElement>();
            int constC = 0;
            int argC = 0;
            StringBuilder acc = new StringBuilder();
            for (int i = 0; i < src.length(); ++i) {
                char c = src.charAt(i);
                if (c == '\u0002' || c == '\u0001') {
                    if (acc.length() > 0) {
                        el.add(new RecipeElement(acc.toString()));
                        acc.setLength(0);
                    }
                    if (c == '\u0002') {
                        Object cnst = constants[constC++];
                        el.add(new RecipeElement(cnst));
                        continue;
                    }
                    if (c != '\u0001') continue;
                    el.add(new RecipeElement(argC++));
                    continue;
                }
                acc.append(c);
            }
            if (acc.length() > 0) {
                el.add(new RecipeElement(acc.toString()));
            }
            this.elements = el;
        }

        public List<RecipeElement> getElements() {
            return this.elements;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Recipe recipe = (Recipe)o;
            return this.elements.equals(recipe.elements);
        }

        public int hashCode() {
            return this.elements.hashCode();
        }
    }

    private static final class Key {
        final String className;
        final MethodType mt;
        final Recipe recipe;

        public Key(String className, MethodType mt, Recipe recipe) {
            this.className = className;
            this.mt = mt;
            this.recipe = recipe;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!this.className.equals(key.className)) {
                return false;
            }
            if (!this.mt.equals((Object)key.mt)) {
                return false;
            }
            return this.recipe.equals(key.recipe);
        }

        public int hashCode() {
            int result = this.className.hashCode();
            result = 31 * result + this.mt.hashCode();
            result = 31 * result + this.recipe.hashCode();
            return result;
        }
    }

    private static enum Strategy {
        BC_SB,
        BC_SB_SIZED,
        BC_SB_SIZED_EXACT,
        MH_SB_SIZED,
        MH_SB_SIZED_EXACT,
        MH_INLINE_SIZED_EXACT;

    }
}

