/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.InfoFromMemberName;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleInfo;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.invoke.VarHandles;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Module;
import java.lang.reflect.ReflectPermission;
import java.nio.ByteOrder;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.internal.misc.VM;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;
import jdk.internal.vm.annotation.ForceInline;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.VerifyAccess;
import sun.invoke.util.Wrapper;
import sun.reflect.misc.ReflectUtil;
import sun.security.util.SecurityConstants;

public class MethodHandles {
    static final MemberName.Factory IMPL_NAMES = MemberName.getFactory();
    private static final Permission ACCESS_PERMISSION = new ReflectPermission("suppressAccessChecks");
    private static final MethodHandle[] IDENTITY_MHS = new MethodHandle[10];
    private static final MethodHandle[] ZERO_MHS = new MethodHandle[10];

    private MethodHandles() {
    }

    @CallerSensitive
    @ForceInline
    public static Lookup lookup() {
        return new Lookup(Reflection.getCallerClass());
    }

    public static Lookup publicLookup() {
        if (!VM.isModuleSystemInited()) {
            return new Lookup(Object.class, 1);
        }
        return LookupHelper.PUBLIC_LOOKUP;
    }

    public static Lookup privateLookupIn(Class<?> targetClass, Lookup lookup) throws IllegalAccessException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ACCESS_PERMISSION);
        }
        if (targetClass.isPrimitive()) {
            throw new IllegalArgumentException(targetClass + " is a primitive class");
        }
        if (targetClass.isArray()) {
            throw new IllegalArgumentException(targetClass + " is an array class");
        }
        Module targetModule = targetClass.getModule();
        Module callerModule = lookup.lookupClass().getModule();
        if (callerModule != targetModule && targetModule.isNamed()) {
            if (!callerModule.canRead(targetModule)) {
                throw new IllegalAccessException(callerModule + " does not read " + targetModule);
            }
            String pn = targetClass.getPackageName();
            assert (pn != null && pn.length() > 0) : "unnamed package cannot be in named module";
            if (!targetModule.isOpen(pn, callerModule)) {
                throw new IllegalAccessException(targetModule + " does not open " + pn + " to " + callerModule);
            }
        }
        if ((lookup.lookupModes() & 0x10) == 0) {
            throw new IllegalAccessException("lookup does not have MODULE lookup mode");
        }
        return new Lookup(targetClass);
    }

    public static <T extends Member> T reflectAs(Class<T> expected, MethodHandle target) {
        SecurityManager smgr = System.getSecurityManager();
        if (smgr != null) {
            smgr.checkPermission(ACCESS_PERMISSION);
        }
        Lookup lookup = Lookup.IMPL_LOOKUP;
        return lookup.revealDirect(target).reflectAs(expected, lookup);
    }

    public static MethodHandle arrayConstructor(Class<?> arrayClass) throws IllegalArgumentException {
        if (!arrayClass.isArray()) {
            throw MethodHandleStatics.newIllegalArgumentException("not an array class: " + arrayClass.getName());
        }
        MethodHandle ani = MethodHandleImpl.getConstantHandle(11).bindTo(arrayClass.getComponentType());
        return ani.asType(ani.type().changeReturnType(arrayClass));
    }

    public static MethodHandle arrayLength(Class<?> arrayClass) throws IllegalArgumentException {
        return MethodHandleImpl.makeArrayElementAccessor(arrayClass, MethodHandleImpl.ArrayAccess.LENGTH);
    }

    public static MethodHandle arrayElementGetter(Class<?> arrayClass) throws IllegalArgumentException {
        return MethodHandleImpl.makeArrayElementAccessor(arrayClass, MethodHandleImpl.ArrayAccess.GET);
    }

    public static MethodHandle arrayElementSetter(Class<?> arrayClass) throws IllegalArgumentException {
        return MethodHandleImpl.makeArrayElementAccessor(arrayClass, MethodHandleImpl.ArrayAccess.SET);
    }

    public static VarHandle arrayElementVarHandle(Class<?> arrayClass) throws IllegalArgumentException {
        return VarHandles.makeArrayElementHandle(arrayClass);
    }

    public static VarHandle byteArrayViewVarHandle(Class<?> viewArrayClass, ByteOrder byteOrder) throws IllegalArgumentException {
        Objects.requireNonNull(byteOrder);
        return VarHandles.byteArrayViewHandle(viewArrayClass, byteOrder == ByteOrder.BIG_ENDIAN);
    }

    public static VarHandle byteBufferViewVarHandle(Class<?> viewArrayClass, ByteOrder byteOrder) throws IllegalArgumentException {
        Objects.requireNonNull(byteOrder);
        return VarHandles.makeByteBufferViewHandle(viewArrayClass, byteOrder == ByteOrder.BIG_ENDIAN);
    }

    public static MethodHandle spreadInvoker(MethodType type, int leadingArgCount) {
        if (leadingArgCount < 0 || leadingArgCount > type.parameterCount()) {
            throw MethodHandleStatics.newIllegalArgumentException("bad argument count", leadingArgCount);
        }
        type = type.asSpreaderType(Object[].class, leadingArgCount, type.parameterCount() - leadingArgCount);
        return type.invokers().spreadInvoker(leadingArgCount);
    }

    public static MethodHandle exactInvoker(MethodType type) {
        return type.invokers().exactInvoker();
    }

    public static MethodHandle invoker(MethodType type) {
        return type.invokers().genericInvoker();
    }

    public static MethodHandle varHandleExactInvoker(VarHandle.AccessMode accessMode, MethodType type) {
        return type.invokers().varHandleMethodExactInvoker(accessMode);
    }

    public static MethodHandle varHandleInvoker(VarHandle.AccessMode accessMode, MethodType type) {
        return type.invokers().varHandleMethodInvoker(accessMode);
    }

    static MethodHandle basicInvoker(MethodType type) {
        return type.invokers().basicInvoker();
    }

    public static MethodHandle explicitCastArguments(MethodHandle target, MethodType newType) {
        MethodHandles.explicitCastArgumentsChecks(target, newType);
        MethodType oldType = target.type();
        if (oldType == newType) {
            return target;
        }
        if (oldType.explicitCastEquivalentToAsType(newType)) {
            return target.asFixedArity().asType(newType);
        }
        return MethodHandleImpl.makePairwiseConvert(target, newType, false);
    }

    private static void explicitCastArgumentsChecks(MethodHandle target, MethodType newType) {
        if (target.type().parameterCount() != newType.parameterCount()) {
            throw new WrongMethodTypeException("cannot explicitly cast " + target + " to " + newType);
        }
    }

    public static MethodHandle permuteArguments(MethodHandle target, MethodType newType, int ... reorder) {
        int ddIdx;
        reorder = (int[])reorder.clone();
        MethodType oldType = target.type();
        MethodHandles.permuteArgumentChecks(reorder, newType, oldType);
        int[] originalReorder = reorder;
        BoundMethodHandle result = target.rebind();
        LambdaForm form = result.form;
        int newArity = newType.parameterCount();
        while ((ddIdx = MethodHandles.findFirstDupOrDrop(reorder, newArity)) != 0) {
            if (ddIdx > 0) {
                int val;
                int srcPos;
                int dstPos = srcPos = ddIdx;
                int dupVal = reorder[srcPos];
                boolean killFirst = false;
                while ((val = reorder[--dstPos]) != dupVal) {
                    if (dupVal <= val) continue;
                    killFirst = true;
                }
                if (!killFirst) {
                    srcPos = dstPos;
                    dstPos = ddIdx;
                }
                form = form.editor().dupArgumentForm(1 + srcPos, 1 + dstPos);
                assert (reorder[srcPos] == reorder[dstPos]);
                oldType = oldType.dropParameterTypes(dstPos, dstPos + 1);
                int tailPos = dstPos + 1;
                System.arraycopy(reorder, tailPos, reorder, dstPos, reorder.length - tailPos);
                reorder = Arrays.copyOf(reorder, reorder.length - 1);
            } else {
                int insPos;
                int dropVal = ~ddIdx;
                for (insPos = 0; insPos < reorder.length && reorder[insPos] < dropVal; ++insPos) {
                }
                Class<?> ptype = newType.parameterType(dropVal);
                form = form.editor().addArgumentForm(1 + insPos, LambdaForm.BasicType.basicType(ptype));
                oldType = oldType.insertParameterTypes(insPos, ptype);
                int tailPos = insPos + 1;
                reorder = Arrays.copyOf(reorder, reorder.length + 1);
                System.arraycopy(reorder, insPos, reorder, tailPos, reorder.length - tailPos);
                reorder[insPos] = dropVal;
            }
            assert (MethodHandles.permuteArgumentChecks(reorder, newType, oldType));
        }
        assert (reorder.length == newArity);
        form = form.editor().permuteArgumentsForm(1, reorder);
        if (newType == result.type() && form == result.internalForm()) {
            return result;
        }
        return result.copyWith(newType, form);
    }

    private static int findFirstDupOrDrop(int[] reorder, int newArity) {
        int BIT_LIMIT = 63;
        if (newArity < 63) {
            long mask = 0L;
            for (int i = 0; i < reorder.length; ++i) {
                int arg = reorder[i];
                if (arg >= newArity) {
                    return reorder.length;
                }
                long bit = 1L << arg;
                if ((mask & bit) != 0L) {
                    return i;
                }
                mask |= bit;
            }
            if (mask == (1L << newArity) - 1L) {
                assert (Long.numberOfTrailingZeros(Long.lowestOneBit(mask ^ 0xFFFFFFFFFFFFFFFFL)) == newArity);
                return 0;
            }
            long zeroBit = Long.lowestOneBit(mask ^ 0xFFFFFFFFFFFFFFFFL);
            int zeroPos = Long.numberOfTrailingZeros(zeroBit);
            assert (zeroPos <= newArity);
            if (zeroPos == newArity) {
                return 0;
            }
            return ~zeroPos;
        }
        BitSet mask = new BitSet(newArity);
        for (int i = 0; i < reorder.length; ++i) {
            int arg = reorder[i];
            if (arg >= newArity) {
                return reorder.length;
            }
            if (mask.get(arg)) {
                return i;
            }
            mask.set(arg);
        }
        int zeroPos = mask.nextClearBit(0);
        assert (zeroPos <= newArity);
        if (zeroPos == newArity) {
            return 0;
        }
        return ~zeroPos;
    }

    private static boolean permuteArgumentChecks(int[] reorder, MethodType newType, MethodType oldType) {
        if (newType.returnType() != oldType.returnType()) {
            throw MethodHandleStatics.newIllegalArgumentException("return types do not match", oldType, newType);
        }
        if (reorder.length == oldType.parameterCount()) {
            int limit = newType.parameterCount();
            boolean bad = false;
            for (int j = 0; j < reorder.length; ++j) {
                Class<?> dst;
                int i = reorder[j];
                if (i < 0 || i >= limit) {
                    bad = true;
                    break;
                }
                Class<?> src = newType.parameterType(i);
                if (src == (dst = oldType.parameterType(j))) continue;
                throw MethodHandleStatics.newIllegalArgumentException("parameter types do not match after reorder", oldType, newType);
            }
            if (!bad) {
                return true;
            }
        }
        throw MethodHandleStatics.newIllegalArgumentException("bad reorder array: " + Arrays.toString(reorder));
    }

    public static MethodHandle constant(Class<?> type, Object value) {
        if (type.isPrimitive()) {
            if (type == Void.TYPE) {
                throw MethodHandleStatics.newIllegalArgumentException("void type");
            }
            Wrapper w = Wrapper.forPrimitiveType(type);
            value = w.convert(value, type);
            if (w.zero().equals(value)) {
                return MethodHandles.zero(w, type);
            }
            return MethodHandles.insertArguments(MethodHandles.identity(type), 0, value);
        }
        if (value == null) {
            return MethodHandles.zero(Wrapper.OBJECT, type);
        }
        return MethodHandles.identity(type).bindTo(value);
    }

    public static MethodHandle identity(Class<?> type) {
        Wrapper btw = type.isPrimitive() ? Wrapper.forPrimitiveType(type) : Wrapper.OBJECT;
        int pos = btw.ordinal();
        MethodHandle ident = IDENTITY_MHS[pos];
        if (ident == null) {
            ident = MethodHandles.setCachedMethodHandle(IDENTITY_MHS, pos, MethodHandles.makeIdentity(btw.primitiveType()));
        }
        if (ident.type().returnType() == type) {
            return ident;
        }
        assert (btw == Wrapper.OBJECT);
        return MethodHandles.makeIdentity(type);
    }

    public static MethodHandle zero(Class<?> type) {
        Objects.requireNonNull(type);
        return type.isPrimitive() ? MethodHandles.zero(Wrapper.forPrimitiveType(type), type) : MethodHandles.zero(Wrapper.OBJECT, type);
    }

    private static MethodHandle identityOrVoid(Class<?> type) {
        return type == Void.TYPE ? MethodHandles.zero(type) : MethodHandles.identity(type);
    }

    public static MethodHandle empty(MethodType type) {
        Objects.requireNonNull(type);
        return MethodHandles.dropArguments(MethodHandles.zero(type.returnType()), 0, type.parameterList());
    }

    private static MethodHandle makeIdentity(Class<?> ptype) {
        MethodType mtype = MethodType.methodType(ptype, ptype);
        LambdaForm lform = LambdaForm.identityForm(LambdaForm.BasicType.basicType(ptype));
        return MethodHandleImpl.makeIntrinsic(mtype, lform, MethodHandleImpl.Intrinsic.IDENTITY);
    }

    private static MethodHandle zero(Wrapper btw, Class<?> rtype) {
        int pos = btw.ordinal();
        MethodHandle zero = ZERO_MHS[pos];
        if (zero == null) {
            zero = MethodHandles.setCachedMethodHandle(ZERO_MHS, pos, MethodHandles.makeZero(btw.primitiveType()));
        }
        if (zero.type().returnType() == rtype) {
            return zero;
        }
        assert (btw == Wrapper.OBJECT);
        return MethodHandles.makeZero(rtype);
    }

    private static MethodHandle makeZero(Class<?> rtype) {
        MethodType mtype = MethodType.methodType(rtype);
        LambdaForm lform = LambdaForm.zeroForm(LambdaForm.BasicType.basicType(rtype));
        return MethodHandleImpl.makeIntrinsic(mtype, lform, MethodHandleImpl.Intrinsic.ZERO);
    }

    private static synchronized MethodHandle setCachedMethodHandle(MethodHandle[] cache, int pos, MethodHandle value) {
        MethodHandle prev = cache[pos];
        if (prev != null) {
            return prev;
        }
        cache[pos] = value;
        return cache[pos];
    }

    public static MethodHandle insertArguments(MethodHandle target, int pos, Object ... values) {
        int insCount = values.length;
        Class<?>[] ptypes = MethodHandles.insertArgumentsChecks(target, insCount, pos);
        if (insCount == 0) {
            return target;
        }
        BoundMethodHandle result = target.rebind();
        for (int i = 0; i < insCount; ++i) {
            Object value = values[i];
            Class<?> ptype = ptypes[pos + i];
            if (ptype.isPrimitive()) {
                result = MethodHandles.insertArgumentPrimitive(result, pos, ptype, value);
                continue;
            }
            value = ptype.cast(value);
            result = result.bindArgumentL(pos, value);
        }
        return result;
    }

    private static BoundMethodHandle insertArgumentPrimitive(BoundMethodHandle result, int pos, Class<?> ptype, Object value) {
        Wrapper w = Wrapper.forPrimitiveType(ptype);
        value = w.convert(value, ptype);
        switch (w) {
            case INT: {
                return result.bindArgumentI(pos, (Integer)value);
            }
            case LONG: {
                return result.bindArgumentJ(pos, (Long)value);
            }
            case FLOAT: {
                return result.bindArgumentF(pos, ((Float)value).floatValue());
            }
            case DOUBLE: {
                return result.bindArgumentD(pos, (Double)value);
            }
        }
        return result.bindArgumentI(pos, ValueConversions.widenSubword(value));
    }

    private static Class<?>[] insertArgumentsChecks(MethodHandle target, int insCount, int pos) throws RuntimeException {
        MethodType oldType = target.type();
        int outargs = oldType.parameterCount();
        int inargs = outargs - insCount;
        if (inargs < 0) {
            throw MethodHandleStatics.newIllegalArgumentException("too many values to insert");
        }
        if (pos < 0 || pos > inargs) {
            throw MethodHandleStatics.newIllegalArgumentException("no argument type to append");
        }
        return oldType.ptypes();
    }

    public static MethodHandle dropArguments(MethodHandle target, int pos, List<Class<?>> valueTypes) {
        return MethodHandles.dropArguments0(target, pos, MethodHandles.copyTypes(valueTypes.toArray()));
    }

    private static List<Class<?>> copyTypes(Object[] array) {
        return Arrays.asList((Class[])Arrays.copyOf(array, array.length, Class[].class));
    }

    private static MethodHandle dropArguments0(MethodHandle target, int pos, List<Class<?>> valueTypes) {
        MethodType oldType = target.type();
        int dropped = MethodHandles.dropArgumentChecks(oldType, pos, valueTypes);
        MethodType newType = oldType.insertParameterTypes(pos, valueTypes);
        if (dropped == 0) {
            return target;
        }
        BoundMethodHandle result = target.rebind();
        LambdaForm lform = result.form;
        int insertFormArg = 1 + pos;
        for (Class<?> ptype : valueTypes) {
            lform = lform.editor().addArgumentForm(insertFormArg++, LambdaForm.BasicType.basicType(ptype));
        }
        result = result.copyWith(newType, lform);
        return result;
    }

    private static int dropArgumentChecks(MethodType oldType, int pos, List<Class<?>> valueTypes) {
        int dropped = valueTypes.size();
        MethodType.checkSlotCount(dropped);
        int outargs = oldType.parameterCount();
        int inargs = outargs + dropped;
        if (pos < 0 || pos > outargs) {
            throw MethodHandleStatics.newIllegalArgumentException("no argument type to remove" + Arrays.asList(oldType, pos, valueTypes, inargs, outargs));
        }
        return dropped;
    }

    public static MethodHandle dropArguments(MethodHandle target, int pos, Class<?> ... valueTypes) {
        return MethodHandles.dropArguments0(target, pos, MethodHandles.copyTypes(valueTypes));
    }

    private static MethodHandle dropArgumentsToMatch(MethodHandle target, int skip, List<Class<?>> newTypes, int pos, boolean nullOnFailure) {
        newTypes = MethodHandles.copyTypes(newTypes.toArray());
        List<Class<?>> oldTypes = target.type().parameterList();
        int match = oldTypes.size();
        if (skip != 0) {
            if (skip < 0 || skip > match) {
                throw MethodHandleStatics.newIllegalArgumentException("illegal skip", skip, target);
            }
            oldTypes = oldTypes.subList(skip, match);
            match -= skip;
        }
        List<Class<?>> addTypes = newTypes;
        int add = addTypes.size();
        if (pos != 0) {
            if (pos < 0 || pos > add) {
                throw MethodHandleStatics.newIllegalArgumentException("illegal pos", pos, newTypes);
            }
            addTypes = addTypes.subList(pos, add);
            assert (addTypes.size() == (add -= pos));
        }
        if (match > add || !oldTypes.equals(addTypes.subList(0, match))) {
            if (nullOnFailure) {
                return null;
            }
            throw MethodHandleStatics.newIllegalArgumentException("argument lists do not match", oldTypes, newTypes);
        }
        addTypes = addTypes.subList(match, add);
        assert (addTypes.size() == (add -= match));
        MethodHandle adapter = target;
        if (add > 0) {
            adapter = MethodHandles.dropArguments0(adapter, skip + match, addTypes);
        }
        if (pos > 0) {
            adapter = MethodHandles.dropArguments0(adapter, skip, newTypes.subList(0, pos));
        }
        return adapter;
    }

    public static MethodHandle dropArgumentsToMatch(MethodHandle target, int skip, List<Class<?>> newTypes, int pos) {
        Objects.requireNonNull(target);
        Objects.requireNonNull(newTypes);
        return MethodHandles.dropArgumentsToMatch(target, skip, newTypes, pos, false);
    }

    public static MethodHandle filterArguments(MethodHandle target, int pos, MethodHandle ... filters) {
        MethodHandles.filterArgumentsCheckArity(target, pos, filters);
        MethodHandle adapter = target;
        int curPos = pos - 1;
        for (MethodHandle filter : filters) {
            ++curPos;
            if (filter == null) continue;
            adapter = MethodHandles.filterArgument(adapter, curPos, filter);
        }
        return adapter;
    }

    static MethodHandle filterArgument(MethodHandle target, int pos, MethodHandle filter) {
        MethodHandles.filterArgumentChecks(target, pos, filter);
        MethodType targetType = target.type();
        MethodType filterType = filter.type();
        BoundMethodHandle result = target.rebind();
        Class<?> newParamType = filterType.parameterType(0);
        LambdaForm lform = result.editor().filterArgumentForm(1 + pos, LambdaForm.BasicType.basicType(newParamType));
        MethodType newType = targetType.changeParameterType(pos, newParamType);
        result = result.copyWithExtendL(newType, lform, filter);
        return result;
    }

    private static void filterArgumentsCheckArity(MethodHandle target, int pos, MethodHandle[] filters) {
        MethodType targetType = target.type();
        int maxPos = targetType.parameterCount();
        if (pos + filters.length > maxPos) {
            throw MethodHandleStatics.newIllegalArgumentException("too many filters");
        }
    }

    private static void filterArgumentChecks(MethodHandle target, int pos, MethodHandle filter) throws RuntimeException {
        MethodType targetType = target.type();
        MethodType filterType = filter.type();
        if (filterType.parameterCount() != 1 || filterType.returnType() != targetType.parameterType(pos)) {
            throw MethodHandleStatics.newIllegalArgumentException("target and filter types do not match", targetType, filterType);
        }
    }

    public static MethodHandle collectArguments(MethodHandle target, int pos, MethodHandle filter) {
        LambdaForm lform;
        MethodType newType = MethodHandles.collectArgumentsChecks(target, pos, filter);
        MethodType collectorType = filter.type();
        BoundMethodHandle result = target.rebind();
        if (collectorType.returnType().isArray() && filter.intrinsicName() == MethodHandleImpl.Intrinsic.NEW_ARRAY && (lform = result.editor().collectArgumentArrayForm(1 + pos, filter)) != null) {
            return result.copyWith(newType, lform);
        }
        lform = result.editor().collectArgumentsForm(1 + pos, collectorType.basicType());
        return result.copyWithExtendL(newType, lform, filter);
    }

    private static MethodType collectArgumentsChecks(MethodHandle target, int pos, MethodHandle filter) throws RuntimeException {
        MethodType targetType = target.type();
        MethodType filterType = filter.type();
        Class<?> rtype = filterType.returnType();
        List<Class<?>> filterArgs = filterType.parameterList();
        if (rtype == Void.TYPE) {
            return targetType.insertParameterTypes(pos, filterArgs);
        }
        if (rtype != targetType.parameterType(pos)) {
            throw MethodHandleStatics.newIllegalArgumentException("target and filter types do not match", targetType, filterType);
        }
        return targetType.dropParameterTypes(pos, pos + 1).insertParameterTypes(pos, filterArgs);
    }

    public static MethodHandle filterReturnValue(MethodHandle target, MethodHandle filter) {
        MethodType targetType = target.type();
        MethodType filterType = filter.type();
        MethodHandles.filterReturnValueChecks(targetType, filterType);
        BoundMethodHandle result = target.rebind();
        LambdaForm.BasicType rtype = LambdaForm.BasicType.basicType(filterType.returnType());
        LambdaForm lform = result.editor().filterReturnForm(rtype, false);
        MethodType newType = targetType.changeReturnType(filterType.returnType());
        result = result.copyWithExtendL(newType, lform, filter);
        return result;
    }

    private static void filterReturnValueChecks(MethodType targetType, MethodType filterType) throws RuntimeException {
        Class<?> rtype = targetType.returnType();
        int filterValues = filterType.parameterCount();
        if (filterValues == 0 ? rtype != Void.TYPE : rtype != filterType.parameterType(0) || filterValues != 1) {
            throw MethodHandleStatics.newIllegalArgumentException("target and filter types do not match", targetType, filterType);
        }
    }

    public static MethodHandle foldArguments(MethodHandle target, MethodHandle combiner) {
        return MethodHandles.foldArguments(target, 0, combiner);
    }

    public static MethodHandle foldArguments(MethodHandle target, int pos, MethodHandle combiner) {
        MethodType targetType = target.type();
        MethodType combinerType = combiner.type();
        Class<?> rtype = MethodHandles.foldArgumentChecks(pos, targetType, combinerType);
        BoundMethodHandle result = target.rebind();
        boolean dropResult = rtype == Void.TYPE;
        LambdaForm lform = result.editor().foldArgumentsForm(1 + pos, dropResult, combinerType.basicType());
        MethodType newType = targetType;
        if (!dropResult) {
            newType = newType.dropParameterTypes(pos, pos + 1);
        }
        result = result.copyWithExtendL(newType, lform, combiner);
        return result;
    }

    static MethodHandle foldArguments(MethodHandle target, int pos, MethodHandle combiner, int ... argPositions) {
        MethodType targetType = target.type();
        MethodType combinerType = combiner.type();
        Class<?> rtype = MethodHandles.foldArgumentChecks(pos, targetType, combinerType, argPositions);
        BoundMethodHandle result = target.rebind();
        boolean dropResult = rtype == Void.TYPE;
        LambdaForm lform = result.editor().foldArgumentsForm(1 + pos, dropResult, combinerType.basicType(), argPositions);
        MethodType newType = targetType;
        if (!dropResult) {
            newType = newType.dropParameterTypes(pos, pos + 1);
        }
        result = result.copyWithExtendL(newType, lform, combiner);
        return result;
    }

    private static Class<?> foldArgumentChecks(int foldPos, MethodType targetType, MethodType combinerType) {
        boolean ok;
        int foldArgs = combinerType.parameterCount();
        Class<?> rtype = combinerType.returnType();
        int foldVals = rtype == Void.TYPE ? 0 : 1;
        int afterInsertPos = foldPos + foldVals;
        boolean bl = ok = targetType.parameterCount() >= afterInsertPos + foldArgs;
        if (ok) {
            for (int i = 0; i < foldArgs; ++i) {
                if (combinerType.parameterType(i) == targetType.parameterType(i + afterInsertPos)) continue;
                ok = false;
                break;
            }
        }
        if (ok && foldVals != 0 && combinerType.returnType() != targetType.parameterType(foldPos)) {
            ok = false;
        }
        if (!ok) {
            throw MethodHandles.misMatchedTypes("target and combiner types", targetType, combinerType);
        }
        return rtype;
    }

    private static Class<?> foldArgumentChecks(int foldPos, MethodType targetType, MethodType combinerType, int ... argPos) {
        int foldArgs = combinerType.parameterCount();
        if (argPos.length != foldArgs) {
            throw MethodHandleStatics.newIllegalArgumentException("combiner and argument map must be equal size", combinerType, argPos.length);
        }
        Class<?> rtype = combinerType.returnType();
        boolean foldVals = rtype != Void.TYPE;
        boolean ok = true;
        for (int i = 0; i < foldArgs; ++i) {
            int arg = argPos[i];
            if (arg < 0 || arg > targetType.parameterCount()) {
                throw MethodHandleStatics.newIllegalArgumentException("arg outside of target parameterRange", targetType, arg);
            }
            if (combinerType.parameterType(i) == targetType.parameterType(arg)) continue;
            throw MethodHandleStatics.newIllegalArgumentException("target argument type at position " + arg + " must match combiner argument type at index " + i + ": " + targetType + " -> " + combinerType + ", map: " + Arrays.toString(argPos));
        }
        if (ok && foldVals && combinerType.returnType() != targetType.parameterType(foldPos)) {
            ok = false;
        }
        if (!ok) {
            throw MethodHandles.misMatchedTypes("target and combiner types", targetType, combinerType);
        }
        return rtype;
    }

    public static MethodHandle guardWithTest(MethodHandle test, MethodHandle target, MethodHandle fallback) {
        MethodType ftype;
        MethodType gtype = test.type();
        MethodType ttype = target.type();
        if (!ttype.equals((Object)(ftype = fallback.type()))) {
            throw MethodHandles.misMatchedTypes("target and fallback types", ttype, ftype);
        }
        if (gtype.returnType() != Boolean.TYPE) {
            throw MethodHandleStatics.newIllegalArgumentException("guard type is not a predicate " + gtype);
        }
        List<Class<?>> targs = ttype.parameterList();
        if ((test = MethodHandles.dropArgumentsToMatch(test, 0, targs, 0, true)) == null) {
            throw MethodHandles.misMatchedTypes("target and test types", ttype, gtype);
        }
        return MethodHandleImpl.makeGuardWithTest(test, target, fallback);
    }

    static <T> RuntimeException misMatchedTypes(String what, T t1, T t2) {
        return MethodHandleStatics.newIllegalArgumentException(what + " must match: " + t1 + " != " + t2);
    }

    public static MethodHandle catchException(MethodHandle target, Class<? extends Throwable> exType, MethodHandle handler) {
        MethodType ttype = target.type();
        MethodType htype = handler.type();
        if (!Throwable.class.isAssignableFrom(exType)) {
            throw new ClassCastException(exType.getName());
        }
        if (htype.parameterCount() < 1 || !htype.parameterType(0).isAssignableFrom(exType)) {
            throw MethodHandleStatics.newIllegalArgumentException("handler does not accept exception type " + exType);
        }
        if (htype.returnType() != ttype.returnType()) {
            throw MethodHandles.misMatchedTypes("target and handler return types", ttype, htype);
        }
        if ((handler = MethodHandles.dropArgumentsToMatch(handler, 1, ttype.parameterList(), 0, true)) == null) {
            throw MethodHandles.misMatchedTypes("target and handler types", ttype, htype);
        }
        return MethodHandleImpl.makeGuardWithCatch(target, exType, handler);
    }

    public static MethodHandle throwException(Class<?> returnType, Class<? extends Throwable> exType) {
        if (!Throwable.class.isAssignableFrom(exType)) {
            throw new ClassCastException(exType.getName());
        }
        return MethodHandleImpl.throwException(MethodType.methodType(returnType, exType));
    }

    public static MethodHandle loop(MethodHandle[] ... clauses) {
        MethodHandles.loopChecks0(clauses);
        ArrayList<MethodHandle> init = new ArrayList<MethodHandle>();
        ArrayList<MethodHandle> step = new ArrayList<MethodHandle>();
        ArrayList<MethodHandle> pred = new ArrayList<MethodHandle>();
        ArrayList<MethodHandle> fini = new ArrayList<MethodHandle>();
        Stream.of(clauses).filter(c -> Stream.of(c).anyMatch(Objects::nonNull)).forEach(clause -> {
            init.add(clause[0]);
            step.add(((MethodHandle[])clause).length <= 1 ? null : clause[1]);
            pred.add(((MethodHandle[])clause).length <= 2 ? null : clause[2]);
            fini.add(((MethodHandle[])clause).length <= 3 ? null : clause[3]);
        });
        assert (Stream.of(init, step, pred, fini).map(List::size).distinct().count() == 1L);
        int nclauses = init.size();
        ArrayList iterationVariableTypes = new ArrayList();
        for (int i = 0; i < nclauses; ++i) {
            MethodHandle in = (MethodHandle)init.get(i);
            MethodHandle st = (MethodHandle)step.get(i);
            if (in == null && st == null) {
                iterationVariableTypes.add(Void.TYPE);
                continue;
            }
            if (in != null && st != null) {
                MethodHandles.loopChecks1a(i, in, st);
                iterationVariableTypes.add(in.type().returnType());
                continue;
            }
            iterationVariableTypes.add(in == null ? st.type().returnType() : in.type().returnType());
        }
        List commonPrefix = iterationVariableTypes.stream().filter(t -> t != Void.TYPE).collect(Collectors.toList());
        List<Class<?>> commonSuffix = MethodHandles.buildCommonSuffix(init, step, pred, fini, commonPrefix.size());
        MethodHandles.loopChecks1b(init, commonSuffix);
        Class<Void> loopReturnType = fini.stream().filter(Objects::nonNull).map(MethodHandle::type).map(MethodType::returnType).findFirst().orElse(Void.TYPE);
        MethodHandles.loopChecks1cd(pred, fini, loopReturnType);
        ArrayList commonParameterSequence = new ArrayList(commonPrefix);
        commonParameterSequence.addAll(commonSuffix);
        MethodHandles.loopChecks2(step, pred, fini, commonParameterSequence);
        for (int i = 0; i < nclauses; ++i) {
            Class t2 = (Class)iterationVariableTypes.get(i);
            if (init.get(i) == null) {
                init.set(i, MethodHandles.empty(MethodType.methodType(t2, commonSuffix)));
            }
            if (step.get(i) == null) {
                step.set(i, MethodHandles.dropArgumentsToMatch(MethodHandles.identityOrVoid(t2), 0, commonParameterSequence, i));
            }
            if (pred.get(i) == null) {
                pred.set(i, MethodHandles.dropArguments0(MethodHandles.constant(Boolean.TYPE, true), 0, commonParameterSequence));
            }
            if (fini.get(i) != null) continue;
            fini.set(i, MethodHandles.empty(MethodType.methodType(t2, commonParameterSequence)));
        }
        List<MethodHandle> finit = MethodHandles.fixArities(MethodHandles.fillParameterTypes(init, commonSuffix));
        List<MethodHandle> fstep = MethodHandles.fixArities(MethodHandles.fillParameterTypes(step, commonParameterSequence));
        List<MethodHandle> fpred = MethodHandles.fixArities(MethodHandles.fillParameterTypes(pred, commonParameterSequence));
        List<MethodHandle> ffini = MethodHandles.fixArities(MethodHandles.fillParameterTypes(fini, commonParameterSequence));
        assert (finit.stream().map(MethodHandle::type).map(MethodType::parameterList).allMatch(pl -> pl.equals(commonSuffix)));
        assert (Stream.of(fstep, fpred, ffini).flatMap(Collection::stream).map(MethodHandle::type).map(MethodType::parameterList).allMatch(pl -> pl.equals(commonParameterSequence)));
        return MethodHandleImpl.makeLoop(loopReturnType, commonSuffix, finit, fstep, fpred, ffini);
    }

    private static void loopChecks0(MethodHandle[][] clauses) {
        if (clauses == null || clauses.length == 0) {
            throw MethodHandleStatics.newIllegalArgumentException("null or no clauses passed");
        }
        if (Stream.of(clauses).anyMatch(Objects::isNull)) {
            throw MethodHandleStatics.newIllegalArgumentException("null clauses are not allowed");
        }
        if (Stream.of(clauses).anyMatch(c -> ((MethodHandle[])c).length > 4)) {
            throw MethodHandleStatics.newIllegalArgumentException("All loop clauses must be represented as MethodHandle arrays with at most 4 elements.");
        }
    }

    private static void loopChecks1a(int i, MethodHandle in, MethodHandle st) {
        if (in.type().returnType() != st.type().returnType()) {
            throw MethodHandles.misMatchedTypes("clause " + i + ": init and step return types", in.type().returnType(), st.type().returnType());
        }
    }

    private static List<Class<?>> longestParameterList(Stream<MethodHandle> mhs, int skipSize) {
        List<Class<?>> empty = List.of();
        List longest = mhs.filter(Objects::nonNull).map(MethodHandle::type).filter(t -> t.parameterCount() > skipSize).map(MethodType::parameterList).reduce((p, q) -> p.size() >= q.size() ? p : q).orElse(empty);
        return longest.size() == 0 ? empty : longest.subList(skipSize, longest.size());
    }

    private static List<Class<?>> longestParameterList(List<List<Class<?>>> lists) {
        List empty = List.of();
        return lists.stream().reduce((p, q) -> p.size() >= q.size() ? p : q).orElse(empty);
    }

    private static List<Class<?>> buildCommonSuffix(List<MethodHandle> init, List<MethodHandle> step, List<MethodHandle> pred, List<MethodHandle> fini, int cpSize) {
        List<Class<?>> longest1 = MethodHandles.longestParameterList(Stream.of(step, pred, fini).flatMap(Collection::stream), cpSize);
        List<Class<?>> longest2 = MethodHandles.longestParameterList(init.stream(), 0);
        return MethodHandles.longestParameterList(Arrays.asList(longest1, longest2));
    }

    private static void loopChecks1b(List<MethodHandle> init, List<Class<?>> commonSuffix) {
        if (init.stream().filter(Objects::nonNull).map(MethodHandle::type).anyMatch(t -> !t.effectivelyIdenticalParameters(0, commonSuffix))) {
            throw MethodHandleStatics.newIllegalArgumentException("found non-effectively identical init parameter type lists: " + init + " (common suffix: " + commonSuffix + ")");
        }
    }

    private static void loopChecks1cd(List<MethodHandle> pred, List<MethodHandle> fini, Class<?> loopReturnType) {
        if (fini.stream().filter(Objects::nonNull).map(MethodHandle::type).map(MethodType::returnType).anyMatch(t -> t != loopReturnType)) {
            throw MethodHandleStatics.newIllegalArgumentException("found non-identical finalizer return types: " + fini + " (return type: " + loopReturnType + ")");
        }
        if (!pred.stream().filter(Objects::nonNull).findFirst().isPresent()) {
            throw MethodHandleStatics.newIllegalArgumentException("no predicate found", pred);
        }
        if (pred.stream().filter(Objects::nonNull).map(MethodHandle::type).map(MethodType::returnType).anyMatch(t -> t != Boolean.TYPE)) {
            throw MethodHandleStatics.newIllegalArgumentException("predicates must have boolean return type", pred);
        }
    }

    private static void loopChecks2(List<MethodHandle> step, List<MethodHandle> pred, List<MethodHandle> fini, List<Class<?>> commonParameterSequence) {
        if (Stream.of(step, pred, fini).flatMap(Collection::stream).filter(Objects::nonNull).map(MethodHandle::type).anyMatch(t -> !t.effectivelyIdenticalParameters(0, commonParameterSequence))) {
            throw MethodHandleStatics.newIllegalArgumentException("found non-effectively identical parameter type lists:\nstep: " + step + "\npred: " + pred + "\nfini: " + fini + " (common parameter sequence: " + commonParameterSequence + ")");
        }
    }

    private static List<MethodHandle> fillParameterTypes(List<MethodHandle> hs, List<Class<?>> targetParams) {
        return hs.stream().map(h -> {
            int tpsize;
            int pc = h.type().parameterCount();
            return pc < (tpsize = targetParams.size()) ? MethodHandles.dropArguments0(h, pc, targetParams.subList(pc, tpsize)) : h;
        }).collect(Collectors.toList());
    }

    private static List<MethodHandle> fixArities(List<MethodHandle> hs) {
        return hs.stream().map(MethodHandle::asFixedArity).collect(Collectors.toList());
    }

    public static MethodHandle whileLoop(MethodHandle init, MethodHandle pred, MethodHandle body) {
        MethodHandles.whileLoopChecks(init, pred, body);
        MethodHandle fini = MethodHandles.identityOrVoid(body.type().returnType());
        MethodHandle[] checkExit = new MethodHandle[]{null, null, pred, fini};
        MethodHandle[] varBody = new MethodHandle[]{init, body};
        return MethodHandles.loop(checkExit, varBody);
    }

    public static MethodHandle doWhileLoop(MethodHandle init, MethodHandle body, MethodHandle pred) {
        MethodHandles.whileLoopChecks(init, pred, body);
        MethodHandle fini = MethodHandles.identityOrVoid(body.type().returnType());
        MethodHandle[] clause = new MethodHandle[]{init, body, pred, fini};
        return MethodHandles.loop(new MethodHandle[][]{clause});
    }

    private static void whileLoopChecks(MethodHandle init, MethodHandle pred, MethodHandle body) {
        MethodType initType;
        MethodType predType;
        List<Class<?>> innerList;
        Objects.requireNonNull(pred);
        Objects.requireNonNull(body);
        MethodType bodyType = body.type();
        Class<?> returnType = bodyType.returnType();
        List<Class<?>> outerList = innerList = bodyType.parameterList();
        if (returnType != Void.TYPE) {
            if (innerList.size() == 0 || innerList.get(0) != returnType) {
                MethodType expected = bodyType.insertParameterTypes(0, returnType);
                throw MethodHandles.misMatchedTypes("body function", bodyType, expected);
            }
            outerList = innerList.subList(1, innerList.size());
        }
        if ((predType = pred.type()).returnType() != Boolean.TYPE || !predType.effectivelyIdenticalParameters(0, innerList)) {
            throw MethodHandles.misMatchedTypes("loop predicate", predType, MethodType.methodType(Boolean.TYPE, innerList));
        }
        if (!(init == null || (initType = init.type()).returnType() == returnType && initType.effectivelyIdenticalParameters(0, outerList))) {
            throw MethodHandles.misMatchedTypes("loop initializer", initType, MethodType.methodType(returnType, outerList));
        }
    }

    public static MethodHandle countedLoop(MethodHandle iterations, MethodHandle init, MethodHandle body) {
        return MethodHandles.countedLoop(MethodHandles.empty(iterations.type()), iterations, init, body);
    }

    public static MethodHandle countedLoop(MethodHandle start, MethodHandle end, MethodHandle init, MethodHandle body) {
        MethodHandles.countedLoopChecks(start, end, init, body);
        Class<?> counterType = start.type().returnType();
        Class<?> limitType = end.type().returnType();
        Class<?> returnType = body.type().returnType();
        MethodHandle incr = MethodHandleImpl.getConstantHandle(7);
        MethodHandle pred = MethodHandleImpl.getConstantHandle(6);
        MethodHandle retv = null;
        if (returnType != Void.TYPE) {
            incr = MethodHandles.dropArguments(incr, 1, returnType);
            pred = MethodHandles.dropArguments(pred, 1, returnType);
            retv = MethodHandles.dropArguments(MethodHandles.identity(returnType), 0, counterType);
        }
        body = MethodHandles.dropArguments(body, 0, counterType);
        MethodHandle[] loopLimit = new MethodHandle[]{end, null, pred, retv};
        MethodHandle[] bodyClause = new MethodHandle[]{init, body};
        MethodHandle[] indexVar = new MethodHandle[]{start, incr};
        return MethodHandles.loop(loopLimit, bodyClause, indexVar);
    }

    private static void countedLoopChecks(MethodHandle start, MethodHandle end, MethodHandle init, MethodHandle body) {
        MethodType initType;
        int vsize;
        Objects.requireNonNull(start);
        Objects.requireNonNull(end);
        Objects.requireNonNull(body);
        Class<?> counterType = start.type().returnType();
        if (counterType != Integer.TYPE) {
            MethodType expected = start.type().changeReturnType(Integer.TYPE);
            throw MethodHandles.misMatchedTypes("start function", start.type(), expected);
        }
        if (end.type().returnType() != counterType) {
            MethodType expected = end.type().changeReturnType(counterType);
            throw MethodHandles.misMatchedTypes("end function", end.type(), expected);
        }
        MethodType bodyType = body.type();
        Class<?> returnType = bodyType.returnType();
        List<Class<?>> innerList = bodyType.parameterList();
        int n = vsize = returnType == Void.TYPE ? 0 : 1;
        if (vsize != 0 && (innerList.size() == 0 || innerList.get(0) != returnType)) {
            MethodType expected = bodyType.insertParameterTypes(0, returnType);
            throw MethodHandles.misMatchedTypes("body function", bodyType, expected);
        }
        if (innerList.size() <= vsize || innerList.get(vsize) != counterType) {
            MethodType expected = bodyType.insertParameterTypes(vsize, counterType);
            throw MethodHandles.misMatchedTypes("body function", bodyType, expected);
        }
        List<Class<?>> outerList = innerList.subList(vsize + 1, innerList.size());
        if (outerList.isEmpty()) {
            outerList = end.type().parameterList();
            innerList = bodyType.insertParameterTypes(vsize + 1, outerList).parameterList();
        }
        MethodType expected = MethodType.methodType(counterType, outerList);
        if (!start.type().effectivelyIdenticalParameters(0, outerList)) {
            throw MethodHandles.misMatchedTypes("start parameter types", start.type(), expected);
        }
        if (end.type() != start.type() && !end.type().effectivelyIdenticalParameters(0, outerList)) {
            throw MethodHandles.misMatchedTypes("end parameter types", end.type(), expected);
        }
        if (!(init == null || (initType = init.type()).returnType() == returnType && initType.effectivelyIdenticalParameters(0, outerList))) {
            throw MethodHandles.misMatchedTypes("loop initializer", initType, MethodType.methodType(returnType, outerList));
        }
    }

    public static MethodHandle iteratedLoop(MethodHandle iterator, MethodHandle init, MethodHandle body) {
        MethodHandle nextVal;
        MethodType iteratorType;
        MethodHandle startIter;
        Class<?> iterableType = MethodHandles.iteratedLoopChecks(iterator, init, body);
        Class<?> returnType = body.type().returnType();
        MethodHandle hasNext = MethodHandleImpl.getConstantHandle(9);
        MethodHandle nextRaw = MethodHandleImpl.getConstantHandle(10);
        if (iterator == null) {
            startIter = MethodHandleImpl.getConstantHandle(8);
            iteratorType = startIter.type().changeParameterType(0, iterableType);
        } else {
            iteratorType = iterator.type().changeReturnType(Iterator.class);
            startIter = iterator;
        }
        Class<?> ttype = body.type().parameterType(returnType == Void.TYPE ? 0 : 1);
        MethodType nextValType = nextRaw.type().changeReturnType(ttype);
        try {
            startIter = startIter.asType(iteratorType);
            nextVal = nextRaw.asType(nextValType);
        }
        catch (WrongMethodTypeException ex) {
            throw new IllegalArgumentException(ex);
        }
        MethodHandle retv = null;
        MethodHandle step = body;
        if (returnType != Void.TYPE) {
            retv = MethodHandles.dropArguments(MethodHandles.identity(returnType), 0, Iterator.class);
            step = MethodHandles.swapArguments(body, 0, 1);
        }
        MethodHandle[] iterVar = new MethodHandle[]{startIter, null, hasNext, retv};
        MethodHandle[] bodyClause = new MethodHandle[]{init, MethodHandles.filterArgument(step, 0, nextVal)};
        return MethodHandles.loop(iterVar, bodyClause);
    }

    private static Class<?> iteratedLoopChecks(MethodHandle iterator, MethodHandle init, MethodHandle body) {
        MethodType initType;
        int vsize;
        Objects.requireNonNull(body);
        MethodType bodyType = body.type();
        Class<?> returnType = bodyType.returnType();
        List<Class<?>> internalParamList = bodyType.parameterList();
        int n = vsize = returnType == Void.TYPE ? 0 : 1;
        if (vsize != 0 && (internalParamList.size() == 0 || internalParamList.get(0) != returnType)) {
            MethodType expected = bodyType.insertParameterTypes(0, returnType);
            throw MethodHandles.misMatchedTypes("body function", bodyType, expected);
        }
        if (internalParamList.size() <= vsize) {
            MethodType expected = bodyType.insertParameterTypes(vsize, Object.class);
            throw MethodHandles.misMatchedTypes("body function", bodyType, expected);
        }
        List<Class<?>> externalParamList = internalParamList.subList(vsize + 1, internalParamList.size());
        Class<Object> iterableType = null;
        if (iterator != null) {
            MethodType itype;
            if (externalParamList.isEmpty()) {
                externalParamList = iterator.type().parameterList();
            }
            if (!Iterator.class.isAssignableFrom((itype = iterator.type()).returnType())) {
                throw MethodHandleStatics.newIllegalArgumentException("iteratedLoop first argument must have Iterator return type");
            }
            if (!itype.effectivelyIdenticalParameters(0, externalParamList)) {
                MethodType expected = MethodType.methodType(itype.returnType(), externalParamList);
                throw MethodHandles.misMatchedTypes("iterator parameters", itype, expected);
            }
        } else if (externalParamList.isEmpty()) {
            externalParamList = Arrays.asList(Iterable.class);
            iterableType = Iterable.class;
        } else {
            iterableType = externalParamList.get(0);
            if (!Iterable.class.isAssignableFrom(iterableType)) {
                throw MethodHandleStatics.newIllegalArgumentException("inferred first loop argument must inherit from Iterable: " + iterableType);
            }
        }
        if (!(init == null || (initType = init.type()).returnType() == returnType && initType.effectivelyIdenticalParameters(0, externalParamList))) {
            throw MethodHandles.misMatchedTypes("loop initializer", initType, MethodType.methodType(returnType, externalParamList));
        }
        return iterableType;
    }

    static MethodHandle swapArguments(MethodHandle mh, int i, int j) {
        int arity = mh.type().parameterCount();
        int[] order = new int[arity];
        for (int k = 0; k < arity; ++k) {
            order[k] = k;
        }
        order[i] = j;
        order[j] = i;
        Class<?>[] types = mh.type().parameterArray();
        Class<?> ti = types[i];
        types[i] = types[j];
        types[j] = ti;
        MethodType swapType = MethodType.methodType(mh.type().returnType(), types);
        return MethodHandles.permuteArguments(mh, swapType, order);
    }

    public static MethodHandle tryFinally(MethodHandle target, MethodHandle cleanup) {
        List<Class<?>> targetParamTypes = target.type().parameterList();
        List<Class<?>> cleanupParamTypes = cleanup.type().parameterList();
        Class<?> rtype = target.type().returnType();
        MethodHandles.tryFinallyChecks(target, cleanup);
        cleanup = MethodHandles.dropArgumentsToMatch(cleanup, rtype == Void.TYPE ? 1 : 2, targetParamTypes, 0);
        return MethodHandleImpl.makeTryFinally(target.asFixedArity(), cleanup.asFixedArity(), rtype, targetParamTypes);
    }

    private static void tryFinallyChecks(MethodHandle target, MethodHandle cleanup) {
        int cleanupArgIndex;
        Class<?> rtype = target.type().returnType();
        if (rtype != cleanup.type().returnType()) {
            throw MethodHandles.misMatchedTypes("target and return types", cleanup.type().returnType(), rtype);
        }
        MethodType cleanupType = cleanup.type();
        if (!Throwable.class.isAssignableFrom(cleanupType.parameterType(0))) {
            throw MethodHandles.misMatchedTypes("cleanup first argument and Throwable", cleanup.type(), Throwable.class);
        }
        if (rtype != Void.TYPE && cleanupType.parameterType(1) != rtype) {
            throw MethodHandles.misMatchedTypes("cleanup second argument and target return type", cleanup.type(), rtype);
        }
        int n = cleanupArgIndex = rtype == Void.TYPE ? 1 : 2;
        if (!cleanupType.effectivelyIdenticalParameters(cleanupArgIndex, target.type().parameterList())) {
            throw MethodHandles.misMatchedTypes("cleanup parameters after (Throwable,result) and target parameter list prefix", cleanup.type(), target.type());
        }
    }

    private static class LookupHelper {
        private static final String UNNAMED = "Unnamed";
        private static final String OBJECT = "java/lang/Object";
        private static final Class<?> PUBLIC_LOOKUP_CLASS = LookupHelper.createClass();
        static final Lookup PUBLIC_LOOKUP = new Lookup(PUBLIC_LOOKUP_CLASS, 1);

        private LookupHelper() {
        }

        private static Class<?> createClass() {
            try {
                ClassWriter cw = new ClassWriter(0);
                cw.visit(52, 48, UNNAMED, null, OBJECT, null);
                cw.visitSource(UNNAMED, null);
                cw.visitEnd();
                final byte[] bytes = cw.toByteArray();
                ClassLoader loader = new ClassLoader(null){

                    @Override
                    protected Class<?> findClass(String cn) throws ClassNotFoundException {
                        if (cn.equals(LookupHelper.UNNAMED)) {
                            return super.defineClass(LookupHelper.UNNAMED, bytes, 0, bytes.length);
                        }
                        throw new ClassNotFoundException(cn);
                    }
                };
                return loader.loadClass(UNNAMED);
            }
            catch (Exception e) {
                throw new InternalError(e);
            }
        }
    }

    public static final class Lookup {
        private final Class<?> lookupClass;
        private final int allowedModes;
        public static final int PUBLIC = 1;
        public static final int PRIVATE = 2;
        public static final int PROTECTED = 4;
        public static final int PACKAGE = 8;
        public static final int MODULE = 16;
        private static final int ALL_MODES = 31;
        private static final int TRUSTED = -1;
        static final Lookup IMPL_LOOKUP;
        private static final boolean ALLOW_NESTMATE_ACCESS = false;
        static ConcurrentHashMap<MemberName, DirectMethodHandle> LOOKASIDE_TABLE;

        private static int fixmods(int mods) {
            return (mods &= 7) != 0 ? mods : 24;
        }

        public Class<?> lookupClass() {
            return this.lookupClass;
        }

        private Class<?> lookupClassOrNull() {
            return this.allowedModes == -1 ? null : this.lookupClass;
        }

        public int lookupModes() {
            return this.allowedModes & 0x1F;
        }

        Lookup(Class<?> lookupClass) {
            this(lookupClass, 31);
            Lookup.checkUnprivilegedlookupClass(lookupClass, 31);
        }

        private Lookup(Class<?> lookupClass, int allowedModes) {
            this.lookupClass = lookupClass;
            this.allowedModes = allowedModes;
        }

        public Lookup in(Class<?> requestedLookupClass) {
            Objects.requireNonNull(requestedLookupClass);
            if (this.allowedModes == -1) {
                return new Lookup(requestedLookupClass, 31);
            }
            if (requestedLookupClass == this.lookupClass) {
                return this;
            }
            int newModes = this.allowedModes & 0x1B;
            if (!VerifyAccess.isSameModule(this.lookupClass, requestedLookupClass)) {
                newModes = this.lookupClass.getModule().isNamed() ? 0 : (newModes &= 0xFFFFFFEF);
            }
            if ((newModes & 8) != 0 && !VerifyAccess.isSamePackage(this.lookupClass, requestedLookupClass)) {
                newModes &= 0xFFFFFFF5;
            }
            if ((newModes & 2) != 0 && !VerifyAccess.isSamePackageMember(this.lookupClass, requestedLookupClass)) {
                newModes &= 0xFFFFFFFD;
            }
            if ((newModes & 1) != 0 && !VerifyAccess.isClassAccessible(requestedLookupClass, this.lookupClass, (int)this.allowedModes)) {
                newModes = 0;
            }
            Lookup.checkUnprivilegedlookupClass(requestedLookupClass, newModes);
            return new Lookup(requestedLookupClass, newModes);
        }

        public Lookup dropLookupMode(int modeToDrop) {
            int oldModes = this.lookupModes();
            int newModes = oldModes & ~(modeToDrop | 4);
            switch (modeToDrop) {
                case 1: {
                    newModes &= 0xFFFFFFE0;
                    break;
                }
                case 16: {
                    newModes &= 0xFFFFFFF5;
                    break;
                }
                case 8: {
                    newModes &= 0xFFFFFFFD;
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(modeToDrop + " is not a valid mode to drop");
                }
            }
            if (newModes == oldModes) {
                return this;
            }
            return new Lookup(this.lookupClass(), newModes);
        }

        private static void checkUnprivilegedlookupClass(Class<?> lookupClass, int allowedModes) {
            String name = lookupClass.getName();
            if (name.startsWith("java.lang.invoke.")) {
                throw MethodHandleStatics.newIllegalArgumentException("illegal lookupClass: " + lookupClass);
            }
            if (allowedModes == 31 && lookupClass.getClassLoader() == null && (name.startsWith("java.") && !name.equals("java.lang.Thread") && !name.startsWith("java.util.concurrent.") || name.startsWith("sun.") && !name.startsWith("sun.invoke."))) {
                throw MethodHandleStatics.newIllegalArgumentException("illegal lookupClass: " + lookupClass);
            }
        }

        public String toString() {
            String cname = this.lookupClass.getName();
            switch (this.allowedModes) {
                case 0: {
                    return cname + "/noaccess";
                }
                case 1: {
                    return cname + "/public";
                }
                case 17: {
                    return cname + "/module";
                }
                case 25: {
                    return cname + "/package";
                }
                case 27: {
                    return cname + "/private";
                }
                case 31: {
                    return cname;
                }
                case -1: {
                    return "/trusted";
                }
            }
            cname = cname + "/" + Integer.toHexString(this.allowedModes);
            assert (false) : cname;
            return cname;
        }

        public MethodHandle findStatic(Class<?> refc, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            MemberName method = this.resolveOrFail((byte)6, refc, name, type);
            return this.getDirectMethod((byte)6, refc, method, this.findBoundCallerClass(method));
        }

        public MethodHandle findVirtual(Class<?> refc, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            MethodHandle mh;
            if (refc == MethodHandle.class ? (mh = this.findVirtualForMH(name, type)) != null : refc == VarHandle.class && (mh = this.findVirtualForVH(name, type)) != null) {
                return mh;
            }
            byte refKind = refc.isInterface() ? (byte)9 : 5;
            MemberName method = this.resolveOrFail(refKind, refc, name, type);
            return this.getDirectMethod(refKind, refc, method, this.findBoundCallerClass(method));
        }

        private MethodHandle findVirtualForMH(String name, MethodType type) {
            if ("invoke".equals(name)) {
                return MethodHandles.invoker(type);
            }
            if ("invokeExact".equals(name)) {
                return MethodHandles.exactInvoker(type);
            }
            assert (!MemberName.isMethodHandleInvokeName(name));
            return null;
        }

        private MethodHandle findVirtualForVH(String name, MethodType type) {
            try {
                return MethodHandles.varHandleInvoker(VarHandle.AccessMode.valueFromMethodName(name), type);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public MethodHandle findConstructor(Class<?> refc, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            if (refc.isArray()) {
                throw new NoSuchMethodException("no constructor for array class: " + refc.getName());
            }
            String name = "<init>";
            MemberName ctor = this.resolveOrFail((byte)8, refc, name, type);
            return this.getDirectConstructor(refc, ctor);
        }

        public Class<?> findClass(String targetName) throws ClassNotFoundException, IllegalAccessException {
            Class<?> targetClass = Class.forName(targetName, false, this.lookupClass.getClassLoader());
            return this.accessClass(targetClass);
        }

        public Class<?> accessClass(Class<?> targetClass) throws IllegalAccessException {
            if (!VerifyAccess.isClassAccessible(targetClass, this.lookupClass, (int)this.allowedModes)) {
                throw new MemberName(targetClass).makeAccessException("access violation", this);
            }
            this.checkSecurityManager(targetClass, null);
            return targetClass;
        }

        public MethodHandle findSpecial(Class<?> refc, String name, MethodType type, Class<?> specialCaller) throws NoSuchMethodException, IllegalAccessException {
            this.checkSpecialCaller(specialCaller, refc);
            Lookup specialLookup = this.in(specialCaller);
            MemberName method = specialLookup.resolveOrFail((byte)7, refc, name, type);
            return specialLookup.getDirectMethod((byte)7, refc, method, this.findBoundCallerClass(method));
        }

        public MethodHandle findGetter(Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            MemberName field = this.resolveOrFail((byte)1, refc, name, type);
            return this.getDirectField((byte)1, refc, field);
        }

        public MethodHandle findSetter(Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            MemberName field = this.resolveOrFail((byte)3, refc, name, type);
            return this.getDirectField((byte)3, refc, field);
        }

        public VarHandle findVarHandle(Class<?> recv, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            MemberName getField = this.resolveOrFail((byte)1, recv, name, type);
            MemberName putField = this.resolveOrFail((byte)3, recv, name, type);
            return this.getFieldVarHandle((byte)1, (byte)3, recv, getField, putField);
        }

        public MethodHandle findStaticGetter(Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            MemberName field = this.resolveOrFail((byte)2, refc, name, type);
            return this.getDirectField((byte)2, refc, field);
        }

        public MethodHandle findStaticSetter(Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            MemberName field = this.resolveOrFail((byte)4, refc, name, type);
            return this.getDirectField((byte)4, refc, field);
        }

        public VarHandle findStaticVarHandle(Class<?> decl, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            MemberName getField = this.resolveOrFail((byte)2, decl, name, type);
            MemberName putField = this.resolveOrFail((byte)4, decl, name, type);
            return this.getFieldVarHandle((byte)2, (byte)4, decl, getField, putField);
        }

        public MethodHandle bind(Object receiver, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            Class<?> refc = receiver.getClass();
            MemberName method = this.resolveOrFail((byte)7, refc, name, type);
            MethodHandle mh = this.getDirectMethodNoRestrict((byte)7, refc, method, this.findBoundCallerClass(method));
            return mh.bindArgumentL(0, receiver).setVarargs(method);
        }

        public MethodHandle unreflect(Method m) throws IllegalAccessException {
            MethodHandle mh;
            if (m.getDeclaringClass() == MethodHandle.class && (mh = this.unreflectForMH(m)) != null) {
                return mh;
            }
            if (m.getDeclaringClass() == VarHandle.class && (mh = this.unreflectForVH(m)) != null) {
                return mh;
            }
            MemberName method = new MemberName(m);
            byte refKind = method.getReferenceKind();
            if (refKind == 7) {
                refKind = 5;
            }
            assert (method.isMethod());
            Lookup lookup = m.isAccessible() ? IMPL_LOOKUP : this;
            return lookup.getDirectMethodNoSecurityManager(refKind, method.getDeclaringClass(), method, this.findBoundCallerClass(method));
        }

        private MethodHandle unreflectForMH(Method m) {
            if (MemberName.isMethodHandleInvokeName(m.getName())) {
                return MethodHandleImpl.fakeMethodHandleInvoke(new MemberName(m));
            }
            return null;
        }

        private MethodHandle unreflectForVH(Method m) {
            if (MemberName.isVarHandleMethodInvokeName(m.getName())) {
                return MethodHandleImpl.fakeVarHandleInvoke(new MemberName(m));
            }
            return null;
        }

        public MethodHandle unreflectSpecial(Method m, Class<?> specialCaller) throws IllegalAccessException {
            this.checkSpecialCaller(specialCaller, null);
            Lookup specialLookup = this.in(specialCaller);
            MemberName method = new MemberName(m, true);
            assert (method.isMethod());
            return specialLookup.getDirectMethodNoSecurityManager((byte)7, method.getDeclaringClass(), method, this.findBoundCallerClass(method));
        }

        public MethodHandle unreflectConstructor(Constructor<?> c) throws IllegalAccessException {
            MemberName ctor = new MemberName(c);
            assert (ctor.isConstructor());
            Lookup lookup = c.isAccessible() ? IMPL_LOOKUP : this;
            return lookup.getDirectConstructorNoSecurityManager(ctor.getDeclaringClass(), ctor);
        }

        public MethodHandle unreflectGetter(Field f) throws IllegalAccessException {
            return this.unreflectField(f, false);
        }

        private MethodHandle unreflectField(Field f, boolean isSetter) throws IllegalAccessException {
            MemberName field = new MemberName(f, isSetter);
            assert (!isSetter ? MethodHandleNatives.refKindIsGetter(field.getReferenceKind()) : MethodHandleNatives.refKindIsSetter(field.getReferenceKind()));
            Lookup lookup = f.isAccessible() ? IMPL_LOOKUP : this;
            return lookup.getDirectFieldNoSecurityManager(field.getReferenceKind(), f.getDeclaringClass(), field);
        }

        public MethodHandle unreflectSetter(Field f) throws IllegalAccessException {
            return this.unreflectField(f, true);
        }

        public VarHandle unreflectVarHandle(Field f) throws IllegalAccessException {
            MemberName getField = new MemberName(f, false);
            MemberName putField = new MemberName(f, true);
            return this.getFieldVarHandleNoSecurityManager(getField.getReferenceKind(), putField.getReferenceKind(), f.getDeclaringClass(), getField, putField);
        }

        public MethodHandleInfo revealDirect(MethodHandle target) {
            MemberName member = target.internalMemberName();
            if (member == null || !member.isResolved() && !member.isMethodHandleInvoke() && !member.isVarHandleMethodInvoke()) {
                throw MethodHandleStatics.newIllegalArgumentException("not a direct method handle");
            }
            Class<?> defc = member.getDeclaringClass();
            byte refKind = member.getReferenceKind();
            assert (MethodHandleNatives.refKindIsValid(refKind));
            if (refKind == 7 && !target.isInvokeSpecial()) {
                refKind = 5;
            }
            if (refKind == 5 && defc.isInterface()) {
                refKind = 9;
            }
            try {
                this.checkAccess(refKind, defc, member);
                this.checkSecurityManager(defc, member);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException(ex);
            }
            if (this.allowedModes != -1 && member.isCallerSensitive()) {
                Class<?> callerClass = target.internalCallerClass();
                if (!this.hasPrivateAccess() || callerClass != this.lookupClass()) {
                    throw new IllegalArgumentException("method handle is caller sensitive: " + callerClass);
                }
            }
            return new InfoFromMemberName(this, member, refKind);
        }

        MemberName resolveOrFail(byte refKind, Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            this.checkSymbolicClass(refc);
            Objects.requireNonNull(name);
            Objects.requireNonNull(type);
            return IMPL_NAMES.resolveOrFail(refKind, new MemberName(refc, name, type, refKind), this.lookupClassOrNull(), NoSuchFieldException.class);
        }

        MemberName resolveOrFail(byte refKind, Class<?> refc, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            this.checkSymbolicClass(refc);
            Objects.requireNonNull(name);
            Objects.requireNonNull(type);
            this.checkMethodName(refKind, name);
            return IMPL_NAMES.resolveOrFail(refKind, new MemberName(refc, name, type, refKind), this.lookupClassOrNull(), NoSuchMethodException.class);
        }

        MemberName resolveOrFail(byte refKind, MemberName member) throws ReflectiveOperationException {
            this.checkSymbolicClass(member.getDeclaringClass());
            Objects.requireNonNull(member.getName());
            Objects.requireNonNull(member.getType());
            return IMPL_NAMES.resolveOrFail(refKind, member, this.lookupClassOrNull(), ReflectiveOperationException.class);
        }

        void checkSymbolicClass(Class<?> refc) throws IllegalAccessException {
            Objects.requireNonNull(refc);
            Class<?> caller = this.lookupClassOrNull();
            if (caller != null && !VerifyAccess.isClassAccessible(refc, caller, (int)this.allowedModes)) {
                throw new MemberName(refc).makeAccessException("symbolic reference class is not accessible", this);
            }
        }

        void checkMethodName(byte refKind, String name) throws NoSuchMethodException {
            if (name.startsWith("<") && refKind != 8) {
                throw new NoSuchMethodException("illegal method name: " + name);
            }
        }

        Class<?> findBoundCallerClass(MemberName m) throws IllegalAccessException {
            Class<?> callerClass = null;
            if (MethodHandleNatives.isCallerSensitive(m)) {
                if (this.hasPrivateAccess()) {
                    callerClass = this.lookupClass;
                } else {
                    throw new IllegalAccessException("Attempt to lookup caller-sensitive method using restricted lookup object");
                }
            }
            return callerClass;
        }

        public boolean hasPrivateAccess() {
            return (this.allowedModes & 2) != 0;
        }

        void checkSecurityManager(Class<?> refc, MemberName m) {
            SecurityManager smgr = System.getSecurityManager();
            if (smgr == null) {
                return;
            }
            if (this.allowedModes == -1) {
                return;
            }
            boolean fullPowerLookup = this.hasPrivateAccess();
            if (!fullPowerLookup || !VerifyAccess.classLoaderIsAncestor(this.lookupClass, refc)) {
                ReflectUtil.checkPackageAccess(refc);
            }
            if (m == null) {
                if (!fullPowerLookup) {
                    smgr.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
                }
                return;
            }
            if (m.isPublic()) {
                return;
            }
            if (!fullPowerLookup) {
                smgr.checkPermission(SecurityConstants.CHECK_MEMBER_ACCESS_PERMISSION);
            }
            Class<?> defc = m.getDeclaringClass();
            if (!fullPowerLookup && defc != refc) {
                ReflectUtil.checkPackageAccess(defc);
            }
        }

        void checkMethod(byte refKind, Class<?> refc, MemberName m) throws IllegalAccessException {
            String message;
            boolean wantStatic;
            boolean bl = wantStatic = refKind == 6;
            if (m.isConstructor()) {
                message = "expected a method, not a constructor";
            } else if (!m.isMethod()) {
                message = "expected a method";
            } else if (wantStatic != m.isStatic()) {
                message = wantStatic ? "expected a static method" : "expected a non-static method";
            } else {
                this.checkAccess(refKind, refc, m);
                return;
            }
            throw m.makeAccessException(message, this);
        }

        void checkField(byte refKind, Class<?> refc, MemberName m) throws IllegalAccessException {
            boolean wantStatic;
            boolean bl = wantStatic = !MethodHandleNatives.refKindHasReceiver(refKind);
            if (wantStatic == m.isStatic()) {
                this.checkAccess(refKind, refc, m);
                return;
            }
            String message = wantStatic ? "expected a static field" : "expected a non-static field";
            throw m.makeAccessException(message, this);
        }

        void checkAccess(byte refKind, Class<?> refc, MemberName m) throws IllegalAccessException {
            assert (m.referenceKindIsConsistentWith(refKind) && MethodHandleNatives.refKindIsValid(refKind) && MethodHandleNatives.refKindIsField(refKind) == m.isField());
            int allowedModes = this.allowedModes;
            if (allowedModes == -1) {
                return;
            }
            int mods = m.getModifiers();
            if (Modifier.isProtected(mods) && refKind == 5 && m.getDeclaringClass() == Object.class && m.getName().equals("clone") && refc.isArray()) {
                mods ^= 5;
            }
            if (Modifier.isProtected(mods) && refKind == 8) {
                mods ^= 4;
            }
            if (Modifier.isFinal(mods) && MethodHandleNatives.refKindIsSetter(refKind)) {
                throw m.makeAccessException("unexpected set of a final field", this);
            }
            int requestedModes = Lookup.fixmods(mods);
            if ((requestedModes & allowedModes) != 0 ? VerifyAccess.isMemberAccessible(refc, m.getDeclaringClass(), (int)mods, this.lookupClass(), (int)allowedModes) : (requestedModes & 4) != 0 && (allowedModes & 8) != 0 && VerifyAccess.isSamePackage(m.getDeclaringClass(), this.lookupClass())) {
                return;
            }
            throw m.makeAccessException(this.accessFailedMessage(refc, m), this);
        }

        String accessFailedMessage(Class<?> refc, MemberName m) {
            boolean classOK;
            Class<?> defc = m.getDeclaringClass();
            int mods = m.getModifiers();
            boolean bl = classOK = Modifier.isPublic(defc.getModifiers()) && (defc == refc || Modifier.isPublic(refc.getModifiers()));
            if (!classOK && (this.allowedModes & 8) != 0) {
                boolean bl2 = classOK = VerifyAccess.isClassAccessible(defc, this.lookupClass(), (int)31) && (defc == refc || VerifyAccess.isClassAccessible(refc, this.lookupClass(), (int)31));
            }
            if (!classOK) {
                return "class is not public";
            }
            if (Modifier.isPublic(mods)) {
                return "access to public member failed";
            }
            if (Modifier.isPrivate(mods)) {
                return "member is private";
            }
            if (Modifier.isProtected(mods)) {
                return "member is protected";
            }
            return "member is private to package";
        }

        private void checkSpecialCaller(Class<?> specialCaller, Class<?> refc) throws IllegalAccessException {
            int allowedModes = this.allowedModes;
            if (allowedModes == -1) {
                return;
            }
            if (!(this.hasPrivateAccess() && (specialCaller == this.lookupClass() || refc != null && refc.isInterface() && refc.isAssignableFrom(specialCaller)))) {
                throw new MemberName(specialCaller).makeAccessException("no private access for invokespecial", this);
            }
        }

        private boolean restrictProtectedReceiver(MemberName method) {
            return method.isProtected() && !method.isStatic() && this.allowedModes != -1 && method.getDeclaringClass() != this.lookupClass() && !VerifyAccess.isSamePackage(method.getDeclaringClass(), this.lookupClass());
            {
            }
        }

        private MethodHandle restrictReceiver(MemberName method, DirectMethodHandle mh, Class<?> caller) throws IllegalAccessException {
            assert (!method.isStatic());
            if (!method.getDeclaringClass().isAssignableFrom(caller)) {
                throw method.makeAccessException("caller class must be a subclass below the method", caller);
            }
            MethodType rawType = mh.type();
            if (rawType.parameterType(0) == caller) {
                return mh;
            }
            MethodType narrowType = rawType.changeParameterType(0, caller);
            assert (!mh.isVarargsCollector());
            assert (mh.viewAsTypeChecks(narrowType, true));
            return mh.copyWith(narrowType, mh.form);
        }

        private MethodHandle getDirectMethod(byte refKind, Class<?> refc, MemberName method, Class<?> callerClass) throws IllegalAccessException {
            boolean doRestrict = true;
            boolean checkSecurity = true;
            return this.getDirectMethodCommon(refKind, refc, method, true, true, callerClass);
        }

        private MethodHandle getDirectMethodNoRestrict(byte refKind, Class<?> refc, MemberName method, Class<?> callerClass) throws IllegalAccessException {
            boolean doRestrict = false;
            boolean checkSecurity = true;
            return this.getDirectMethodCommon(refKind, refc, method, true, false, callerClass);
        }

        private MethodHandle getDirectMethodNoSecurityManager(byte refKind, Class<?> refc, MemberName method, Class<?> callerClass) throws IllegalAccessException {
            boolean doRestrict = true;
            boolean checkSecurity = false;
            return this.getDirectMethodCommon(refKind, refc, method, false, true, callerClass);
        }

        private MethodHandle getDirectMethodCommon(byte refKind, Class<?> refc, MemberName method, boolean checkSecurity, boolean doRestrict, Class<?> callerClass) throws IllegalAccessException {
            this.checkMethod(refKind, refc, method);
            if (checkSecurity) {
                this.checkSecurityManager(refc, method);
            }
            assert (!method.isMethodHandleInvoke());
            if (refKind == 7 && refc != this.lookupClass() && !refc.isInterface() && refc != this.lookupClass().getSuperclass() && refc.isAssignableFrom(this.lookupClass())) {
                MemberName m2;
                assert (!method.getName().equals("<init>"));
                Class<?> refcAsSuper = this.lookupClass();
                do {
                    refcAsSuper = refcAsSuper.getSuperclass();
                    m2 = new MemberName(refcAsSuper, method.getName(), method.getMethodType(), 7);
                } while ((m2 = IMPL_NAMES.resolveOrNull(refKind, m2, this.lookupClassOrNull())) == null && refc != refcAsSuper);
                if (m2 == null) {
                    throw new InternalError(method.toString());
                }
                method = m2;
                refc = refcAsSuper;
                this.checkMethod(refKind, refc, method);
            }
            DirectMethodHandle dmh = DirectMethodHandle.make(refKind, refc, method);
            MethodHandle mh = dmh;
            if (doRestrict && (refKind == 7 || MethodHandleNatives.refKindHasReceiver(refKind) && this.restrictProtectedReceiver(method))) {
                mh = this.restrictReceiver(method, dmh, this.lookupClass());
            }
            mh = this.maybeBindCaller(method, mh, callerClass);
            mh = mh.setVarargs(method);
            return mh;
        }

        private MethodHandle maybeBindCaller(MemberName method, MethodHandle mh, Class<?> callerClass) throws IllegalAccessException {
            if (this.allowedModes == -1 || !MethodHandleNatives.isCallerSensitive(method)) {
                return mh;
            }
            Class<?> hostClass = this.lookupClass;
            if (!this.hasPrivateAccess()) {
                hostClass = callerClass;
            }
            MethodHandle cbmh = MethodHandleImpl.bindCaller(mh, hostClass);
            return cbmh;
        }

        private MethodHandle getDirectField(byte refKind, Class<?> refc, MemberName field) throws IllegalAccessException {
            boolean checkSecurity = true;
            return this.getDirectFieldCommon(refKind, refc, field, true);
        }

        private MethodHandle getDirectFieldNoSecurityManager(byte refKind, Class<?> refc, MemberName field) throws IllegalAccessException {
            boolean checkSecurity = false;
            return this.getDirectFieldCommon(refKind, refc, field, false);
        }

        private MethodHandle getDirectFieldCommon(byte refKind, Class<?> refc, MemberName field, boolean checkSecurity) throws IllegalAccessException {
            boolean doRestrict;
            this.checkField(refKind, refc, field);
            if (checkSecurity) {
                this.checkSecurityManager(refc, field);
            }
            DirectMethodHandle dmh = DirectMethodHandle.make(refc, field);
            boolean bl = doRestrict = MethodHandleNatives.refKindHasReceiver(refKind) && this.restrictProtectedReceiver(field);
            if (doRestrict) {
                return this.restrictReceiver(field, dmh, this.lookupClass());
            }
            return dmh;
        }

        private VarHandle getFieldVarHandle(byte getRefKind, byte putRefKind, Class<?> refc, MemberName getField, MemberName putField) throws IllegalAccessException {
            boolean checkSecurity = true;
            return this.getFieldVarHandleCommon(getRefKind, putRefKind, refc, getField, putField, true);
        }

        private VarHandle getFieldVarHandleNoSecurityManager(byte getRefKind, byte putRefKind, Class<?> refc, MemberName getField, MemberName putField) throws IllegalAccessException {
            boolean checkSecurity = false;
            return this.getFieldVarHandleCommon(getRefKind, putRefKind, refc, getField, putField, false);
        }

        private VarHandle getFieldVarHandleCommon(byte getRefKind, byte putRefKind, Class<?> refc, MemberName getField, MemberName putField, boolean checkSecurity) throws IllegalAccessException {
            boolean doRestrict;
            assert (getField.isStatic() == putField.isStatic());
            assert (getField.isGetter() && putField.isSetter());
            assert (MethodHandleNatives.refKindIsStatic(getRefKind) == MethodHandleNatives.refKindIsStatic(putRefKind));
            assert (MethodHandleNatives.refKindIsGetter(getRefKind) && MethodHandleNatives.refKindIsSetter(putRefKind));
            this.checkField(getRefKind, refc, getField);
            if (checkSecurity) {
                this.checkSecurityManager(refc, getField);
            }
            if (!putField.isFinal()) {
                this.checkField(putRefKind, refc, putField);
                if (checkSecurity) {
                    this.checkSecurityManager(refc, putField);
                }
            }
            boolean bl = doRestrict = MethodHandleNatives.refKindHasReceiver(getRefKind) && this.restrictProtectedReceiver(getField);
            if (doRestrict) {
                assert (!getField.isStatic());
                if (!getField.getDeclaringClass().isAssignableFrom(this.lookupClass())) {
                    throw getField.makeAccessException("caller class must be a subclass below the method", this.lookupClass());
                }
                refc = this.lookupClass();
            }
            return VarHandles.makeFieldHandle(getField, refc, getField.getFieldType(), this.allowedModes == -1);
        }

        private MethodHandle getDirectConstructor(Class<?> refc, MemberName ctor) throws IllegalAccessException {
            boolean checkSecurity = true;
            return this.getDirectConstructorCommon(refc, ctor, true);
        }

        private MethodHandle getDirectConstructorNoSecurityManager(Class<?> refc, MemberName ctor) throws IllegalAccessException {
            boolean checkSecurity = false;
            return this.getDirectConstructorCommon(refc, ctor, false);
        }

        private MethodHandle getDirectConstructorCommon(Class<?> refc, MemberName ctor, boolean checkSecurity) throws IllegalAccessException {
            assert (ctor.isConstructor());
            this.checkAccess((byte)8, refc, ctor);
            if (checkSecurity) {
                this.checkSecurityManager(refc, ctor);
            }
            assert (!MethodHandleNatives.isCallerSensitive(ctor));
            return DirectMethodHandle.make(ctor).setVarargs(ctor);
        }

        MethodHandle linkMethodHandleConstant(byte refKind, Class<?> defc, String name, Object type) throws ReflectiveOperationException {
            if (!(type instanceof Class) && !(type instanceof MethodType)) {
                throw new InternalError("unresolved MemberName");
            }
            MemberName member = new MemberName(refKind, defc, name, type);
            MethodHandle mh = LOOKASIDE_TABLE.get(member);
            if (mh != null) {
                this.checkSymbolicClass(defc);
                return mh;
            }
            if (defc == MethodHandle.class && refKind == 5 && (mh = this.findVirtualForMH(member.getName(), member.getMethodType())) != null) {
                return mh;
            }
            MemberName resolved = this.resolveOrFail(refKind, member);
            mh = this.getDirectMethodForConstant(refKind, defc, resolved);
            if (mh instanceof DirectMethodHandle && this.canBeCached(refKind, defc, resolved)) {
                MemberName key = mh.internalMemberName();
                if (key != null) {
                    key = key.asNormalOriginal();
                }
                if (member.equals(key)) {
                    LOOKASIDE_TABLE.put(key, (DirectMethodHandle)mh);
                }
            }
            return mh;
        }

        private boolean canBeCached(byte refKind, Class<?> defc, MemberName member) {
            if (refKind == 7) {
                return false;
            }
            if (!Modifier.isPublic(defc.getModifiers()) || !Modifier.isPublic(member.getDeclaringClass().getModifiers()) || !member.isPublic() || member.isCallerSensitive()) {
                return false;
            }
            ClassLoader loader = defc.getClassLoader();
            if (!VM.isSystemDomainLoader(loader)) {
                boolean found = false;
                for (ClassLoader sysl = ClassLoader.getSystemClassLoader(); sysl != null; sysl = sysl.getParent()) {
                    if (loader != sysl) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return false;
                }
            }
            try {
                MemberName resolved2 = MethodHandles.publicLookup().resolveOrFail(refKind, new MemberName(refKind, defc, member.getName(), member.getType()));
                this.checkSecurityManager(defc, resolved2);
            }
            catch (ReflectiveOperationException | SecurityException ex) {
                return false;
            }
            return true;
        }

        private MethodHandle getDirectMethodForConstant(byte refKind, Class<?> defc, MemberName member) throws ReflectiveOperationException {
            if (MethodHandleNatives.refKindIsField(refKind)) {
                return this.getDirectFieldNoSecurityManager(refKind, defc, member);
            }
            if (MethodHandleNatives.refKindIsMethod(refKind)) {
                return this.getDirectMethodNoSecurityManager(refKind, defc, member, this.lookupClass);
            }
            if (refKind == 8) {
                return this.getDirectConstructorNoSecurityManager(defc, member);
            }
            throw MethodHandleStatics.newIllegalArgumentException("bad MethodHandle constant #" + member);
        }

        static {
            IMPL_NAMES.getClass();
            IMPL_LOOKUP = new Lookup(Object.class, -1);
            LOOKASIDE_TABLE = new ConcurrentHashMap();
        }
    }
}

