/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.DelegatingMethodHandle;
import java.lang.invoke.GenerateJLIClassesHelper;
import java.lang.invoke.InvokerBytecodeGenerator;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.SimpleMethodHandle;
import java.lang.invoke.VarHandle;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import jdk.internal.HotSpotIntrinsicCandidate;
import jdk.internal.misc.JavaLangInvokeAccess;
import jdk.internal.misc.SharedSecrets;
import jdk.internal.org.objectweb.asm.AnnotationVisitor;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;
import jdk.internal.vm.annotation.ForceInline;
import jdk.internal.vm.annotation.Stable;
import sun.invoke.empty.Empty;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.VerifyType;
import sun.invoke.util.Wrapper;

abstract class MethodHandleImpl {
    static MethodHandle[] FAKE_METHOD_HANDLE_INVOKE = new MethodHandle[2];
    private static final Object[] NO_ARGS_ARRAY = new Object[0];
    private static final int ARRAYS_COUNT = 11;
    @Stable
    private static final MethodHandle[] ARRAYS = new MethodHandle[MethodHandleStatics.MAX_ARITY + 1];
    private static final int FILL_ARRAYS_COUNT = 11;
    @Stable
    private static final MethodHandle[] FILL_ARRAYS = new MethodHandle[11];
    private static final int LEFT_ARGS = 10;
    @Stable
    private static final MethodHandle[] FILL_ARRAY_TO_RIGHT = new MethodHandle[MethodHandleStatics.MAX_ARITY + 1];
    static final int MAX_JVM_ARITY = 255;
    static final LambdaForm.NamedFunction NF_checkSpreadArgument;
    static final LambdaForm.NamedFunction NF_guardWithCatch;
    static final LambdaForm.NamedFunction NF_throwException;
    static final LambdaForm.NamedFunction NF_tryFinally;
    static final LambdaForm.NamedFunction NF_loop;
    static final LambdaForm.NamedFunction NF_profileBoolean;
    static final int MH_cast = 0;
    static final int MH_selectAlternative = 1;
    static final int MH_copyAsPrimitiveArray = 2;
    static final int MH_fillNewTypedArray = 3;
    static final int MH_fillNewArray = 4;
    static final int MH_arrayIdentity = 5;
    static final int MH_countedLoopPred = 6;
    static final int MH_countedLoopStep = 7;
    static final int MH_initIterator = 8;
    static final int MH_iteratePred = 9;
    static final int MH_iterateNext = 10;
    static final int MH_Array_newInstance = 11;
    static final int MH_LIMIT = 12;
    @Stable
    private static final MethodHandle[] HANDLES;

    MethodHandleImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MethodHandle makeArrayElementAccessor(Class<?> arrayClass, ArrayAccess access) {
        int cacheIndex;
        if (arrayClass == Object[].class) {
            return ArrayAccess.objectAccessor(access);
        }
        if (!arrayClass.isArray()) {
            throw MethodHandleStatics.newIllegalArgumentException("not an array: " + arrayClass);
        }
        MethodHandle[] cache = ArrayAccessor.TYPED_ACCESSORS.get(arrayClass);
        MethodHandle mh = cache[cacheIndex = ArrayAccess.cacheIndex(access)];
        if (mh != null) {
            return mh;
        }
        mh = ArrayAccessor.getAccessor(arrayClass, access);
        MethodType correctType = ArrayAccessor.correctType(arrayClass, access);
        if (mh.type() != correctType) {
            assert (mh.type().parameterType(0) == Object[].class);
            assert (access != ArrayAccess.SET || mh.type().parameterType(2) == Object.class);
            assert (access != ArrayAccess.GET || mh.type().returnType() == Object.class && correctType.parameterType(0).getComponentType() == correctType.returnType());
            mh = mh.viewAsType(correctType, false);
        }
        mh = MethodHandleImpl.makeIntrinsic(mh, ArrayAccess.intrinsic(access));
        MethodHandle[] methodHandleArray = cache;
        synchronized (cache) {
            if (cache[cacheIndex] == null) {
                cache[cacheIndex] = mh;
            } else {
                mh = cache[cacheIndex];
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return mh;
        }
    }

    static InternalError unmatchedArrayAccess(ArrayAccess a) {
        return MethodHandleStatics.newInternalError("should not reach here (unmatched ArrayAccess: " + (Object)((Object)a) + ")");
    }

    static MethodHandle makePairwiseConvert(MethodHandle target, MethodType srcType, boolean strict, boolean monobox) {
        MethodType dstType = target.type();
        if (srcType == dstType) {
            return target;
        }
        return MethodHandleImpl.makePairwiseConvertByEditor(target, srcType, strict, monobox);
    }

    private static int countNonNull(Object[] array) {
        int count = 0;
        for (Object x : array) {
            if (x == null) continue;
            ++count;
        }
        return count;
    }

    static MethodHandle makePairwiseConvertByEditor(MethodHandle target, MethodType srcType, boolean strict, boolean monobox) {
        Object[] convSpecs = MethodHandleImpl.computeValueConversions(srcType, target.type(), strict, monobox);
        int convCount = MethodHandleImpl.countNonNull(convSpecs);
        if (convCount == 0) {
            return target.viewAsType(srcType, strict);
        }
        MethodType basicSrcType = srcType.basicType();
        MethodType midType = target.type().basicType();
        BoundMethodHandle mh = target.rebind();
        for (int i = 0; i < convSpecs.length - 1; ++i) {
            Object convSpec = convSpecs[i];
            if (convSpec == null) continue;
            MethodHandle fn = convSpec instanceof Class ? MethodHandleImpl.getConstantHandle(0).bindTo(convSpec) : (MethodHandle)convSpec;
            Class<?> newType = basicSrcType.parameterType(i);
            midType = --convCount == 0 ? srcType : midType.changeParameterType(i, newType);
            LambdaForm form2 = mh.editor().filterArgumentForm(1 + i, LambdaForm.BasicType.basicType(newType));
            mh = mh.copyWithExtendL(midType, form2, fn);
            mh = mh.rebind();
        }
        Object convSpec = convSpecs[convSpecs.length - 1];
        if (convSpec != null) {
            LambdaForm form2;
            Object fn = convSpec instanceof Class ? (convSpec == Void.TYPE ? null : MethodHandleImpl.getConstantHandle(0).bindTo(convSpec)) : (MethodHandle)convSpec;
            Class<?> newType = basicSrcType.returnType();
            assert (--convCount == 0);
            midType = srcType;
            if (fn != null) {
                mh = mh.rebind();
                form2 = mh.editor().filterReturnForm(LambdaForm.BasicType.basicType(newType), false);
                mh = mh.copyWithExtendL(midType, form2, fn);
            } else {
                form2 = mh.editor().filterReturnForm(LambdaForm.BasicType.basicType(newType), true);
                mh = mh.copyWith(midType, form2);
            }
        }
        assert (convCount == 0);
        assert (mh.type().equals((Object)srcType));
        return mh;
    }

    static MethodHandle makePairwiseConvertIndirect(MethodHandle target, MethodType srcType, boolean strict, boolean monobox) {
        boolean retVoid;
        assert (target.type().parameterCount() == srcType.parameterCount());
        Object[] convSpecs = MethodHandleImpl.computeValueConversions(srcType, target.type(), strict, monobox);
        int INARG_COUNT = srcType.parameterCount();
        int convCount = MethodHandleImpl.countNonNull(convSpecs);
        boolean retConv = convSpecs[INARG_COUNT] != null;
        boolean bl = retVoid = srcType.returnType() == Void.TYPE;
        if (retConv && retVoid) {
            --convCount;
            retConv = false;
        }
        boolean IN_MH = false;
        boolean INARG_BASE = true;
        int INARG_LIMIT = 1 + INARG_COUNT;
        int NAME_LIMIT = INARG_LIMIT + convCount + 1;
        int RETURN_CONV = !retConv ? -1 : NAME_LIMIT - 1;
        int OUT_CALL = (!retConv ? NAME_LIMIT : RETURN_CONV) - 1;
        int RESULT = retVoid ? -1 : NAME_LIMIT - 1;
        MethodType lambdaType = srcType.basicType().invokerType();
        LambdaForm.Name[] names = LambdaForm.arguments(NAME_LIMIT - INARG_LIMIT, lambdaType);
        boolean OUTARG_BASE = false;
        Object[] outArgs = new Object[0 + INARG_COUNT];
        int nameCursor = INARG_LIMIT;
        for (int i = 0; i < INARG_COUNT; ++i) {
            LambdaForm.Name conv;
            Object convSpec = convSpecs[i];
            if (convSpec == null) {
                outArgs[0 + i] = names[1 + i];
                continue;
            }
            if (convSpec instanceof Class) {
                Class convClass = (Class)convSpec;
                conv = new LambdaForm.Name(MethodHandleImpl.getConstantHandle(0), convClass, names[1 + i]);
            } else {
                MethodHandle fn = (MethodHandle)convSpec;
                conv = new LambdaForm.Name(fn, names[1 + i]);
            }
            assert (names[nameCursor] == null);
            names[nameCursor++] = conv;
            assert (outArgs[0 + i] == null);
            outArgs[0 + i] = conv;
        }
        assert (nameCursor == OUT_CALL);
        names[OUT_CALL] = new LambdaForm.Name(target, outArgs);
        Object convSpec = convSpecs[INARG_COUNT];
        if (!retConv) {
            assert (OUT_CALL == names.length - 1);
        } else {
            LambdaForm.Name conv;
            if (convSpec == Void.TYPE) {
                conv = new LambdaForm.Name(LambdaForm.constantZero(LambdaForm.BasicType.basicType(srcType.returnType())), new Object[0]);
            } else if (convSpec instanceof Class) {
                Class convClass = (Class)convSpec;
                conv = new LambdaForm.Name(MethodHandleImpl.getConstantHandle(0), convClass, names[OUT_CALL]);
            } else {
                MethodHandle fn = (MethodHandle)convSpec;
                conv = fn.type().parameterCount() == 0 ? new LambdaForm.Name(fn, new Object[0]) : new LambdaForm.Name(fn, names[OUT_CALL]);
            }
            assert (names[RETURN_CONV] == null);
            names[RETURN_CONV] = conv;
            assert (RETURN_CONV == names.length - 1);
        }
        LambdaForm form = new LambdaForm("convert", lambdaType.parameterCount(), names, RESULT);
        return SimpleMethodHandle.make(srcType, form);
    }

    static Object[] computeValueConversions(MethodType srcType, MethodType dstType, boolean strict, boolean monobox) {
        int INARG_COUNT = srcType.parameterCount();
        Object[] convSpecs = new Object[INARG_COUNT + 1];
        for (int i = 0; i <= INARG_COUNT; ++i) {
            Class<?> dst;
            boolean isRet = i == INARG_COUNT;
            Class<?> src = isRet ? dstType.returnType() : srcType.parameterType(i);
            Class<?> clazz = dst = isRet ? srcType.returnType() : dstType.parameterType(i);
            if (VerifyType.isNullConversion(src, dst, strict)) continue;
            convSpecs[i] = MethodHandleImpl.valueConversion(src, dst, strict, monobox);
        }
        return convSpecs;
    }

    static MethodHandle makePairwiseConvert(MethodHandle target, MethodType srcType, boolean strict) {
        return MethodHandleImpl.makePairwiseConvert(target, srcType, strict, false);
    }

    static Object valueConversion(Class<?> src, Class<?> dst, boolean strict, boolean monobox) {
        MethodHandle fn;
        assert (!VerifyType.isNullConversion(src, dst, strict));
        if (dst == Void.TYPE) {
            return dst;
        }
        if (src.isPrimitive()) {
            if (src == Void.TYPE) {
                return Void.TYPE;
            }
            if (dst.isPrimitive()) {
                fn = ValueConversions.convertPrimitive(src, dst);
            } else {
                Wrapper wsrc = Wrapper.forPrimitiveType(src);
                fn = ValueConversions.boxExact(wsrc);
                assert (fn.type().parameterType(0) == wsrc.primitiveType());
                assert (fn.type().returnType() == wsrc.wrapperType());
                if (!VerifyType.isNullConversion(wsrc.wrapperType(), dst, strict)) {
                    MethodType mt = MethodType.methodType(dst, src);
                    fn = strict ? fn.asType(mt) : MethodHandleImpl.makePairwiseConvert(fn, mt, false);
                }
            }
        } else if (dst.isPrimitive()) {
            Wrapper wdst = Wrapper.forPrimitiveType(dst);
            fn = monobox || src == wdst.wrapperType() ? ValueConversions.unboxExact(wdst, strict) : (strict ? ValueConversions.unboxWiden(wdst) : ValueConversions.unboxCast(wdst));
        } else {
            return dst;
        }
        assert (fn.type().parameterCount() <= 1) : "pc" + Arrays.asList(src.getSimpleName(), dst.getSimpleName(), fn);
        return fn;
    }

    static MethodHandle makeVarargsCollector(MethodHandle target, Class<?> arrayType) {
        int last;
        MethodType type = target.type();
        if (type.parameterType(last = type.parameterCount() - 1) != arrayType) {
            target = target.asType(type.changeParameterType(last, arrayType));
        }
        target = target.asFixedArity();
        return new AsVarargsCollector(target, arrayType);
    }

    static MethodHandle makeSpreadArguments(MethodHandle target, Class<?> spreadArgType, int spreadArgPos, int spreadArgCount) {
        MethodType targetType = target.type();
        for (int i = 0; i < spreadArgCount; ++i) {
            Class<Object> arg = VerifyType.spreadArgElementType(spreadArgType, (int)i);
            if (arg == null) {
                arg = Object.class;
            }
            targetType = targetType.changeParameterType(spreadArgPos + i, arg);
        }
        target = target.asType(targetType);
        MethodType srcType = targetType.replaceParameterTypes(spreadArgPos, spreadArgPos + spreadArgCount, spreadArgType);
        MethodType lambdaType = srcType.invokerType();
        LambdaForm.Name[] names = LambdaForm.arguments(spreadArgCount + 2, lambdaType);
        int nameCursor = lambdaType.parameterCount();
        int[] indexes = new int[targetType.parameterCount()];
        int i = 0;
        int argIndex = 1;
        while (i < targetType.parameterCount() + 1) {
            Class<?> src = lambdaType.parameterType(i);
            if (i == spreadArgPos) {
                MethodHandle aload = MethodHandles.arrayElementGetter(spreadArgType);
                LambdaForm.Name array = names[argIndex];
                names[nameCursor++] = new LambdaForm.Name(NF_checkSpreadArgument, array, spreadArgCount);
                for (int j = 0; j < spreadArgCount; ++j) {
                    indexes[i] = nameCursor;
                    names[nameCursor++] = new LambdaForm.Name(aload, array, j);
                    ++i;
                }
            } else if (i < indexes.length) {
                indexes[i] = argIndex;
            }
            ++i;
            ++argIndex;
        }
        assert (nameCursor == names.length - 1);
        LambdaForm.Name[] targetArgs = new LambdaForm.Name[targetType.parameterCount()];
        for (int i2 = 0; i2 < targetType.parameterCount(); ++i2) {
            int idx = indexes[i2];
            targetArgs[i2] = names[idx];
        }
        names[names.length - 1] = new LambdaForm.Name(target, (Object[])targetArgs);
        LambdaForm form = new LambdaForm("spread", lambdaType.parameterCount(), names);
        return SimpleMethodHandle.make(srcType, form);
    }

    static void checkSpreadArgument(Object av, int n) {
        int len;
        if (av == null ? n == 0 : (av instanceof Object[] ? (len = ((Object[])av).length) == n : (len = Array.getLength(av)) == n)) {
            return;
        }
        throw MethodHandleStatics.newIllegalArgumentException("array is not of length " + n);
    }

    static MethodHandle makeCollectArguments(MethodHandle target, MethodHandle collector, int collectArgPos, boolean retainOriginalArgs) {
        MethodType targetType = target.type();
        MethodType collectorType = collector.type();
        int collectArgCount = collectorType.parameterCount();
        Class<?> collectValType = collectorType.returnType();
        int collectValCount = collectValType == Void.TYPE ? 0 : 1;
        MethodType srcType = targetType.dropParameterTypes(collectArgPos, collectArgPos + collectValCount);
        if (!retainOriginalArgs) {
            srcType = srcType.insertParameterTypes(collectArgPos, collectorType.parameterArray());
        }
        MethodType lambdaType = srcType.invokerType();
        LambdaForm.Name[] names = LambdaForm.arguments(2, lambdaType);
        int collectNamePos = names.length - 2;
        int targetNamePos = names.length - 1;
        LambdaForm.Name[] collectorArgs = Arrays.copyOfRange(names, 1 + collectArgPos, 1 + collectArgPos + collectArgCount);
        names[collectNamePos] = new LambdaForm.Name(collector, (Object[])collectorArgs);
        LambdaForm.Name[] targetArgs = new LambdaForm.Name[targetType.parameterCount()];
        int inputArgPos = 1;
        int targetArgPos = 0;
        int chunk = collectArgPos;
        System.arraycopy(names, inputArgPos, targetArgs, targetArgPos, chunk);
        inputArgPos += chunk;
        targetArgPos += chunk;
        if (collectValType != Void.TYPE) {
            targetArgs[targetArgPos++] = names[collectNamePos];
        }
        chunk = collectArgCount;
        if (retainOriginalArgs) {
            System.arraycopy(names, inputArgPos, targetArgs, targetArgPos, chunk);
            targetArgPos += chunk;
        }
        inputArgPos += chunk;
        chunk = targetArgs.length - targetArgPos;
        System.arraycopy(names, inputArgPos, targetArgs, targetArgPos, chunk);
        assert (inputArgPos + chunk == collectNamePos);
        names[targetNamePos] = new LambdaForm.Name(target, (Object[])targetArgs);
        LambdaForm form = new LambdaForm("collect", lambdaType.parameterCount(), names);
        return SimpleMethodHandle.make(srcType, form);
    }

    @LambdaForm.Hidden
    static MethodHandle selectAlternative(boolean testResult, MethodHandle target, MethodHandle fallback) {
        if (testResult) {
            return target;
        }
        return fallback;
    }

    @LambdaForm.Hidden
    @HotSpotIntrinsicCandidate
    static boolean profileBoolean(boolean result, int[] counters) {
        int idx = result ? 1 : 0;
        try {
            counters[idx] = Math.addExact(counters[idx], 1);
        }
        catch (ArithmeticException e) {
            counters[idx] = counters[idx] / 2;
        }
        return result;
    }

    @LambdaForm.Hidden
    @HotSpotIntrinsicCandidate
    static boolean isCompileConstant(Object obj) {
        return false;
    }

    static MethodHandle makeGuardWithTest(MethodHandle test, MethodHandle target, MethodHandle fallback) {
        BoundMethodHandle mh;
        MethodType type = target.type();
        assert (test.type().equals((Object)type.changeReturnType(Boolean.TYPE)) && fallback.type().equals((Object)type));
        MethodType basicType = type.basicType();
        LambdaForm form = MethodHandleImpl.makeGuardWithTestForm(basicType);
        try {
            if (MethodHandleStatics.PROFILE_GWT) {
                int[] counts = new int[2];
                mh = BoundMethodHandle.speciesData_LLLL().constructor().invokeBasic(type, form, test, MethodHandleImpl.profile(target), MethodHandleImpl.profile(fallback), counts);
            } else {
                mh = BoundMethodHandle.speciesData_LLL().constructor().invokeBasic(type, form, test, MethodHandleImpl.profile(target), MethodHandleImpl.profile(fallback));
            }
        }
        catch (Throwable ex) {
            throw MethodHandleStatics.uncaughtException(ex);
        }
        assert (mh.type() == type);
        return mh;
    }

    static MethodHandle profile(MethodHandle target) {
        if (MethodHandleStatics.DONT_INLINE_THRESHOLD >= 0) {
            return MethodHandleImpl.makeBlockInliningWrapper(target);
        }
        return target;
    }

    static MethodHandle makeBlockInliningWrapper(MethodHandle target) {
        LambdaForm lform = MethodHandleStatics.DONT_INLINE_THRESHOLD > 0 ? Makers.PRODUCE_BLOCK_INLINING_FORM.apply(target) : Makers.PRODUCE_REINVOKER_FORM.apply(target);
        return new CountingWrapper(target, lform, Makers.PRODUCE_BLOCK_INLINING_FORM, Makers.PRODUCE_REINVOKER_FORM, MethodHandleStatics.DONT_INLINE_THRESHOLD);
    }

    static LambdaForm makeGuardWithTestForm(MethodType basicType) {
        int ARG_LIMIT;
        LambdaForm lform = basicType.form().cachedLambdaForm(17);
        if (lform != null) {
            return lform;
        }
        boolean THIS_MH = false;
        boolean ARG_BASE = true;
        int nameCursor = ARG_LIMIT = 1 + basicType.parameterCount();
        int GET_TEST = nameCursor++;
        int GET_TARGET = nameCursor++;
        int GET_FALLBACK = nameCursor++;
        int GET_COUNTERS = MethodHandleStatics.PROFILE_GWT ? nameCursor++ : -1;
        int CALL_TEST = nameCursor++;
        int PROFILE = GET_COUNTERS != -1 ? nameCursor++ : -1;
        int TEST = nameCursor - 1;
        int SELECT_ALT = nameCursor++;
        int CALL_TARGET = nameCursor++;
        assert (CALL_TARGET == SELECT_ALT + 1);
        MethodType lambdaType = basicType.invokerType();
        LambdaForm.Name[] names = LambdaForm.arguments(nameCursor - ARG_LIMIT, lambdaType);
        BoundMethodHandle.SpeciesData data = GET_COUNTERS != -1 ? BoundMethodHandle.speciesData_LLLL() : BoundMethodHandle.speciesData_LLL();
        names[0] = names[0].withConstraint(data);
        names[GET_TEST] = new LambdaForm.Name(data.getterFunction(0), names[0]);
        names[GET_TARGET] = new LambdaForm.Name(data.getterFunction(1), names[0]);
        names[GET_FALLBACK] = new LambdaForm.Name(data.getterFunction(2), names[0]);
        if (GET_COUNTERS != -1) {
            names[GET_COUNTERS] = new LambdaForm.Name(data.getterFunction(3), names[0]);
        }
        Object[] invokeArgs = Arrays.copyOfRange(names, 0, ARG_LIMIT, Object[].class);
        MethodType testType = basicType.changeReturnType(Boolean.TYPE).basicType();
        invokeArgs[0] = names[GET_TEST];
        names[CALL_TEST] = new LambdaForm.Name(testType, invokeArgs);
        if (PROFILE != -1) {
            names[PROFILE] = new LambdaForm.Name(NF_profileBoolean, names[CALL_TEST], names[GET_COUNTERS]);
        }
        names[SELECT_ALT] = new LambdaForm.Name(MethodHandleImpl.getConstantHandle(1), names[TEST], names[GET_TARGET], names[GET_FALLBACK]);
        invokeArgs[0] = names[SELECT_ALT];
        names[CALL_TARGET] = new LambdaForm.Name(basicType, invokeArgs);
        lform = new LambdaForm("guard", lambdaType.parameterCount(), names, true);
        return basicType.form().setCachedLambdaForm(17, lform);
    }

    private static LambdaForm makeGuardWithCatchForm(MethodType basicType) {
        int ARG_LIMIT;
        MethodType lambdaType = basicType.invokerType();
        LambdaForm lform = basicType.form().cachedLambdaForm(16);
        if (lform != null) {
            return lform;
        }
        boolean THIS_MH = false;
        boolean ARG_BASE = true;
        int nameCursor = ARG_LIMIT = 1 + basicType.parameterCount();
        int GET_TARGET = nameCursor++;
        int GET_CLASS = nameCursor++;
        int GET_CATCHER = nameCursor++;
        int GET_COLLECT_ARGS = nameCursor++;
        int GET_UNBOX_RESULT = nameCursor++;
        int BOXED_ARGS = nameCursor++;
        int TRY_CATCH = nameCursor++;
        int UNBOX_RESULT = nameCursor++;
        LambdaForm.Name[] names = LambdaForm.arguments(nameCursor - ARG_LIMIT, lambdaType);
        BoundMethodHandle.SpeciesData data = BoundMethodHandle.speciesData_LLLLL();
        names[0] = names[0].withConstraint(data);
        names[GET_TARGET] = new LambdaForm.Name(data.getterFunction(0), names[0]);
        names[GET_CLASS] = new LambdaForm.Name(data.getterFunction(1), names[0]);
        names[GET_CATCHER] = new LambdaForm.Name(data.getterFunction(2), names[0]);
        names[GET_COLLECT_ARGS] = new LambdaForm.Name(data.getterFunction(3), names[0]);
        names[GET_UNBOX_RESULT] = new LambdaForm.Name(data.getterFunction(4), names[0]);
        MethodType collectArgsType = basicType.changeReturnType(Object.class);
        MethodHandle invokeBasic = MethodHandles.basicInvoker(collectArgsType);
        Object[] args = new Object[invokeBasic.type().parameterCount()];
        args[0] = names[GET_COLLECT_ARGS];
        System.arraycopy(names, 1, args, 1, ARG_LIMIT - 1);
        names[BOXED_ARGS] = new LambdaForm.Name(MethodHandleImpl.makeIntrinsic(invokeBasic, Intrinsic.GUARD_WITH_CATCH), args);
        Object[] gwcArgs = new Object[]{names[GET_TARGET], names[GET_CLASS], names[GET_CATCHER], names[BOXED_ARGS]};
        names[TRY_CATCH] = new LambdaForm.Name(NF_guardWithCatch, gwcArgs);
        MethodHandle invokeBasicUnbox = MethodHandles.basicInvoker(MethodType.methodType(basicType.rtype(), Object.class));
        Object[] unboxArgs = new Object[]{names[GET_UNBOX_RESULT], names[TRY_CATCH]};
        names[UNBOX_RESULT] = new LambdaForm.Name(invokeBasicUnbox, unboxArgs);
        lform = new LambdaForm("guardWithCatch", lambdaType.parameterCount(), names);
        return basicType.form().setCachedLambdaForm(16, lform);
    }

    static MethodHandle makeGuardWithCatch(MethodHandle target, Class<? extends Throwable> exType, MethodHandle catcher) {
        BoundMethodHandle mh;
        MethodType type = target.type();
        LambdaForm form = MethodHandleImpl.makeGuardWithCatchForm(type.basicType());
        MethodType varargsType = type.changeReturnType(Object[].class);
        MethodHandle collectArgs = MethodHandleImpl.varargsArray(type.parameterCount()).asType(varargsType);
        MethodHandle unboxResult = MethodHandleImpl.unboxResultHandle(type.returnType());
        BoundMethodHandle.SpeciesData data = BoundMethodHandle.speciesData_LLLLL();
        try {
            mh = data.constructor().invokeBasic(type, form, target, exType, catcher, collectArgs, unboxResult);
        }
        catch (Throwable ex) {
            throw MethodHandleStatics.uncaughtException(ex);
        }
        assert (mh.type() == type);
        return mh;
    }

    @LambdaForm.Hidden
    static Object guardWithCatch(MethodHandle target, Class<? extends Throwable> exType, MethodHandle catcher, Object ... av) throws Throwable {
        try {
            return target.asFixedArity().invokeWithArguments(av);
        }
        catch (Throwable t) {
            if (!exType.isInstance(t)) {
                throw t;
            }
            return catcher.asFixedArity().invokeWithArguments(MethodHandleImpl.prepend(av, t));
        }
    }

    @LambdaForm.Hidden
    private static Object[] prepend(Object[] array, Object ... elems) {
        int nArray = array.length;
        int nElems = elems.length;
        Object[] newArray = new Object[nArray + nElems];
        System.arraycopy(elems, 0, newArray, 0, nElems);
        System.arraycopy(array, 0, newArray, nElems, nArray);
        return newArray;
    }

    static MethodHandle throwException(MethodType type) {
        assert (Throwable.class.isAssignableFrom(type.parameterType(0)));
        int arity = type.parameterCount();
        if (arity > 1) {
            MethodHandle mh = MethodHandleImpl.throwException(type.dropParameterTypes(1, arity));
            mh = MethodHandles.dropArguments(mh, 1, Arrays.copyOfRange(type.parameterArray(), 1, arity));
            return mh;
        }
        return MethodHandleImpl.makePairwiseConvert(NF_throwException.resolvedHandle(), type, false, true);
    }

    static <T extends Throwable> Empty throwException(T t) throws T {
        throw t;
    }

    static MethodHandle fakeMethodHandleInvoke(MemberName method) {
        int idx;
        assert (method.isMethodHandleInvoke());
        switch (method.getName()) {
            case "invoke": {
                idx = 0;
                break;
            }
            case "invokeExact": {
                idx = 1;
                break;
            }
            default: {
                throw new InternalError(method.getName());
            }
        }
        MethodHandle mh = FAKE_METHOD_HANDLE_INVOKE[idx];
        if (mh != null) {
            return mh;
        }
        MethodType type = MethodType.methodType(Object.class, UnsupportedOperationException.class, MethodHandle.class, Object[].class);
        mh = MethodHandleImpl.throwException(type);
        mh = mh.bindTo(new UnsupportedOperationException("cannot reflectively invoke MethodHandle"));
        if (!method.getInvocationType().equals((Object)mh.type())) {
            throw new InternalError(method.toString());
        }
        mh = mh.withInternalMemberName(method, false);
        mh = mh.withVarargs(true);
        assert (method.isVarargs());
        MethodHandleImpl.FAKE_METHOD_HANDLE_INVOKE[idx] = mh;
        return mh;
    }

    static MethodHandle fakeVarHandleInvoke(MemberName method) {
        MethodType type = MethodType.methodType(method.getReturnType(), UnsupportedOperationException.class, VarHandle.class, Object[].class);
        MethodHandle mh = MethodHandleImpl.throwException(type);
        mh = mh.bindTo(new UnsupportedOperationException("cannot reflectively invoke VarHandle"));
        if (!method.getInvocationType().equals((Object)mh.type())) {
            throw new InternalError(method.toString());
        }
        mh = mh.withInternalMemberName(method, false);
        mh = mh.asVarargsCollector(Object[].class);
        assert (method.isVarargs());
        return mh;
    }

    static MethodHandle bindCaller(MethodHandle mh, Class<?> hostClass) {
        return BindCaller.bindCaller(mh, hostClass);
    }

    static MethodHandle makeWrappedMember(MethodHandle target, MemberName member, boolean isInvokeSpecial) {
        if (member.equals(target.internalMemberName()) && isInvokeSpecial == target.isInvokeSpecial()) {
            return target;
        }
        return new WrappedMember(target, target.type(), member, isInvokeSpecial, null);
    }

    static MethodHandle makeIntrinsic(MethodHandle target, Intrinsic intrinsicName) {
        if (intrinsicName == target.intrinsicName()) {
            return target;
        }
        return new IntrinsicMethodHandle(target, intrinsicName);
    }

    static MethodHandle makeIntrinsic(MethodType type, LambdaForm form, Intrinsic intrinsicName) {
        return new IntrinsicMethodHandle(SimpleMethodHandle.make(type, form), intrinsicName);
    }

    private static MethodHandle findCollector(String name, int nargs, Class<?> rtype, Class<?> ... ptypes) {
        MethodType type = MethodType.genericMethodType(nargs).changeReturnType(rtype).insertParameterTypes(0, ptypes);
        try {
            return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MethodHandleImpl.class, name, type);
        }
        catch (ReflectiveOperationException ex) {
            return null;
        }
    }

    private static Object[] makeArray(Object ... args) {
        return args;
    }

    private static Object[] array() {
        return NO_ARGS_ARRAY;
    }

    private static Object[] array(Object a0) {
        return MethodHandleImpl.makeArray(a0);
    }

    private static Object[] array(Object a0, Object a1) {
        return MethodHandleImpl.makeArray(a0, a1);
    }

    private static Object[] array(Object a0, Object a1, Object a2) {
        return MethodHandleImpl.makeArray(a0, a1, a2);
    }

    private static Object[] array(Object a0, Object a1, Object a2, Object a3) {
        return MethodHandleImpl.makeArray(a0, a1, a2, a3);
    }

    private static Object[] array(Object a0, Object a1, Object a2, Object a3, Object a4) {
        return MethodHandleImpl.makeArray(a0, a1, a2, a3, a4);
    }

    private static Object[] array(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5) {
        return MethodHandleImpl.makeArray(a0, a1, a2, a3, a4, a5);
    }

    private static Object[] array(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6) {
        return MethodHandleImpl.makeArray(a0, a1, a2, a3, a4, a5, a6);
    }

    private static Object[] array(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7) {
        return MethodHandleImpl.makeArray(a0, a1, a2, a3, a4, a5, a6, a7);
    }

    private static Object[] array(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7, Object a8) {
        return MethodHandleImpl.makeArray(a0, a1, a2, a3, a4, a5, a6, a7, a8);
    }

    private static Object[] array(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7, Object a8, Object a9) {
        return MethodHandleImpl.makeArray(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
    }

    private static Object[] fillNewArray(Integer len, Object[] args) {
        Object[] a = new Object[len.intValue()];
        MethodHandleImpl.fillWithArguments(a, 0, args);
        return a;
    }

    private static Object[] fillNewTypedArray(Object[] example, Integer len, Object[] args) {
        Object[] a = Arrays.copyOf(example, (int)len);
        assert (a.getClass() != Object[].class);
        MethodHandleImpl.fillWithArguments(a, 0, args);
        return a;
    }

    private static void fillWithArguments(Object[] a, int pos, Object ... args) {
        System.arraycopy(args, 0, a, pos, args.length);
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0) {
        MethodHandleImpl.fillWithArguments(a, pos, a0);
        return a;
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0, Object a1) {
        MethodHandleImpl.fillWithArguments(a, pos, a0, a1);
        return a;
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0, Object a1, Object a2) {
        MethodHandleImpl.fillWithArguments(a, pos, a0, a1, a2);
        return a;
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0, Object a1, Object a2, Object a3) {
        MethodHandleImpl.fillWithArguments(a, pos, a0, a1, a2, a3);
        return a;
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0, Object a1, Object a2, Object a3, Object a4) {
        MethodHandleImpl.fillWithArguments(a, pos, a0, a1, a2, a3, a4);
        return a;
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0, Object a1, Object a2, Object a3, Object a4, Object a5) {
        MethodHandleImpl.fillWithArguments(a, pos, a0, a1, a2, a3, a4, a5);
        return a;
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6) {
        MethodHandleImpl.fillWithArguments(a, pos, a0, a1, a2, a3, a4, a5, a6);
        return a;
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7) {
        MethodHandleImpl.fillWithArguments(a, pos, a0, a1, a2, a3, a4, a5, a6, a7);
        return a;
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7, Object a8) {
        MethodHandleImpl.fillWithArguments(a, pos, a0, a1, a2, a3, a4, a5, a6, a7, a8);
        return a;
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7, Object a8, Object a9) {
        MethodHandleImpl.fillWithArguments(a, pos, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
        return a;
    }

    private static MethodHandle getFillArray(int count) {
        assert (count > 0 && count < 11);
        MethodHandle mh = FILL_ARRAYS[count];
        if (mh != null) {
            return mh;
        }
        MethodHandleImpl.FILL_ARRAYS[count] = mh = MethodHandleImpl.findCollector("fillArray", count, Object[].class, Integer.class, Object[].class);
        return mh;
    }

    private static Object copyAsPrimitiveArray(Wrapper w, Object ... boxes) {
        Object a = w.makeArray(boxes.length);
        w.copyArrayUnboxing(boxes, 0, a, 0, boxes.length);
        return a;
    }

    static MethodHandle varargsArray(int nargs) {
        MethodHandle mh = ARRAYS[nargs];
        if (mh != null) {
            return mh;
        }
        mh = nargs < 11 ? MethodHandleImpl.findCollector("array", nargs, Object[].class, new Class[0]) : MethodHandleImpl.buildVarargsArray(MethodHandleImpl.getConstantHandle(4), MethodHandleImpl.getConstantHandle(5), nargs);
        assert (MethodHandleImpl.assertCorrectArity(mh, nargs));
        MethodHandleImpl.ARRAYS[nargs] = mh = MethodHandleImpl.makeIntrinsic(mh, Intrinsic.NEW_ARRAY);
        return MethodHandleImpl.ARRAYS[nargs];
    }

    private static boolean assertCorrectArity(MethodHandle mh, int arity) {
        assert (mh.type().parameterCount() == arity) : "arity != " + arity + ": " + mh;
        return true;
    }

    static <T> T[] identity(T[] x) {
        return x;
    }

    private static MethodHandle buildVarargsArray(MethodHandle newArray, MethodHandle finisher, int nargs) {
        int leftLen = Math.min(nargs, 10);
        int rightLen = nargs - leftLen;
        MethodHandle leftCollector = newArray.bindTo(nargs);
        leftCollector = leftCollector.asCollector(Object[].class, leftLen);
        MethodHandle mh = finisher;
        if (rightLen > 0) {
            MethodHandle rightFiller = MethodHandleImpl.fillToRight(10 + rightLen);
            mh = mh.equals(MethodHandleImpl.getConstantHandle(5)) ? rightFiller : MethodHandles.collectArguments(mh, 0, rightFiller);
        }
        mh = mh.equals(MethodHandleImpl.getConstantHandle(5)) ? leftCollector : MethodHandles.collectArguments(mh, 0, leftCollector);
        return mh;
    }

    private static MethodHandle fillToRight(int nargs) {
        MethodHandle filler = FILL_ARRAY_TO_RIGHT[nargs];
        if (filler != null) {
            return filler;
        }
        filler = MethodHandleImpl.buildFiller(nargs);
        assert (MethodHandleImpl.assertCorrectArity(filler, nargs - 10 + 1));
        MethodHandleImpl.FILL_ARRAY_TO_RIGHT[nargs] = filler;
        return MethodHandleImpl.FILL_ARRAY_TO_RIGHT[nargs];
    }

    private static MethodHandle buildFiller(int nargs) {
        if (nargs <= 10) {
            return MethodHandleImpl.getConstantHandle(5);
        }
        int CHUNK = 10;
        int rightLen = nargs % 10;
        int midLen = nargs - rightLen;
        if (rightLen == 0) {
            rightLen = 10;
            midLen = nargs - 10;
            if (FILL_ARRAY_TO_RIGHT[midLen] == null) {
                for (int j = 0; j < midLen; j += 10) {
                    if (j <= 10) continue;
                    MethodHandleImpl.fillToRight(j);
                }
            }
        }
        if (midLen < 10) {
            midLen = 10;
            rightLen = nargs - 10;
        }
        assert (rightLen > 0);
        MethodHandle midFill = MethodHandleImpl.fillToRight(midLen);
        MethodHandle rightFill = MethodHandleImpl.getFillArray(rightLen).bindTo(midLen);
        assert (midFill.type().parameterCount() == 1 + midLen - 10);
        assert (rightFill.type().parameterCount() == 1 + rightLen);
        if (midLen == 10) {
            return rightFill;
        }
        return MethodHandles.collectArguments(rightFill, 0, midFill);
    }

    static MethodHandle varargsArray(Class<?> arrayType, int nargs) {
        MethodHandle mh;
        Class<?> elemType = arrayType.getComponentType();
        if (elemType == null) {
            throw new IllegalArgumentException("not an array: " + arrayType);
        }
        if (nargs >= 126) {
            int slots = nargs;
            int MAX_ARRAY_SLOTS = 254;
            if (slots <= 254 && elemType.isPrimitive()) {
                slots *= Wrapper.forPrimitiveType(elemType).stackSlots();
            }
            if (slots > 254) {
                throw new IllegalArgumentException("too many arguments: " + arrayType.getSimpleName() + ", length " + nargs);
            }
        }
        if (elemType == Object.class) {
            return MethodHandleImpl.varargsArray(nargs);
        }
        MethodHandle[] cache = Makers.TYPED_COLLECTORS.get(elemType);
        MethodHandle methodHandle = mh = nargs < cache.length ? cache[nargs] : null;
        if (mh != null) {
            return mh;
        }
        if (nargs == 0) {
            Object example = Array.newInstance(arrayType.getComponentType(), 0);
            mh = MethodHandles.constant(arrayType, example);
        } else if (elemType.isPrimitive()) {
            MethodHandle builder = MethodHandleImpl.getConstantHandle(4);
            MethodHandle producer = MethodHandleImpl.buildArrayProducer(arrayType);
            mh = MethodHandleImpl.buildVarargsArray(builder, producer, nargs);
        } else {
            Class<Object[]> objArrayType = arrayType.asSubclass(Object[].class);
            T[] example = Arrays.copyOf(NO_ARGS_ARRAY, 0, objArrayType);
            MethodHandle builder = MethodHandleImpl.getConstantHandle(3).bindTo(example);
            MethodHandle producer = MethodHandleImpl.getConstantHandle(5);
            mh = MethodHandleImpl.buildVarargsArray(builder, producer, nargs);
        }
        mh = mh.asType(MethodType.methodType(arrayType, Collections.nCopies(nargs, elemType)));
        mh = MethodHandleImpl.makeIntrinsic(mh, Intrinsic.NEW_ARRAY);
        assert (MethodHandleImpl.assertCorrectArity(mh, nargs));
        if (nargs < cache.length) {
            cache[nargs] = mh;
        }
        return mh;
    }

    private static MethodHandle buildArrayProducer(Class<?> arrayType) {
        Class<?> elemType = arrayType.getComponentType();
        assert (elemType.isPrimitive());
        return MethodHandleImpl.getConstantHandle(2).bindTo((Object)Wrapper.forPrimitiveType(elemType));
    }

    static void assertSame(Object mh1, Object mh2) {
        if (mh1 != mh2) {
            String msg = String.format("mh1 != mh2: mh1 = %s (form: %s); mh2 = %s (form: %s)", mh1, ((MethodHandle)mh1).form, mh2, ((MethodHandle)mh2).form);
            throw MethodHandleStatics.newInternalError(msg);
        }
    }

    private static MethodHandle unboxResultHandle(Class<?> returnType) {
        if (returnType.isPrimitive()) {
            if (returnType == Void.TYPE) {
                return ValueConversions.ignore();
            }
            Wrapper w = Wrapper.forPrimitiveType(returnType);
            return ValueConversions.unboxExact(w);
        }
        return MethodHandles.identity(Object.class);
    }

    static MethodHandle makeLoop(Class<?> tloop, List<Class<?>> targs, List<MethodHandle> init, List<MethodHandle> step, List<MethodHandle> pred, List<MethodHandle> fini) {
        BoundMethodHandle mh;
        MethodType type = MethodType.methodType(tloop, targs);
        LambdaForm.BasicType[] initClauseTypes = (LambdaForm.BasicType[])init.stream().map(h -> h.type().returnType()).map(LambdaForm.BasicType::basicType).toArray(LambdaForm.BasicType[]::new);
        LambdaForm form = MethodHandleImpl.makeLoopForm(type.basicType(), initClauseTypes);
        MethodType varargsType = type.changeReturnType(Object[].class);
        MethodHandle collectArgs = MethodHandleImpl.varargsArray(type.parameterCount()).asType(varargsType);
        MethodHandle unboxResult = MethodHandleImpl.unboxResultHandle(tloop);
        LoopClauses clauseData = new LoopClauses(new MethodHandle[][]{MethodHandleImpl.toArray(init), MethodHandleImpl.toArray(step), MethodHandleImpl.toArray(pred), MethodHandleImpl.toArray(fini)});
        BoundMethodHandle.SpeciesData data = BoundMethodHandle.speciesData_LLL();
        try {
            mh = data.constructor().invokeBasic(type, form, clauseData, collectArgs, unboxResult);
        }
        catch (Throwable ex) {
            throw MethodHandleStatics.uncaughtException(ex);
        }
        assert (mh.type() == type);
        return mh;
    }

    private static MethodHandle[] toArray(List<MethodHandle> l) {
        return l.toArray(new MethodHandle[0]);
    }

    private static LambdaForm makeLoopForm(MethodType basicType, LambdaForm.BasicType[] localVarTypes) {
        int ARG_LIMIT;
        MethodType lambdaType = basicType.invokerType();
        boolean THIS_MH = false;
        boolean ARG_BASE = true;
        int nameCursor = ARG_LIMIT = 1 + basicType.parameterCount();
        int GET_CLAUSE_DATA = nameCursor++;
        int GET_COLLECT_ARGS = nameCursor++;
        int GET_UNBOX_RESULT = nameCursor++;
        int BOXED_ARGS = nameCursor++;
        int LOOP = nameCursor++;
        int UNBOX_RESULT = nameCursor++;
        LambdaForm lform = basicType.form().cachedLambdaForm(19);
        if (lform == null) {
            LambdaForm.Name[] names = LambdaForm.arguments(nameCursor - ARG_LIMIT, lambdaType);
            BoundMethodHandle.SpeciesData data = BoundMethodHandle.speciesData_LLL();
            names[0] = names[0].withConstraint(data);
            names[GET_CLAUSE_DATA] = new LambdaForm.Name(data.getterFunction(0), names[0]);
            names[GET_COLLECT_ARGS] = new LambdaForm.Name(data.getterFunction(1), names[0]);
            names[GET_UNBOX_RESULT] = new LambdaForm.Name(data.getterFunction(2), names[0]);
            MethodType collectArgsType = basicType.changeReturnType(Object.class);
            MethodHandle invokeBasic = MethodHandles.basicInvoker(collectArgsType);
            Object[] args = new Object[invokeBasic.type().parameterCount()];
            args[0] = names[GET_COLLECT_ARGS];
            System.arraycopy(names, 1, args, 1, ARG_LIMIT - 1);
            names[BOXED_ARGS] = new LambdaForm.Name(MethodHandleImpl.makeIntrinsic(invokeBasic, Intrinsic.LOOP), args);
            Object[] lArgs = new Object[]{null, names[GET_CLAUSE_DATA], names[BOXED_ARGS]};
            names[LOOP] = new LambdaForm.Name(NF_loop, lArgs);
            MethodHandle invokeBasicUnbox = MethodHandles.basicInvoker(MethodType.methodType(basicType.rtype(), Object.class));
            Object[] unboxArgs = new Object[]{names[GET_UNBOX_RESULT], names[LOOP]};
            names[UNBOX_RESULT] = new LambdaForm.Name(invokeBasicUnbox, unboxArgs);
            lform = basicType.form().setCachedLambdaForm(19, new LambdaForm("loop", lambdaType.parameterCount(), names));
        }
        return lform.editor().noteLoopLocalTypesForm(BOXED_ARGS, localVarTypes);
    }

    @LambdaForm.Hidden
    static Object loop(LambdaForm.BasicType[] localTypes, LoopClauses clauseData, Object ... av) throws Throwable {
        MethodHandle[] init = clauseData.clauses[0];
        MethodHandle[] step = clauseData.clauses[1];
        MethodHandle[] pred = clauseData.clauses[2];
        MethodHandle[] fini = clauseData.clauses[3];
        int varSize = (int)Stream.of(init).filter(h -> h.type().returnType() != Void.TYPE).count();
        int nArgs = init[0].type().parameterCount();
        Object[] varsAndArgs = new Object[varSize + nArgs];
        int v = 0;
        for (int i = 0; i < init.length; ++i) {
            MethodHandle ih = init[i];
            if (ih.type().returnType() == Void.TYPE) {
                ih.invokeWithArguments(av);
                continue;
            }
            varsAndArgs[v++] = ih.invokeWithArguments(av);
        }
        System.arraycopy(av, 0, varsAndArgs, varSize, nArgs);
        int nSteps = step.length;
        block1: while (true) {
            int i = 0;
            int v2 = 0;
            while (true) {
                if (i >= nSteps) continue block1;
                MethodHandle p = pred[i];
                MethodHandle s = step[i];
                MethodHandle f = fini[i];
                if (s.type().returnType() == Void.TYPE) {
                    s.invokeWithArguments(varsAndArgs);
                } else {
                    varsAndArgs[v2++] = s.invokeWithArguments(varsAndArgs);
                }
                if (!((Boolean)p.invokeWithArguments(varsAndArgs)).booleanValue()) {
                    return f.invokeWithArguments(varsAndArgs);
                }
                ++i;
            }
            break;
        }
    }

    static boolean countedLoopPredicate(int limit, int counter) {
        return counter < limit;
    }

    static int countedLoopStep(int limit, int counter) {
        return counter + 1;
    }

    static Iterator<?> initIterator(Iterable<?> it) {
        return it.iterator();
    }

    static boolean iteratePredicate(Iterator<?> it) {
        return it.hasNext();
    }

    static Object iterateNext(Iterator<?> it) {
        return it.next();
    }

    static MethodHandle makeTryFinally(MethodHandle target, MethodHandle cleanup, Class<?> rtype, List<Class<?>> argTypes) {
        BoundMethodHandle mh;
        MethodType type = MethodType.methodType(rtype, argTypes);
        LambdaForm form = MethodHandleImpl.makeTryFinallyForm(type.basicType());
        MethodType varargsType = type.changeReturnType(Object[].class);
        MethodHandle collectArgs = MethodHandleImpl.varargsArray(type.parameterCount()).asType(varargsType);
        MethodHandle unboxResult = MethodHandleImpl.unboxResultHandle(rtype);
        BoundMethodHandle.SpeciesData data = BoundMethodHandle.speciesData_LLLL();
        try {
            mh = data.constructor().invokeBasic(type, form, target, cleanup, collectArgs, unboxResult);
        }
        catch (Throwable ex) {
            throw MethodHandleStatics.uncaughtException(ex);
        }
        assert (mh.type() == type);
        return mh;
    }

    private static LambdaForm makeTryFinallyForm(MethodType basicType) {
        int ARG_LIMIT;
        MethodType lambdaType = basicType.invokerType();
        LambdaForm lform = basicType.form().cachedLambdaForm(18);
        if (lform != null) {
            return lform;
        }
        boolean THIS_MH = false;
        boolean ARG_BASE = true;
        int nameCursor = ARG_LIMIT = 1 + basicType.parameterCount();
        int GET_TARGET = nameCursor++;
        int GET_CLEANUP = nameCursor++;
        int GET_COLLECT_ARGS = nameCursor++;
        int GET_UNBOX_RESULT = nameCursor++;
        int BOXED_ARGS = nameCursor++;
        int TRY_FINALLY = nameCursor++;
        int UNBOX_RESULT = nameCursor++;
        LambdaForm.Name[] names = LambdaForm.arguments(nameCursor - ARG_LIMIT, lambdaType);
        BoundMethodHandle.SpeciesData data = BoundMethodHandle.speciesData_LLLL();
        names[0] = names[0].withConstraint(data);
        names[GET_TARGET] = new LambdaForm.Name(data.getterFunction(0), names[0]);
        names[GET_CLEANUP] = new LambdaForm.Name(data.getterFunction(1), names[0]);
        names[GET_COLLECT_ARGS] = new LambdaForm.Name(data.getterFunction(2), names[0]);
        names[GET_UNBOX_RESULT] = new LambdaForm.Name(data.getterFunction(3), names[0]);
        MethodType collectArgsType = basicType.changeReturnType(Object.class);
        MethodHandle invokeBasic = MethodHandles.basicInvoker(collectArgsType);
        Object[] args = new Object[invokeBasic.type().parameterCount()];
        args[0] = names[GET_COLLECT_ARGS];
        System.arraycopy(names, 1, args, 1, ARG_LIMIT - 1);
        names[BOXED_ARGS] = new LambdaForm.Name(MethodHandleImpl.makeIntrinsic(invokeBasic, Intrinsic.TRY_FINALLY), args);
        Object[] tfArgs = new Object[]{names[GET_TARGET], names[GET_CLEANUP], names[BOXED_ARGS]};
        names[TRY_FINALLY] = new LambdaForm.Name(NF_tryFinally, tfArgs);
        MethodHandle invokeBasicUnbox = MethodHandles.basicInvoker(MethodType.methodType(basicType.rtype(), Object.class));
        Object[] unboxArgs = new Object[]{names[GET_UNBOX_RESULT], names[TRY_FINALLY]};
        names[UNBOX_RESULT] = new LambdaForm.Name(invokeBasicUnbox, unboxArgs);
        lform = new LambdaForm("tryFinally", lambdaType.parameterCount(), names);
        return basicType.form().setCachedLambdaForm(18, lform);
    }

    @LambdaForm.Hidden
    static Object tryFinally(MethodHandle target, MethodHandle cleanup, Object ... av) throws Throwable {
        Object[] objectArray;
        Throwable t = null;
        Object r = null;
        try {
            r = target.invokeWithArguments(av);
            objectArray = target.type().returnType() == Void.TYPE ? MethodHandleImpl.prepend(av, t) : MethodHandleImpl.prepend(av, t, r);
        }
        catch (Throwable thrown) {
            try {
                t = thrown;
                throw t;
            }
            catch (Throwable throwable) {
                Object[] args = target.type().returnType() == Void.TYPE ? MethodHandleImpl.prepend(av, t) : MethodHandleImpl.prepend(av, t, r);
                r = cleanup.invokeWithArguments(args);
                throw throwable;
            }
        }
        Object[] args = objectArray;
        r = cleanup.invokeWithArguments(args);
        return r;
    }

    static MethodHandle getConstantHandle(int idx) {
        MethodHandle handle = HANDLES[idx];
        if (handle != null) {
            return handle;
        }
        return MethodHandleImpl.setCachedHandle(idx, MethodHandleImpl.makeConstantHandle(idx));
    }

    private static synchronized MethodHandle setCachedHandle(int idx, MethodHandle method) {
        MethodHandle prev = HANDLES[idx];
        if (prev != null) {
            return prev;
        }
        MethodHandleImpl.HANDLES[idx] = method;
        return method;
    }

    private static MethodHandle makeConstantHandle(int idx) {
        try {
            switch (idx) {
                case 0: {
                    return MethodHandles.Lookup.IMPL_LOOKUP.findVirtual(Class.class, "cast", MethodType.methodType(Object.class, Object.class));
                }
                case 2: {
                    return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MethodHandleImpl.class, "copyAsPrimitiveArray", MethodType.methodType(Object.class, Wrapper.class, Object[].class));
                }
                case 5: {
                    return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MethodHandleImpl.class, "identity", MethodType.methodType(Object[].class, Object[].class));
                }
                case 4: {
                    return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MethodHandleImpl.class, "fillNewArray", MethodType.methodType(Object[].class, Integer.class, Object[].class));
                }
                case 3: {
                    return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MethodHandleImpl.class, "fillNewTypedArray", MethodType.methodType(Object[].class, Object[].class, Integer.class, Object[].class));
                }
                case 1: {
                    return MethodHandleImpl.makeIntrinsic(MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MethodHandleImpl.class, "selectAlternative", MethodType.methodType(MethodHandle.class, Boolean.TYPE, MethodHandle.class, MethodHandle.class)), Intrinsic.SELECT_ALTERNATIVE);
                }
                case 6: {
                    return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MethodHandleImpl.class, "countedLoopPredicate", MethodType.methodType(Boolean.TYPE, Integer.TYPE, Integer.TYPE));
                }
                case 7: {
                    return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MethodHandleImpl.class, "countedLoopStep", MethodType.methodType(Integer.TYPE, Integer.TYPE, Integer.TYPE));
                }
                case 8: {
                    return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MethodHandleImpl.class, "initIterator", MethodType.methodType(Iterator.class, Iterable.class));
                }
                case 9: {
                    return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MethodHandleImpl.class, "iteratePredicate", MethodType.methodType(Boolean.TYPE, Iterator.class));
                }
                case 10: {
                    return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MethodHandleImpl.class, "iterateNext", MethodType.methodType(Object.class, Iterator.class));
                }
                case 11: {
                    return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(Array.class, "newInstance", MethodType.methodType(Object.class, Class.class, Integer.TYPE));
                }
            }
        }
        catch (ReflectiveOperationException ex) {
            throw MethodHandleStatics.newInternalError(ex);
        }
        throw MethodHandleStatics.newInternalError("Unknown function index: " + idx);
    }

    static {
        try {
            NF_checkSpreadArgument = new LambdaForm.NamedFunction(MethodHandleImpl.class.getDeclaredMethod("checkSpreadArgument", Object.class, Integer.TYPE));
            NF_guardWithCatch = new LambdaForm.NamedFunction(MethodHandleImpl.class.getDeclaredMethod("guardWithCatch", MethodHandle.class, Class.class, MethodHandle.class, Object[].class));
            NF_tryFinally = new LambdaForm.NamedFunction(MethodHandleImpl.class.getDeclaredMethod("tryFinally", MethodHandle.class, MethodHandle.class, Object[].class));
            NF_loop = new LambdaForm.NamedFunction(MethodHandleImpl.class.getDeclaredMethod("loop", LambdaForm.BasicType[].class, LoopClauses.class, Object[].class));
            NF_throwException = new LambdaForm.NamedFunction(MethodHandleImpl.class.getDeclaredMethod("throwException", Throwable.class));
            NF_profileBoolean = new LambdaForm.NamedFunction(MethodHandleImpl.class.getDeclaredMethod("profileBoolean", Boolean.TYPE, int[].class));
        }
        catch (ReflectiveOperationException ex) {
            throw MethodHandleStatics.newInternalError(ex);
        }
        SharedSecrets.setJavaLangInvokeAccess((JavaLangInvokeAccess)new JavaLangInvokeAccess(){

            public Object newMemberName() {
                return new MemberName();
            }

            public String getName(Object mname) {
                MemberName memberName = (MemberName)mname;
                return memberName.getName();
            }

            public boolean isNative(Object mname) {
                MemberName memberName = (MemberName)mname;
                return memberName.isNative();
            }

            public byte[] generateDirectMethodHandleHolderClassBytes(String className, MethodType[] methodTypes, int[] types) {
                return GenerateJLIClassesHelper.generateDirectMethodHandleHolderClassBytes(className, methodTypes, types);
            }

            public byte[] generateDelegatingMethodHandleHolderClassBytes(String className, MethodType[] methodTypes) {
                return GenerateJLIClassesHelper.generateDelegatingMethodHandleHolderClassBytes(className, methodTypes);
            }

            public Map.Entry<String, byte[]> generateConcreteBMHClassBytes(String types) {
                return GenerateJLIClassesHelper.generateConcreteBMHClassBytes(types);
            }

            public byte[] generateBasicFormsClassBytes(String className) {
                return GenerateJLIClassesHelper.generateBasicFormsClassBytes(className);
            }

            public byte[] generateInvokersHolderClassBytes(String className, MethodType[] methodTypes) {
                return GenerateJLIClassesHelper.generateInvokersHolderClassBytes(className, methodTypes);
            }
        });
        HANDLES = new MethodHandle[12];
    }

    static class LoopClauses {
        @Stable
        final MethodHandle[][] clauses;

        LoopClauses(MethodHandle[][] clauses) {
            assert (clauses.length == 4);
            this.clauses = clauses;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("LoopClauses -- ");
            for (int i = 0; i < 4; ++i) {
                if (i > 0) {
                    sb.append("       ");
                }
                sb.append('<').append(i).append(">: ");
                MethodHandle[] hs = this.clauses[i];
                for (int j = 0; j < hs.length; ++j) {
                    if (j > 0) {
                        sb.append("          ");
                    }
                    sb.append('*').append(j).append(": ").append(hs[j]).append('\n');
                }
            }
            sb.append(" --\n");
            return sb.toString();
        }
    }

    static final class IntrinsicMethodHandle
    extends DelegatingMethodHandle {
        private final MethodHandle target;
        private final Intrinsic intrinsicName;

        IntrinsicMethodHandle(MethodHandle target, Intrinsic intrinsicName) {
            super(target.type(), target);
            this.target = target;
            this.intrinsicName = intrinsicName;
        }

        @Override
        protected MethodHandle getTarget() {
            return this.target;
        }

        @Override
        Intrinsic intrinsicName() {
            return this.intrinsicName;
        }

        @Override
        public MethodHandle asTypeUncached(MethodType newType) {
            this.asTypeCache = this.target.asType(newType);
            return this.asTypeCache;
        }

        @Override
        String internalProperties() {
            return super.internalProperties() + "\n& Intrinsic=" + (Object)((Object)this.intrinsicName);
        }

        @Override
        public MethodHandle asCollector(Class<?> arrayType, int arrayLength) {
            if (this.intrinsicName == Intrinsic.IDENTITY) {
                MethodType resultType = this.type().asCollectorType(arrayType, this.type().parameterCount() - 1, arrayLength);
                MethodHandle newArray = MethodHandleImpl.varargsArray(arrayType, arrayLength);
                return newArray.asType(resultType);
            }
            return super.asCollector(arrayType, arrayLength);
        }
    }

    static enum Intrinsic {
        SELECT_ALTERNATIVE,
        GUARD_WITH_CATCH,
        TRY_FINALLY,
        LOOP,
        NEW_ARRAY,
        ARRAY_LOAD,
        ARRAY_STORE,
        ARRAY_LENGTH,
        IDENTITY,
        ZERO,
        NONE;

    }

    private static final class WrappedMember
    extends DelegatingMethodHandle {
        private final MethodHandle target;
        private final MemberName member;
        private final Class<?> callerClass;
        private final boolean isInvokeSpecial;

        private WrappedMember(MethodHandle target, MethodType type, MemberName member, boolean isInvokeSpecial, Class<?> callerClass) {
            super(type, target);
            this.target = target;
            this.member = member;
            this.callerClass = callerClass;
            this.isInvokeSpecial = isInvokeSpecial;
        }

        @Override
        MemberName internalMemberName() {
            return this.member;
        }

        @Override
        Class<?> internalCallerClass() {
            return this.callerClass;
        }

        @Override
        boolean isInvokeSpecial() {
            return this.isInvokeSpecial;
        }

        @Override
        protected MethodHandle getTarget() {
            return this.target;
        }

        @Override
        public MethodHandle asTypeUncached(MethodType newType) {
            this.asTypeCache = this.target.asType(newType);
            return this.asTypeCache;
        }
    }

    private static class BindCaller {
        private static MethodType INVOKER_MT = MethodType.methodType(Object.class, MethodHandle.class, Object[].class);
        private static ClassValue<MethodHandle> CV_makeInjectedInvoker = new ClassValue<MethodHandle>(){

            @Override
            protected MethodHandle computeValue(Class<?> hostClass) {
                return BindCaller.makeInjectedInvoker(hostClass);
            }
        };
        private static final MethodHandle MH_checkCallerClass;
        private static final byte[] INJECTED_INVOKER_TEMPLATE;

        private BindCaller() {
        }

        static MethodHandle bindCaller(MethodHandle mh, Class<?> hostClass) {
            if (hostClass == null || hostClass.isArray() || hostClass.isPrimitive() || hostClass.getName().startsWith("java.lang.invoke.")) {
                throw new InternalError();
            }
            MethodHandle vamh = BindCaller.prepareForInvoker(mh);
            MethodHandle bccInvoker = CV_makeInjectedInvoker.get(hostClass);
            return BindCaller.restoreToType(bccInvoker.bindTo(vamh), mh, hostClass);
        }

        private static MethodHandle makeInjectedInvoker(Class<?> hostClass) {
            try {
                Class invokerClass = MethodHandleStatics.UNSAFE.defineAnonymousClass(hostClass, INJECTED_INVOKER_TEMPLATE, null);
                assert (BindCaller.checkInjectedInvoker(hostClass, invokerClass));
                return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(invokerClass, "invoke_V", INVOKER_MT);
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
        }

        private static MethodHandle prepareForInvoker(MethodHandle mh) {
            mh = mh.asFixedArity();
            MethodType mt = mh.type();
            int arity = mt.parameterCount();
            MethodHandle vamh = mh.asType(mt.generic());
            vamh.internalForm().compileToBytecode();
            vamh = vamh.asSpreader(Object[].class, arity);
            vamh.internalForm().compileToBytecode();
            return vamh;
        }

        private static MethodHandle restoreToType(MethodHandle vamh, MethodHandle original, Class<?> hostClass) {
            MethodType type = original.type();
            MethodHandle mh = vamh.asCollector(Object[].class, type.parameterCount());
            MemberName member = original.internalMemberName();
            mh = mh.asType(type);
            mh = new WrappedMember(mh, type, member, original.isInvokeSpecial(), hostClass);
            return mh;
        }

        private static boolean checkInjectedInvoker(Class<?> hostClass, Class<?> invokerClass) {
            assert (hostClass.getClassLoader() == invokerClass.getClassLoader()) : hostClass.getName() + " (CL)";
            try {
                assert (hostClass.getProtectionDomain() == invokerClass.getProtectionDomain()) : hostClass.getName() + " (PD)";
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            try {
                MethodHandle invoker = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(invokerClass, "invoke_V", INVOKER_MT);
                MethodHandle vamh = BindCaller.prepareForInvoker(MH_checkCallerClass);
                return invoker.invoke(vamh, new Object[]{invokerClass});
            }
            catch (Throwable ex) {
                throw new InternalError(ex);
            }
        }

        @CallerSensitive
        @ForceInline
        private static boolean checkCallerClass(Class<?> expected) {
            Class<?> actual = Reflection.getCallerClass();
            if (actual != expected) {
                throw new InternalError("found " + actual.getName() + ", expected " + expected.getName());
            }
            return true;
        }

        private static byte[] generateInvokerTemplate() {
            ClassWriter cw = new ClassWriter(0);
            cw.visit(52, 34, "InjectedInvoker", null, "java/lang/Object", null);
            MethodVisitor mv = cw.visitMethod(8, "invoke_V", "(Ljava/lang/invoke/MethodHandle;[Ljava/lang/Object;)Ljava/lang/Object;", null, null);
            AnnotationVisitor av0 = mv.visitAnnotation("Ljava/lang/invoke/LambdaForm$Hidden;", true);
            av0.visitEnd();
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, "java/lang/invoke/MethodHandle", "invokeExact", "([Ljava/lang/Object;)Ljava/lang/Object;", false);
            mv.visitInsn(176);
            mv.visitMaxs(2, 2);
            mv.visitEnd();
            cw.visitEnd();
            return cw.toByteArray();
        }

        static {
            Class<BindCaller> THIS_CLASS = BindCaller.class;
            assert (BindCaller.checkCallerClass(THIS_CLASS));
            try {
                MH_checkCallerClass = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(THIS_CLASS, "checkCallerClass", MethodType.methodType(Boolean.TYPE, Class.class));
                assert (MH_checkCallerClass.invokeExact(THIS_CLASS));
            }
            catch (Throwable ex) {
                throw new InternalError(ex);
            }
            INJECTED_INVOKER_TEMPLATE = BindCaller.generateInvokerTemplate();
        }
    }

    static class CountingWrapper
    extends DelegatingMethodHandle {
        private final MethodHandle target;
        private int count;
        private Function<MethodHandle, LambdaForm> countingFormProducer;
        private Function<MethodHandle, LambdaForm> nonCountingFormProducer;
        private volatile boolean isCounting;
        private int invocations = MethodHandleStatics.CUSTOMIZE_THRESHOLD;
        static final LambdaForm.NamedFunction NF_maybeStopCounting;

        private CountingWrapper(MethodHandle target, LambdaForm lform, Function<MethodHandle, LambdaForm> countingFromProducer, Function<MethodHandle, LambdaForm> nonCountingFormProducer, int count) {
            super(target.type(), lform);
            this.target = target;
            this.count = count;
            this.countingFormProducer = countingFromProducer;
            this.nonCountingFormProducer = nonCountingFormProducer;
            this.isCounting = count > 0;
        }

        @Override
        @LambdaForm.Hidden
        protected MethodHandle getTarget() {
            return this.target;
        }

        @Override
        public MethodHandle asTypeUncached(MethodType newType) {
            MethodHandle wrapper;
            MethodHandle newTarget = this.target.asType(newType);
            if (this.isCounting) {
                LambdaForm lform = this.countingFormProducer.apply(newTarget);
                wrapper = new CountingWrapper(newTarget, lform, this.countingFormProducer, this.nonCountingFormProducer, MethodHandleStatics.DONT_INLINE_THRESHOLD);
            } else {
                wrapper = newTarget;
            }
            this.asTypeCache = wrapper;
            return this.asTypeCache;
        }

        private void maybeCustomizeTarget() {
            int c = this.invocations;
            if (c >= 0) {
                if (c == 1) {
                    this.target.customize();
                }
                this.invocations = c - 1;
            }
        }

        boolean countDown() {
            int c = this.count;
            this.maybeCustomizeTarget();
            if (c <= 1) {
                if (this.isCounting) {
                    this.isCounting = false;
                    return true;
                }
                return false;
            }
            this.count = c - 1;
            return false;
        }

        @LambdaForm.Hidden
        static void maybeStopCounting(Object o1) {
            CountingWrapper wrapper = (CountingWrapper)o1;
            if (wrapper.countDown()) {
                LambdaForm lform = wrapper.nonCountingFormProducer.apply(wrapper.target);
                lform.compileToBytecode();
                wrapper.updateForm(lform);
            }
        }

        static {
            Class<CountingWrapper> THIS_CLASS = CountingWrapper.class;
            try {
                NF_maybeStopCounting = new LambdaForm.NamedFunction(THIS_CLASS.getDeclaredMethod("maybeStopCounting", Object.class));
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.newInternalError(ex);
            }
        }
    }

    private static final class Makers {
        static final Function<MethodHandle, LambdaForm> PRODUCE_BLOCK_INLINING_FORM = new Function<MethodHandle, LambdaForm>(){

            @Override
            public LambdaForm apply(MethodHandle target) {
                return DelegatingMethodHandle.makeReinvokerForm(target, 9, CountingWrapper.class, "reinvoker.dontInline", false, DelegatingMethodHandle.NF_getTarget, CountingWrapper.NF_maybeStopCounting);
            }
        };
        static final Function<MethodHandle, LambdaForm> PRODUCE_REINVOKER_FORM = new Function<MethodHandle, LambdaForm>(){

            @Override
            public LambdaForm apply(MethodHandle target) {
                return DelegatingMethodHandle.makeReinvokerForm(target, 8, DelegatingMethodHandle.class, DelegatingMethodHandle.NF_getTarget);
            }
        };
        static final ClassValue<MethodHandle[]> TYPED_COLLECTORS = new ClassValue<MethodHandle[]>(){

            @Override
            protected MethodHandle[] computeValue(Class<?> type) {
                return new MethodHandle[256];
            }
        };

        private Makers() {
        }
    }

    private static final class AsVarargsCollector
    extends DelegatingMethodHandle {
        private final MethodHandle target;
        private final Class<?> arrayType;
        @Stable
        private MethodHandle asCollectorCache;

        AsVarargsCollector(MethodHandle target, Class<?> arrayType) {
            this(target.type(), target, arrayType);
        }

        AsVarargsCollector(MethodType type, MethodHandle target, Class<?> arrayType) {
            super(type, target);
            this.target = target;
            this.arrayType = arrayType;
            this.asCollectorCache = target.asCollector(arrayType, 0);
        }

        @Override
        public boolean isVarargsCollector() {
            return true;
        }

        @Override
        protected MethodHandle getTarget() {
            return this.target;
        }

        @Override
        public MethodHandle asFixedArity() {
            return this.target;
        }

        @Override
        MethodHandle setVarargs(MemberName member) {
            if (member.isVarargs()) {
                return this;
            }
            return this.asFixedArity();
        }

        @Override
        public MethodHandle asTypeUncached(MethodType newType) {
            MethodHandle collector;
            MethodType type = this.type();
            int collectArg = type.parameterCount() - 1;
            int newArity = newType.parameterCount();
            if (newArity == collectArg + 1 && type.parameterType(collectArg).isAssignableFrom(newType.parameterType(collectArg))) {
                this.asTypeCache = this.asFixedArity().asType(newType);
                return this.asTypeCache;
            }
            MethodHandle acc = this.asCollectorCache;
            if (acc != null && acc.type().parameterCount() == newArity) {
                this.asTypeCache = acc.asType(newType);
                return this.asTypeCache;
            }
            int arrayLength = newArity - collectArg;
            try {
                collector = this.asFixedArity().asCollector(this.arrayType, arrayLength);
                assert (collector.type().parameterCount() == newArity) : "newArity=" + newArity + " but collector=" + collector;
            }
            catch (IllegalArgumentException ex) {
                throw new WrongMethodTypeException("cannot build collector", ex);
            }
            this.asCollectorCache = collector;
            this.asTypeCache = collector.asType(newType);
            return this.asTypeCache;
        }

        @Override
        boolean viewAsTypeChecks(MethodType newType, boolean strict) {
            super.viewAsTypeChecks(newType, true);
            if (strict) {
                return true;
            }
            assert (this.type().lastParameterType().getComponentType().isAssignableFrom(newType.lastParameterType().getComponentType())) : Arrays.asList(this, newType);
            return true;
        }
    }

    static final class ArrayAccessor {
        static final int GETTER_INDEX = 0;
        static final int SETTER_INDEX = 1;
        static final int LENGTH_INDEX = 2;
        static final int INDEX_LIMIT = 3;
        static final ClassValue<MethodHandle[]> TYPED_ACCESSORS = new ClassValue<MethodHandle[]>(){

            @Override
            protected MethodHandle[] computeValue(Class<?> type) {
                return new MethodHandle[3];
            }
        };
        static final MethodHandle OBJECT_ARRAY_GETTER;
        static final MethodHandle OBJECT_ARRAY_SETTER;
        static final MethodHandle OBJECT_ARRAY_LENGTH;

        ArrayAccessor() {
        }

        static int getElementI(int[] a, int i) {
            return a[i];
        }

        static long getElementJ(long[] a, int i) {
            return a[i];
        }

        static float getElementF(float[] a, int i) {
            return a[i];
        }

        static double getElementD(double[] a, int i) {
            return a[i];
        }

        static boolean getElementZ(boolean[] a, int i) {
            return a[i];
        }

        static byte getElementB(byte[] a, int i) {
            return a[i];
        }

        static short getElementS(short[] a, int i) {
            return a[i];
        }

        static char getElementC(char[] a, int i) {
            return a[i];
        }

        static Object getElementL(Object[] a, int i) {
            return a[i];
        }

        static void setElementI(int[] a, int i, int x) {
            a[i] = x;
        }

        static void setElementJ(long[] a, int i, long x) {
            a[i] = x;
        }

        static void setElementF(float[] a, int i, float x) {
            a[i] = x;
        }

        static void setElementD(double[] a, int i, double x) {
            a[i] = x;
        }

        static void setElementZ(boolean[] a, int i, boolean x) {
            a[i] = x;
        }

        static void setElementB(byte[] a, int i, byte x) {
            a[i] = x;
        }

        static void setElementS(short[] a, int i, short x) {
            a[i] = x;
        }

        static void setElementC(char[] a, int i, char x) {
            a[i] = x;
        }

        static void setElementL(Object[] a, int i, Object x) {
            a[i] = x;
        }

        static int lengthI(int[] a) {
            return a.length;
        }

        static int lengthJ(long[] a) {
            return a.length;
        }

        static int lengthF(float[] a) {
            return a.length;
        }

        static int lengthD(double[] a) {
            return a.length;
        }

        static int lengthZ(boolean[] a) {
            return a.length;
        }

        static int lengthB(byte[] a) {
            return a.length;
        }

        static int lengthS(short[] a) {
            return a.length;
        }

        static int lengthC(char[] a) {
            return a.length;
        }

        static int lengthL(Object[] a) {
            return a.length;
        }

        static String name(Class<?> arrayClass, ArrayAccess access) {
            Class<?> elemClass = arrayClass.getComponentType();
            if (elemClass == null) {
                throw MethodHandleStatics.newIllegalArgumentException("not an array", arrayClass);
            }
            return ArrayAccess.opName(access) + Wrapper.basicTypeChar(elemClass);
        }

        static MethodType type(Class<?> arrayClass, ArrayAccess access) {
            Class<Object> elemClass = arrayClass.getComponentType();
            Class<Object> arrayArgClass = arrayClass;
            if (!elemClass.isPrimitive()) {
                arrayArgClass = Object[].class;
                elemClass = Object.class;
            }
            switch (access) {
                case GET: {
                    return MethodType.methodType(elemClass, arrayArgClass, Integer.TYPE);
                }
                case SET: {
                    return MethodType.methodType(Void.TYPE, arrayArgClass, Integer.TYPE, elemClass);
                }
                case LENGTH: {
                    return MethodType.methodType(Integer.TYPE, arrayArgClass);
                }
            }
            throw MethodHandleImpl.unmatchedArrayAccess(access);
        }

        static MethodType correctType(Class<?> arrayClass, ArrayAccess access) {
            Class<?> elemClass = arrayClass.getComponentType();
            switch (access) {
                case GET: {
                    return MethodType.methodType(elemClass, arrayClass, Integer.TYPE);
                }
                case SET: {
                    return MethodType.methodType(Void.TYPE, arrayClass, Integer.TYPE, elemClass);
                }
                case LENGTH: {
                    return MethodType.methodType(Integer.TYPE, arrayClass);
                }
            }
            throw MethodHandleImpl.unmatchedArrayAccess(access);
        }

        static MethodHandle getAccessor(Class<?> arrayClass, ArrayAccess access) {
            String name = ArrayAccessor.name(arrayClass, access);
            MethodType type = ArrayAccessor.type(arrayClass, access);
            try {
                return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(ArrayAccessor.class, name, type);
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
        }

        static {
            MethodHandle[] cache = TYPED_ACCESSORS.get(Object[].class);
            cache[0] = OBJECT_ARRAY_GETTER = MethodHandleImpl.makeIntrinsic(ArrayAccessor.getAccessor(Object[].class, ArrayAccess.GET), Intrinsic.ARRAY_LOAD);
            cache[1] = OBJECT_ARRAY_SETTER = MethodHandleImpl.makeIntrinsic(ArrayAccessor.getAccessor(Object[].class, ArrayAccess.SET), Intrinsic.ARRAY_STORE);
            cache[2] = OBJECT_ARRAY_LENGTH = MethodHandleImpl.makeIntrinsic(ArrayAccessor.getAccessor(Object[].class, ArrayAccess.LENGTH), Intrinsic.ARRAY_LENGTH);
            assert (InvokerBytecodeGenerator.isStaticallyInvocable(OBJECT_ARRAY_GETTER.internalMemberName()));
            assert (InvokerBytecodeGenerator.isStaticallyInvocable(OBJECT_ARRAY_SETTER.internalMemberName()));
            assert (InvokerBytecodeGenerator.isStaticallyInvocable(OBJECT_ARRAY_LENGTH.internalMemberName()));
        }
    }

    static enum ArrayAccess {
        GET,
        SET,
        LENGTH;


        static String opName(ArrayAccess a) {
            switch (a) {
                case GET: {
                    return "getElement";
                }
                case SET: {
                    return "setElement";
                }
                case LENGTH: {
                    return "length";
                }
            }
            throw MethodHandleImpl.unmatchedArrayAccess(a);
        }

        static MethodHandle objectAccessor(ArrayAccess a) {
            switch (a) {
                case GET: {
                    return ArrayAccessor.OBJECT_ARRAY_GETTER;
                }
                case SET: {
                    return ArrayAccessor.OBJECT_ARRAY_SETTER;
                }
                case LENGTH: {
                    return ArrayAccessor.OBJECT_ARRAY_LENGTH;
                }
            }
            throw MethodHandleImpl.unmatchedArrayAccess(a);
        }

        static int cacheIndex(ArrayAccess a) {
            switch (a) {
                case GET: {
                    return 0;
                }
                case SET: {
                    return 1;
                }
                case LENGTH: {
                    return 2;
                }
            }
            throw MethodHandleImpl.unmatchedArrayAccess(a);
        }

        static Intrinsic intrinsic(ArrayAccess a) {
            switch (a) {
                case GET: {
                    return Intrinsic.ARRAY_LOAD;
                }
                case SET: {
                    return Intrinsic.ARRAY_STORE;
                }
                case LENGTH: {
                    return Intrinsic.ARRAY_LENGTH;
                }
            }
            throw MethodHandleImpl.unmatchedArrayAccess(a);
        }
    }
}

